/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.rules;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.SortedSet;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.internal.changedetection.rules.DescriptiveChange;
import org.gradle.api.internal.changedetection.rules.TaskStateChange;
import org.gradle.api.internal.changedetection.rules.TaskStateChanges;
import org.gradle.api.internal.changedetection.state.FileCollectionSnapshot;
import org.gradle.api.internal.changedetection.state.FileCollectionSnapshotter;
import org.gradle.api.internal.changedetection.state.FileCollectionSnapshotterRegistry;
import org.gradle.api.internal.changedetection.state.TaskExecution;
import org.gradle.api.internal.tasks.TaskFilePropertySpec;
import org.gradle.normalization.internal.InputNormalizationStrategy;
import org.gradle.util.ChangeListener;
import org.gradle.util.DiffUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractNamedFileSnapshotTaskStateChanges
implements TaskStateChanges {
    private final ImmutableSortedMap<String, FileCollectionSnapshot> fileSnapshotsBeforeExecution;
    private final String taskName;
    private final String title;
    private final ImmutableSortedSet<? extends TaskFilePropertySpec> fileProperties;
    private final FileCollectionSnapshotterRegistry snapshotterRegistry;
    protected final TaskExecution previous;
    protected final TaskExecution current;
    private final InputNormalizationStrategy normalizationStrategy;

    protected AbstractNamedFileSnapshotTaskStateChanges(String taskName, TaskExecution previous, TaskExecution current, FileCollectionSnapshotterRegistry snapshotterRegistry, String title, ImmutableSortedSet<? extends TaskFilePropertySpec> fileProperties, InputNormalizationStrategy normalizationStrategy) {
        this.taskName = taskName;
        this.previous = previous;
        this.current = current;
        this.snapshotterRegistry = snapshotterRegistry;
        this.title = title;
        this.fileProperties = fileProperties;
        this.normalizationStrategy = normalizationStrategy;
        this.fileSnapshotsBeforeExecution = this.buildSnapshots(taskName, snapshotterRegistry, title, (SortedSet<? extends TaskFilePropertySpec>)fileProperties);
    }

    protected String getTaskName() {
        return this.taskName;
    }

    protected String getTitle() {
        return this.title;
    }

    protected ImmutableSortedSet<? extends TaskFilePropertySpec> getFileProperties() {
        return this.fileProperties;
    }

    protected abstract ImmutableSortedMap<String, FileCollectionSnapshot> getPrevious();

    protected abstract void saveCurrent();

    protected FileCollectionSnapshotterRegistry getSnapshotterRegistry() {
        return this.snapshotterRegistry;
    }

    protected ImmutableSortedMap<String, FileCollectionSnapshot> getCurrent() {
        return this.fileSnapshotsBeforeExecution;
    }

    protected ImmutableSortedMap<String, FileCollectionSnapshot> buildSnapshots(String taskName, FileCollectionSnapshotterRegistry snapshotterRegistry, String title, SortedSet<? extends TaskFilePropertySpec> fileProperties) {
        ImmutableSortedMap.Builder builder = ImmutableSortedMap.naturalOrder();
        for (TaskFilePropertySpec taskFilePropertySpec : fileProperties) {
            FileCollectionSnapshot result;
            try {
                FileCollectionSnapshotter snapshotter = snapshotterRegistry.getSnapshotter(taskFilePropertySpec.getSnapshotter());
                result = snapshotter.snapshot(taskFilePropertySpec.getPropertyFiles(), taskFilePropertySpec.getCompareStrategy(), taskFilePropertySpec.getSnapshotNormalizationStrategy(), this.normalizationStrategy);
            }
            catch (UncheckedIOException e) {
                throw new UncheckedIOException(String.format("Failed to capture snapshot of %s files for task '%s' property '%s' during up-to-date check.", title.toLowerCase(), taskName, taskFilePropertySpec.getPropertyName()), (Throwable)e);
            }
            builder.put((Object)taskFilePropertySpec.getPropertyName(), (Object)result);
        }
        return builder.build();
    }

    @Override
    public Iterator<TaskStateChange> iterator() {
        if (this.getPrevious() == null) {
            return Iterators.singletonIterator((Object)new DescriptiveChange(this.title + " file history is not available.", new Object[0]));
        }
        final LinkedList propertyChanges = Lists.newLinkedList();
        DiffUtil.diff(this.getCurrent().keySet(), this.getPrevious().keySet(), new ChangeListener<String>(){

            @Override
            public void added(String element) {
                propertyChanges.add(new DescriptiveChange("%s property '%s' has been added for task '%s'", AbstractNamedFileSnapshotTaskStateChanges.this.title, element, AbstractNamedFileSnapshotTaskStateChanges.this.taskName));
            }

            @Override
            public void removed(String element) {
                propertyChanges.add(new DescriptiveChange("%s property '%s' has been removed for task '%s'", AbstractNamedFileSnapshotTaskStateChanges.this.title, element, AbstractNamedFileSnapshotTaskStateChanges.this.taskName));
            }

            @Override
            public void changed(String element) {
                throw new AssertionError();
            }
        });
        if (!propertyChanges.isEmpty()) {
            return propertyChanges.iterator();
        }
        return Iterators.concat(Iterables.transform((Iterable)this.getCurrent().entrySet(), (Function)new Function<Map.Entry<String, FileCollectionSnapshot>, Iterator<TaskStateChange>>(){

            public Iterator<TaskStateChange> apply(Map.Entry<String, FileCollectionSnapshot> entry) {
                String propertyName = entry.getKey();
                FileCollectionSnapshot currentSnapshot = entry.getValue();
                FileCollectionSnapshot previousSnapshot = (FileCollectionSnapshot)AbstractNamedFileSnapshotTaskStateChanges.this.getPrevious().get((Object)propertyName);
                String propertyTitle = AbstractNamedFileSnapshotTaskStateChanges.this.title + " property '" + propertyName + "'";
                return currentSnapshot.iterateContentChangesSince(previousSnapshot, propertyTitle);
            }
        }).iterator());
    }

    @Override
    public void snapshotAfterTask() {
        this.saveCurrent();
    }
}

