/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.cache.internal;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.gradle.api.Action;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.cache.PersistentCache;
import org.gradle.internal.operations.BuildOperationContext;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.operations.CallableBuildOperation;
import org.gradle.internal.operations.RunnableBuildOperation;
import org.gradle.internal.progress.BuildOperationDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FixedSizeOldestCacheCleanup
implements Action<PersistentCache> {
    private static final Logger LOGGER = Logging.getLogger(FixedSizeOldestCacheCleanup.class);
    private static final Comparator<File> NEWEST_FIRST = Ordering.natural().onResultOf((Function)new Function<File, Comparable>(){

        public Comparable apply(File input) {
            return Long.valueOf(input.lastModified());
        }
    }).reverse();
    private final BuildOperationExecutor buildOperationExecutor;
    private final long targetSizeInMB;

    public FixedSizeOldestCacheCleanup(BuildOperationExecutor buildOperationExecutor, long targetSizeInMB) {
        this.buildOperationExecutor = buildOperationExecutor;
        this.targetSizeInMB = targetSizeInMB;
    }

    public void execute(final PersistentCache persistentCache) {
        this.buildOperationExecutor.run(new RunnableBuildOperation(){

            public void run(BuildOperationContext context) {
                FixedSizeOldestCacheCleanup.this.cleanup(persistentCache);
            }

            public BuildOperationDescriptor.Builder description() {
                return BuildOperationDescriptor.displayName((String)("Clean up " + persistentCache));
            }
        });
    }

    private void cleanup(final PersistentCache persistentCache) {
        List filesForDeletion;
        final File[] filesEligibleForCleanup = (File[])this.buildOperationExecutor.call((CallableBuildOperation)new CallableBuildOperation<File[]>(){

            public File[] call(BuildOperationContext context) {
                return FixedSizeOldestCacheCleanup.this.findEligibleFiles(persistentCache.getBaseDir());
            }

            public BuildOperationDescriptor.Builder description() {
                return BuildOperationDescriptor.displayName((String)("Scan " + persistentCache.getBaseDir()));
            }
        });
        if (filesEligibleForCleanup.length > 0 && !(filesForDeletion = (List)this.buildOperationExecutor.call((CallableBuildOperation)new CallableBuildOperation<List<File>>(){

            public List<File> call(BuildOperationContext context) {
                return FixedSizeOldestCacheCleanup.this.findFilesToDelete(persistentCache, filesEligibleForCleanup);
            }

            public BuildOperationDescriptor.Builder description() {
                return BuildOperationDescriptor.displayName((String)("Choose files to delete from " + persistentCache));
            }
        })).isEmpty()) {
            this.buildOperationExecutor.run(new RunnableBuildOperation(){

                public void run(BuildOperationContext context) {
                    FixedSizeOldestCacheCleanup.this.cleanupFiles(persistentCache, filesForDeletion);
                }

                public BuildOperationDescriptor.Builder description() {
                    return BuildOperationDescriptor.displayName((String)("Delete files for " + persistentCache));
                }
            });
        }
    }

    List<File> findFilesToDelete(PersistentCache persistentCache, File[] filesEligibleForCleanup) {
        Arrays.sort(filesEligibleForCleanup, NEWEST_FIRST);
        long totalSize = 0L;
        long targetSize = this.targetSizeInMB * 1024L * 1024L;
        ArrayList filesForDeletion = Lists.newArrayList();
        for (File file : filesEligibleForCleanup) {
            long size = file.length();
            if ((totalSize += size) <= targetSize) continue;
            filesForDeletion.add(file);
        }
        LOGGER.info("{} consuming {} MB (target: {} MB).", new Object[]{persistentCache, FileUtils.byteCountToDisplaySize((long)totalSize), this.targetSizeInMB});
        return filesForDeletion;
    }

    File[] findEligibleFiles(File cacheDir) {
        return cacheDir.listFiles(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return FixedSizeOldestCacheCleanup.this.canBeDeleted(name);
            }
        });
    }

    void cleanupFiles(PersistentCache persistentCache, List<File> filesForDeletion) {
        long removedSize = this.deleteFiles(filesForDeletion);
        LOGGER.info("{} removing {} cache entries ({} MB reclaimed).", new Object[]{persistentCache, filesForDeletion.size(), FileUtils.byteCountToDisplaySize((long)removedSize)});
    }

    private long deleteFiles(List<File> files) {
        long removedSize = 0L;
        for (File file : files) {
            try {
                if (!file.delete()) continue;
                removedSize += file.length();
            }
            catch (Exception e) {
                LOGGER.debug("Could not clean up cache " + file, (Throwable)e);
            }
        }
        return removedSize;
    }

    boolean canBeDeleted(String name) {
        return !name.endsWith(".properties") && !name.endsWith(".lock");
    }
}

