/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.job.wrap;

import com.oracle.javafx.scenebuilder.kit.editor.EditorController;
import com.oracle.javafx.scenebuilder.kit.editor.job.Job;
import com.oracle.javafx.scenebuilder.kit.editor.job.atomic.AddPropertyJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.wrap.AbstractWrapInJob;
import com.oracle.javafx.scenebuilder.kit.editor.selection.ObjectSelectionGroup;
import com.oracle.javafx.scenebuilder.kit.editor.selection.Selection;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMObject;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMPropertyC;
import com.oracle.javafx.scenebuilder.kit.metadata.util.DesignHierarchyMask;
import com.oracle.javafx.scenebuilder.kit.metadata.util.PropertyName;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractWrapInContentJob
extends AbstractWrapInJob {
    public AbstractWrapInContentJob(EditorController editorController) {
        super(editorController);
    }

    @Override
    protected boolean canWrapIn() {
        boolean result;
        if (super.canWrapIn()) {
            Selection selection = this.getEditorController().getSelection();
            assert (selection.getGroup() instanceof ObjectSelectionGroup);
            ObjectSelectionGroup osg = (ObjectSelectionGroup)selection.getGroup();
            result = osg.getItems().size() == 1;
        } else {
            result = false;
        }
        return result;
    }

    @Override
    protected List<Job> wrapChildrenJobs(List<FXOMObject> children) {
        ArrayList<Job> jobs = new ArrayList<Job>();
        DesignHierarchyMask newContainerMask = new DesignHierarchyMask(this.newContainer);
        assert (newContainerMask.isAcceptingAccessory(DesignHierarchyMask.Accessory.CONTENT));
        PropertyName newContainerPropertyName = new PropertyName("content");
        FXOMPropertyC newContainerProperty = new FXOMPropertyC(this.newContainer.getFxomDocument(), newContainerPropertyName);
        assert (children.size() == 1);
        jobs.addAll(this.modifyChildrenJobs(children));
        jobs.addAll(this.addChildrenJobs(newContainerProperty, children));
        assert (newContainerProperty.getParentInstance() == null);
        AddPropertyJob addPropertyJob = new AddPropertyJob(newContainerProperty, this.newContainer, -1, this.getEditorController());
        jobs.add(addPropertyJob);
        return jobs;
    }
}

