/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.metadata.property.value;

import com.oracle.javafx.scenebuilder.kit.fxom.FXOMInstance;
import com.oracle.javafx.scenebuilder.kit.metadata.property.value.DoublePropertyMetadata;
import com.oracle.javafx.scenebuilder.kit.metadata.property.value.list.ListValuePropertyMetadata;
import com.oracle.javafx.scenebuilder.kit.metadata.util.InspectorPath;
import com.oracle.javafx.scenebuilder.kit.metadata.util.PropertyName;
import java.util.ArrayList;
import java.util.List;

public class DoubleArrayPropertyMetadata
extends ListValuePropertyMetadata<Double> {
    private static final PropertyName unusedName = new PropertyName("unused");
    private static final DoublePropertyMetadata doubleMetadata = new DoublePropertyMetadata(unusedName, DoublePropertyMetadata.DoubleKind.COORDINATE, true, 0.0, InspectorPath.UNUSED);

    public DoubleArrayPropertyMetadata(PropertyName name, boolean readWrite, List<Double> defaultValue, InspectorPath inspectorPath) {
        super(name, Double.class, doubleMetadata, readWrite, defaultValue, inspectorPath);
    }

    public void synchronizeWithSceneGraphObject(FXOMInstance fxomInstance) {
        List value;
        Object sceneGraphValue = this.getValueInSceneGraphObject(fxomInstance);
        if (sceneGraphValue == null) {
            value = this.getDefaultValue();
        } else {
            assert (sceneGraphValue.getClass().getComponentType() == Double.TYPE);
            value = new ArrayList();
            for (double d : (double[])sceneGraphValue) {
                value.add(d);
            }
        }
        this.setValue(fxomInstance, value);
    }
}

