/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.actions;

import com.android.tools.idea.actions.MockupToggleAction;
import com.android.tools.idea.uibuilder.mockup.editor.FileChooserActionListener;
import com.android.tools.idea.uibuilder.model.NlComponent;
import com.android.tools.idea.uibuilder.property.NlPropertyItem;
import com.android.tools.idea.uibuilder.surface.DesignSurface;
import com.android.tools.idea.uibuilder.surface.ScreenView;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import java.util.Collections;
import java.util.List;
import org.jetbrains.android.dom.attrs.ToolsAttributeUtil;
import org.jetbrains.annotations.NotNull;

public class MockupEditAction
extends AnAction {
    private static FileChooserActionListener ourFileChooserActionListener = new FileChooserActionListener();
    private static final String EDIT_ACTION_TITLE = "Edit Mockup";
    private static final String ADD_ACTION_TITLE = "Add Mockup";
    private final MockupToggleAction myMockupToggleAction;

    public MockupEditAction(@NotNull DesignSurface designSurface) {
        if (designSurface == null) {
            MockupEditAction.$$$reportNull$$$0(0);
        }
        super(ADD_ACTION_TITLE);
        this.myMockupToggleAction = new MockupToggleAction(designSurface);
        ScreenView screenView = designSurface.getCurrentScreenView();
        if (screenView != null) {
            List<NlComponent> selection = screenView.getSelectionModel().getSelection();
            if (selection.isEmpty()) {
                selection = screenView.getModel().getComponents();
            }
            if (!selection.isEmpty()) {
                NlComponent nlComponent = selection.get(0);
                Presentation presentation = this.getTemplatePresentation();
                if (nlComponent.getAttribute("http://schemas.android.com/tools", "mockup") != null) {
                    presentation.setText(EDIT_ACTION_TITLE);
                } else {
                    presentation.setText(ADD_ACTION_TITLE);
                }
                ourFileChooserActionListener.setFilePathProperty(new NlPropertyItem(Collections.singletonList(nlComponent), "http://schemas.android.com/tools", ToolsAttributeUtil.getAttrDefByName("mockup")));
                ourFileChooserActionListener.setCropProperty(new NlPropertyItem(Collections.singletonList(nlComponent), "http://schemas.android.com/tools", ToolsAttributeUtil.getAttrDefByName("mockup_crop")));
            } else {
                this.getTemplatePresentation().setEnabled(false);
            }
        }
    }

    public void update(AnActionEvent e) {
        e.getPresentation().setEnabledAndVisible(false);
    }

    public void actionPerformed(AnActionEvent e) {
        this.myMockupToggleAction.setSelected(e, true);
        ourFileChooserActionListener.actionPerformed(null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "designSurface", "com/android/tools/idea/actions/MockupEditAction", "<init>"));
    }
}

