/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.configurations;

import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ex.CustomComponentAction;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.ColorUtil;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.DefaultButtonModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;

public abstract class FlatAction
extends AnAction
implements CustomComponentAction {
    private DataContext myDataContext;

    protected FlatAction() {
    }

    public JComponent createCustomComponent(Presentation presentation) {
        JPanel panel = new JPanel(new GridBagLayout());
        FlatButton button = this.createComboBoxButton(presentation);
        panel.add((Component)button, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, (Insets)JBUI.emptyInsets(), 0, 0));
        return panel;
    }

    protected FlatButton createComboBoxButton(Presentation presentation) {
        return new FlatButton(presentation);
    }

    public void update(AnActionEvent e) {
        super.update(e);
        this.myDataContext = e.getDataContext();
    }

    protected class FlatButton
    extends JButton {
        private final Presentation myPresentation;
        private final Border myBorder = JBUI.Borders.empty((int)0, (int)2);
        private PropertyChangeListener myButtonSynchronizer;
        private boolean myMouseInside = false;

        public FlatButton(Presentation presentation) {
            this.myPresentation = presentation;
            this.setModel(new DefaultButtonModel());
            this.setHorizontalAlignment(2);
            this.setFocusable(false);
            Insets margins = this.getMargin();
            this.setMargin((Insets)JBUI.insets((int)margins.top, (int)2, (int)margins.bottom, (int)2));
            this.setBorder(this.myBorder);
            if (!UIUtil.isUnderGTKLookAndFeel()) {
                this.setFont(UIUtil.getLabelFont((UIUtil.FontSize)UIUtil.FontSize.SMALL));
            }
            this.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(new Runnable(){

                        @Override
                        public void run() {
                            AnActionEvent event = AnActionEvent.createFromInputEvent((AnAction)FlatAction.this, null, (String)"EditorToolbar");
                            FlatAction.this.actionPerformed(event);
                        }
                    });
                }
            });
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent e) {
                    FlatButton.this.myMouseInside = true;
                    FlatButton.this.repaint();
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    FlatButton.this.myMouseInside = false;
                    FlatButton.this.repaint();
                }

                @Override
                public void mousePressed(MouseEvent e) {
                    if (SwingUtilities.isLeftMouseButton(e)) {
                        e.consume();
                        FlatButton.this.doClick();
                    }
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                }
            });
            this.addMouseMotionListener(new MouseMotionListener(){

                @Override
                public void mouseDragged(MouseEvent e) {
                    this.mouseMoved(new MouseEvent(e.getComponent(), 503, e.getWhen(), e.getModifiers(), e.getX(), e.getY(), e.getClickCount(), e.isPopupTrigger(), e.getButton()));
                }

                @Override
                public void mouseMoved(MouseEvent e) {
                }
            });
        }

        protected DataContext getDataContext() {
            return FlatAction.this.myDataContext == null ? DataManager.getInstance().getDataContext((Component)this) : FlatAction.this.myDataContext;
        }

        @Override
        public void removeNotify() {
            if (this.myButtonSynchronizer != null) {
                this.myPresentation.removePropertyChangeListener(this.myButtonSynchronizer);
                this.myButtonSynchronizer = null;
            }
            super.removeNotify();
        }

        @Override
        public void addNotify() {
            super.addNotify();
            if (this.myButtonSynchronizer == null) {
                this.myButtonSynchronizer = new MyButtonSynchronizer();
                this.myPresentation.addPropertyChangeListener(this.myButtonSynchronizer);
            }
            this.initButton();
        }

        private void initButton() {
            this.setIcon(this.myPresentation.getIcon());
            this.setEnabled(this.myPresentation.isEnabled());
            this.setText(this.myPresentation.getText());
            this.updateTooltipText(this.myPresentation.getDescription());
            this.updateButtonSize();
        }

        private void updateTooltipText(String description) {
            String tooltip = KeymapUtil.createTooltipText((String)description, (AnAction)FlatAction.this);
            this.setToolTipText(!tooltip.isEmpty() ? tooltip : null);
        }

        @Override
        public void updateUI() {
            super.updateUI();
            this.setBorder(this.myBorder);
        }

        @Override
        public boolean isOpaque() {
            return false;
        }

        @Override
        public Dimension getPreferredSize() {
            boolean isEmpty = this.getIcon() == null && StringUtil.isEmpty((String)this.getText());
            int width = isEmpty ? JBUI.scale((int)10) : super.getPreferredSize().width;
            return new Dimension(width, JBUI.scale((int)24));
        }

        @Override
        public void paint(Graphics g) {
            GraphicsUtil.setupAntialiasing((Graphics)g);
            boolean textEmpty = StringUtil.isEmpty((String)this.getText());
            Dimension size = this.getSize();
            Graphics2D g2 = (Graphics2D)g;
            Color controlColor = UIUtil.getControlColor();
            if (UIUtil.isUnderIntelliJLaF()) {
                controlColor = this.getParent().getBackground();
            }
            g2.setColor(controlColor);
            int w = this.getWidth();
            int h = this.getHeight();
            if (this.getModel().isArmed() && this.getModel().isPressed()) {
                g2.setPaint(new GradientPaint(0.0f, 0.0f, controlColor, 0.0f, h, ColorUtil.shift((Color)controlColor, (double)0.8)));
            } else if (this.myMouseInside) {
                g2.setPaint(new GradientPaint(0.0f, 0.0f, ColorUtil.shift((Color)controlColor, (double)1.1), 0.0f, h, ColorUtil.shift((Color)controlColor, (double)0.9)));
            }
            g2.fillRect(1, 1, w - 2, h - 2);
            GraphicsUtil.setupAntialiasing((Graphics)g2);
            if (this.myMouseInside) {
                if (!UIUtil.isUnderDarcula()) {
                    g2.setPaint(new GradientPaint(0.0f, 0.0f, UIUtil.getBorderColor().darker(), 0.0f, h, UIUtil.getBorderColor().darker().darker()));
                } else {
                    g2.setPaint(new GradientPaint(0.0f, 0.0f, ColorUtil.shift((Color)controlColor, (double)1.4), 0.0f, h, ColorUtil.shift((Color)controlColor, (double)1.5)));
                }
                g2.drawRect(0, 0, w - 1, h - 1);
            }
            Icon icon = this.getIcon();
            int x = 2;
            if (icon != null) {
                icon.paintIcon(null, g, x, (size.height - icon.getIconHeight()) / 2 - 1);
                x += icon.getIconWidth() + 1;
            }
            if (!textEmpty) {
                Font font = this.getFont();
                g2.setFont(font);
                g2.setColor(UIManager.getColor("Panel.foreground"));
                g2.drawString(this.getText(), x, (size.height + font.getSize()) / 2 - 1);
            }
            g.setPaintMode();
        }

        protected void updateButtonSize() {
            this.invalidate();
            this.repaint();
        }

        private class MyButtonSynchronizer
        implements PropertyChangeListener {
            private MyButtonSynchronizer() {
            }

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                String propertyName = evt.getPropertyName();
                if ("text".equals(propertyName)) {
                    FlatButton.this.setText((String)evt.getNewValue());
                    FlatButton.this.updateButtonSize();
                } else if ("description".equals(propertyName)) {
                    FlatButton.this.updateTooltipText((String)evt.getNewValue());
                } else if ("icon".equals(propertyName)) {
                    FlatButton.this.setIcon((Icon)evt.getNewValue());
                    FlatButton.this.updateButtonSize();
                } else if ("enabled".equals(propertyName)) {
                    FlatButton.this.setEnabled((Boolean)evt.getNewValue());
                }
            }
        }
    }
}

