/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.configurations;

import com.android.ide.common.resources.configuration.DeviceConfigHelper;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.resources.NightMode;
import com.android.resources.ScreenOrientation;
import com.android.resources.UiMode;
import com.android.sdklib.devices.Device;
import com.android.sdklib.devices.State;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.configurations.ConfigurationAction;
import com.android.tools.idea.configurations.ConfigurationHolder;
import com.android.tools.idea.configurations.ConfigurationMatcher;
import com.android.tools.idea.configurations.FlatComboAction;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.vfs.VirtualFile;
import icons.AndroidIcons;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class OrientationMenuAction
extends FlatComboAction {
    private final ConfigurationHolder myRenderContext;

    public OrientationMenuAction(ConfigurationHolder renderContext) {
        this.myRenderContext = renderContext;
        Presentation presentation = this.getTemplatePresentation();
        presentation.setDescription("Orientation in Editor");
        presentation.setIcon(AndroidIcons.NeleIcons.Rotate);
    }

    @NotNull
    private static String getPresentationDescription(@NotNull State state) {
        if (state == null) {
            OrientationMenuAction.$$$reportNull$$$0(0);
        }
        String string = String.format("Switch to %1$s", state.getName());
        if (string == null) {
            OrientationMenuAction.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    protected boolean handleIconClicked() {
        Configuration configuration = this.myRenderContext.getConfiguration();
        if (configuration == null) {
            return false;
        }
        State current = configuration.getDeviceState();
        State flip = configuration.getNextDeviceState(current);
        if (flip != null) {
            SetDeviceStateAction action = new SetDeviceStateAction(this.myRenderContext, flip.getName(), flip, false, false);
            action.perform();
        }
        return true;
    }

    @Override
    @NotNull
    protected DefaultActionGroup createPopupActionGroup() {
        DefaultActionGroup group = new DefaultActionGroup(null, true);
        Configuration configuration = this.myRenderContext.getConfiguration();
        if (configuration != null) {
            Device device = configuration.getDevice();
            if (device != null) {
                List states = device.getAllStates();
                State current = configuration.getDeviceState();
                if (states.size() > 1 && current != null) {
                    State flip = configuration.getNextDeviceState(current);
                    State nextSate = flip == null ? current : flip;
                    String title = OrientationMenuAction.getPresentationDescription(nextSate);
                    group.add((AnAction)new SetDeviceStateAction(this.myRenderContext, title, nextSate, false, true));
                    group.addSeparator();
                }
                for (State config : states) {
                    String stateName;
                    String title = stateName = config.getName();
                    VirtualFile better = ConfigurationMatcher.getBetterMatch(configuration, null, stateName, null, null);
                    if (better != null) {
                        title = ConfigurationAction.getBetterMatchLabel(stateName, better, configuration.getFile());
                    }
                    group.add((AnAction)new SetDeviceStateAction(this.myRenderContext, title, config, config == current, false));
                }
                group.addSeparator();
            }
            group.addSeparator();
            DefaultActionGroup uiModeGroup = new DefaultActionGroup("_UI Mode", true);
            UiMode currentUiMode = configuration.getUiMode();
            for (State uiMode : UiMode.values()) {
                String title = uiMode.getShortDisplayValue();
                boolean checked = uiMode == currentUiMode;
                uiModeGroup.add((AnAction)new SetUiModeAction(this.myRenderContext, title, (UiMode)uiMode, checked));
            }
            group.add((AnAction)uiModeGroup);
            group.addSeparator();
            DefaultActionGroup nightModeGroup = new DefaultActionGroup("_Night Mode", true);
            NightMode currentNightMode = configuration.getNightMode();
            for (NightMode nightMode : NightMode.values()) {
                String title = nightMode.getShortDisplayValue();
                boolean checked = nightMode == currentNightMode;
                nightModeGroup.add((AnAction)new SetNightModeAction(this.myRenderContext, title, nightMode, checked));
            }
            group.add((AnAction)nightModeGroup);
        }
        DefaultActionGroup defaultActionGroup = group;
        if (defaultActionGroup == null) {
            OrientationMenuAction.$$$reportNull$$$0(2);
        }
        return defaultActionGroup;
    }

    @NotNull
    public static Icon getOrientationIcon(@NotNull ScreenOrientation orientation, boolean flip) {
        if (orientation == null) {
            OrientationMenuAction.$$$reportNull$$$0(3);
        }
        switch (orientation) {
            case LANDSCAPE: {
                Icon icon = flip ? AndroidIcons.FlipLandscape : AndroidIcons.Landscape;
                if (icon == null) {
                    OrientationMenuAction.$$$reportNull$$$0(4);
                }
                return icon;
            }
            case SQUARE: {
                Icon icon = AndroidIcons.Square;
                if (icon == null) {
                    OrientationMenuAction.$$$reportNull$$$0(5);
                }
                return icon;
            }
        }
        Icon icon = flip ? AndroidIcons.FlipPortrait : AndroidIcons.Portrait;
        if (icon == null) {
            OrientationMenuAction.$$$reportNull$$$0(6);
        }
        return icon;
    }

    @NotNull
    public static ScreenOrientation getOrientation(@NotNull State state) {
        if (state == null) {
            OrientationMenuAction.$$$reportNull$$$0(7);
        }
        FolderConfiguration config = DeviceConfigHelper.getFolderConfig((State)state);
        ScreenOrientation orientation = null;
        if (config != null && config.getScreenOrientationQualifier() != null) {
            orientation = config.getScreenOrientationQualifier().getValue();
        }
        if (orientation == null) {
            orientation = ScreenOrientation.PORTRAIT;
        }
        ScreenOrientation screenOrientation = orientation;
        if (screenOrientation == null) {
            OrientationMenuAction.$$$reportNull$$$0(8);
        }
        return screenOrientation;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/configurations/OrientationMenuAction";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "orientation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/configurations/OrientationMenuAction";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentationDescription";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createPopupActionGroup";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrientationIcon";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrientation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getPresentationDescription";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getOrientationIcon";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getOrientation";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class SetNightModeAction
    extends ConfigurationAction {
        @NotNull
        private final NightMode myNightMode;

        private SetNightModeAction(@NotNull ConfigurationHolder renderContext, @NotNull String title, @NotNull NightMode nightMode, boolean checked) {
            if (renderContext == null) {
                SetNightModeAction.$$$reportNull$$$0(0);
            }
            if (title == null) {
                SetNightModeAction.$$$reportNull$$$0(1);
            }
            if (nightMode == null) {
                SetNightModeAction.$$$reportNull$$$0(2);
            }
            super(renderContext, title);
            this.myNightMode = nightMode;
            if (checked) {
                this.getTemplatePresentation().setIcon(AllIcons.Actions.Checked);
            }
        }

        @Override
        protected void updateConfiguration(@NotNull Configuration configuration, boolean commit) {
            if (configuration == null) {
                SetNightModeAction.$$$reportNull$$$0(3);
            }
            configuration.setNightMode(this.myNightMode);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "renderContext";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "title";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "nightMode";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "configuration";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/configurations/OrientationMenuAction$SetNightModeAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "updateConfiguration";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class SetUiModeAction
    extends ConfigurationAction {
        @NotNull
        private final UiMode myUiMode;

        private SetUiModeAction(@NotNull ConfigurationHolder renderContext, @NotNull String title, @NotNull UiMode uiMode, boolean checked) {
            if (renderContext == null) {
                SetUiModeAction.$$$reportNull$$$0(0);
            }
            if (title == null) {
                SetUiModeAction.$$$reportNull$$$0(1);
            }
            if (uiMode == null) {
                SetUiModeAction.$$$reportNull$$$0(2);
            }
            super(renderContext, title);
            this.myUiMode = uiMode;
            if (checked) {
                this.getTemplatePresentation().setIcon(AllIcons.Actions.Checked);
            }
        }

        @Override
        protected void updateConfiguration(@NotNull Configuration configuration, boolean commit) {
            if (configuration == null) {
                SetUiModeAction.$$$reportNull$$$0(3);
            }
            configuration.setUiMode(this.myUiMode);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "renderContext";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "title";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "uiMode";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "configuration";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/configurations/OrientationMenuAction$SetUiModeAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "updateConfiguration";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class SetDeviceStateAction
    extends ConfigurationAction {
        @NotNull
        private final State myState;

        private SetDeviceStateAction(@NotNull ConfigurationHolder renderContext, @NotNull String title, @NotNull State state, boolean checked, boolean flip) {
            if (renderContext == null) {
                SetDeviceStateAction.$$$reportNull$$$0(0);
            }
            if (title == null) {
                SetDeviceStateAction.$$$reportNull$$$0(1);
            }
            if (state == null) {
                SetDeviceStateAction.$$$reportNull$$$0(2);
            }
            super(renderContext, title);
            this.myState = state;
            ScreenOrientation orientation = OrientationMenuAction.getOrientation(state);
            this.getTemplatePresentation().setIcon(OrientationMenuAction.getOrientationIcon(orientation, flip));
        }

        public void perform() {
            this.tryUpdateConfiguration();
            this.updatePresentation();
        }

        @Override
        protected void updateConfiguration(@NotNull Configuration configuration, boolean commit) {
            if (configuration == null) {
                SetDeviceStateAction.$$$reportNull$$$0(3);
            }
            configuration.setDeviceState(this.myState);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "renderContext";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "title";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "state";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "configuration";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/configurations/OrientationMenuAction$SetDeviceStateAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "updateConfiguration";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

