/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ddms.actions;

import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.Client;
import com.android.ddmlib.ClientData;
import com.android.tools.adtui.EventData;
import com.android.tools.idea.ddms.DeviceContext;
import com.android.tools.idea.ddms.EdtExecutor;
import com.android.tools.idea.ddms.actions.AbstractClientToggleAction;
import com.android.tools.idea.editors.allocations.AllocationCaptureType;
import com.android.tools.idea.profiling.capture.Capture;
import com.android.tools.idea.profiling.capture.CaptureHandle;
import com.android.tools.idea.profiling.capture.CaptureService;
import com.google.common.util.concurrent.FutureCallback;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import icons.AndroidIcons;
import java.io.IOException;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;

public class ToggleAllocationTrackingAction
extends AbstractClientToggleAction {
    private final Project myProject;
    private final EventData myEvents;
    private EventData.Event myEvent;

    public ToggleAllocationTrackingAction(@NotNull Project project, @NotNull DeviceContext context, @NotNull EventData events) {
        if (project == null) {
            ToggleAllocationTrackingAction.$$$reportNull$$$0(0);
        }
        if (context == null) {
            ToggleAllocationTrackingAction.$$$reportNull$$$0(1);
        }
        if (events == null) {
            ToggleAllocationTrackingAction.$$$reportNull$$$0(2);
        }
        super(context, AndroidBundle.message("android.ddms.actions.allocationtracker.start", new Object[0]), AndroidBundle.message("android.ddms.actions.allocationtracker.description", new Object[0]), AndroidIcons.Ddms.AllocationTracker);
        this.myProject = project;
        this.myEvents = events;
    }

    @Override
    protected boolean isSelected(@NotNull Client c) {
        if (c == null) {
            ToggleAllocationTrackingAction.$$$reportNull$$$0(3);
        }
        return c.getClientData().getAllocationStatus() == ClientData.AllocationTrackingStatus.ON;
    }

    @Override
    protected void setSelected(@NotNull Client c) {
        if (c == null) {
            ToggleAllocationTrackingAction.$$$reportNull$$$0(4);
        }
        long now = System.currentTimeMillis();
        if (c.getClientData().getAllocationStatus() == ClientData.AllocationTrackingStatus.ON) {
            c.requestAllocationDetails();
            c.enableAllocationTracker(false);
            if (this.myEvent == null) {
                this.myEvent = this.myEvents.start(now, 2);
            }
            this.myEvent.stop(now);
            this.myEvent = null;
        } else {
            this.installListener(c, this.myProject);
            c.enableAllocationTracker(true);
            if (this.myEvent != null) {
                this.myEvent.stop(now);
            }
            this.myEvent = this.myEvents.start(now, 2);
        }
        c.requestAllocationStatus();
    }

    @Override
    @NotNull
    protected String getActiveText(@NotNull Client c) {
        if (c == null) {
            ToggleAllocationTrackingAction.$$$reportNull$$$0(5);
        }
        String string = c.getClientData().getAllocationStatus() == ClientData.AllocationTrackingStatus.ON ? AndroidBundle.message("android.ddms.actions.allocationtracker.stop", new Object[0]) : AndroidBundle.message("android.ddms.actions.allocationtracker.start", new Object[0]);
        if (string == null) {
            ToggleAllocationTrackingAction.$$$reportNull$$$0(6);
        }
        return string;
    }

    private void installListener(final @NotNull Client listeningClient, @NotNull Project project) {
        if (listeningClient == null) {
            ToggleAllocationTrackingAction.$$$reportNull$$$0(7);
        }
        if (project == null) {
            ToggleAllocationTrackingAction.$$$reportNull$$$0(8);
        }
        AndroidDebugBridge.addClientChangeListener((AndroidDebugBridge.IClientChangeListener)new AndroidDebugBridge.IClientChangeListener(){

            public void clientChanged(Client client, int changeMask) {
                if (client == listeningClient && (changeMask & 0x200) != 0) {
                    final byte[] data = client.getClientData().getAllocationsData();
                    ApplicationManager.getApplication().invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                if (ToggleAllocationTrackingAction.this.myProject.isDisposed()) {
                                    return;
                                }
                                final CaptureService service = CaptureService.getInstance(ToggleAllocationTrackingAction.this.myProject);
                                String name = service.getSuggestedName(listeningClient);
                                CaptureHandle handle = service.startCaptureFile(AllocationCaptureType.class, name, true);
                                service.appendDataCopy(handle, data);
                                service.finalizeCaptureFileAsynchronous(handle, new FutureCallback<Capture>(){

                                    public void onSuccess(Capture result) {
                                        service.notifyCaptureReady(result);
                                    }

                                    public void onFailure(Throwable t) {
                                        throw new RuntimeException(t);
                                    }
                                }, EdtExecutor.INSTANCE);
                            }
                            catch (IOException e) {
                                throw new RuntimeException(e);
                            }
                        }
                    });
                    AndroidDebugBridge.removeClientChangeListener((AndroidDebugBridge.IClientChangeListener)this);
                }
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "events";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/ddms/actions/ToggleAllocationTrackingAction";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listeningClient";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/ddms/actions/ToggleAllocationTrackingAction";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getActiveText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isSelected";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setSelected";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getActiveText";
                break;
            }
            case 6: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "installListener";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

