/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.strings;

import com.android.ide.common.res2.ResourceItem;
import com.android.resources.ResourceType;
import com.android.tools.idea.actions.BrowserHelpAction;
import com.android.tools.idea.configurations.LocaleMenuAction;
import com.android.tools.idea.editors.strings.FontUtil;
import com.android.tools.idea.editors.strings.MultilineStringEditorDialog;
import com.android.tools.idea.editors.strings.NewStringKeyDialog;
import com.android.tools.idea.editors.strings.StringResource;
import com.android.tools.idea.editors.strings.StringResourceData;
import com.android.tools.idea.editors.strings.StringResourceParser;
import com.android.tools.idea.editors.strings.StringsWriteUtils;
import com.android.tools.idea.editors.strings.table.StringResourceTable;
import com.android.tools.idea.editors.strings.table.StringResourceTableModel;
import com.android.tools.idea.model.AndroidModuleInfo;
import com.android.tools.idea.model.MergedManifest;
import com.android.tools.idea.rendering.Locale;
import com.android.tools.idea.res.LocalResourceRepository;
import com.android.tools.idea.res.ResourceNotificationManager;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import com.intellij.icons.AllIcons;
import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.ex.CheckboxAction;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.safeDelete.SafeDeleteHandler;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.ListSpeedSearch;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBLoadingPanel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.components.JBTextField;
import com.intellij.ui.table.JBTable;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import icons.AndroidIcons;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.IntSupplier;
import java.util.stream.Stream;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.JTextComponent;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;

final class StringResourceViewPanel
implements Disposable,
HyperlinkListener {
    private static final boolean HIDE_TRANSLATION_ORDER_LINK = Boolean.getBoolean("hide.order.translations");
    private final JBLoadingPanel myLoadingPanel;
    private JPanel myContainer;
    private StringResourceTable myTable;
    JTextComponent myKeyTextField;
    @VisibleForTesting
    TextFieldWithBrowseButton myDefaultValueTextField;
    TextFieldWithBrowseButton myTranslationTextField;
    private JPanel myToolbarPanel;
    private final AndroidFacet myFacet;
    private LocalResourceRepository myResourceRepository;
    private long myModificationCount;
    private ResourceNotificationManager.ResourceChangeListener myResourceChangeListener;

    StringResourceViewPanel(AndroidFacet facet, Disposable parentDisposable) {
        this.myFacet = facet;
        this.$$$setupUI$$$();
        this.myLoadingPanel = new JBLoadingPanel((LayoutManager)new BorderLayout(), parentDisposable, 200);
        this.myLoadingPanel.add((Component)this.myContainer);
        ActionToolbar toolbar = this.createToolbar();
        this.myToolbarPanel.add((Component)toolbar.getComponent(), "Center");
        if (!HIDE_TRANSLATION_ORDER_LINK) {
            HyperlinkLabel hyperlinkLabel = new HyperlinkLabel("Order a translation...");
            this.myToolbarPanel.add((Component)hyperlinkLabel, "East");
            hyperlinkLabel.addHyperlinkListener((HyperlinkListener)this);
            this.myToolbarPanel.setBorder(IdeBorderFactory.createBorder((int)8));
        }
        this.initTable();
        this.myKeyTextField.addFocusListener(new SetTableValueAtFocusListener(0));
        this.addResourceChangeListener();
        Disposer.register((Disposable)parentDisposable, (Disposable)this);
        this.myLoadingPanel.setLoadingText("Loading string resource data");
        this.myLoadingPanel.startLoading();
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            new ParseTask("Loading string resource data").queue();
        }
    }

    private void createUIComponents() {
        this.myTable = new StringResourceTable();
        this.createDefaultValueTextField();
        this.createTranslationTextField();
    }

    private void createDefaultValueTextField() {
        this.myDefaultValueTextField = new TextFieldWithBrowseButton((JTextField)((Object)new TranslationsEditorTextField()));
        this.myDefaultValueTextField.setButtonIcon(AllIcons.Actions.ShowViewer);
        this.myDefaultValueTextField.addActionListener((ActionListener)new ShowMultilineActionListener());
        SetTableValueAtFocusListener listener = new SetTableValueAtFocusListener(2);
        this.myDefaultValueTextField.getTextField().addFocusListener(listener);
    }

    private void createTranslationTextField() {
        this.myTranslationTextField = new TextFieldWithBrowseButton((JTextField)((Object)new TranslationsEditorTextField()));
        this.myTranslationTextField.setButtonIcon(AllIcons.Actions.ShowViewer);
        this.myTranslationTextField.addActionListener((ActionListener)new ShowMultilineActionListener());
        this.myTranslationTextField.getTextField().addFocusListener(new SetTableValueAtFocusListener(this.myTable::getSelectedColumnModelIndex));
    }

    public void dispose() {
        ResourceNotificationManager.getInstance(this.myFacet.getModule().getProject()).removeListener(this.myResourceChangeListener, this.myFacet, null, null);
    }

    public void reloadData() {
        this.myLoadingPanel.setLoadingText("Updating string resource data");
        this.myLoadingPanel.startLoading();
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            new ParseTask("Updating string resource data").queue();
        }
    }

    private ActionToolbar createToolbar() {
        DefaultActionGroup group = new DefaultActionGroup();
        ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("AndroidStringResourceView", (ActionGroup)group, true);
        AnAction addKeyAction = new AnAction("Add Key", "", AllIcons.ToolbarDecorator.Add){

            public void update(AnActionEvent e) {
                e.getPresentation().setEnabled(StringResourceViewPanel.this.myTable.getData() != null);
            }

            public void actionPerformed(AnActionEvent e) {
                StringResourceData data = StringResourceViewPanel.this.myTable.getData();
                assert (data != null);
                NewStringKeyDialog dialog = new NewStringKeyDialog(StringResourceViewPanel.this.myFacet, (Set<String>)ImmutableSet.copyOf(data.getKeys()));
                if (dialog.showAndGet()) {
                    StringsWriteUtils.createItem(StringResourceViewPanel.this.myFacet, dialog.getResFolder(), null, dialog.getKey(), dialog.getDefaultValue(), true);
                }
            }
        };
        group.add(addKeyAction);
        group.add((AnAction)new RemoveKeysAction());
        group.add((AnAction)new AddLocaleAction(toolbar.getComponent()));
        group.add(this.newShowOnlyKeysNeedingTranslationsAction());
        group.add((AnAction)new BrowserHelpAction("Translations editor", "https://developer.android.com/r/studio-ui/translations-editor.html"));
        return toolbar;
    }

    private AnAction newShowOnlyKeysNeedingTranslationsAction() {
        return new CheckboxAction("Show only keys _needing translations"){

            public boolean isSelected(AnActionEvent event) {
                return StringResourceViewPanel.this.myTable.getRowSorter() != null;
            }

            public void setSelected(AnActionEvent event, boolean showingOnlyKeysNeedingTranslations) {
                StringResourceViewPanel.this.myTable.setShowingOnlyKeysNeedingTranslations(showingOnlyKeysNeedingTranslations);
            }

            public void update(AnActionEvent event) {
                event.getPresentation().setEnabled(StringResourceViewPanel.this.myTable.getData() != null);
                super.update(event);
            }
        };
    }

    public boolean dataIsCurrent() {
        return this.myResourceRepository != null && this.myModificationCount >= this.myResourceRepository.getModificationCount();
    }

    private void initTable() {
        CellSelectionListener listener = new CellSelectionListener();
        this.myTable.getColumnModel().getSelectionModel().addListSelectionListener(listener);
        this.myTable.getSelectionModel().addListSelectionListener(listener);
    }

    private void addResourceChangeListener() {
        this.myResourceChangeListener = reasons -> {
            if (reasons.contains((Object)ResourceNotificationManager.Reason.RESOURCE_EDIT)) {
                this.reloadData();
            }
        };
        ResourceNotificationManager.getInstance(this.myFacet.getModule().getProject()).addListener(this.myResourceChangeListener, this.myFacet, null, null);
    }

    @NotNull
    public JPanel getComponent() {
        JBLoadingPanel jBLoadingPanel = this.myLoadingPanel;
        if (jBLoadingPanel == null) {
            StringResourceViewPanel.$$$reportNull$$$0(0);
        }
        return jBLoadingPanel;
    }

    @NotNull
    public JBTable getPreferredFocusedComponent() {
        StringResourceTable stringResourceTable = this.myTable;
        if (stringResourceTable == null) {
            StringResourceViewPanel.$$$reportNull$$$0(1);
        }
        return stringResourceTable;
    }

    StringResourceTable getTable() {
        return this.myTable;
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent e) {
        Integer versionCode;
        AndroidModuleInfo moduleInfo;
        String appId;
        StringBuilder sb = new StringBuilder("https://translate.google.com/manager/android_studio/");
        sb.append("?asVer=");
        ApplicationInfo ideInfo = ApplicationInfo.getInstance();
        sb.append(ideInfo.getMajorVersion()).append('.').append(ideInfo.getMinorVersion()).append('.').append(ideInfo.getMicroVersion()).append('.').append(ideInfo.getPatchVersion());
        MergedManifest manifest = MergedManifest.get(this.myFacet);
        String pkg = manifest.getPackage();
        if (pkg != null) {
            sb.append("&pkgName=");
            sb.append(pkg.replace('.', '_'));
        }
        if ((appId = (moduleInfo = AndroidModuleInfo.get(this.myFacet)).getPackage()) != null) {
            sb.append("&appId=");
            sb.append(appId.replace('.', '_'));
        }
        if ((versionCode = manifest.getVersionCode()) != null) {
            sb.append("&apkVer=");
            sb.append(versionCode.toString());
        }
        BrowserUtil.browse((String)sb.toString());
    }

    @VisibleForTesting
    void parse(@NotNull LocalResourceRepository resourceRepository) {
        if (resourceRepository == null) {
            StringResourceViewPanel.$$$reportNull$$$0(2);
        }
        this.parse(resourceRepository, StringResourceParser.parse(this.myFacet, resourceRepository));
    }

    private void parse(@NotNull LocalResourceRepository resourceRepository, @NotNull StringResourceData data) {
        if (resourceRepository == null) {
            StringResourceViewPanel.$$$reportNull$$$0(3);
        }
        if (data == null) {
            StringResourceViewPanel.$$$reportNull$$$0(4);
        }
        this.myResourceRepository = resourceRepository;
        this.myModificationCount = resourceRepository.getModificationCount();
        this.myTable.setModel(new StringResourceTableModel(data));
        this.myLoadingPanel.stopLoading();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/editors/strings/StringResourceViewPanel";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resourceRepository";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreferredFocusedComponent";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/editors/strings/StringResourceViewPanel";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "parse";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JPanel jPanel2;
        this.createUIComponents();
        this.myContainer = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jPanel2.add((Component)jBScrollPane, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        StringResourceTable stringResourceTable = this.myTable;
        jBScrollPane.setViewportView((Component)((Object)stringResourceTable));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(5, 5, 5, 5), -1, -1, false, false));
        jPanel2.add((Component)jPanel3, new GridConstraints(2, 0, 1, 1, 2, 1, 3, 1, null, null, null));
        JBLabel jBLabel = new JBLabel();
        jBLabel.setText("Key:");
        jPanel3.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 4, 0, 0, 0, null, null, null));
        JTextField jTextField = new JTextField();
        this.myKeyTextField = jTextField;
        jPanel3.add((Component)jTextField, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JBLabel jBLabel2 = new JBLabel();
        jBLabel2.setText("Default Value:");
        jPanel3.add((Component)jBLabel2, new GridConstraints(1, 0, 1, 1, 4, 0, 0, 0, null, null, null));
        JBLabel jBLabel3 = new JBLabel();
        jBLabel3.setText("Translation:");
        jPanel3.add((Component)jBLabel3, new GridConstraints(2, 0, 1, 1, 4, 0, 0, 0, null, null, null));
        TextFieldWithBrowseButton textFieldWithBrowseButton = this.myDefaultValueTextField;
        textFieldWithBrowseButton.setName("defaultValueTextField");
        jPanel3.add((Component)textFieldWithBrowseButton, new GridConstraints(1, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        TextFieldWithBrowseButton textFieldWithBrowseButton2 = this.myTranslationTextField;
        jPanel3.add((Component)textFieldWithBrowseButton2, new GridConstraints(2, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        this.myToolbarPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel2.add((Component)jPanel, new GridConstraints(0, 0, 1, 1, 1, 1, 0, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myContainer;
    }

    private class ShowMultilineActionListener
    implements ActionListener {
        private ShowMultilineActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (StringResourceViewPanel.this.myTable.getSelectedRowCount() != 1 || StringResourceViewPanel.this.myTable.getSelectedColumnCount() != 1) {
                return;
            }
            int row = StringResourceViewPanel.this.myTable.getSelectedRowModelIndex();
            int column = StringResourceViewPanel.this.myTable.getSelectedColumnModelIndex();
            StringResourceTableModel model = (StringResourceTableModel)StringResourceViewPanel.this.myTable.getModel();
            String value = (String)model.getValueAt(row, 2);
            Locale locale = model.getLocale(column);
            String translation = locale == null ? null : (String)model.getValueAt(row, column);
            MultilineStringEditorDialog d = new MultilineStringEditorDialog(StringResourceViewPanel.this.myFacet, model.getKey(row), value, locale, translation);
            if (d.showAndGet()) {
                if (!StringUtil.equals((CharSequence)value, (CharSequence)d.getDefaultValue())) {
                    model.setValueAt(d.getDefaultValue(), row, 2);
                    StringResourceViewPanel.this.myTable.refilter();
                }
                if (locale != null && !StringUtil.equals((CharSequence)translation, (CharSequence)d.getTranslation())) {
                    model.setValueAt(d.getTranslation(), row, column);
                    StringResourceViewPanel.this.myTable.refilter();
                }
            }
        }
    }

    private class CellSelectionListener
    implements ListSelectionListener {
        private CellSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (e.getValueIsAdjusting()) {
                return;
            }
            if (StringResourceViewPanel.this.myTable.getSelectedColumnCount() != 1 || StringResourceViewPanel.this.myTable.getSelectedRowCount() != 1) {
                this.setTextAndEditable(StringResourceViewPanel.this.myKeyTextField, "", false);
                this.setTextAndEditable(StringResourceViewPanel.this.myDefaultValueTextField.getTextField(), "", false);
                this.setTextAndEditable(StringResourceViewPanel.this.myTranslationTextField.getTextField(), "", false);
                StringResourceViewPanel.this.myDefaultValueTextField.getButton().setEnabled(false);
                StringResourceViewPanel.this.myTranslationTextField.getButton().setEnabled(false);
                return;
            }
            StringResourceTableModel model = (StringResourceTableModel)StringResourceViewPanel.this.myTable.getModel();
            int row = StringResourceViewPanel.this.myTable.getSelectedRowModelIndex();
            int column = StringResourceViewPanel.this.myTable.getSelectedColumnModelIndex();
            Locale locale = model.getLocale(column);
            this.setTextAndEditable(StringResourceViewPanel.this.myKeyTextField, model.getKey(row), false);
            String defaultValue = (String)model.getValueAt(row, 2);
            boolean defaultValueEditable = !StringUtil.containsChar((String)defaultValue, (char)'\n');
            this.setTextAndEditable(StringResourceViewPanel.this.myDefaultValueTextField.getTextField(), defaultValue, defaultValueEditable);
            StringResourceViewPanel.this.myDefaultValueTextField.getButton().setEnabled(true);
            boolean translationEditable = false;
            String translation = "";
            if (locale != null) {
                translation = (String)model.getValueAt(row, column);
                translationEditable = !StringUtil.containsChar((String)translation, (char)'\n');
            }
            this.setTextAndEditable(StringResourceViewPanel.this.myTranslationTextField.getTextField(), translation, translationEditable);
            StringResourceViewPanel.this.myTranslationTextField.getButton().setEnabled(locale != null);
        }

        private void setTextAndEditable(@NotNull JTextComponent component, @NotNull String text, boolean editable) {
            if (component == null) {
                CellSelectionListener.$$$reportNull$$$0(0);
            }
            if (text == null) {
                CellSelectionListener.$$$reportNull$$$0(1);
            }
            component.setText(text);
            component.setCaretPosition(0);
            component.setEditable(editable);
            component.getCaret().setVisible(editable && component.hasFocus());
            component.setFont(FontUtil.getFontAbleToDisplay(text, component.getFont()));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "component";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "text";
                    break;
                }
            }
            objectArray[1] = "com/android/tools/idea/editors/strings/StringResourceViewPanel$CellSelectionListener";
            objectArray[2] = "setTextAndEditable";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class ParseTask
    extends Task.Backgroundable {
        private final AtomicReference<LocalResourceRepository> myResourceRepositoryRef;
        private final AtomicReference<StringResourceData> myResourceDataRef;

        public ParseTask(String description) {
            super(StringResourceViewPanel.this.myFacet.getModule().getProject(), description, false);
            this.myResourceRepositoryRef = new AtomicReference<Object>(null);
            this.myResourceDataRef = new AtomicReference<Object>(null);
        }

        public void run(@NotNull ProgressIndicator indicator) {
            if (indicator == null) {
                ParseTask.$$$reportNull$$$0(0);
            }
            indicator.setIndeterminate(true);
            LocalResourceRepository moduleResources = StringResourceViewPanel.this.myFacet.getModuleResources(true);
            this.myResourceRepositoryRef.set(moduleResources);
            this.myResourceDataRef.set(StringResourceParser.parse(StringResourceViewPanel.this.myFacet, moduleResources));
        }

        public void onSuccess() {
            StringResourceViewPanel.this.parse(this.myResourceRepositoryRef.get(), this.myResourceDataRef.get());
        }

        public void onCancel() {
            StringResourceViewPanel.this.myLoadingPanel.stopLoading();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/android/tools/idea/editors/strings/StringResourceViewPanel$ParseTask", "run"));
        }
    }

    private final class AddLocaleAction
    extends AnAction {
        private final JComponent myComponent;

        private AddLocaleAction(JComponent component) {
            if (component == null) {
                AddLocaleAction.$$$reportNull$$$0(0);
            }
            super("Add Locale", "", AndroidIcons.Globe);
            this.myComponent = component;
        }

        public void update(@NotNull AnActionEvent event) {
            if (event == null) {
                AddLocaleAction.$$$reportNull$$$0(1);
            }
            StringResourceData data = StringResourceViewPanel.this.myTable.getData();
            event.getPresentation().setEnabled(data != null && !data.getResources().isEmpty());
        }

        public void actionPerformed(AnActionEvent e) {
            StringResourceData data = StringResourceViewPanel.this.myTable.getData();
            assert (data != null);
            List<Locale> missingLocales = LocaleMenuAction.getAllLocales();
            missingLocales.removeAll(data.getLocales());
            Collections.sort(missingLocales, Locale.LANGUAGE_NAME_COMPARATOR);
            JBList list = new JBList(missingLocales);
            list.setFixedCellHeight(20);
            list.setCellRenderer((ListCellRenderer)new ColoredListCellRenderer<Locale>(){

                protected void customizeCellRenderer(@NotNull JList list, Locale value, int index, boolean selected, boolean hasFocus) {
                    if (list == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    this.append(LocaleMenuAction.getLocaleLabel(value, false));
                    this.setIcon(value.getFlagImage());
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/android/tools/idea/editors/strings/StringResourceViewPanel$AddLocaleAction$1", "customizeCellRenderer"));
                }
            });
            new ListSpeedSearch((JList)list){

                protected String getElementText(Object element) {
                    if (element instanceof Locale) {
                        return LocaleMenuAction.getLocaleLabel((Locale)element, false);
                    }
                    return super.getElementText(element);
                }
            };
            this.showPopupUnderneathOf((JList)list);
        }

        private void showPopupUnderneathOf(@NotNull JList list) {
            if (list == null) {
                AddLocaleAction.$$$reportNull$$$0(2);
            }
            Runnable runnable = () -> {
                if (list == null) {
                    AddLocaleAction.$$$reportNull$$$0(3);
                }
                VirtualFile primaryResourceDir = StringResourceViewPanel.this.myFacet.getPrimaryResourceDir();
                assert (primaryResourceDir != null);
                StringResourceData data = StringResourceViewPanel.this.myTable.getData();
                assert (data != null);
                String key = "app_name";
                StringResource resource = data.containsKey(key) ? data.getStringResource(key) : data.getResources().iterator().next();
                String string = resource.getDefaultValueAsString();
                StringsWriteUtils.createItem(StringResourceViewPanel.this.myFacet, primaryResourceDir, (Locale)list.getSelectedValue(), resource.getKey(), string, true);
            };
            JBPopup popup = JBPopupFactory.getInstance().createListPopupBuilder(list).setItemChoosenCallback(runnable).createPopup();
            popup.showUnderneathOf((Component)this.myComponent);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "component";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "list";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/editors/strings/StringResourceViewPanel$AddLocaleAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "showPopupUnderneathOf";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "lambda$showPopupUnderneathOf$0";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private final class RemoveKeysAction
    extends AnAction {
        private RemoveKeysAction() {
            super("Remove Keys", "", AllIcons.ToolbarDecorator.Remove);
        }

        public void update(@NotNull AnActionEvent event) {
            if (event == null) {
                RemoveKeysAction.$$$reportNull$$$0(0);
            }
            event.getPresentation().setEnabled(StringResourceViewPanel.this.myTable.getSelectedRowCount() != 0);
        }

        public void actionPerformed(@NotNull AnActionEvent event) {
            if (event == null) {
                RemoveKeysAction.$$$reportNull$$$0(1);
            }
            Project project = event.getProject();
            assert (project != null);
            PsiElement[] elements = (PsiElement[])Arrays.stream(StringResourceViewPanel.this.myTable.getSelectedRowModelIndices()).mapToObj(index -> ((StringResourceTableModel)StringResourceViewPanel.this.myTable.getModel()).getStringResourceAt(index).getKey()).flatMap(this::getResourceItemStream).map(item -> LocalResourceRepository.getItemTag(project, item)).toArray(PsiElement[]::new);
            SafeDeleteHandler.invoke((Project)project, (PsiElement[])elements, (Module)((Module)LangDataKeys.MODULE.getData(event.getDataContext())), (boolean)true, null);
        }

        @NotNull
        private Stream<ResourceItem> getResourceItemStream(@NotNull String key) {
            List items;
            if (key == null) {
                RemoveKeysAction.$$$reportNull$$$0(2);
            }
            Stream<Object> stream = (items = StringResourceViewPanel.this.myResourceRepository.getResourceItem(ResourceType.STRING, key)) == null ? Stream.empty() : items.stream();
            if (stream == null) {
                RemoveKeysAction.$$$reportNull$$$0(3);
            }
            return stream;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "key";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/editors/strings/StringResourceViewPanel$RemoveKeysAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/editors/strings/StringResourceViewPanel$RemoveKeysAction";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getResourceItemStream";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getResourceItemStream";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private final class SetTableValueAtFocusListener
    implements FocusListener {
        private final IntSupplier myColumnSupplier;
        private int mySelectedRowCount;
        private int mySelectedColumnCount;
        private int myRow;
        private int myColumn;

        private SetTableValueAtFocusListener(int column) {
            this.myColumnSupplier = () -> column;
        }

        private SetTableValueAtFocusListener(IntSupplier columnSupplier) {
            if (columnSupplier == null) {
                SetTableValueAtFocusListener.$$$reportNull$$$0(0);
            }
            this.myColumnSupplier = columnSupplier;
        }

        @Override
        public void focusGained(@NotNull FocusEvent event) {
            if (event == null) {
                SetTableValueAtFocusListener.$$$reportNull$$$0(1);
            }
            this.mySelectedRowCount = StringResourceViewPanel.this.myTable.getSelectedRowCount();
            this.mySelectedColumnCount = StringResourceViewPanel.this.myTable.getSelectedColumnCount();
            this.myRow = StringResourceViewPanel.this.myTable.getSelectedRowModelIndex();
            this.myColumn = this.myColumnSupplier.getAsInt();
        }

        @Override
        public void focusLost(@NotNull FocusEvent event) {
            if (event == null) {
                SetTableValueAtFocusListener.$$$reportNull$$$0(2);
            }
            if (this.mySelectedRowCount != 1 || this.mySelectedColumnCount != 1) {
                return;
            }
            JTextComponent component = (JTextComponent)event.getComponent();
            if (!component.isEditable()) {
                return;
            }
            StringResourceViewPanel.this.myTable.getModel().setValueAt(component.getText(), this.myRow, this.myColumn);
            StringResourceViewPanel.this.myTable.refilter();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "columnSupplier";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/editors/strings/StringResourceViewPanel$SetTableValueAtFocusListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "focusGained";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "focusLost";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class TranslationsEditorTextField
    extends JBTextField {
        private TranslationsEditorTextField() {
            super(10);
        }

        public void paste() {
            super.paste();
            this.setFont(FontUtil.getFontAbleToDisplay(this.getText(), this.getFont()));
        }
    }
}

