/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.strings;

import com.android.ide.common.res2.ResourceItem;
import com.android.ide.common.res2.ValueXmlHelper;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.ide.common.resources.configuration.LocaleQualifier;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.tools.idea.rendering.Locale;
import com.android.tools.idea.res.LocalResourceRepository;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.XmlElementFactory;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlTagChild;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.util.AndroidResourceUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StringsWriteUtils {
    public static boolean setAttributeForItems(@NotNull Project project, final @NotNull String attribute, final @Nullable String value, @NotNull List<ResourceItem> items) {
        if (project == null) {
            StringsWriteUtils.$$$reportNull$$$0(0);
        }
        if (attribute == null) {
            StringsWriteUtils.$$$reportNull$$$0(1);
        }
        if (items == null) {
            StringsWriteUtils.$$$reportNull$$$0(2);
        }
        if (items.isEmpty()) {
            return false;
        }
        final ArrayList tags = Lists.newArrayListWithExpectedSize((int)items.size());
        HashSet files = Sets.newHashSetWithExpectedSize((int)items.size());
        for (ResourceItem item : items) {
            XmlTag tag = LocalResourceRepository.getItemTag(project, item);
            if (tag == null) {
                return false;
            }
            tags.add(tag);
            files.add(tag.getContainingFile());
        }
        final boolean deleteTag = attribute.equals("name") && (value == null || value.isEmpty());
        new WriteCommandAction.Simple(project, "Setting attribute " + attribute, files.toArray(new PsiFile[files.size()])){

            public void run() {
                for (XmlTag tag : tags) {
                    if (deleteTag) {
                        tag.delete();
                        continue;
                    }
                    tag.setAttribute(attribute, value);
                }
            }
        }.execute();
        return true;
    }

    public static boolean setItemText(final @NotNull Project project, @NotNull ResourceItem item, final @NotNull String value) {
        if (project == null) {
            StringsWriteUtils.$$$reportNull$$$0(3);
        }
        if (item == null) {
            StringsWriteUtils.$$$reportNull$$$0(4);
        }
        if (value == null) {
            StringsWriteUtils.$$$reportNull$$$0(5);
        }
        if (value.isEmpty()) {
            return StringsWriteUtils.setAttributeForItems(project, "name", null, Collections.singletonList(item));
        }
        final XmlTag tag = LocalResourceRepository.getItemTag(project, item);
        if (tag != null) {
            new WriteCommandAction.Simple(project, "Setting value of " + item.getName(), new PsiFile[]{tag.getContainingFile()}){

                public void run() {
                    for (XmlTagChild child : tag.getValue().getChildren()) {
                        child.delete();
                    }
                    XmlElementFactory factory = XmlElementFactory.getInstance((Project)project);
                    XmlTag text = factory.createTagFromText((CharSequence)("<string>" + StringsWriteUtils.escapeResourceStringAsXml(value) + "</string>"));
                    for (XmlTagChild psiElement : text.getValue().getChildren()) {
                        tag.add((PsiElement)psiElement);
                    }
                }
            }.execute();
            return true;
        }
        return false;
    }

    @Nullable
    public static ResourceItem createItem(final @NotNull AndroidFacet facet, @NotNull VirtualFile resFolder, final @Nullable Locale locale, final @NotNull String name, final @NotNull String value, final boolean translatable) {
        Project project;
        XmlFile resourceFile;
        if (facet == null) {
            StringsWriteUtils.$$$reportNull$$$0(6);
        }
        if (resFolder == null) {
            StringsWriteUtils.$$$reportNull$$$0(7);
        }
        if (name == null) {
            StringsWriteUtils.$$$reportNull$$$0(8);
        }
        if (value == null) {
            StringsWriteUtils.$$$reportNull$$$0(9);
        }
        if ((resourceFile = StringsWriteUtils.getStringResourceFile(project = facet.getModule().getProject(), resFolder, locale)) == null) {
            return null;
        }
        final XmlTag root = resourceFile.getRootTag();
        if (root == null) {
            return null;
        }
        new WriteCommandAction.Simple(project, "Creating string " + name, new PsiFile[]{resourceFile}){

            public void run() {
                XmlTag child = root.createChildTag(ResourceType.STRING.getName(), root.getNamespace(), StringsWriteUtils.escapeResourceStringAsXml(value), false);
                child.setAttribute("name", name);
                child.setAttribute("translatable", translatable ? null : "false");
                root.addSubTag(child, false);
            }
        }.execute();
        if (ApplicationManager.getApplication().isReadAccessAllowed()) {
            return StringsWriteUtils.getStringResourceItem(facet, name, locale);
        }
        return (ResourceItem)ApplicationManager.getApplication().runReadAction((Computable)new Computable<ResourceItem>(){

            public ResourceItem compute() {
                return StringsWriteUtils.getStringResourceItem(facet, name, locale);
            }
        });
    }

    @Nullable
    private static ResourceItem getStringResourceItem(@NotNull AndroidFacet facet, @NotNull String key, @Nullable Locale locale) {
        if (facet == null) {
            StringsWriteUtils.$$$reportNull$$$0(10);
        }
        if (key == null) {
            StringsWriteUtils.$$$reportNull$$$0(11);
        }
        LocalResourceRepository repository = facet.getModuleResources(true);
        repository.sync();
        List items = repository.getResourceItem(ResourceType.STRING, key);
        if (items == null) {
            return null;
        }
        for (ResourceItem item : items) {
            Locale l;
            LocaleQualifier qualifier;
            FolderConfiguration config = item.getConfiguration();
            LocaleQualifier localeQualifier = qualifier = config == null ? null : config.getLocaleQualifier();
            if (!(qualifier == null ? locale == null : (l = Locale.create(qualifier)).equals(locale))) continue;
            return item;
        }
        return null;
    }

    @Nullable
    private static XmlFile getStringResourceFile(@NotNull Project project, final @NotNull VirtualFile resFolder, @Nullable Locale locale) {
        XmlFile resourceFile;
        if (project == null) {
            StringsWriteUtils.$$$reportNull$$$0(12);
        }
        if (resFolder == null) {
            StringsWriteUtils.$$$reportNull$$$0(13);
        }
        FolderConfiguration configuration = new FolderConfiguration();
        if (locale != null) {
            configuration.setLocaleQualifier(locale.qualifier);
        }
        PsiManager manager = PsiManager.getInstance((Project)project);
        final String valuesFolderName = configuration.getFolderName(ResourceFolderType.VALUES);
        VirtualFile valuesFolder = resFolder.findChild(valuesFolderName);
        if (valuesFolder == null && (valuesFolder = (VirtualFile)new WriteCommandAction<VirtualFile>(project, "Creating directory " + valuesFolderName, new PsiFile[]{manager.findFile(resFolder)}){

            public void run(@NotNull Result<VirtualFile> result) {
                if (result == null) {
                    5.$$$reportNull$$$0(0);
                }
                try {
                    result.setResult((Object)resFolder.createChildDirectory((Object)this, valuesFolderName));
                }
                catch (IOException ex) {
                    result.setResult(null);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/android/tools/idea/editors/strings/StringsWriteUtils$5", "run"));
            }
        }.execute().getResultObject()) == null) {
            return null;
        }
        String resourceFileName = AndroidResourceUtil.getDefaultResourceFileName(ResourceType.STRING);
        if (resourceFileName == null) {
            return null;
        }
        VirtualFile resourceVirtualFile = valuesFolder.findChild(resourceFileName);
        if (resourceVirtualFile == null) {
            PsiDirectory valuesDir = manager.findDirectory(valuesFolder);
            if (valuesDir == null) {
                return null;
            }
            try {
                resourceFile = AndroidResourceUtil.createFileResource(resourceFileName, valuesDir, "", ResourceType.STRING.getName(), true);
            }
            catch (Exception ex) {
                return null;
            }
        } else {
            PsiFile resourcePsiFile = manager.findFile(resourceVirtualFile);
            if (!(resourcePsiFile instanceof XmlFile)) {
                return null;
            }
            resourceFile = (XmlFile)resourcePsiFile;
        }
        return resourceFile;
    }

    @NotNull
    private static String escapeResourceStringAsXml(@NotNull String xml) {
        String string;
        if (xml == null) {
            StringsWriteUtils.$$$reportNull$$$0(14);
        }
        try {
            string = ValueXmlHelper.escapeResourceStringAsXml((String)xml);
        }
        catch (IllegalArgumentException exception) {
            Logger.getInstance(StringsWriteUtils.class).warn((Throwable)exception);
            String string2 = xml;
            if (string2 == null) {
                StringsWriteUtils.$$$reportNull$$$0(16);
            }
            return string2;
        }
        if (string == null) {
            StringsWriteUtils.$$$reportNull$$$0(15);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 15: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 15: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attribute";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "items";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 7: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resFolder";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "xml";
                break;
            }
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/editors/strings/StringsWriteUtils";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/editors/strings/StringsWriteUtils";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "escapeResourceStringAsXml";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setAttributeForItems";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setItemText";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createItem";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getStringResourceItem";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getStringResourceFile";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "escapeResourceStringAsXml";
                break;
            }
            case 15: 
            case 16: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 15: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

