/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.theme;

import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.rendering.api.StyleResourceValue;
import com.android.ide.common.resources.ResourceRepository;
import com.android.ide.common.resources.ResourceResolver;
import com.android.ide.common.resources.ResourceValueMap;
import com.android.resources.ResourceType;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.editors.theme.ResolutionUtils;
import com.android.tools.idea.editors.theme.datamodels.ConfiguredThemeEditorStyle;
import com.android.tools.idea.res.AppResourceRepository;
import com.android.tools.idea.res.LocalResourceRepository;
import com.android.tools.idea.res.ModuleResourceRepository;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ThemeResolver {
    private final Map<String, ConfiguredThemeEditorStyle> myThemeByName;
    private final ImmutableList<ConfiguredThemeEditorStyle> myFrameworkThemes;
    private final ImmutableList<ConfiguredThemeEditorStyle> myLocalThemes;
    private final ImmutableList<ConfiguredThemeEditorStyle> myExternalLibraryThemes;
    private final Configuration myConfiguration;
    private final ResourceResolver myResolver;

    public ThemeResolver(@NotNull Configuration configuration) {
        if (configuration == null) {
            ThemeResolver.$$$reportNull$$$0(0);
        }
        this.myThemeByName = Maps.newHashMap();
        this.myConfiguration = configuration;
        this.myResolver = configuration.getResourceResolver();
        if (this.myResolver == null) {
            throw new IllegalArgumentException("Acquired ResourceResolver is null, not an Android module?");
        }
        this.myFrameworkThemes = this.fillThemeResolverFromStyles(this.resolveFrameworkThemes());
        ImmutableList.Builder localThemes = ImmutableList.builder();
        for (Pair<StyleResourceValue, Module> pair : this.resolveLocallyDefinedModuleThemes()) {
            ConfiguredThemeEditorStyle theme = this.constructThemeFromResourceValue((StyleResourceValue)pair.getFirst(), (Module)pair.getSecond());
            if (theme == null) continue;
            localThemes.add((Object)theme);
        }
        this.myLocalThemes = localThemes.build();
        this.myExternalLibraryThemes = this.fillThemeResolverFromStyles(this.resolveNonFrameworkThemes());
    }

    @Nullable
    private ConfiguredThemeEditorStyle constructThemeFromResourceValue(@NotNull StyleResourceValue value, @Nullable Module sourceModule) {
        String name;
        if (value == null) {
            ThemeResolver.$$$reportNull$$$0(1);
        }
        if (this.myThemeByName.containsKey(name = ResolutionUtils.getQualifiedStyleName(value))) {
            return null;
        }
        ConfiguredThemeEditorStyle theme = ResolutionUtils.getStyle(this.myConfiguration, name, sourceModule);
        if (theme != null) {
            this.myThemeByName.put(name, theme);
        }
        return theme;
    }

    private ImmutableList<ConfiguredThemeEditorStyle> fillThemeResolverFromStyles(@NotNull List<StyleResourceValue> source) {
        if (source == null) {
            ThemeResolver.$$$reportNull$$$0(2);
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        for (StyleResourceValue value : source) {
            ConfiguredThemeEditorStyle theme = this.constructThemeFromResourceValue(value, null);
            if (theme == null) continue;
            builder.add((Object)theme);
        }
        return builder.build();
    }

    @NotNull
    private List<StyleResourceValue> resolveFrameworkThemes() {
        ResourceRepository repository = this.myConfiguration.getFrameworkResources();
        if (repository == null) {
            List<StyleResourceValue> list = Collections.emptyList();
            if (list == null) {
                ThemeResolver.$$$reportNull$$$0(3);
            }
            return list;
        }
        List<StyleResourceValue> list = this.getThemes((ResourceValueMap)repository.getConfiguredResources(this.myConfiguration.getFullConfig()).get(ResourceType.STYLE), true);
        if (list == null) {
            ThemeResolver.$$$reportNull$$$0(4);
        }
        return list;
    }

    @NotNull
    private List<StyleResourceValue> resolveNonFrameworkThemes() {
        AppResourceRepository repository = AppResourceRepository.getAppResources(this.myConfiguration.getModule(), true);
        if (repository == null) {
            List<StyleResourceValue> list = Collections.emptyList();
            if (list == null) {
                ThemeResolver.$$$reportNull$$$0(5);
            }
            return list;
        }
        List<StyleResourceValue> list = this.getThemes(repository.getConfiguredResources(ResourceType.STYLE, this.myConfiguration.getFullConfig()), false);
        if (list == null) {
            ThemeResolver.$$$reportNull$$$0(6);
        }
        return list;
    }

    @NotNull
    private List<Pair<StyleResourceValue, Module>> resolveLocallyDefinedModuleThemes() {
        Module module = this.myConfiguration.getModule();
        ArrayList result = Lists.newArrayList();
        this.fillModuleResources(module, ModuleResourceRepository.getModuleResources(module, true), result);
        List<AndroidFacet> allAndroidDependencies = AndroidUtils.getAllAndroidDependencies(module, false);
        for (AndroidFacet facet : allAndroidDependencies) {
            this.fillModuleResources(facet.getModule(), facet.getModuleResources(true), result);
        }
        ArrayList arrayList = result;
        if (arrayList == null) {
            ThemeResolver.$$$reportNull$$$0(7);
        }
        return arrayList;
    }

    private void fillModuleResources(@NotNull Module module, @Nullable LocalResourceRepository repository, @NotNull List<Pair<StyleResourceValue, Module>> sink) {
        if (module == null) {
            ThemeResolver.$$$reportNull$$$0(8);
        }
        if (sink == null) {
            ThemeResolver.$$$reportNull$$$0(9);
        }
        if (repository == null) {
            return;
        }
        for (StyleResourceValue value : this.getThemes(repository.getConfiguredResources(ResourceType.STYLE, this.myConfiguration.getFullConfig()), false)) {
            sink.add((Pair<StyleResourceValue, Module>)Pair.create((Object)value, (Object)module));
        }
    }

    @NotNull
    private List<StyleResourceValue> getThemes(@NotNull ResourceValueMap styles, boolean isFramework) {
        if (styles == null) {
            ThemeResolver.$$$reportNull$$$0(10);
        }
        Collection values = styles.values();
        ArrayList<StyleResourceValue> themes = new ArrayList<StyleResourceValue>(values.size());
        if (!isFramework) {
            HashMap cache = Maps.newHashMapWithExpectedSize((int)values.size());
            for (ResourceValue value : values) {
                StyleResourceValue styleValue;
                if (!(value instanceof StyleResourceValue) || !this.myResolver.isTheme((ResourceValue)(styleValue = (StyleResourceValue)value), (Map)cache)) continue;
                themes.add(styleValue);
            }
            ArrayList<StyleResourceValue> arrayList = themes;
            if (arrayList == null) {
                ThemeResolver.$$$reportNull$$$0(11);
            }
            return arrayList;
        }
        for (ResourceValue value : values) {
            String name = value.getName();
            if (!name.startsWith("Theme.") && !name.equals("Theme")) continue;
            themes.add((StyleResourceValue)value);
        }
        ArrayList<StyleResourceValue> arrayList = themes;
        if (arrayList == null) {
            ThemeResolver.$$$reportNull$$$0(12);
        }
        return arrayList;
    }

    @Nullable
    public ConfiguredThemeEditorStyle getTheme(@NotNull String themeName) {
        if (themeName == null) {
            ThemeResolver.$$$reportNull$$$0(13);
        }
        return this.myThemeByName.get(themeName);
    }

    @NotNull
    public ImmutableList<ConfiguredThemeEditorStyle> getLocalThemes() {
        ImmutableList<ConfiguredThemeEditorStyle> immutableList = this.myLocalThemes;
        if (immutableList == null) {
            ThemeResolver.$$$reportNull$$$0(14);
        }
        return immutableList;
    }

    @NotNull
    public ImmutableList<ConfiguredThemeEditorStyle> getExternalLibraryThemes() {
        ImmutableList<ConfiguredThemeEditorStyle> immutableList = this.myExternalLibraryThemes;
        if (immutableList == null) {
            ThemeResolver.$$$reportNull$$$0(15);
        }
        return immutableList;
    }

    @NotNull
    public ImmutableList<ConfiguredThemeEditorStyle> getFrameworkThemes() {
        ImmutableList<ConfiguredThemeEditorStyle> immutableList = this.myFrameworkThemes;
        if (immutableList == null) {
            ThemeResolver.$$$reportNull$$$0(16);
        }
        return immutableList;
    }

    public int getThemesCount() {
        return this.myFrameworkThemes.size() + this.myExternalLibraryThemes.size() + this.myLocalThemes.size();
    }

    @NotNull
    Configuration getConfiguration() {
        Configuration configuration = this.myConfiguration;
        if (configuration == null) {
            ThemeResolver.$$$reportNull$$$0(17);
        }
        return configuration;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/editors/theme/ThemeResolver";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sink";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "styles";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "themeName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/editors/theme/ThemeResolver";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveFrameworkThemes";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveNonFrameworkThemes";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveLocallyDefinedModuleThemes";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getThemes";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocalThemes";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getExternalLibraryThemes";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getFrameworkThemes";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfiguration";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "constructThemeFromResourceValue";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "fillThemeResolverFromStyles";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "fillModuleResources";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getThemes";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getTheme";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

