/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.theme.attributes;

import com.android.tools.idea.editors.theme.attributes.TableLabel;
import com.android.tools.idea.editors.theme.datamodels.EditedStyleItem;
import com.google.common.base.Supplier;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimaps;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.TreeMap;
import org.jetbrains.annotations.NotNull;

public class AttributesGrouper {
    private AttributesGrouper() {
    }

    @NotNull
    private static List<TableLabel> generateLabelsForType(@NotNull List<EditedStyleItem> source, @NotNull List<EditedStyleItem> sink) {
        if (source == null) {
            AttributesGrouper.$$$reportNull$$$0(0);
        }
        if (sink == null) {
            AttributesGrouper.$$$reportNull$$$0(1);
        }
        ArrayListMultimap classes = ArrayListMultimap.create();
        for (EditedStyleItem item : source) {
            String name = item.getName();
            classes.put((Object)Group.getGroupFromName(name), (Object)item);
        }
        ArrayList<TableLabel> labels = new ArrayList<TableLabel>();
        int offset = 0;
        for (Group group : Group.values()) {
            boolean addHeader;
            Collection elements = classes.get((Object)group);
            boolean bl = addHeader = !elements.isEmpty();
            if (addHeader && group == Group.OTHER) {
                boolean bl2 = addHeader = offset != 0;
            }
            if (addHeader) {
                labels.add(new TableLabel(group.name, offset));
            }
            sink.addAll(elements);
            offset += elements.size();
        }
        ArrayList<TableLabel> arrayList = labels;
        if (arrayList == null) {
            AttributesGrouper.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    @NotNull
    private static List<TableLabel> generateLabelsForGroup(List<EditedStyleItem> source, List<EditedStyleItem> sink) {
        ListMultimap classes = Multimaps.newListMultimap(new TreeMap(), (Supplier)new Supplier<List<EditedStyleItem>>(){

            public List<EditedStyleItem> get() {
                return new ArrayList<EditedStyleItem>();
            }
        });
        for (EditedStyleItem item : source) {
            String group = item.getAttrGroup();
            classes.put((Object)group, (Object)item);
        }
        ArrayList<TableLabel> labels = new ArrayList<TableLabel>();
        int offset = 0;
        sink.clear();
        for (String group : classes.keySet()) {
            int size = classes.get((Object)group).size();
            sink.addAll(classes.get((Object)group));
            if (size != 0) {
                labels.add(new TableLabel(group, offset));
            }
            offset += size;
        }
        ArrayList<TableLabel> arrayList = labels;
        if (arrayList == null) {
            AttributesGrouper.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    @NotNull
    public static List<TableLabel> generateLabels(@NotNull GroupBy group, List<EditedStyleItem> source, List<EditedStyleItem> sink) {
        if (group == null) {
            AttributesGrouper.$$$reportNull$$$0(4);
        }
        switch (group) {
            case TYPE: {
                List<TableLabel> list = AttributesGrouper.generateLabelsForType(source, sink);
                if (list == null) {
                    AttributesGrouper.$$$reportNull$$$0(5);
                }
                return list;
            }
            case GROUP: {
                List<TableLabel> list = AttributesGrouper.generateLabelsForGroup(source, sink);
                if (list == null) {
                    AttributesGrouper.$$$reportNull$$$0(6);
                }
                return list;
            }
        }
        throw new IllegalArgumentException();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sink";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/editors/theme/attributes/AttributesGrouper";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/editors/theme/attributes/AttributesGrouper";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "generateLabelsForType";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "generateLabelsForGroup";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "generateLabels";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "generateLabelsForType";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "generateLabels";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static enum Group {
        STYLES("Styles", (List<String>)ImmutableList.of((Object)"style", (Object)"theme")),
        COLORS("Colors", (List<String>)ImmutableList.of((Object)"color")),
        DRAWABLES("Drawables", (List<String>)ImmutableList.of((Object)"drawable")),
        METRICS("Metrics", (List<String>)ImmutableList.of((Object)"size", (Object)"width", (Object)"height")),
        OTHER("Everything Else", Collections.emptyList());

        public final String name;
        public final List<String> markers;

        private Group(String name, List<String> markers) {
            if (name == null) {
                Group.$$$reportNull$$$0(0);
            }
            if (markers == null) {
                Group.$$$reportNull$$$0(1);
            }
            this.name = name;
            this.markers = markers;
        }

        private static Group getGroupFromName(String name) {
            for (Group group : Group.values()) {
                for (String marker : group.markers) {
                    if (!StringUtil.containsIgnoreCase((String)name, (String)marker)) continue;
                    return group;
                }
            }
            return OTHER;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "name";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "markers";
                    break;
                }
            }
            objectArray[1] = "com/android/tools/idea/editors/theme/attributes/AttributesGrouper$Group";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static enum GroupBy {
        GROUP("By Group"),
        TYPE("By Type");

        private final String myText;

        private GroupBy(String text) {
            this.myText = text;
        }

        public String toString() {
            return this.myText;
        }
    }
}

