/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.model.android;

import com.android.tools.idea.gradle.dsl.model.android.AbstractFlavorTypeModel;
import com.android.tools.idea.gradle.dsl.model.values.GradleNotNullValue;
import com.android.tools.idea.gradle.dsl.model.values.GradleNullableValue;
import com.android.tools.idea.gradle.dsl.parser.android.BuildTypeDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslExpressionList;
import com.android.utils.Pair;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BuildTypeModel
extends AbstractFlavorTypeModel {
    @NonNls
    private static final String APPLICATION_ID_SUFFIX = "applicationIdSuffix";
    @NonNls
    private static final String BUILD_CONFIG_FIELD = "buildConfigField";
    @NonNls
    private static final String DEBUGGABLE = "debuggable";
    @NonNls
    private static final String EMBED_MICRO_APP = "embedMicroApp";
    @NonNls
    private static final String JNI_DEBUGGABLE = "jniDebuggable";
    @NonNls
    private static final String MINIFY_ENABLED = "minifyEnabled";
    @NonNls
    private static final String PSEUDO_LOCALES_ENABLED = "pseudoLocalesEnabled";
    @NonNls
    private static final String RENDERSCRIPT_DEBUGGABLE = "renderscriptDebuggable";
    @NonNls
    private static final String RENDERSCRIPT_OPTIM_LEVEL = "renderscriptOptimLevel";
    @NonNls
    private static final String SHRINK_RESOURCES = "shrinkResources";
    @NonNls
    private static final String TEST_COVERAGE_ENABLED = "testCoverageEnabled";
    @NonNls
    private static final String VERSION_NAME_SUFFIX = "versionNameSuffix";
    @NonNls
    private static final String ZIP_ALIGN_ENABLED = "zipAlignEnabled";

    public BuildTypeModel(@NotNull BuildTypeDslElement dslElement) {
        if (dslElement == null) {
            BuildTypeModel.$$$reportNull$$$0(0);
        }
        super(dslElement);
    }

    @NotNull
    public GradleNullableValue<String> applicationIdSuffix() {
        GradleNullableValue<String> gradleNullableValue = this.myDslElement.getLiteralProperty(APPLICATION_ID_SUFFIX, String.class);
        if (gradleNullableValue == null) {
            BuildTypeModel.$$$reportNull$$$0(1);
        }
        return gradleNullableValue;
    }

    @NotNull
    public BuildTypeModel setApplicationIdSuffix(@NotNull String applicationIdSuffix) {
        if (applicationIdSuffix == null) {
            BuildTypeModel.$$$reportNull$$$0(2);
        }
        this.myDslElement.setNewLiteral(APPLICATION_ID_SUFFIX, applicationIdSuffix);
        BuildTypeModel buildTypeModel = this;
        if (buildTypeModel == null) {
            BuildTypeModel.$$$reportNull$$$0(3);
        }
        return buildTypeModel;
    }

    @NotNull
    public BuildTypeModel removeApplicationIdSuffix() {
        this.myDslElement.removeProperty(APPLICATION_ID_SUFFIX);
        BuildTypeModel buildTypeModel = this;
        if (buildTypeModel == null) {
            BuildTypeModel.$$$reportNull$$$0(4);
        }
        return buildTypeModel;
    }

    @Nullable
    public List<GradleNotNullValue<BuildConfigField>> buildConfigFields() {
        List<Pair<GradleDslExpressionList, AbstractFlavorTypeModel.TypeNameValueElement>> typeNameValueElements = this.getTypeNameValueElements(BUILD_CONFIG_FIELD);
        if (typeNameValueElements == null) {
            return null;
        }
        ArrayList buildConfigFields = Lists.newArrayListWithCapacity((int)typeNameValueElements.size());
        for (Pair<GradleDslExpressionList, AbstractFlavorTypeModel.TypeNameValueElement> pair : typeNameValueElements) {
            GradleDslExpressionList listElement = (GradleDslExpressionList)pair.getFirst();
            AbstractFlavorTypeModel.TypeNameValueElement typeNameValueElement = (AbstractFlavorTypeModel.TypeNameValueElement)pair.getSecond();
            buildConfigFields.add(new GradleNotNullValue<BuildConfigField>(listElement, new BuildConfigField(typeNameValueElement.type(), typeNameValueElement.name(), typeNameValueElement.value())));
        }
        return buildConfigFields;
    }

    @NotNull
    public BuildTypeModel addBuildConfigField(@NotNull BuildConfigField buildConfigField) {
        if (buildConfigField == null) {
            BuildTypeModel.$$$reportNull$$$0(5);
        }
        BuildTypeModel buildTypeModel = (BuildTypeModel)this.addTypeNameValueElement(buildConfigField);
        if (buildTypeModel == null) {
            BuildTypeModel.$$$reportNull$$$0(6);
        }
        return buildTypeModel;
    }

    @NotNull
    public BuildTypeModel removeBuildConfigField(@NotNull BuildConfigField buildConfigField) {
        if (buildConfigField == null) {
            BuildTypeModel.$$$reportNull$$$0(7);
        }
        BuildTypeModel buildTypeModel = (BuildTypeModel)this.removeTypeNameValueElement(buildConfigField);
        if (buildTypeModel == null) {
            BuildTypeModel.$$$reportNull$$$0(8);
        }
        return buildTypeModel;
    }

    @NotNull
    public BuildTypeModel removeAllBuildConfigFields() {
        this.myDslElement.removeProperty(BUILD_CONFIG_FIELD);
        BuildTypeModel buildTypeModel = this;
        if (buildTypeModel == null) {
            BuildTypeModel.$$$reportNull$$$0(9);
        }
        return buildTypeModel;
    }

    @NotNull
    public BuildTypeModel replaceBuildConfigField(@NotNull BuildConfigField oldBuildConfigField, @NotNull BuildConfigField newBuildConfigField) {
        if (oldBuildConfigField == null) {
            BuildTypeModel.$$$reportNull$$$0(10);
        }
        if (newBuildConfigField == null) {
            BuildTypeModel.$$$reportNull$$$0(11);
        }
        BuildTypeModel buildTypeModel = (BuildTypeModel)this.replaceTypeNameValueElement(oldBuildConfigField, newBuildConfigField);
        if (buildTypeModel == null) {
            BuildTypeModel.$$$reportNull$$$0(12);
        }
        return buildTypeModel;
    }

    @NotNull
    public GradleNullableValue<Boolean> debuggable() {
        GradleNullableValue<Boolean> gradleNullableValue = this.myDslElement.getLiteralProperty(DEBUGGABLE, Boolean.class);
        if (gradleNullableValue == null) {
            BuildTypeModel.$$$reportNull$$$0(13);
        }
        return gradleNullableValue;
    }

    @NotNull
    public BuildTypeModel setDebuggable(@NotNull Boolean debuggable) {
        if (debuggable == null) {
            BuildTypeModel.$$$reportNull$$$0(14);
        }
        this.myDslElement.setNewLiteral(DEBUGGABLE, debuggable);
        BuildTypeModel buildTypeModel = this;
        if (buildTypeModel == null) {
            BuildTypeModel.$$$reportNull$$$0(15);
        }
        return buildTypeModel;
    }

    @NotNull
    public BuildTypeModel removeDebuggable() {
        this.myDslElement.removeProperty(DEBUGGABLE);
        BuildTypeModel buildTypeModel = this;
        if (buildTypeModel == null) {
            BuildTypeModel.$$$reportNull$$$0(16);
        }
        return buildTypeModel;
    }

    @NotNull
    public GradleNullableValue<Boolean> embedMicroApp() {
        GradleNullableValue<Boolean> gradleNullableValue = this.myDslElement.getLiteralProperty(EMBED_MICRO_APP, Boolean.class);
        if (gradleNullableValue == null) {
            BuildTypeModel.$$$reportNull$$$0(17);
        }
        return gradleNullableValue;
    }

    @NotNull
    public BuildTypeModel setEmbedMicroApp(@NotNull Boolean embedMicroApp) {
        if (embedMicroApp == null) {
            BuildTypeModel.$$$reportNull$$$0(18);
        }
        this.myDslElement.setNewLiteral(EMBED_MICRO_APP, embedMicroApp);
        BuildTypeModel buildTypeModel = this;
        if (buildTypeModel == null) {
            BuildTypeModel.$$$reportNull$$$0(19);
        }
        return buildTypeModel;
    }

    @NotNull
    public BuildTypeModel removeEmbedMicroApp() {
        this.myDslElement.removeProperty(EMBED_MICRO_APP);
        BuildTypeModel buildTypeModel = this;
        if (buildTypeModel == null) {
            BuildTypeModel.$$$reportNull$$$0(20);
        }
        return buildTypeModel;
    }

    @NotNull
    public GradleNullableValue<Boolean> jniDebuggable() {
        GradleNullableValue<Boolean> gradleNullableValue = this.myDslElement.getLiteralProperty(JNI_DEBUGGABLE, Boolean.class);
        if (gradleNullableValue == null) {
            BuildTypeModel.$$$reportNull$$$0(21);
        }
        return gradleNullableValue;
    }

    @NotNull
    public BuildTypeModel setJniDebuggable(@NotNull Boolean jniDebuggable) {
        if (jniDebuggable == null) {
            BuildTypeModel.$$$reportNull$$$0(22);
        }
        this.myDslElement.setNewLiteral(JNI_DEBUGGABLE, jniDebuggable);
        BuildTypeModel buildTypeModel = this;
        if (buildTypeModel == null) {
            BuildTypeModel.$$$reportNull$$$0(23);
        }
        return buildTypeModel;
    }

    @NotNull
    public BuildTypeModel removeJniDebuggable() {
        this.myDslElement.removeProperty(JNI_DEBUGGABLE);
        BuildTypeModel buildTypeModel = this;
        if (buildTypeModel == null) {
            BuildTypeModel.$$$reportNull$$$0(24);
        }
        return buildTypeModel;
    }

    @NotNull
    public GradleNullableValue<Boolean> minifyEnabled() {
        GradleNullableValue<Boolean> gradleNullableValue = this.myDslElement.getLiteralProperty(MINIFY_ENABLED, Boolean.class);
        if (gradleNullableValue == null) {
            BuildTypeModel.$$$reportNull$$$0(25);
        }
        return gradleNullableValue;
    }

    @NotNull
    public BuildTypeModel setMinifyEnabled(@NotNull Boolean minifyEnabled) {
        if (minifyEnabled == null) {
            BuildTypeModel.$$$reportNull$$$0(26);
        }
        this.myDslElement.setNewLiteral(MINIFY_ENABLED, minifyEnabled);
        BuildTypeModel buildTypeModel = this;
        if (buildTypeModel == null) {
            BuildTypeModel.$$$reportNull$$$0(27);
        }
        return buildTypeModel;
    }

    @NotNull
    public BuildTypeModel removeMinifyEnabled() {
        this.myDslElement.removeProperty(MINIFY_ENABLED);
        BuildTypeModel buildTypeModel = this;
        if (buildTypeModel == null) {
            BuildTypeModel.$$$reportNull$$$0(28);
        }
        return buildTypeModel;
    }

    @NotNull
    public GradleNullableValue<Boolean> pseudoLocalesEnabled() {
        GradleNullableValue<Boolean> gradleNullableValue = this.myDslElement.getLiteralProperty(PSEUDO_LOCALES_ENABLED, Boolean.class);
        if (gradleNullableValue == null) {
            BuildTypeModel.$$$reportNull$$$0(29);
        }
        return gradleNullableValue;
    }

    @NotNull
    public BuildTypeModel setPseudoLocalesEnabled(@NotNull Boolean pseudoLocalesEnabled) {
        if (pseudoLocalesEnabled == null) {
            BuildTypeModel.$$$reportNull$$$0(30);
        }
        this.myDslElement.setNewLiteral(PSEUDO_LOCALES_ENABLED, pseudoLocalesEnabled);
        BuildTypeModel buildTypeModel = this;
        if (buildTypeModel == null) {
            BuildTypeModel.$$$reportNull$$$0(31);
        }
        return buildTypeModel;
    }

    @NotNull
    public BuildTypeModel removePseudoLocalesEnabled() {
        this.myDslElement.removeProperty(PSEUDO_LOCALES_ENABLED);
        BuildTypeModel buildTypeModel = this;
        if (buildTypeModel == null) {
            BuildTypeModel.$$$reportNull$$$0(32);
        }
        return buildTypeModel;
    }

    @NotNull
    public GradleNullableValue<Boolean> renderscriptDebuggable() {
        GradleNullableValue<Boolean> gradleNullableValue = this.myDslElement.getLiteralProperty(RENDERSCRIPT_DEBUGGABLE, Boolean.class);
        if (gradleNullableValue == null) {
            BuildTypeModel.$$$reportNull$$$0(33);
        }
        return gradleNullableValue;
    }

    @NotNull
    public BuildTypeModel setRenderscriptDebuggable(@NotNull Boolean renderscriptDebuggable) {
        if (renderscriptDebuggable == null) {
            BuildTypeModel.$$$reportNull$$$0(34);
        }
        this.myDslElement.setNewLiteral(RENDERSCRIPT_DEBUGGABLE, renderscriptDebuggable);
        BuildTypeModel buildTypeModel = this;
        if (buildTypeModel == null) {
            BuildTypeModel.$$$reportNull$$$0(35);
        }
        return buildTypeModel;
    }

    @NotNull
    public BuildTypeModel removeRenderscriptDebuggable() {
        this.myDslElement.removeProperty(RENDERSCRIPT_DEBUGGABLE);
        BuildTypeModel buildTypeModel = this;
        if (buildTypeModel == null) {
            BuildTypeModel.$$$reportNull$$$0(36);
        }
        return buildTypeModel;
    }

    @NotNull
    public GradleNullableValue<Integer> renderscriptOptimLevel() {
        GradleNullableValue<Integer> gradleNullableValue = this.myDslElement.getLiteralProperty(RENDERSCRIPT_OPTIM_LEVEL, Integer.class);
        if (gradleNullableValue == null) {
            BuildTypeModel.$$$reportNull$$$0(37);
        }
        return gradleNullableValue;
    }

    @NotNull
    public BuildTypeModel setRenderscriptOptimLevel(@NotNull Integer renderscriptOptimLevel) {
        if (renderscriptOptimLevel == null) {
            BuildTypeModel.$$$reportNull$$$0(38);
        }
        this.myDslElement.setNewLiteral(RENDERSCRIPT_OPTIM_LEVEL, renderscriptOptimLevel);
        BuildTypeModel buildTypeModel = this;
        if (buildTypeModel == null) {
            BuildTypeModel.$$$reportNull$$$0(39);
        }
        return buildTypeModel;
    }

    @NotNull
    public BuildTypeModel removeRenderscriptOptimLevel() {
        this.myDslElement.removeProperty(RENDERSCRIPT_OPTIM_LEVEL);
        BuildTypeModel buildTypeModel = this;
        if (buildTypeModel == null) {
            BuildTypeModel.$$$reportNull$$$0(40);
        }
        return buildTypeModel;
    }

    @NotNull
    public GradleNullableValue<Boolean> shrinkResources() {
        GradleNullableValue<Boolean> gradleNullableValue = this.myDslElement.getLiteralProperty(SHRINK_RESOURCES, Boolean.class);
        if (gradleNullableValue == null) {
            BuildTypeModel.$$$reportNull$$$0(41);
        }
        return gradleNullableValue;
    }

    @NotNull
    public BuildTypeModel setShrinkResources(@NotNull Boolean shrinkResources) {
        if (shrinkResources == null) {
            BuildTypeModel.$$$reportNull$$$0(42);
        }
        this.myDslElement.setNewLiteral(SHRINK_RESOURCES, shrinkResources);
        BuildTypeModel buildTypeModel = this;
        if (buildTypeModel == null) {
            BuildTypeModel.$$$reportNull$$$0(43);
        }
        return buildTypeModel;
    }

    @NotNull
    public BuildTypeModel removeShrinkResources() {
        this.myDslElement.removeProperty(SHRINK_RESOURCES);
        BuildTypeModel buildTypeModel = this;
        if (buildTypeModel == null) {
            BuildTypeModel.$$$reportNull$$$0(44);
        }
        return buildTypeModel;
    }

    @NotNull
    public GradleNullableValue<Boolean> testCoverageEnabled() {
        GradleNullableValue<Boolean> gradleNullableValue = this.myDslElement.getLiteralProperty(TEST_COVERAGE_ENABLED, Boolean.class);
        if (gradleNullableValue == null) {
            BuildTypeModel.$$$reportNull$$$0(45);
        }
        return gradleNullableValue;
    }

    @NotNull
    public BuildTypeModel setTestCoverageEnabled(@NotNull Boolean testCoverageEnabled) {
        if (testCoverageEnabled == null) {
            BuildTypeModel.$$$reportNull$$$0(46);
        }
        this.myDslElement.setNewLiteral(TEST_COVERAGE_ENABLED, testCoverageEnabled);
        BuildTypeModel buildTypeModel = this;
        if (buildTypeModel == null) {
            BuildTypeModel.$$$reportNull$$$0(47);
        }
        return buildTypeModel;
    }

    @NotNull
    public BuildTypeModel removeTestCoverageEnabled() {
        this.myDslElement.removeProperty(TEST_COVERAGE_ENABLED);
        BuildTypeModel buildTypeModel = this;
        if (buildTypeModel == null) {
            BuildTypeModel.$$$reportNull$$$0(48);
        }
        return buildTypeModel;
    }

    @NotNull
    public GradleNullableValue<String> versionNameSuffix() {
        GradleNullableValue<String> gradleNullableValue = this.myDslElement.getLiteralProperty(VERSION_NAME_SUFFIX, String.class);
        if (gradleNullableValue == null) {
            BuildTypeModel.$$$reportNull$$$0(49);
        }
        return gradleNullableValue;
    }

    @NotNull
    public BuildTypeModel setVersionNameSuffix(@NotNull String versionNameSuffix) {
        if (versionNameSuffix == null) {
            BuildTypeModel.$$$reportNull$$$0(50);
        }
        this.myDslElement.setNewLiteral(VERSION_NAME_SUFFIX, versionNameSuffix);
        BuildTypeModel buildTypeModel = this;
        if (buildTypeModel == null) {
            BuildTypeModel.$$$reportNull$$$0(51);
        }
        return buildTypeModel;
    }

    @NotNull
    public BuildTypeModel removeVersionNameSuffix() {
        this.myDslElement.removeProperty(VERSION_NAME_SUFFIX);
        BuildTypeModel buildTypeModel = this;
        if (buildTypeModel == null) {
            BuildTypeModel.$$$reportNull$$$0(52);
        }
        return buildTypeModel;
    }

    @NotNull
    public GradleNullableValue<Boolean> zipAlignEnabled() {
        GradleNullableValue<Boolean> gradleNullableValue = this.myDslElement.getLiteralProperty(ZIP_ALIGN_ENABLED, Boolean.class);
        if (gradleNullableValue == null) {
            BuildTypeModel.$$$reportNull$$$0(53);
        }
        return gradleNullableValue;
    }

    @NotNull
    public BuildTypeModel setZipAlignEnabled(@NotNull Boolean zipAlignEnabled) {
        if (zipAlignEnabled == null) {
            BuildTypeModel.$$$reportNull$$$0(54);
        }
        this.myDslElement.setNewLiteral(ZIP_ALIGN_ENABLED, zipAlignEnabled);
        BuildTypeModel buildTypeModel = this;
        if (buildTypeModel == null) {
            BuildTypeModel.$$$reportNull$$$0(55);
        }
        return buildTypeModel;
    }

    @NotNull
    public BuildTypeModel removeZipAlignEnabled() {
        this.myDslElement.removeProperty(ZIP_ALIGN_ENABLED);
        BuildTypeModel buildTypeModel = this;
        if (buildTypeModel == null) {
            BuildTypeModel.$$$reportNull$$$0(56);
        }
        return buildTypeModel;
    }

    @Override
    @NotNull
    public BuildTypeModel addConsumerProguardFile(@NotNull String consumerProguardFile) {
        if (consumerProguardFile == null) {
            BuildTypeModel.$$$reportNull$$$0(57);
        }
        BuildTypeModel buildTypeModel = (BuildTypeModel)super.addConsumerProguardFile(consumerProguardFile);
        if (buildTypeModel == null) {
            BuildTypeModel.$$$reportNull$$$0(58);
        }
        return buildTypeModel;
    }

    @Override
    @NotNull
    public BuildTypeModel removeConsumerProguardFile(@NotNull String consumerProguardFile) {
        if (consumerProguardFile == null) {
            BuildTypeModel.$$$reportNull$$$0(59);
        }
        BuildTypeModel buildTypeModel = (BuildTypeModel)super.removeConsumerProguardFile(consumerProguardFile);
        if (buildTypeModel == null) {
            BuildTypeModel.$$$reportNull$$$0(60);
        }
        return buildTypeModel;
    }

    @Override
    @NotNull
    public BuildTypeModel removeAllConsumerProguardFiles() {
        BuildTypeModel buildTypeModel = (BuildTypeModel)super.removeAllConsumerProguardFiles();
        if (buildTypeModel == null) {
            BuildTypeModel.$$$reportNull$$$0(61);
        }
        return buildTypeModel;
    }

    @Override
    @NotNull
    public BuildTypeModel replaceConsumerProguardFile(@NotNull String oldConsumerProguardFile, @NotNull String newConsumerProguardFile) {
        if (oldConsumerProguardFile == null) {
            BuildTypeModel.$$$reportNull$$$0(62);
        }
        if (newConsumerProguardFile == null) {
            BuildTypeModel.$$$reportNull$$$0(63);
        }
        BuildTypeModel buildTypeModel = (BuildTypeModel)super.replaceConsumerProguardFile(oldConsumerProguardFile, newConsumerProguardFile);
        if (buildTypeModel == null) {
            BuildTypeModel.$$$reportNull$$$0(64);
        }
        return buildTypeModel;
    }

    @Override
    @NotNull
    public BuildTypeModel setManifestPlaceholder(@NotNull String name, @NotNull String value) {
        if (name == null) {
            BuildTypeModel.$$$reportNull$$$0(65);
        }
        if (value == null) {
            BuildTypeModel.$$$reportNull$$$0(66);
        }
        BuildTypeModel buildTypeModel = (BuildTypeModel)super.setManifestPlaceholder(name, value);
        if (buildTypeModel == null) {
            BuildTypeModel.$$$reportNull$$$0(67);
        }
        return buildTypeModel;
    }

    @Override
    @NotNull
    public BuildTypeModel setManifestPlaceholder(@NotNull String name, int value) {
        if (name == null) {
            BuildTypeModel.$$$reportNull$$$0(68);
        }
        BuildTypeModel buildTypeModel = (BuildTypeModel)super.setManifestPlaceholder(name, value);
        if (buildTypeModel == null) {
            BuildTypeModel.$$$reportNull$$$0(69);
        }
        return buildTypeModel;
    }

    @Override
    @NotNull
    public BuildTypeModel setManifestPlaceholder(@NotNull String name, boolean value) {
        if (name == null) {
            BuildTypeModel.$$$reportNull$$$0(70);
        }
        BuildTypeModel buildTypeModel = (BuildTypeModel)super.setManifestPlaceholder(name, value);
        if (buildTypeModel == null) {
            BuildTypeModel.$$$reportNull$$$0(71);
        }
        return buildTypeModel;
    }

    @Override
    @NotNull
    public BuildTypeModel removeManifestPlaceholder(@NotNull String name) {
        if (name == null) {
            BuildTypeModel.$$$reportNull$$$0(72);
        }
        BuildTypeModel buildTypeModel = (BuildTypeModel)super.removeManifestPlaceholder(name);
        if (buildTypeModel == null) {
            BuildTypeModel.$$$reportNull$$$0(73);
        }
        return buildTypeModel;
    }

    @Override
    @NotNull
    public BuildTypeModel removeAllManifestPlaceholders() {
        BuildTypeModel buildTypeModel = (BuildTypeModel)super.removeAllManifestPlaceholders();
        if (buildTypeModel == null) {
            BuildTypeModel.$$$reportNull$$$0(74);
        }
        return buildTypeModel;
    }

    @Override
    @NotNull
    public BuildTypeModel setMultiDexEnabled(boolean multiDexEnabled) {
        BuildTypeModel buildTypeModel = (BuildTypeModel)super.setMultiDexEnabled(multiDexEnabled);
        if (buildTypeModel == null) {
            BuildTypeModel.$$$reportNull$$$0(75);
        }
        return buildTypeModel;
    }

    @Override
    @NotNull
    public BuildTypeModel removeMultiDexEnabled() {
        BuildTypeModel buildTypeModel = (BuildTypeModel)super.removeMultiDexEnabled();
        if (buildTypeModel == null) {
            BuildTypeModel.$$$reportNull$$$0(76);
        }
        return buildTypeModel;
    }

    @Override
    @NotNull
    public BuildTypeModel addProguardFile(@NotNull String proguardFile) {
        if (proguardFile == null) {
            BuildTypeModel.$$$reportNull$$$0(77);
        }
        BuildTypeModel buildTypeModel = (BuildTypeModel)super.addProguardFile(proguardFile);
        if (buildTypeModel == null) {
            BuildTypeModel.$$$reportNull$$$0(78);
        }
        return buildTypeModel;
    }

    @Override
    @NotNull
    public BuildTypeModel removeProguardFile(@NotNull String proguardFile) {
        if (proguardFile == null) {
            BuildTypeModel.$$$reportNull$$$0(79);
        }
        BuildTypeModel buildTypeModel = (BuildTypeModel)super.removeProguardFile(proguardFile);
        if (buildTypeModel == null) {
            BuildTypeModel.$$$reportNull$$$0(80);
        }
        return buildTypeModel;
    }

    @Override
    @NotNull
    public BuildTypeModel removeAllProguardFiles() {
        BuildTypeModel buildTypeModel = (BuildTypeModel)super.removeAllProguardFiles();
        if (buildTypeModel == null) {
            BuildTypeModel.$$$reportNull$$$0(81);
        }
        return buildTypeModel;
    }

    @Override
    @NotNull
    public BuildTypeModel replaceProguardFile(@NotNull String oldProguardFile, @NotNull String newProguardFile) {
        if (oldProguardFile == null) {
            BuildTypeModel.$$$reportNull$$$0(82);
        }
        if (newProguardFile == null) {
            BuildTypeModel.$$$reportNull$$$0(83);
        }
        BuildTypeModel buildTypeModel = (BuildTypeModel)super.replaceProguardFile(oldProguardFile, newProguardFile);
        if (buildTypeModel == null) {
            BuildTypeModel.$$$reportNull$$$0(84);
        }
        return buildTypeModel;
    }

    @Override
    @NotNull
    public BuildTypeModel addResValue(@NotNull AbstractFlavorTypeModel.ResValue resValue) {
        if (resValue == null) {
            BuildTypeModel.$$$reportNull$$$0(85);
        }
        BuildTypeModel buildTypeModel = (BuildTypeModel)super.addResValue(resValue);
        if (buildTypeModel == null) {
            BuildTypeModel.$$$reportNull$$$0(86);
        }
        return buildTypeModel;
    }

    @Override
    @NotNull
    public BuildTypeModel removeResValue(@NotNull AbstractFlavorTypeModel.ResValue resValue) {
        if (resValue == null) {
            BuildTypeModel.$$$reportNull$$$0(87);
        }
        BuildTypeModel buildTypeModel = (BuildTypeModel)super.removeResValue(resValue);
        if (buildTypeModel == null) {
            BuildTypeModel.$$$reportNull$$$0(88);
        }
        return buildTypeModel;
    }

    @Override
    @NotNull
    public BuildTypeModel removeAllResValues() {
        BuildTypeModel buildTypeModel = (BuildTypeModel)super.removeAllResValues();
        if (buildTypeModel == null) {
            BuildTypeModel.$$$reportNull$$$0(89);
        }
        return buildTypeModel;
    }

    @Override
    @NotNull
    public BuildTypeModel replaceResValue(@NotNull AbstractFlavorTypeModel.ResValue oldResValue, @NotNull AbstractFlavorTypeModel.ResValue newResValue) {
        if (oldResValue == null) {
            BuildTypeModel.$$$reportNull$$$0(90);
        }
        if (newResValue == null) {
            BuildTypeModel.$$$reportNull$$$0(91);
        }
        BuildTypeModel buildTypeModel = (BuildTypeModel)super.replaceResValue(oldResValue, newResValue);
        if (buildTypeModel == null) {
            BuildTypeModel.$$$reportNull$$$0(92);
        }
        return buildTypeModel;
    }

    @Override
    @NotNull
    public BuildTypeModel setUseJack(boolean useJack) {
        BuildTypeModel buildTypeModel = (BuildTypeModel)super.setUseJack(useJack);
        if (buildTypeModel == null) {
            BuildTypeModel.$$$reportNull$$$0(93);
        }
        return buildTypeModel;
    }

    @Override
    @NotNull
    public BuildTypeModel removeUseJack() {
        BuildTypeModel buildTypeModel = (BuildTypeModel)super.removeUseJack();
        if (buildTypeModel == null) {
            BuildTypeModel.$$$reportNull$$$0(94);
        }
        return buildTypeModel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 29: 
            case 31: 
            case 32: 
            case 33: 
            case 35: 
            case 36: 
            case 37: 
            case 39: 
            case 40: 
            case 41: 
            case 43: 
            case 44: 
            case 45: 
            case 47: 
            case 48: 
            case 49: 
            case 51: 
            case 52: 
            case 53: 
            case 55: 
            case 56: 
            case 58: 
            case 60: 
            case 61: 
            case 64: 
            case 67: 
            case 69: 
            case 71: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 78: 
            case 80: 
            case 81: 
            case 84: 
            case 86: 
            case 88: 
            case 89: 
            case 92: 
            case 93: 
            case 94: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 29: 
            case 31: 
            case 32: 
            case 33: 
            case 35: 
            case 36: 
            case 37: 
            case 39: 
            case 40: 
            case 41: 
            case 43: 
            case 44: 
            case 45: 
            case 47: 
            case 48: 
            case 49: 
            case 51: 
            case 52: 
            case 53: 
            case 55: 
            case 56: 
            case 58: 
            case 60: 
            case 61: 
            case 64: 
            case 67: 
            case 69: 
            case 71: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 78: 
            case 80: 
            case 81: 
            case 84: 
            case 86: 
            case 88: 
            case 89: 
            case 92: 
            case 93: 
            case 94: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dslElement";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 29: 
            case 31: 
            case 32: 
            case 33: 
            case 35: 
            case 36: 
            case 37: 
            case 39: 
            case 40: 
            case 41: 
            case 43: 
            case 44: 
            case 45: 
            case 47: 
            case 48: 
            case 49: 
            case 51: 
            case 52: 
            case 53: 
            case 55: 
            case 56: 
            case 58: 
            case 60: 
            case 61: 
            case 64: 
            case 67: 
            case 69: 
            case 71: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 78: 
            case 80: 
            case 81: 
            case 84: 
            case 86: 
            case 88: 
            case 89: 
            case 92: 
            case 93: 
            case 94: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/dsl/model/android/BuildTypeModel";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = APPLICATION_ID_SUFFIX;
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = BUILD_CONFIG_FIELD;
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldBuildConfigField";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newBuildConfigField";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = DEBUGGABLE;
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = EMBED_MICRO_APP;
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = JNI_DEBUGGABLE;
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = MINIFY_ENABLED;
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = PSEUDO_LOCALES_ENABLED;
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = RENDERSCRIPT_DEBUGGABLE;
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = RENDERSCRIPT_OPTIM_LEVEL;
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = SHRINK_RESOURCES;
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = TEST_COVERAGE_ENABLED;
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = VERSION_NAME_SUFFIX;
                break;
            }
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = ZIP_ALIGN_ENABLED;
                break;
            }
            case 57: 
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumerProguardFile";
                break;
            }
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldConsumerProguardFile";
                break;
            }
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newConsumerProguardFile";
                break;
            }
            case 65: 
            case 68: 
            case 70: 
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 77: 
            case 79: {
                objectArray2 = objectArray3;
                objectArray3[0] = "proguardFile";
                break;
            }
            case 82: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldProguardFile";
                break;
            }
            case 83: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newProguardFile";
                break;
            }
            case 85: 
            case 87: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resValue";
                break;
            }
            case 90: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldResValue";
                break;
            }
            case 91: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newResValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/dsl/model/android/BuildTypeModel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = APPLICATION_ID_SUFFIX;
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "setApplicationIdSuffix";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "removeApplicationIdSuffix";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "addBuildConfigField";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "removeBuildConfigField";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "removeAllBuildConfigFields";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "replaceBuildConfigField";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = DEBUGGABLE;
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "setDebuggable";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "removeDebuggable";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = EMBED_MICRO_APP;
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "setEmbedMicroApp";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "removeEmbedMicroApp";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = JNI_DEBUGGABLE;
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "setJniDebuggable";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "removeJniDebuggable";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = MINIFY_ENABLED;
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "setMinifyEnabled";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "removeMinifyEnabled";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = PSEUDO_LOCALES_ENABLED;
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "setPseudoLocalesEnabled";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "removePseudoLocalesEnabled";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = RENDERSCRIPT_DEBUGGABLE;
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "setRenderscriptDebuggable";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "removeRenderscriptDebuggable";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = RENDERSCRIPT_OPTIM_LEVEL;
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "setRenderscriptOptimLevel";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "removeRenderscriptOptimLevel";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = SHRINK_RESOURCES;
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "setShrinkResources";
                break;
            }
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "removeShrinkResources";
                break;
            }
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = TEST_COVERAGE_ENABLED;
                break;
            }
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "setTestCoverageEnabled";
                break;
            }
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "removeTestCoverageEnabled";
                break;
            }
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = VERSION_NAME_SUFFIX;
                break;
            }
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "setVersionNameSuffix";
                break;
            }
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "removeVersionNameSuffix";
                break;
            }
            case 53: {
                objectArray = objectArray2;
                objectArray2[1] = ZIP_ALIGN_ENABLED;
                break;
            }
            case 55: {
                objectArray = objectArray2;
                objectArray2[1] = "setZipAlignEnabled";
                break;
            }
            case 56: {
                objectArray = objectArray2;
                objectArray2[1] = "removeZipAlignEnabled";
                break;
            }
            case 58: {
                objectArray = objectArray2;
                objectArray2[1] = "addConsumerProguardFile";
                break;
            }
            case 60: {
                objectArray = objectArray2;
                objectArray2[1] = "removeConsumerProguardFile";
                break;
            }
            case 61: {
                objectArray = objectArray2;
                objectArray2[1] = "removeAllConsumerProguardFiles";
                break;
            }
            case 64: {
                objectArray = objectArray2;
                objectArray2[1] = "replaceConsumerProguardFile";
                break;
            }
            case 67: 
            case 69: 
            case 71: {
                objectArray = objectArray2;
                objectArray2[1] = "setManifestPlaceholder";
                break;
            }
            case 73: {
                objectArray = objectArray2;
                objectArray2[1] = "removeManifestPlaceholder";
                break;
            }
            case 74: {
                objectArray = objectArray2;
                objectArray2[1] = "removeAllManifestPlaceholders";
                break;
            }
            case 75: {
                objectArray = objectArray2;
                objectArray2[1] = "setMultiDexEnabled";
                break;
            }
            case 76: {
                objectArray = objectArray2;
                objectArray2[1] = "removeMultiDexEnabled";
                break;
            }
            case 78: {
                objectArray = objectArray2;
                objectArray2[1] = "addProguardFile";
                break;
            }
            case 80: {
                objectArray = objectArray2;
                objectArray2[1] = "removeProguardFile";
                break;
            }
            case 81: {
                objectArray = objectArray2;
                objectArray2[1] = "removeAllProguardFiles";
                break;
            }
            case 84: {
                objectArray = objectArray2;
                objectArray2[1] = "replaceProguardFile";
                break;
            }
            case 86: {
                objectArray = objectArray2;
                objectArray2[1] = "addResValue";
                break;
            }
            case 88: {
                objectArray = objectArray2;
                objectArray2[1] = "removeResValue";
                break;
            }
            case 89: {
                objectArray = objectArray2;
                objectArray2[1] = "removeAllResValues";
                break;
            }
            case 92: {
                objectArray = objectArray2;
                objectArray2[1] = "replaceResValue";
                break;
            }
            case 93: {
                objectArray = objectArray2;
                objectArray2[1] = "setUseJack";
                break;
            }
            case 94: {
                objectArray = objectArray2;
                objectArray2[1] = "removeUseJack";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 29: 
            case 31: 
            case 32: 
            case 33: 
            case 35: 
            case 36: 
            case 37: 
            case 39: 
            case 40: 
            case 41: 
            case 43: 
            case 44: 
            case 45: 
            case 47: 
            case 48: 
            case 49: 
            case 51: 
            case 52: 
            case 53: 
            case 55: 
            case 56: 
            case 58: 
            case 60: 
            case 61: 
            case 64: 
            case 67: 
            case 69: 
            case 71: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 78: 
            case 80: 
            case 81: 
            case 84: 
            case 86: 
            case 88: 
            case 89: 
            case 92: 
            case 93: 
            case 94: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setApplicationIdSuffix";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addBuildConfigField";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "removeBuildConfigField";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "replaceBuildConfigField";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "setDebuggable";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "setEmbedMicroApp";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "setJniDebuggable";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "setMinifyEnabled";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "setPseudoLocalesEnabled";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "setRenderscriptDebuggable";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "setRenderscriptOptimLevel";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "setShrinkResources";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "setTestCoverageEnabled";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "setVersionNameSuffix";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "setZipAlignEnabled";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "addConsumerProguardFile";
                break;
            }
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "removeConsumerProguardFile";
                break;
            }
            case 62: 
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "replaceConsumerProguardFile";
                break;
            }
            case 65: 
            case 66: 
            case 68: 
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "setManifestPlaceholder";
                break;
            }
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "removeManifestPlaceholder";
                break;
            }
            case 77: {
                objectArray = objectArray;
                objectArray[2] = "addProguardFile";
                break;
            }
            case 79: {
                objectArray = objectArray;
                objectArray[2] = "removeProguardFile";
                break;
            }
            case 82: 
            case 83: {
                objectArray = objectArray;
                objectArray[2] = "replaceProguardFile";
                break;
            }
            case 85: {
                objectArray = objectArray;
                objectArray[2] = "addResValue";
                break;
            }
            case 87: {
                objectArray = objectArray;
                objectArray[2] = "removeResValue";
                break;
            }
            case 90: 
            case 91: {
                objectArray = objectArray;
                objectArray[2] = "replaceResValue";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 29: 
            case 31: 
            case 32: 
            case 33: 
            case 35: 
            case 36: 
            case 37: 
            case 39: 
            case 40: 
            case 41: 
            case 43: 
            case 44: 
            case 45: 
            case 47: 
            case 48: 
            case 49: 
            case 51: 
            case 52: 
            case 53: 
            case 55: 
            case 56: 
            case 58: 
            case 60: 
            case 61: 
            case 64: 
            case 67: 
            case 69: 
            case 71: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 78: 
            case 80: 
            case 81: 
            case 84: 
            case 86: 
            case 88: 
            case 89: 
            case 92: 
            case 93: 
            case 94: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static final class BuildConfigField
    extends AbstractFlavorTypeModel.TypeNameValueElement {
        public BuildConfigField(@NotNull String type, @NotNull String name, @NotNull String value) {
            if (type == null) {
                BuildConfigField.$$$reportNull$$$0(0);
            }
            if (name == null) {
                BuildConfigField.$$$reportNull$$$0(1);
            }
            if (value == null) {
                BuildConfigField.$$$reportNull$$$0(2);
            }
            super(BuildTypeModel.BUILD_CONFIG_FIELD, type, name, value);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "type";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "name";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "value";
                    break;
                }
            }
            objectArray[1] = "com/android/tools/idea/gradle/dsl/model/android/BuildTypeModel$BuildConfigField";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

