/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.setup.module.common;

import com.android.tools.idea.gradle.project.subset.ProjectSubset;
import com.android.tools.idea.gradle.project.sync.hyperlink.NotificationHyperlink;
import com.android.tools.idea.gradle.project.sync.messages.MessageType;
import com.android.tools.idea.gradle.project.sync.messages.SyncMessage;
import com.android.tools.idea.gradle.project.sync.messages.SyncMessages;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.util.ArrayUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DependencySetupErrors {
    @NotNull
    private final Project myProject;
    @NotNull
    private final SyncMessages mySyncMessages;
    @NotNull
    private final Map<String, MissingModule> myMissingModules;
    @NotNull
    private final Map<String, MissingModule> myMissingModulesWithBackupLibraries;
    @NotNull
    private final Set<String> myDependentsOnModulesWithoutName;
    @NotNull
    private final Set<String> myDependentsOnLibrariesWithoutBinaryPath;
    @NotNull
    private final Set<InvalidModuleDependency> myInvalidModuleDependencies;

    @NotNull
    public static DependencySetupErrors getInstance(@NotNull Project project) {
        if (project == null) {
            DependencySetupErrors.$$$reportNull$$$0(0);
        }
        DependencySetupErrors dependencySetupErrors = (DependencySetupErrors)ServiceManager.getService((Project)project, DependencySetupErrors.class);
        if (dependencySetupErrors == null) {
            DependencySetupErrors.$$$reportNull$$$0(1);
        }
        return dependencySetupErrors;
    }

    public DependencySetupErrors(@NotNull Project project, @NotNull SyncMessages syncMessages) {
        if (project == null) {
            DependencySetupErrors.$$$reportNull$$$0(2);
        }
        if (syncMessages == null) {
            DependencySetupErrors.$$$reportNull$$$0(3);
        }
        this.myMissingModules = new HashMap<String, MissingModule>();
        this.myMissingModulesWithBackupLibraries = new HashMap<String, MissingModule>();
        this.myDependentsOnModulesWithoutName = new HashSet<String>();
        this.myDependentsOnLibrariesWithoutBinaryPath = new HashSet<String>();
        this.myInvalidModuleDependencies = new HashSet<InvalidModuleDependency>();
        this.myProject = project;
        this.mySyncMessages = syncMessages;
    }

    public void reportErrors() {
        String msg;
        this.reportModulesNotFoundIssues(this.getMissingModules());
        for (String dependent : this.getMissingNames()) {
            msg = String.format("Module '%1$s' depends on modules that do not have a name.", dependent);
            this.mySyncMessages.report(new SyncMessage("Missing Dependencies", MessageType.ERROR, msg));
        }
        for (String dependent : this.getDependentsOnLibrariesWithoutBinaryPath()) {
            msg = String.format("Module '%1$s' depends on libraries that do not have a 'binary' path.", dependent);
            this.mySyncMessages.report(new SyncMessage("Missing Dependencies", MessageType.ERROR, msg));
        }
        for (InvalidModuleDependency dependency : this.myInvalidModuleDependencies) {
            msg = String.format("Ignoring dependency of module '%1$s' on module '%2$s'. %3$s", dependency.dependent, dependency.dependency.getName(), dependency.causeDescription);
            VirtualFile buildFile = GradleUtil.getGradleBuildFile(dependency.dependency);
            assert (buildFile != null);
            OpenFileDescriptor navigatable = new OpenFileDescriptor(dependency.dependency.getProject(), buildFile, 0);
            this.mySyncMessages.report(new SyncMessage("Missing Dependencies", MessageType.WARNING, (Navigatable)navigatable, msg));
        }
        this.reportModulesNotFoundIssues(this.getMissingModulesWithBackupLibraries());
        this.clear();
    }

    @VisibleForTesting
    @NotNull
    List<MissingModule> getMissingModules() {
        List<MissingModule> list = DependencySetupErrors.getMissingModules(this.myMissingModules);
        if (list == null) {
            DependencySetupErrors.$$$reportNull$$$0(4);
        }
        return list;
    }

    @VisibleForTesting
    @NotNull
    List<MissingModule> getMissingModulesWithBackupLibraries() {
        List<MissingModule> list = DependencySetupErrors.getMissingModules(this.myMissingModulesWithBackupLibraries);
        if (list == null) {
            DependencySetupErrors.$$$reportNull$$$0(5);
        }
        return list;
    }

    @NotNull
    private static List<MissingModule> getMissingModules(@NotNull Map<String, MissingModule> missingModulesByName) {
        if (missingModulesByName == null) {
            DependencySetupErrors.$$$reportNull$$$0(6);
        }
        if (missingModulesByName.isEmpty()) {
            List<MissingModule> list = Collections.emptyList();
            if (list == null) {
                DependencySetupErrors.$$$reportNull$$$0(7);
            }
            return list;
        }
        ArrayList<MissingModule> missingModules = new ArrayList<MissingModule>();
        ArrayList<String> names = new ArrayList<String>(missingModulesByName.keySet());
        if (names.size() > 1) {
            Collections.sort(names);
        }
        for (String name : names) {
            MissingModule missingModule = missingModulesByName.get(name);
            missingModule.sortDependentNames();
            missingModules.add(missingModule);
        }
        ArrayList<MissingModule> arrayList = missingModules;
        if (arrayList == null) {
            DependencySetupErrors.$$$reportNull$$$0(8);
        }
        return arrayList;
    }

    @VisibleForTesting
    @NotNull
    List<String> getMissingNames() {
        List<String> list = DependencySetupErrors.sortSet(this.myDependentsOnModulesWithoutName);
        if (list == null) {
            DependencySetupErrors.$$$reportNull$$$0(9);
        }
        return list;
    }

    @VisibleForTesting
    @NotNull
    List<String> getDependentsOnLibrariesWithoutBinaryPath() {
        List<String> list = DependencySetupErrors.sortSet(this.myDependentsOnLibrariesWithoutBinaryPath);
        if (list == null) {
            DependencySetupErrors.$$$reportNull$$$0(10);
        }
        return list;
    }

    @NotNull
    private static List<String> sortSet(@NotNull Set<String> set) {
        if (set == null) {
            DependencySetupErrors.$$$reportNull$$$0(11);
        }
        if (set.isEmpty()) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                DependencySetupErrors.$$$reportNull$$$0(12);
            }
            return list;
        }
        ArrayList<String> sorted = new ArrayList<String>(set);
        if (sorted.size() > 1) {
            Collections.sort(sorted);
        }
        ArrayList<String> arrayList = sorted;
        if (arrayList == null) {
            DependencySetupErrors.$$$reportNull$$$0(13);
        }
        return arrayList;
    }

    private void reportModulesNotFoundIssues(@NotNull List<MissingModule> missingModules) {
        if (missingModules == null) {
            DependencySetupErrors.$$$reportNull$$$0(14);
        }
        if (!missingModules.isEmpty()) {
            boolean hasSelection;
            CharSequence text;
            MessageType type = MessageType.ERROR;
            for (MissingModule missingModule : missingModules) {
                ArrayList<String> messageLines = new ArrayList<String>();
                text = new StringBuilder();
                ((StringBuilder)text).append(String.format("Unable to find module with Gradle path '%1$s' (needed by module", missingModule.dependencyPath));
                DependencySetupErrors.addDependentsToText((StringBuilder)text, missingModule.dependentNames);
                ((StringBuilder)text).append(".)");
                messageLines.add(((StringBuilder)text).toString());
                String backupLibraryName = missingModule.backupLibraryName;
                if (StringUtil.isNotEmpty((String)backupLibraryName)) {
                    type = MessageType.WARNING;
                    String msg = String.format("Linking to library '%1$s' instead.", backupLibraryName);
                    messageLines.add(msg);
                }
                this.mySyncMessages.report(new SyncMessage("Missing Dependencies", type, ArrayUtil.toStringArray(messageLines)));
            }
            ProjectSubset projectSubset = ProjectSubset.getInstance(this.myProject);
            String[] selection = projectSubset.getSelection();
            boolean bl = hasSelection = selection != null && selection.length > 0;
            if (type == MessageType.ERROR && hasSelection && projectSubset.hasCachedModules()) {
                text = "The missing modules may have been excluded from the project subset.";
                SyncMessage message = new SyncMessage("Missing Dependencies", MessageType.INFO, new String[]{text});
                message.add(new IncludeMissingModulesHyperlink(missingModules));
                this.mySyncMessages.report(message);
            }
        }
    }

    private static void addDependentsToText(@NotNull StringBuilder text, @NotNull List<String> dependents) {
        if (text == null) {
            DependencySetupErrors.$$$reportNull$$$0(15);
        }
        if (dependents == null) {
            DependencySetupErrors.$$$reportNull$$$0(16);
        }
        assert (!dependents.isEmpty());
        if (dependents.size() == 1) {
            text.append(String.format(" '%1$s'", dependents.get(0)));
            return;
        }
        text.append("s: ");
        int i = 0;
        for (String dependent : dependents) {
            if (i++ > 0) {
                text.append(", ");
            }
            text.append(String.format("'%1$s'", dependent));
        }
    }

    private void clear() {
        this.myMissingModules.clear();
        this.myMissingModulesWithBackupLibraries.clear();
        this.myDependentsOnModulesWithoutName.clear();
        this.myDependentsOnLibrariesWithoutBinaryPath.clear();
        this.myInvalidModuleDependencies.clear();
    }

    public void addMissingModule(@NotNull String dependencyName, @NotNull String dependentName, @Nullable String backupLibraryName) {
        Map<String, MissingModule> mapping;
        MissingModule missingModule;
        if (dependencyName == null) {
            DependencySetupErrors.$$$reportNull$$$0(17);
        }
        if (dependentName == null) {
            DependencySetupErrors.$$$reportNull$$$0(18);
        }
        if ((missingModule = (mapping = StringUtil.isNotEmpty((String)backupLibraryName) ? this.myMissingModulesWithBackupLibraries : this.myMissingModules).get(dependencyName)) == null) {
            missingModule = new MissingModule(dependencyName, backupLibraryName);
            mapping.put(dependencyName, missingModule);
        }
        missingModule.addDependent(dependentName);
    }

    public void addMissingName(@NotNull String dependentName) {
        if (dependentName == null) {
            DependencySetupErrors.$$$reportNull$$$0(19);
        }
        this.myDependentsOnModulesWithoutName.add(dependentName);
    }

    public void addMissingBinaryPath(@NotNull String dependentName) {
        if (dependentName == null) {
            DependencySetupErrors.$$$reportNull$$$0(20);
        }
        this.myDependentsOnLibrariesWithoutBinaryPath.add(dependentName);
    }

    public void addInvalidModuleDependency(@NotNull Module module, @NotNull String targetModuleName, @NotNull String causeDescription) {
        if (module == null) {
            DependencySetupErrors.$$$reportNull$$$0(21);
        }
        if (targetModuleName == null) {
            DependencySetupErrors.$$$reportNull$$$0(22);
        }
        if (causeDescription == null) {
            DependencySetupErrors.$$$reportNull$$$0(23);
        }
        this.myInvalidModuleDependencies.add(new InvalidModuleDependency(module, targetModuleName, causeDescription));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/project/sync/setup/module/common/DependencySetupErrors";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "syncMessages";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "missingModulesByName";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "set";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "missingModules";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependents";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependencyName";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependentName";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetModuleName";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "causeDescription";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/project/sync/setup/module/common/DependencySetupErrors";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 4: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getMissingModules";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getMissingModulesWithBackupLibraries";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getMissingNames";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getDependentsOnLibrariesWithoutBinaryPath";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "sortSet";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getMissingModules";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "sortSet";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "reportModulesNotFoundIssues";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "addDependentsToText";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "addMissingModule";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "addMissingName";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "addMissingBinaryPath";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "addInvalidModuleDependency";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class IncludeMissingModulesHyperlink
    extends NotificationHyperlink {
        @NotNull
        private final Set<String> myModuleGradlePaths;

        IncludeMissingModulesHyperlink(@NotNull List<MissingModule> missingModules) {
            if (missingModules == null) {
                IncludeMissingModulesHyperlink.$$$reportNull$$$0(0);
            }
            super("include.missing.modules", "Find and include missing modules");
            this.myModuleGradlePaths = new HashSet<String>(missingModules.size());
            for (MissingModule module : missingModules) {
                this.myModuleGradlePaths.add(module.dependencyPath);
            }
        }

        @Override
        protected void execute(@NotNull Project project) {
            if (project == null) {
                IncludeMissingModulesHyperlink.$$$reportNull$$$0(1);
            }
            ProjectSubset.getInstance(project).findAndIncludeModules(this.myModuleGradlePaths);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "missingModules";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/gradle/project/sync/setup/module/common/DependencySetupErrors$IncludeMissingModulesHyperlink";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "execute";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    @VisibleForTesting
    static class InvalidModuleDependency {
        @NotNull
        final Module dependency;
        @NotNull
        final String dependent;
        @NotNull
        final String causeDescription;

        InvalidModuleDependency(@NotNull Module dependency, @NotNull String dependent, @NotNull String causeDescription) {
            if (dependency == null) {
                InvalidModuleDependency.$$$reportNull$$$0(0);
            }
            if (dependent == null) {
                InvalidModuleDependency.$$$reportNull$$$0(1);
            }
            if (causeDescription == null) {
                InvalidModuleDependency.$$$reportNull$$$0(2);
            }
            this.dependency = dependency;
            this.dependent = dependent;
            this.causeDescription = causeDescription;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "dependency";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "dependent";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "causeDescription";
                    break;
                }
            }
            objectArray[1] = "com/android/tools/idea/gradle/project/sync/setup/module/common/DependencySetupErrors$InvalidModuleDependency";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    @VisibleForTesting
    static class MissingModule {
        @NotNull
        final String dependencyPath;
        @NotNull
        final List<String> dependentNames;
        @Nullable
        final String backupLibraryName;

        MissingModule(@NotNull String dependencyPath, @Nullable String backupLibraryName) {
            if (dependencyPath == null) {
                MissingModule.$$$reportNull$$$0(0);
            }
            this.dependencyPath = dependencyPath;
            this.dependentNames = new ArrayList<String>();
            this.backupLibraryName = backupLibraryName;
        }

        void addDependent(@NotNull String dependentName) {
            if (dependentName == null) {
                MissingModule.$$$reportNull$$$0(1);
            }
            this.dependentNames.add(dependentName);
        }

        void sortDependentNames() {
            if (!this.dependentNames.isEmpty()) {
                Collections.sort(this.dependentNames);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dependencyPath";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dependentName";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/gradle/project/sync/setup/module/common/DependencySetupErrors$MissingModule";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addDependent";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

