/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.model;

import com.android.builder.model.MavenCoordinates;
import com.android.tools.idea.gradle.dsl.model.dependencies.ArtifactDependencyModel;
import com.android.tools.idea.gradle.structure.configurables.ui.PsUISettings;
import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.List;
import org.gradle.tooling.model.GradleModuleVersion;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsArtifactDependencySpec {
    @NotNull
    public String name;
    @Nullable
    public String group;
    @Nullable
    public String version;

    @Nullable
    public static PsArtifactDependencySpec create(@NotNull String notation) {
        List segments;
        int segmentCount;
        if (notation == null) {
            PsArtifactDependencySpec.$$$reportNull$$$0(0);
        }
        if ((segmentCount = (segments = Splitter.on((String)":").trimResults().omitEmptyStrings().splitToList((CharSequence)notation)).size()) > 0) {
            String lastSegment = (String)(segments = Lists.newArrayList((Iterable)segments)).remove(segmentCount - 1);
            int indexOfAt = lastSegment.indexOf(64);
            if (indexOfAt != -1) {
                lastSegment = lastSegment.substring(0, indexOfAt);
            }
            segments.add(lastSegment);
            segmentCount = segments.size();
            String group = null;
            String name = null;
            String version = null;
            if (segmentCount == 1) {
                name = (String)segments.get(0);
            } else if (segmentCount == 2) {
                if (!lastSegment.isEmpty() && Character.isDigit(lastSegment.charAt(0))) {
                    name = (String)segments.get(0);
                    version = lastSegment;
                } else {
                    group = (String)segments.get(0);
                    name = (String)segments.get(1);
                }
            } else if (segmentCount == 3 || segmentCount == 4) {
                group = (String)segments.get(0);
                name = (String)segments.get(1);
                version = (String)segments.get(2);
            }
            if (StringUtil.isNotEmpty((String)name)) {
                return new PsArtifactDependencySpec(name, group, version);
            }
        }
        return null;
    }

    @NotNull
    public static PsArtifactDependencySpec create(@NotNull ArtifactDependencyModel dependency) {
        if (dependency == null) {
            PsArtifactDependencySpec.$$$reportNull$$$0(1);
        }
        PsArtifactDependencySpec psArtifactDependencySpec = new PsArtifactDependencySpec(dependency.name().value(), (String)dependency.group().value(), (String)dependency.version().value());
        if (psArtifactDependencySpec == null) {
            PsArtifactDependencySpec.$$$reportNull$$$0(2);
        }
        return psArtifactDependencySpec;
    }

    @NotNull
    public static PsArtifactDependencySpec create(@NotNull MavenCoordinates coordinates) {
        if (coordinates == null) {
            PsArtifactDependencySpec.$$$reportNull$$$0(3);
        }
        PsArtifactDependencySpec psArtifactDependencySpec = new PsArtifactDependencySpec(coordinates.getArtifactId(), coordinates.getGroupId(), coordinates.getVersion());
        if (psArtifactDependencySpec == null) {
            PsArtifactDependencySpec.$$$reportNull$$$0(4);
        }
        return psArtifactDependencySpec;
    }

    @NotNull
    public static PsArtifactDependencySpec create(@NotNull GradleModuleVersion moduleVersion) {
        if (moduleVersion == null) {
            PsArtifactDependencySpec.$$$reportNull$$$0(5);
        }
        PsArtifactDependencySpec psArtifactDependencySpec = new PsArtifactDependencySpec(moduleVersion.getName(), moduleVersion.getGroup(), moduleVersion.getVersion());
        if (psArtifactDependencySpec == null) {
            PsArtifactDependencySpec.$$$reportNull$$$0(6);
        }
        return psArtifactDependencySpec;
    }

    public PsArtifactDependencySpec(@NotNull String name, @Nullable String group, @Nullable String version) {
        if (name == null) {
            PsArtifactDependencySpec.$$$reportNull$$$0(7);
        }
        this.name = name;
        this.group = Strings.emptyToNull((String)group);
        this.version = Strings.emptyToNull((String)version);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PsArtifactDependencySpec that = (PsArtifactDependencySpec)o;
        return Objects.equal((Object)this.name, (Object)that.name) && Objects.equal((Object)this.group, (Object)that.group) && Objects.equal((Object)this.version, (Object)that.version);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.name, this.group, this.version});
    }

    public String toString() {
        return this.compactNotation();
    }

    @NotNull
    public String compactNotation() {
        ArrayList segments = Lists.newArrayList((Object[])new String[]{this.group, this.name, this.version});
        String string = Joiner.on((String)":").skipNulls().join((Iterable)segments);
        if (string == null) {
            PsArtifactDependencySpec.$$$reportNull$$$0(8);
        }
        return string;
    }

    @NotNull
    public String getDisplayText() {
        boolean showGroupId = PsUISettings.getInstance().DECLARED_DEPENDENCIES_SHOW_GROUP_ID;
        StringBuilder text = new StringBuilder();
        if (showGroupId && StringUtil.isNotEmpty((String)this.group)) {
            text.append(this.group).append(":");
        }
        text.append(this.name);
        if (StringUtil.isNotEmpty((String)this.version)) {
            text.append(":").append(this.version);
        }
        String string = text.toString();
        if (string == null) {
            PsArtifactDependencySpec.$$$reportNull$$$0(9);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "notation";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependency";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/structure/model/PsArtifactDependencySpec";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "coordinates";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleVersion";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/structure/model/PsArtifactDependencySpec";
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "compactNotation";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 9: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

