/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.util;

import com.android.ide.common.repository.GradleVersion;
import com.android.tools.idea.gradle.project.GradleProjectInfo;
import com.android.tools.idea.gradle.project.ProjectImportUtil;
import com.android.tools.idea.gradle.project.build.compiler.AndroidGradleBuildConfiguration;
import com.android.tools.idea.gradle.project.facet.gradle.GradleFacet;
import com.android.tools.idea.gradle.project.facet.gradle.GradleFacetConfiguration;
import com.android.tools.idea.gradle.project.facet.java.JavaFacet;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.project.subset.ProjectSubset;
import com.android.tools.idea.gradle.project.sync.messages.SyncMessages;
import com.android.tools.idea.gradle.project.sync.setup.module.dependency.LibraryDependency;
import com.android.tools.idea.gradle.project.sync.setup.post.PostSyncProjectSetup;
import com.android.tools.idea.model.AndroidModel;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.intellij.ide.DataManager;
import com.intellij.ide.impl.ProjectUtil;
import com.intellij.ide.projectView.ProjectView;
import com.intellij.ide.projectView.impl.AbstractProjectViewPane;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.service.project.ProjectDataManager;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.openapi.roots.ex.ProjectRootManagerEx;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.ex.IdeFrameEx;
import com.intellij.openapi.wm.impl.IdeFrameImpl;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.awt.Component;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.swing.JComponent;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.settings.GradleSettings;
import org.jetbrains.plugins.gradle.util.GradleConstants;

public final class Projects {
    private static final com.intellij.openapi.util.Key<LibraryDependency> MODULE_COMPILED_ARTIFACT = com.intellij.openapi.util.Key.create((String)"module.compiled.artifact");
    private static final com.intellij.openapi.util.Key<Collection<Module>> MODULES_TO_DISPOSE_POST_SYNC = com.intellij.openapi.util.Key.create((String)"project.modules.to.dispose.post.sync");
    private static final com.intellij.openapi.util.Key<Boolean> SYNC_REQUESTED_DURING_BUILD = com.intellij.openapi.util.Key.create((String)"project.sync.requested.during.build");
    private static final com.intellij.openapi.util.Key<Map<String, GradleVersion>> PLUGIN_VERSIONS_BY_MODULE = com.intellij.openapi.util.Key.create((String)"project.plugin.versions.by.module");

    private Projects() {
    }

    @NotNull
    public static File getBaseDirPath(@NotNull Project project) {
        if (project == null) {
            Projects.$$$reportNull$$$0(0);
        }
        String basePath = project.getBasePath();
        assert (basePath != null);
        File file = new File(FileUtil.toCanonicalPath((String)basePath));
        if (file == null) {
            Projects.$$$reportNull$$$0(1);
        }
        return file;
    }

    public static void removeAllModuleCompiledArtifacts(@NotNull Project project) {
        if (project == null) {
            Projects.$$$reportNull$$$0(2);
        }
        ModuleManager moduleManager = ModuleManager.getInstance((Project)project);
        for (Module module : moduleManager.getModules()) {
            Projects.setModuleCompiledArtifact(module, null);
        }
    }

    public static void setModuleCompiledArtifact(@NotNull Module module, @Nullable LibraryDependency compiledArtifact) {
        if (module == null) {
            Projects.$$$reportNull$$$0(3);
        }
        module.putUserData(MODULE_COMPILED_ARTIFACT, (Object)compiledArtifact);
    }

    @Nullable
    public static LibraryDependency getModuleCompiledArtifact(@NotNull Module module) {
        if (module == null) {
            Projects.$$$reportNull$$$0(4);
        }
        return (LibraryDependency)module.getUserData(MODULE_COMPILED_ARTIFACT);
    }

    public static void populate(@NotNull Project project, @NotNull DataNode<ProjectData> projectInfo, @Nullable PostSyncProjectSetup.Request setupRequest, boolean selectModulesToImport) {
        if (project == null) {
            Projects.$$$reportNull$$$0(5);
        }
        if (projectInfo == null) {
            Projects.$$$reportNull$$$0(6);
        }
        Collection<DataNode<ModuleData>> modulesToImport = Projects.getModulesToImport(project, projectInfo, selectModulesToImport);
        Projects.populate(project, projectInfo, modulesToImport, setupRequest);
    }

    @NotNull
    private static Collection<DataNode<ModuleData>> getModulesToImport(@NotNull Project project, @NotNull DataNode<ProjectData> projectInfo, boolean selectModulesToImport) {
        if (project == null) {
            Projects.$$$reportNull$$$0(7);
        }
        if (projectInfo == null) {
            Projects.$$$reportNull$$$0(8);
        }
        Collection modules = ExternalSystemApiUtil.findAll(projectInfo, (Key)ProjectKeys.MODULE);
        ProjectSubset subview = ProjectSubset.getInstance(project);
        if (!ApplicationManager.getApplication().isUnitTestMode() && ProjectSubset.getInstance(project).isFeatureEnabled() && modules.size() > 1) {
            if (selectModulesToImport) {
                Collection<DataNode<ModuleData>> selection = subview.showModuleSelectionDialog(modules);
                if (selection != null) {
                    Collection<DataNode<ModuleData>> collection = selection;
                    if (collection == null) {
                        Projects.$$$reportNull$$$0(9);
                    }
                    return collection;
                }
            } else {
                int moduleCount;
                Object[] persistedModuleNames = subview.getSelection();
                if (persistedModuleNames != null && (moduleCount = persistedModuleNames.length) > 0) {
                    ArrayList moduleNames = Lists.newArrayList((Object[])persistedModuleNames);
                    ArrayList selectedModules = Lists.newArrayListWithExpectedSize((int)moduleCount);
                    for (DataNode module : modules) {
                        String name = ((ModuleData)module.getData()).getExternalName();
                        if (!moduleNames.contains(name)) continue;
                        selectedModules.add(module);
                    }
                    ArrayList arrayList = selectedModules;
                    if (arrayList == null) {
                        Projects.$$$reportNull$$$0(10);
                    }
                    return arrayList;
                }
            }
        }
        subview.clearSelection();
        Collection collection = modules;
        if (collection == null) {
            Projects.$$$reportNull$$$0(11);
        }
        return collection;
    }

    public static void populate(@NotNull Project project, @NotNull DataNode<ProjectData> projectInfo, @NotNull Collection<DataNode<ModuleData>> modulesToImport, @Nullable PostSyncProjectSetup.Request setupRequest) {
        if (project == null) {
            Projects.$$$reportNull$$$0(12);
        }
        if (projectInfo == null) {
            Projects.$$$reportNull$$$0(13);
        }
        if (modulesToImport == null) {
            Projects.$$$reportNull$$$0(14);
        }
        ApplicationManager.getApplication().invokeAndWait(() -> {
            if (project == null) {
                Projects.$$$reportNull$$$0(52);
            }
            if (projectInfo == null) {
                Projects.$$$reportNull$$$0(53);
            }
            if (modulesToImport == null) {
                Projects.$$$reportNull$$$0(54);
            }
            if (project.isDisposed()) {
                return;
            }
            SyncMessages.getInstance(project).removeProjectMessages();
            Projects.disableExcludedModules(projectInfo, modulesToImport);
            Projects.doSelectiveImport(modulesToImport, project);
            if (setupRequest != null) {
                PostSyncProjectSetup.getInstance(project).setUpProject(setupRequest, null);
            }
        });
    }

    private static void disableExcludedModules(@NotNull DataNode<ProjectData> projectInfo, @NotNull Collection<DataNode<ModuleData>> selectedModules) {
        if (projectInfo == null) {
            Projects.$$$reportNull$$$0(15);
        }
        if (selectedModules == null) {
            Projects.$$$reportNull$$$0(16);
        }
        Collection allModules = ExternalSystemApiUtil.findAll(projectInfo, (Key)ProjectKeys.MODULE);
        if (selectedModules.size() != allModules.size()) {
            HashSet moduleToIgnore = Sets.newHashSet((Iterable)allModules);
            moduleToIgnore.removeAll(selectedModules);
            for (DataNode moduleNode : moduleToIgnore) {
                ExternalSystemApiUtil.visit((DataNode)moduleNode, node -> node.setIgnored(true));
            }
        }
    }

    private static void doSelectiveImport(@NotNull Collection<DataNode<ModuleData>> enabledModules, @NotNull Project project) {
        DataNode projectNode;
        if (enabledModules == null) {
            Projects.$$$reportNull$$$0(17);
        }
        if (project == null) {
            Projects.$$$reportNull$$$0(18);
        }
        ProjectDataManager dataManager = (ProjectDataManager)ServiceManager.getService(ProjectDataManager.class);
        DataNode dataNode = projectNode = enabledModules.isEmpty() ? null : ExternalSystemApiUtil.findParent(enabledModules.iterator().next(), (Key)ProjectKeys.PROJECT);
        if (projectNode != null) {
            Collection allModules = ExternalSystemApiUtil.findAll((DataNode)projectNode, (Key)ProjectKeys.MODULE);
            if (enabledModules.size() != allModules.size()) {
                THashSet moduleToIgnore = ContainerUtil.newIdentityTroveSet((Collection)allModules);
                moduleToIgnore.removeAll(enabledModules);
                for (DataNode moduleNode : moduleToIgnore) {
                    ExternalSystemApiUtil.visit((DataNode)moduleNode, node -> node.setIgnored(true));
                }
            }
            dataManager.importData(projectNode, project, true);
        } else {
            dataManager.importData(enabledModules, project, true);
        }
    }

    public static void executeProjectChanges(@NotNull Project project, @NotNull Runnable changes) {
        if (project == null) {
            Projects.$$$reportNull$$$0(19);
        }
        if (changes == null) {
            Projects.$$$reportNull$$$0(20);
        }
        if (ApplicationManager.getApplication().isWriteAccessAllowed()) {
            if (!project.isDisposed()) {
                changes.run();
            }
            return;
        }
        ApplicationManager.getApplication().invokeAndWait(() -> {
            if (project == null) {
                Projects.$$$reportNull$$$0(48);
            }
            if (changes == null) {
                Projects.$$$reportNull$$$0(49);
            }
            ApplicationManager.getApplication().runWriteAction(() -> {
                if (project == null) {
                    Projects.$$$reportNull$$$0(50);
                }
                if (changes == null) {
                    Projects.$$$reportNull$$$0(51);
                }
                if (!project.isDisposed()) {
                    ProjectRootManagerEx.getInstanceEx((Project)project).mergeRootsChangesDuring(changes);
                }
            });
        }, ModalityState.defaultModalityState());
    }

    public static boolean requiredAndroidModelMissing(@NotNull Project project) {
        if (project == null) {
            Projects.$$$reportNull$$$0(21);
        }
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            AndroidFacet facet = AndroidFacet.getInstance(module);
            if (facet == null || !facet.requiresAndroidModel() || facet.getAndroidModel() != null) continue;
            return true;
        }
        return false;
    }

    public static void open(@NotNull Project project) {
        boolean fullScreen;
        IdeFocusManager instance;
        IdeFrame lastFocusedFrame;
        if (project == null) {
            Projects.$$$reportNull$$$0(22);
        }
        ProjectUtil.updateLastProjectLocation((String)project.getBasePath());
        if (WindowManager.getInstance().isFullScreenSupportedInCurrentOS() && (lastFocusedFrame = (instance = IdeFocusManager.findInstance()).getLastFocusedFrame()) instanceof IdeFrameEx && (fullScreen = ((IdeFrameEx)lastFocusedFrame).isInFullScreen())) {
            project.putUserData(IdeFrameImpl.SHOULD_OPEN_IN_FULL_SCREEN, (Object)Boolean.TRUE);
        }
        ProjectManagerEx.getInstanceEx().openProject(project);
    }

    public static boolean isDirectGradleInvocationEnabled(@NotNull Project project) {
        if (project == null) {
            Projects.$$$reportNull$$$0(23);
        }
        AndroidGradleBuildConfiguration buildConfiguration = AndroidGradleBuildConfiguration.getInstance(project);
        return buildConfiguration.USE_EXPERIMENTAL_FASTER_BUILD;
    }

    public static boolean isOfflineBuildModeEnabled(@NotNull Project project) {
        if (project == null) {
            Projects.$$$reportNull$$$0(24);
        }
        return GradleSettings.getInstance((Project)project).isOfflineWork();
    }

    @Nullable
    public static AndroidModel getAndroidModel(@NotNull Module module) {
        AndroidFacet androidFacet;
        if (module == null) {
            Projects.$$$reportNull$$$0(25);
        }
        return (androidFacet = AndroidFacet.getInstance(module)) != null ? androidFacet.getAndroidModel() : null;
    }

    public static boolean isLegacyIdeaAndroidProject(@NotNull Project project) {
        if (project == null) {
            Projects.$$$reportNull$$$0(26);
        }
        ModuleManager moduleManager = ModuleManager.getInstance((Project)project);
        for (Module module : moduleManager.getModules()) {
            if (!Projects.isLegacyIdeaAndroidModule(module)) continue;
            return true;
        }
        return false;
    }

    public static boolean isLegacyIdeaAndroidModule(@NotNull Module module) {
        AndroidFacet facet;
        if (module == null) {
            Projects.$$$reportNull$$$0(27);
        }
        return (facet = AndroidFacet.getInstance(module)) != null && !facet.requiresAndroidModel();
    }

    public static boolean isIdeaAndroidModule(@NotNull Module module) {
        if (module == null) {
            Projects.$$$reportNull$$$0(28);
        }
        if (GradleFacet.getInstance(module) != null || JavaFacet.getInstance(module) != null) {
            return true;
        }
        AndroidFacet androidFacet = AndroidFacet.getInstance(module);
        return androidFacet != null && androidFacet.requiresAndroidModel();
    }

    @NotNull
    public static Module[] getModulesToBuildFromSelection(@NotNull Project project, @Nullable DataContext dataContext) {
        Module[] modules;
        if (project == null) {
            Projects.$$$reportNull$$$0(29);
        }
        if (dataContext == null) {
            ProjectView projectView = ProjectView.getInstance((Project)project);
            AbstractProjectViewPane pane = projectView.getCurrentProjectViewPane();
            if (pane != null) {
                JComponent treeComponent = pane.getComponentToFocus();
                dataContext = DataManager.getInstance().getDataContext((Component)treeComponent);
            } else {
                if (Module.EMPTY_ARRAY == null) {
                    Projects.$$$reportNull$$$0(30);
                }
                return Module.EMPTY_ARRAY;
            }
        }
        if ((modules = (Module[])LangDataKeys.MODULE_CONTEXT_ARRAY.getData(dataContext)) != null) {
            if (modules.length == 1 && Projects.isProjectModule(modules[0])) {
                Module[] moduleArray = ModuleManager.getInstance((Project)project).getModules();
                if (moduleArray == null) {
                    Projects.$$$reportNull$$$0(31);
                }
                return moduleArray;
            }
            if (modules == null) {
                Projects.$$$reportNull$$$0(32);
            }
            return modules;
        }
        Module module = (Module)LangDataKeys.MODULE.getData(dataContext);
        if (module != null) {
            Module[] moduleArray;
            if (Projects.isProjectModule(module)) {
                moduleArray = ModuleManager.getInstance((Project)project).getModules();
            } else {
                Module[] moduleArray2 = new Module[1];
                moduleArray = moduleArray2;
                moduleArray2[0] = module;
            }
            if (moduleArray == null) {
                Projects.$$$reportNull$$$0(33);
            }
            return moduleArray;
        }
        if (Module.EMPTY_ARRAY == null) {
            Projects.$$$reportNull$$$0(34);
        }
        return Module.EMPTY_ARRAY;
    }

    public static boolean isProjectModule(@NotNull Module module) {
        File moduleFilePath;
        File moduleRootDirPath;
        if (module == null) {
            Projects.$$$reportNull$$$0(35);
        }
        if ((moduleRootDirPath = (moduleFilePath = new File(FileUtil.toSystemDependentName((String)module.getModuleFilePath()))).getParentFile()) == null) {
            return false;
        }
        String basePath = module.getProject().getBasePath();
        return basePath != null && FileUtil.filesEqual((File)moduleRootDirPath, (File)new File(basePath)) && !Projects.isBuildWithGradle(module);
    }

    @Deprecated
    public static boolean isBuildWithGradle(@NotNull Project project) {
        if (project == null) {
            Projects.$$$reportNull$$$0(36);
        }
        return GradleProjectInfo.getInstance(project).isBuildWithGradle();
    }

    public static boolean isBuildWithGradle(@NotNull Module module) {
        if (module == null) {
            Projects.$$$reportNull$$$0(37);
        }
        return GradleFacet.getInstance(module) != null;
    }

    public static boolean isGradleProjectModule(@NotNull Module module) {
        if (module == null) {
            Projects.$$$reportNull$$$0(38);
        }
        if (!ExternalSystemApiUtil.isExternalSystemAwareModule((ProjectSystemId)GradleConstants.SYSTEM_ID, (Module)module)) {
            return false;
        }
        AndroidFacet androidFacet = AndroidFacet.getInstance(module);
        if (androidFacet != null && androidFacet.requiresAndroidModel() && Projects.isBuildWithGradle(module)) {
            File moduleFilePath = new File(FileUtil.toSystemDependentName((String)module.getModuleFilePath()));
            File moduleRootDirPath = moduleFilePath.getParentFile();
            return FileUtil.pathsEqual((String)moduleRootDirPath.getPath(), (String)module.getProject().getBasePath());
        }
        return !Projects.isBuildWithGradle(module);
    }

    @Nullable
    public static Collection<Module> getModulesToDisposePostSync(@NotNull Project project) {
        if (project == null) {
            Projects.$$$reportNull$$$0(39);
        }
        return (Collection)project.getUserData(MODULES_TO_DISPOSE_POST_SYNC);
    }

    public static void setModulesToDisposePostSync(@NotNull Project project, @Nullable Collection<Module> modules) {
        if (project == null) {
            Projects.$$$reportNull$$$0(40);
        }
        project.putUserData(MODULES_TO_DISPOSE_POST_SYNC, modules);
    }

    public static boolean canImportAsGradleProject(@NotNull VirtualFile importSource) {
        VirtualFile target;
        if (importSource == null) {
            Projects.$$$reportNull$$$0(41);
        }
        return (target = ProjectImportUtil.findImportTarget(importSource)) != null && "gradle".equals(target.getExtension());
    }

    public static void setSyncRequestedDuringBuild(@NotNull Project project, @Nullable Boolean value) {
        if (project == null) {
            Projects.$$$reportNull$$$0(42);
        }
        project.putUserData(SYNC_REQUESTED_DURING_BUILD, (Object)value);
    }

    public static boolean isSyncRequestedDuringBuild(@NotNull Project project) {
        if (project == null) {
            Projects.$$$reportNull$$$0(43);
        }
        return Projects.getBoolean(project, SYNC_REQUESTED_DURING_BUILD);
    }

    private static boolean getBoolean(@NotNull Project project, @NotNull com.intellij.openapi.util.Key<Boolean> key) {
        Boolean val;
        if (project == null) {
            Projects.$$$reportNull$$$0(44);
        }
        if (key == null) {
            Projects.$$$reportNull$$$0(45);
        }
        return (val = (Boolean)project.getUserData(key)) != null && val != false;
    }

    public static void storePluginVersionsPerModule(@NotNull Project project) {
        if (project == null) {
            Projects.$$$reportNull$$$0(46);
        }
        HashMap pluginVersionsPerModule = Maps.newHashMap();
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            GradleVersion modelVersion;
            GradleFacet facet;
            AndroidModuleModel model = AndroidModuleModel.get(module);
            if (model == null || (facet = GradleFacet.getInstance(module)) == null || (modelVersion = model.getModelVersion()) == null) continue;
            pluginVersionsPerModule.put(((GradleFacetConfiguration)facet.getConfiguration()).GRADLE_PROJECT_PATH, modelVersion);
        }
        project.putUserData(PLUGIN_VERSIONS_BY_MODULE, (Object)pluginVersionsPerModule);
    }

    @Nullable
    public static Map<String, GradleVersion> getPluginVersionsPerModule(@NotNull Project project) {
        if (project == null) {
            Projects.$$$reportNull$$$0(47);
        }
        return (Map)project.getUserData(PLUGIN_VERSIONS_BY_MODULE);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 9: 
            case 10: 
            case 11: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 9: 
            case 10: 
            case 11: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 9: 
            case 10: 
            case 11: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/util/Projects";
                break;
            }
            case 3: 
            case 4: 
            case 25: 
            case 27: 
            case 28: 
            case 35: 
            case 37: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 6: 
            case 8: 
            case 13: 
            case 15: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectInfo";
                break;
            }
            case 14: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modulesToImport";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedModules";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "enabledModules";
                break;
            }
            case 20: 
            case 49: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changes";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importSource";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/util/Projects";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getBaseDirPath";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getModulesToImport";
                break;
            }
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getModulesToBuildFromSelection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getBaseDirPath";
                break;
            }
            case 1: 
            case 9: 
            case 10: 
            case 11: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "removeAllModuleCompiledArtifacts";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setModuleCompiledArtifact";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getModuleCompiledArtifact";
                break;
            }
            case 5: 
            case 6: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "populate";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getModulesToImport";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "disableExcludedModules";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "doSelectiveImport";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "executeProjectChanges";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "requiredAndroidModelMissing";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "open";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "isDirectGradleInvocationEnabled";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "isOfflineBuildModeEnabled";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getAndroidModel";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "isLegacyIdeaAndroidProject";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "isLegacyIdeaAndroidModule";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "isIdeaAndroidModule";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getModulesToBuildFromSelection";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "isProjectModule";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "isBuildWithGradle";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "isGradleProjectModule";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "getModulesToDisposePostSync";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "setModulesToDisposePostSync";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "canImportAsGradleProject";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "setSyncRequestedDuringBuild";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "isSyncRequestedDuringBuild";
                break;
            }
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "getBoolean";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "storePluginVersionsPerModule";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "getPluginVersionsPerModule";
                break;
            }
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "lambda$executeProjectChanges$4";
                break;
            }
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$3";
                break;
            }
            case 52: 
            case 53: 
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "lambda$populate$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 9: 
            case 10: 
            case 11: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

