/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lint;

import com.android.tools.idea.lint.LintIdeClient;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.TextFormat;
import com.intellij.codeInsight.documentation.DocumentationComponent;
import com.intellij.codeInsight.documentation.DocumentationManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Disposer;
import com.intellij.psi.PsiElement;
import javax.swing.JComponent;
import org.jetbrains.android.inspections.lint.AndroidLintQuickFix;
import org.jetbrains.android.inspections.lint.AndroidQuickfixContexts;
import org.jetbrains.annotations.NotNull;

class ShowCustomIssueExplanationFix
implements AndroidLintQuickFix {
    private final PsiElement myElement;
    private final Issue myIssue;

    public static AndroidLintQuickFix[] getFixes(@NotNull PsiElement element, @NotNull String message) {
        Issue issue;
        if (element == null) {
            ShowCustomIssueExplanationFix.$$$reportNull$$$0(0);
        }
        if (message == null) {
            ShowCustomIssueExplanationFix.$$$reportNull$$$0(1);
        }
        if ((issue = LintIdeClient.findCustomIssue(message)) != null) {
            return new AndroidLintQuickFix[]{new ShowCustomIssueExplanationFix(element, issue)};
        }
        return AndroidLintQuickFix.EMPTY_ARRAY;
    }

    private ShowCustomIssueExplanationFix(@NotNull PsiElement element, @NotNull Issue issue) {
        if (element == null) {
            ShowCustomIssueExplanationFix.$$$reportNull$$$0(2);
        }
        if (issue == null) {
            ShowCustomIssueExplanationFix.$$$reportNull$$$0(3);
        }
        this.myElement = element;
        this.myIssue = issue;
    }

    @Override
    public void apply(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.Context context) {
        if (startElement == null) {
            ShowCustomIssueExplanationFix.$$$reportNull$$$0(4);
        }
        if (endElement == null) {
            ShowCustomIssueExplanationFix.$$$reportNull$$$0(5);
        }
        if (context == null) {
            ShowCustomIssueExplanationFix.$$$reportNull$$$0(6);
        }
        Project project = this.myElement.getProject();
        DocumentationManager manager = DocumentationManager.getInstance((Project)project);
        DocumentationComponent component = new DocumentationComponent(manager);
        component.setText("<html>" + this.myIssue.getExplanation(TextFormat.HTML) + "</html>", this.myElement, false);
        JBPopup popup = JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)component, (JComponent)component).setDimensionServiceKey(project, "javadoc.popup", false).setResizable(true).setMovable(true).setRequestFocus(true).createPopup();
        component.setHint(popup);
        if (context.getType() == AndroidQuickfixContexts.EditorContext.TYPE) {
            popup.showInBestPositionFor(((AndroidQuickfixContexts.EditorContext)context).getEditor());
        } else {
            popup.showCenteredInCurrentWindow(project);
        }
        Disposer.dispose((Disposable)component);
    }

    @Override
    public boolean isApplicable(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.ContextType contextType) {
        if (startElement == null) {
            ShowCustomIssueExplanationFix.$$$reportNull$$$0(7);
        }
        if (endElement == null) {
            ShowCustomIssueExplanationFix.$$$reportNull$$$0(8);
        }
        if (contextType == null) {
            ShowCustomIssueExplanationFix.$$$reportNull$$$0(9);
        }
        return true;
    }

    @Override
    @NotNull
    public String getName() {
        if ("Show Full Explanation" == null) {
            ShowCustomIssueExplanationFix.$$$reportNull$$$0(10);
        }
        return "Show Full Explanation";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "issue";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startElement";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endElement";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextType";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/lint/ShowCustomIssueExplanationFix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/lint/ShowCustomIssueExplanationFix";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getFixes";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "apply";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isApplicable";
                break;
            }
            case 10: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

