/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.monitor.ui.memory.view;

import com.android.tools.adtui.Animatable;
import com.android.tools.adtui.common.ColumnTreeBuilder;
import com.android.tools.adtui.model.Range;
import com.android.tools.idea.monitor.tool.ProfilerEventListener;
import com.android.tools.idea.monitor.ui.BaseSegment;
import com.android.tools.idea.monitor.ui.memory.model.MemoryInfoTreeNode;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.JBColor;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.EventDispatcher;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.SortOrder;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;

public class MemoryDetailSegment
extends BaseSegment {
    private static final String SEGMENT_NAME = "Memory Details";
    private static final Color NEGATIVE_COLOR = new JBColor(new Color(0x33FF0000, true), new Color(872375396, true));
    private static final Color POSITIVE_COLOR = new JBColor(new Color(0x330000FF, true), new Color(861445622, true));
    @NotNull
    private final MemoryInfoTreeNode mRoot;
    private JComponent mColumnTree;
    private JTree mTree;
    private DefaultTreeModel mTreeModel;

    public MemoryDetailSegment(@NotNull Range timeCurrentRangeUs, @NotNull MemoryInfoTreeNode root, @NotNull EventDispatcher<ProfilerEventListener> dispatcher) {
        if (timeCurrentRangeUs == null) {
            MemoryDetailSegment.$$$reportNull$$$0(0);
        }
        if (root == null) {
            MemoryDetailSegment.$$$reportNull$$$0(1);
        }
        if (dispatcher == null) {
            MemoryDetailSegment.$$$reportNull$$$0(2);
        }
        super(SEGMENT_NAME, timeCurrentRangeUs, dispatcher);
        this.mRoot = root;
    }

    public void refreshNode(@NotNull MemoryInfoTreeNode node) {
        if (node == null) {
            MemoryDetailSegment.$$$reportNull$$$0(3);
        }
        this.mTreeModel.reload(node);
    }

    public boolean getExpandState(@NotNull MemoryInfoTreeNode node) {
        if (node == null) {
            MemoryDetailSegment.$$$reportNull$$$0(4);
        }
        return this.mTree.isExpanded(new TreePath(this.mTreeModel.getPathToRoot(node)));
    }

    public void setExpandState(@NotNull MemoryInfoTreeNode node, boolean expand) {
        if (node == null) {
            MemoryDetailSegment.$$$reportNull$$$0(5);
        }
        if (expand) {
            this.mTree.expandPath(new TreePath(this.mTreeModel.getPathToRoot(node)));
        } else {
            this.mTree.collapsePath(new TreePath(this.mTreeModel.getPathToRoot(node)));
        }
    }

    public void insertNode(@NotNull MemoryInfoTreeNode parent, @NotNull MemoryInfoTreeNode child) {
        if (parent == null) {
            MemoryDetailSegment.$$$reportNull$$$0(6);
        }
        if (child == null) {
            MemoryDetailSegment.$$$reportNull$$$0(7);
        }
        this.mTreeModel.insertNodeInto(child, parent, parent.getChildCount());
    }

    @Override
    protected boolean hasLeftContent() {
        return false;
    }

    @Override
    protected boolean hasRightContent() {
        return false;
    }

    @Override
    protected void setCenterContent(@NotNull JPanel panel) {
        if (panel == null) {
            MemoryDetailSegment.$$$reportNull$$$0(8);
        }
        panel.add((Component)this.mColumnTree, "Center");
    }

    @Override
    public void createComponentsList(@NotNull List<Animatable> animatables) {
        if (animatables == null) {
            MemoryDetailSegment.$$$reportNull$$$0(9);
        }
        this.mTreeModel = new DefaultTreeModel(this.mRoot);
        this.mTree = new Tree((TreeModel)this.mTreeModel);
        this.mTree.setRootVisible(false);
        this.mTree.setShowsRootHandles(true);
        ColumnTreeBuilder builder = new ColumnTreeBuilder(this.mTree).addColumn(new ColumnTreeBuilder.ColumnBuilder().setName("Class").setHeaderAlignment(2).setRenderer((ColoredTreeCellRenderer)new MemoryInfoColumnRenderer(0, this.mRoot))).addColumn(new ColumnTreeBuilder.ColumnBuilder().setName("Count").setHeaderAlignment(2).setRenderer((ColoredTreeCellRenderer)new MemoryInfoColumnRenderer(1, this.mRoot)).setInitialOrder(SortOrder.DESCENDING).setComparator((a, b) -> a.getCount() - b.getCount()));
        builder.setTreeSorter((comparator, sortOrder) -> {
            this.mRoot.sort(comparator);
            this.mTreeModel.nodeStructureChanged(this.mRoot);
        });
        this.mColumnTree = builder.build();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "timeCurrentRangeUs";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dispatcher";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "panel";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "animatables";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/monitor/ui/memory/view/MemoryDetailSegment";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "refreshNode";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getExpandState";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "setExpandState";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "insertNode";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "setCenterContent";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "createComponentsList";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class MemoryInfoHealthBar
    extends JComponent {
        private float mDelta;

        private MemoryInfoHealthBar() {
        }

        private void setDelta(float delta) {
            this.mDelta = delta;
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            Dimension dim = this.getSize();
            if (this.mDelta > 0.0f) {
                g.setColor(NEGATIVE_COLOR);
            } else {
                g.setColor(POSITIVE_COLOR);
            }
            g.fillRect(0, 0, (int)((float)dim.width * Math.abs(this.mDelta)), dim.height);
        }
    }

    private static class MemoryInfoColumnRenderer
    extends ColoredTreeCellRenderer {
        @NotNull
        private final MemoryInfoHealthBar mHealthBar;
        @NotNull
        private final MemoryInfoTreeNode mRoot;
        private final int mColumnIndex;

        private MemoryInfoColumnRenderer(int index, @NotNull MemoryInfoTreeNode root) {
            if (root == null) {
                MemoryInfoColumnRenderer.$$$reportNull$$$0(0);
            }
            this.mHealthBar = new MemoryInfoHealthBar();
            this.mColumnIndex = index;
            this.mRoot = root;
            if (this.mColumnIndex > 0) {
                this.setLayout(new BorderLayout());
                this.add(this.mHealthBar, "Center");
            }
        }

        public void customizeCellRenderer(@NotNull JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            if (tree == null) {
                MemoryInfoColumnRenderer.$$$reportNull$$$0(1);
            }
            if (value instanceof MemoryInfoTreeNode) {
                MemoryInfoTreeNode node = (MemoryInfoTreeNode)value;
                switch (this.mColumnIndex) {
                    case 0: {
                        this.append(node.getName());
                        break;
                    }
                    case 1: {
                        this.append(String.valueOf(node.getCount()));
                    }
                }
                this.mHealthBar.setDelta((float)node.getCount() / (float)this.mRoot.getCount());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "root";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tree";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/monitor/ui/memory/view/MemoryDetailSegment$MemoryInfoColumnRenderer";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "customizeCellRenderer";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

