/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw;

import com.android.ide.common.repository.GradleVersion;
import com.android.tools.idea.gradle.plugin.AndroidPluginGeneration;
import com.android.tools.idea.gradle.plugin.AndroidPluginInfo;
import com.android.tools.idea.gradle.project.sync.GradleSyncInvoker;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.npw.AndroidModuleTemplatesProvider;
import com.android.tools.idea.npw.ModuleTemplate;
import com.android.tools.idea.npw.NewModuleDynamicPath;
import com.android.tools.idea.npw.NewModuleDynamicPathFactory;
import com.android.tools.idea.npw.NewProjectWizardDynamic;
import com.android.tools.idea.npw.PostStartupGradleSyncListener;
import com.android.tools.idea.npw.deprecated.ChooseModuleTypeStep;
import com.android.tools.idea.npw.deprecated.ConfigureAndroidProjectPath;
import com.android.tools.idea.npw.deprecated.NewFormFactorModulePath;
import com.android.tools.idea.templates.TemplateManager;
import com.android.tools.idea.templates.TemplateUtils;
import com.android.tools.idea.wizard.WizardConstants;
import com.android.tools.idea.wizard.dynamic.DynamicWizard;
import com.android.tools.idea.wizard.dynamic.DynamicWizardHost;
import com.android.tools.idea.wizard.dynamic.DynamicWizardStepWithHeaderAndDescription;
import com.android.tools.idea.wizard.dynamic.ScopedStateStore;
import com.android.tools.idea.wizard.dynamic.SingleStepPath;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Collection;
import org.jetbrains.android.sdk.AndroidSdkUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NewModuleWizardDynamic
extends DynamicWizard {
    public NewModuleWizardDynamic(@Nullable Project project, @Nullable Module module) {
        super(project, module, "New Module");
        this.setTitle("Create New Module");
    }

    public NewModuleWizardDynamic(@Nullable Project project, @Nullable Module module, @NotNull DynamicWizardHost host) {
        if (host == null) {
            NewModuleWizardDynamic.$$$reportNull$$$0(0);
        }
        super(project, module, "New Module", host);
        this.setTitle("Create New Module");
    }

    @Override
    public void init() {
        if (!this.checkSdk()) {
            return;
        }
        this.addPaths();
        ConfigureAndroidProjectPath.putSdkDependentParams(this.getState());
        this.initState();
        super.init();
    }

    protected boolean checkSdk() {
        if (!AndroidSdkUtils.isAndroidSdkAvailable() || !TemplateManager.templatesAreValid()) {
            String title = "SDK problem";
            String msg = "<html>Your Android SDK is missing, out of date, or is missing templates.<br>You can configure your SDK via <b>Configure | Project Defaults | Project Structure | SDKs</b></html>";
            Messages.showErrorDialog((String)msg, (String)title);
            return false;
        }
        return true;
    }

    private void initState() {
        ScopedStateStore state = this.getState();
        Project project = this.getProject();
        NewProjectWizardDynamic.initState(state, NewModuleWizardDynamic.determineGradlePluginVersion(project));
        if (project != null) {
            state.put(WizardConstants.PROJECT_LOCATION_KEY, project.getBasePath());
        }
        state.put(WizardConstants.ALSO_CREATE_IAPK_KEY, false);
    }

    @NotNull
    private static String determineGradlePluginVersion(@Nullable Project project) {
        if (project != null) {
            GradleVersion pluginVersion;
            GradleVersion versionInUse = GradleUtil.getAndroidGradleModelVersionInUse(project);
            if (versionInUse != null) {
                String string = versionInUse.toString();
                if (string == null) {
                    NewModuleWizardDynamic.$$$reportNull$$$0(1);
                }
                return string;
            }
            AndroidPluginInfo androidPluginInfo = AndroidPluginInfo.searchInBuildFilesOnly(project);
            if (androidPluginInfo != null && (pluginVersion = androidPluginInfo.getPluginVersion()) != null) {
                String string = pluginVersion.toString();
                if (string == null) {
                    NewModuleWizardDynamic.$$$reportNull$$$0(2);
                }
                return string;
            }
        }
        String string = AndroidPluginGeneration.ORIGINAL.getLatestKnownVersion();
        if (string == null) {
            NewModuleWizardDynamic.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    public static DynamicWizardStepWithHeaderAndDescription.WizardStepHeaderSettings buildHeader() {
        DynamicWizardStepWithHeaderAndDescription.WizardStepHeaderSettings wizardStepHeaderSettings = DynamicWizardStepWithHeaderAndDescription.WizardStepHeaderSettings.createProductHeader("New Module");
        if (wizardStepHeaderSettings == null) {
            NewModuleWizardDynamic.$$$reportNull$$$0(4);
        }
        return wizardStepHeaderSettings;
    }

    private void addPaths() {
        Collection<NewModuleDynamicPath> contributions = this.getContributedPaths();
        Iterable templateProviders = Iterables.concat((Iterable)ImmutableSet.of((Object)new AndroidModuleTemplatesProvider()), contributions);
        this.addPath(new SingleStepPath(new ChooseModuleTypeStep(templateProviders, this.getDisposable())));
        for (NewFormFactorModulePath path : NewFormFactorModulePath.getAvailableFormFactorModulePaths(this.getDisposable())) {
            path.setGradleSyncIfNecessary(false);
            this.addPath(path);
        }
        for (NewModuleDynamicPath contribution : contributions) {
            this.addPath(contribution);
        }
    }

    private Collection<NewModuleDynamicPath> getContributedPaths() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (NewModuleDynamicPathFactory factory : (NewModuleDynamicPathFactory[])NewModuleDynamicPathFactory.EP_NAME.getExtensions()) {
            builder.addAll(factory.createWizardPaths(this.getProject(), this.getDisposable()));
        }
        return builder.build();
    }

    @Override
    protected String getWizardActionDescription() {
        String applicationName = this.getState().get(WizardConstants.APPLICATION_NAME_KEY);
        if (StringUtil.isEmptyOrSpaces((String)applicationName)) {
            ModuleTemplate moduleType = this.myState.get(WizardConstants.SELECTED_MODULE_TYPE_KEY);
            applicationName = moduleType != null ? moduleType.getName() : "Module";
        }
        return String.format("Create %1$s", applicationName);
    }

    @Override
    public void performFinishingActions() {
        Project project = this.getProject();
        if (project == null) {
            return;
        }
        GradleSyncInvoker.getInstance().requestProjectSyncAndSourceGeneration(project, new PostStartupGradleSyncListener(() -> {
            Collection filesToOpen = this.myState.get(WizardConstants.FILES_TO_OPEN_KEY);
            assert (filesToOpen != null);
            TemplateUtils.openEditors(project, filesToOpen, true);
        }));
    }

    @Override
    @NotNull
    protected String getProgressTitle() {
        if ("Creating module..." == null) {
            NewModuleWizardDynamic.$$$reportNull$$$0(5);
        }
        return "Creating module...";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "host";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/npw/NewModuleWizardDynamic";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/npw/NewModuleWizardDynamic";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "determineGradlePluginVersion";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "buildHeader";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getProgressTitle";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

