/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run;

import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.IDevice;
import com.android.tools.idea.ddms.adb.AdbService;
import com.android.tools.idea.run.util.LaunchUtils;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import com.google.common.util.concurrent.Uninterruptibles;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jetbrains.android.actions.AndroidEnableAdbServiceAction;
import org.jetbrains.android.sdk.AndroidSdkUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EmulatorConnectionListener {
    /*
     * WARNING - void declaration
     */
    public static ListenableFuture<IDevice> getDeviceForEmulator(@NotNull Project project, @NotNull String avdName, @Nullable ProcessHandler emulatorProcessHandler, long timeout, @NotNull TimeUnit timeUnit) {
        void units;
        if (project == null) {
            EmulatorConnectionListener.$$$reportNull$$$0(0);
        }
        if (avdName == null) {
            EmulatorConnectionListener.$$$reportNull$$$0(1);
        }
        if (timeUnit == null) {
            EmulatorConnectionListener.$$$reportNull$$$0(2);
        }
        if (emulatorProcessHandler == null) {
            return Futures.immediateFailedFuture((Throwable)new RuntimeException("Emulator process for AVD " + avdName + " died."));
        }
        SettableFuture future = SettableFuture.create();
        WaitForEmulatorTask task = new WaitForEmulatorTask(project, future, avdName, emulatorProcessHandler, timeout, (TimeUnit)units);
        ApplicationManager.getApplication().executeOnPooledThread((Runnable)task);
        return future;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "avdName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "units";
                break;
            }
        }
        objectArray[1] = "com/android/tools/idea/run/EmulatorConnectionListener";
        objectArray[2] = "getDeviceForEmulator";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class WaitForEmulatorTask
    implements Runnable {
        private static final TimeUnit POLL_TIMEUNIT = TimeUnit.SECONDS;
        private final Project myProject;
        private final SettableFuture<IDevice> myDeviceFuture;
        private final String myAvdName;
        private final ProcessHandler myEmulatorProcessHandler;
        private final long myTimeout;

        /*
         * WARNING - void declaration
         */
        private WaitForEmulatorTask(@NotNull Project project, @NotNull SettableFuture<IDevice> device, @NotNull String avdName, @NotNull ProcessHandler emulatorProcessHandler, long timeout, @NotNull TimeUnit timeUnit) {
            void units;
            if (project == null) {
                WaitForEmulatorTask.$$$reportNull$$$0(0);
            }
            if (device == null) {
                WaitForEmulatorTask.$$$reportNull$$$0(1);
            }
            if (avdName == null) {
                WaitForEmulatorTask.$$$reportNull$$$0(2);
            }
            if (emulatorProcessHandler == null) {
                WaitForEmulatorTask.$$$reportNull$$$0(3);
            }
            if (timeUnit == null) {
                WaitForEmulatorTask.$$$reportNull$$$0(4);
            }
            this.myProject = project;
            this.myDeviceFuture = device;
            this.myAvdName = avdName;
            this.myEmulatorProcessHandler = emulatorProcessHandler;
            this.myTimeout = POLL_TIMEUNIT.convert(timeout, (TimeUnit)units);
        }

        @Override
        public void run() {
            File adb = AndroidSdkUtils.getAdb(this.myProject);
            if (adb == null) {
                this.myDeviceFuture.setException((Throwable)new IllegalArgumentException("Unable to locate adb"));
                return;
            }
            for (long i = 0L; i < this.myTimeout; ++i) {
                AndroidDebugBridge bridge;
                if (this.myDeviceFuture.isCancelled()) {
                    return;
                }
                if (this.myEmulatorProcessHandler.isProcessTerminated() || this.myEmulatorProcessHandler.isProcessTerminating()) {
                    this.myDeviceFuture.setException((Throwable)new RuntimeException("The emulator process for AVD " + this.myAvdName + " was killed."));
                    return;
                }
                ListenableFuture<AndroidDebugBridge> bridgeFuture = AdbService.getInstance().getDebugBridge(adb);
                try {
                    bridge = (AndroidDebugBridge)bridgeFuture.get(1L, POLL_TIMEUNIT);
                }
                catch (TimeoutException e) {
                    continue;
                }
                catch (Exception e) {
                    this.myDeviceFuture.setException((Throwable)e);
                    return;
                }
                if (bridge == null || !bridge.isConnected()) {
                    this.myDeviceFuture.setException((Throwable)new RuntimeException("adb connection not available, or was terminated."));
                    return;
                }
                for (IDevice device : bridge.getDevices()) {
                    if (!device.isEmulator() || !StringUtil.equals((CharSequence)device.getAvdName(), (CharSequence)this.myAvdName) || !WaitForEmulatorTask.isEmulatorReady(device)) continue;
                    LaunchUtils.initiateDismissKeyguard(device);
                    this.myDeviceFuture.set((Object)device);
                    return;
                }
                Uninterruptibles.sleepUninterruptibly((long)1L, (TimeUnit)POLL_TIMEUNIT);
            }
            String msg = "Timed out after " + POLL_TIMEUNIT.toSeconds(this.myTimeout) + "seconds waiting for emulator to come online.";
            this.myDeviceFuture.setException((Throwable)new TimeoutException(msg));
            Logger.getInstance(EmulatorConnectionListener.class).warn(msg);
        }

        private static boolean isEmulatorReady(@NotNull IDevice device) {
            if (device == null) {
                WaitForEmulatorTask.$$$reportNull$$$0(5);
            }
            if (!device.isOnline()) {
                return false;
            }
            String bootComplete = device.getProperty("dev.bootcomplete");
            if (bootComplete == null) {
                Logger.getInstance(EmulatorConnectionListener.class).warn("Emulator not ready yet, dev.bootcomplete = null");
                return false;
            }
            if (!AndroidEnableAdbServiceAction.isAdbServiceEnabled()) {
                Logger.getInstance(EmulatorConnectionListener.class).warn("ADB Integration is turned off, we cannot check the number of clients.");
                return true;
            }
            return device.getClients().length > 5 || device.getClient("android.process.acore") != null || device.getClient("com.google.android.wearable.app") != null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "device";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "avdName";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "emulatorProcessHandler";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "units";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/run/EmulatorConnectionListener$WaitForEmulatorTask";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isEmulatorReady";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

