/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.editor;

import com.android.tools.idea.run.editor.AndroidDebugger;
import com.android.tools.idea.run.editor.AndroidDebuggerState;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.Lists;
import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.WriteExternalException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidDebuggerContext
implements JDOMExternalizable {
    public String DEBUGGER_TYPE;
    private final Map<String, AndroidDebuggerState> myAndroidDebuggerStates;
    private final String myDefaultDebuggerType;

    public AndroidDebuggerContext(@NotNull String defaultDebuggerType) {
        if (defaultDebuggerType == null) {
            AndroidDebuggerContext.$$$reportNull$$$0(0);
        }
        this.myDefaultDebuggerType = defaultDebuggerType;
        this.DEBUGGER_TYPE = this.getDefaultAndroidDebuggerType();
        ImmutableSortedMap.Builder builder = ImmutableSortedMap.naturalOrder();
        for (AndroidDebugger androidDebugger : this.getAndroidDebuggers()) {
            builder.put((Object)androidDebugger.getId(), androidDebugger.createState());
        }
        this.myAndroidDebuggerStates = builder.build();
    }

    public void readExternal(Element element) throws InvalidDataException {
        DefaultJDOMExternalizer.readExternal((Object)this, (Element)element);
        for (Map.Entry<String, AndroidDebuggerState> entry : this.myAndroidDebuggerStates.entrySet()) {
            Element optionElement = element.getChild(entry.getKey());
            if (optionElement == null) continue;
            entry.getValue().readExternal(optionElement);
        }
        if (this.getAndroidDebugger() == null) {
            this.DEBUGGER_TYPE = this.getDefaultAndroidDebuggerType();
        }
    }

    public void writeExternal(Element element) throws WriteExternalException {
        DefaultJDOMExternalizer.writeExternal((Object)this, (Element)element);
        for (Map.Entry<String, AndroidDebuggerState> entry : this.myAndroidDebuggerStates.entrySet()) {
            Element optionElement = new Element(entry.getKey());
            element.addContent(optionElement);
            entry.getValue().writeExternal(optionElement);
        }
    }

    @NotNull
    public String getDebuggerType() {
        String string = this.DEBUGGER_TYPE;
        if (string == null) {
            AndroidDebuggerContext.$$$reportNull$$$0(1);
        }
        return string;
    }

    public void setDebuggerType(@NotNull String debuggerType) {
        if (debuggerType == null) {
            AndroidDebuggerContext.$$$reportNull$$$0(2);
        }
        this.DEBUGGER_TYPE = debuggerType;
    }

    @NotNull
    public List<AndroidDebugger> getAndroidDebuggers() {
        ArrayList arrayList = Lists.newArrayList((Object[])AndroidDebugger.EP_NAME.getExtensions());
        if (arrayList == null) {
            AndroidDebuggerContext.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    @Nullable
    public AndroidDebugger getAndroidDebugger() {
        for (AndroidDebugger androidDebugger : this.getAndroidDebuggers()) {
            if (!androidDebugger.getId().equals(this.DEBUGGER_TYPE)) continue;
            return androidDebugger;
        }
        return null;
    }

    @Nullable
    public <T extends AndroidDebuggerState> T getAndroidDebuggerState(@NotNull String androidDebuggerId) {
        AndroidDebuggerState state;
        if (androidDebuggerId == null) {
            AndroidDebuggerContext.$$$reportNull$$$0(4);
        }
        return (T)((state = this.myAndroidDebuggerStates.get(androidDebuggerId)) != null ? state : null);
    }

    @Nullable
    public <T extends AndroidDebuggerState> T getAndroidDebuggerState() {
        return this.getAndroidDebuggerState(this.DEBUGGER_TYPE);
    }

    @NotNull
    protected String getDefaultAndroidDebuggerType() {
        for (AndroidDebugger androidDebugger : this.getAndroidDebuggers()) {
            if (!androidDebugger.shouldBeDefault()) continue;
            String string = androidDebugger.getId();
            if (string == null) {
                AndroidDebuggerContext.$$$reportNull$$$0(5);
            }
            return string;
        }
        String string = this.myDefaultDebuggerType;
        if (string == null) {
            AndroidDebuggerContext.$$$reportNull$$$0(6);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultDebuggerType";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/run/editor/AndroidDebuggerContext";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debuggerType";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "androidDebuggerId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/run/editor/AndroidDebuggerContext";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDebuggerType";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getAndroidDebuggers";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultAndroidDebuggerType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setDebuggerType";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getAndroidDebuggerState";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

