/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.testartifacts.instrumented;

import com.android.builder.model.AndroidArtifact;
import com.android.builder.model.Variant;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.IShellEnabledDevice;
import com.android.ddmlib.testrunner.ITestRunListener;
import com.android.ddmlib.testrunner.RemoteAndroidTestRunner;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.run.AndroidRunConfigurationBase;
import com.android.tools.idea.run.ApkProvider;
import com.android.tools.idea.run.ApkProvisionException;
import com.android.tools.idea.run.ApplicationIdProvider;
import com.android.tools.idea.run.ConsolePrinter;
import com.android.tools.idea.run.ConsoleProvider;
import com.android.tools.idea.run.GradleApkProvider;
import com.android.tools.idea.run.NonGradleApkProvider;
import com.android.tools.idea.run.ValidationError;
import com.android.tools.idea.run.editor.AndroidRunConfigurationEditor;
import com.android.tools.idea.run.editor.TestRunParameters;
import com.android.tools.idea.run.tasks.LaunchTask;
import com.android.tools.idea.run.util.LaunchStatus;
import com.android.tools.idea.testartifacts.instrumented.AndroidTestConsoleProperties;
import com.android.tools.idea.testartifacts.instrumented.AndroidTestListener;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.JavaExecutionUtil;
import com.intellij.execution.ProgramRunnerUtil;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.configurations.RefactoringListenerProvider;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.junit.JUnitUtil;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.testframework.TestConsoleProperties;
import com.intellij.execution.testframework.sm.SMTestRunnerConnectionUtil;
import com.intellij.execution.testframework.ui.BaseTestsOutputConsoleView;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiPackage;
import com.intellij.refactoring.listeners.RefactoringElementAdapter;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.android.dom.manifest.Instrumentation;
import org.jetbrains.android.dom.manifest.Manifest;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetConfiguration;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidTestRunConfiguration
extends AndroidRunConfigurationBase
implements RefactoringListenerProvider {
    private static final Logger LOG = Logger.getInstance(AndroidTestRunConfiguration.class);
    public static final int TEST_ALL_IN_MODULE = 0;
    public static final int TEST_ALL_IN_PACKAGE = 1;
    public static final int TEST_CLASS = 2;
    public static final int TEST_METHOD = 3;
    public int TESTING_TYPE = 0;
    public String INSTRUMENTATION_RUNNER_CLASS = "";
    public String METHOD_NAME = "";
    public String CLASS_NAME = "";
    public String PACKAGE_NAME = "";
    public String EXTRA_OPTIONS = "";

    public AndroidTestRunConfiguration(Project project, ConfigurationFactory factory) {
        super(project, factory, true);
    }

    @Override
    protected Pair<Boolean, String> supportsRunningLibraryProjects(@NotNull AndroidFacet facet) {
        if (facet == null) {
            AndroidTestRunConfiguration.$$$reportNull$$$0(0);
        }
        if (!facet.requiresAndroidModel()) {
            return Pair.create((Object)Boolean.FALSE, (Object)AndroidBundle.message("android.cannot.run.library.project.error", new Object[0]));
        }
        AndroidModuleModel androidModel = AndroidModuleModel.get(facet);
        if (androidModel == null) {
            return Pair.create((Object)Boolean.FALSE, (Object)AndroidBundle.message("android.cannot.run.library.project.error", new Object[0]));
        }
        AndroidArtifact testArtifact = androidModel.getAndroidTestArtifactInSelectedVariant();
        String testTask = testArtifact != null ? testArtifact.getAssembleTaskName() : null;
        return new Pair((Object)(testTask != null ? 1 : 0), (Object)AndroidBundle.message("android.cannot.run.library.project.in.this.buildtype", new Object[0]));
    }

    public boolean isGeneratedName() {
        String name = this.getName();
        if (!(this.TESTING_TYPE != 2 && this.TESTING_TYPE != 3 || this.CLASS_NAME != null && this.CLASS_NAME.length() != 0)) {
            return JavaExecutionUtil.isNewName((String)name);
        }
        if (this.TESTING_TYPE == 3 && (this.METHOD_NAME == null || this.METHOD_NAME.length() == 0)) {
            return JavaExecutionUtil.isNewName((String)name);
        }
        return Comparing.equal((String)name, (String)this.suggestedName());
    }

    public String suggestedName() {
        if (this.TESTING_TYPE == 1) {
            return ExecutionBundle.message((String)"test.in.scope.presentable.text", (Object[])new Object[]{this.PACKAGE_NAME});
        }
        if (this.TESTING_TYPE == 2) {
            return ProgramRunnerUtil.shortenName((String)JavaExecutionUtil.getShortClassName((String)this.CLASS_NAME), (int)0);
        }
        if (this.TESTING_TYPE == 3) {
            return ProgramRunnerUtil.shortenName((String)this.METHOD_NAME, (int)2) + "()";
        }
        return ExecutionBundle.message((String)"all.tests.scope.presentable.text", (Object[])new Object[0]);
    }

    @Override
    @NotNull
    public List<ValidationError> checkConfiguration(@NotNull AndroidFacet facet) {
        int count;
        if (facet == null) {
            AndroidTestRunConfiguration.$$$reportNull$$$0(1);
        }
        ArrayList errors = Lists.newArrayList();
        Module module = facet.getModule();
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)module.getProject());
        switch (this.TESTING_TYPE) {
            case 1: {
                PsiPackage testPackage = facade.findPackage(this.PACKAGE_NAME);
                if (testPackage != null) break;
                errors.add(ValidationError.warning(ExecutionBundle.message((String)"package.does.not.exist.error.message", (Object[])new Object[]{this.PACKAGE_NAME})));
                break;
            }
            case 2: {
                PsiClass testClass = null;
                try {
                    testClass = ((JavaRunConfigurationModule)this.getConfigurationModule()).checkModuleAndClassName(this.CLASS_NAME, ExecutionBundle.message((String)"no.test.class.specified.error.text", (Object[])new Object[0]));
                }
                catch (RuntimeConfigurationException e) {
                    errors.add(ValidationError.fromException(e));
                }
                if (testClass == null || JUnitUtil.isTestClass((PsiClass)testClass)) break;
                errors.add(ValidationError.warning(ExecutionBundle.message((String)"class.isnt.test.class.error.message", (Object[])new Object[]{this.CLASS_NAME})));
                break;
            }
            case 3: {
                errors.addAll(this.checkTestMethod());
            }
        }
        if (this.INSTRUMENTATION_RUNNER_CLASS.length() > 0 && facade.findClass(this.INSTRUMENTATION_RUNNER_CLASS, module.getModuleWithDependenciesAndLibrariesScope(true)) == null) {
            errors.add(ValidationError.fatal(AndroidBundle.message("instrumentation.runner.class.not.specified.error", new Object[0])));
        }
        final AndroidFacetConfiguration configuration = (AndroidFacetConfiguration)facet.getConfiguration();
        if (!facet.requiresAndroidModel() && !configuration.getState().PACK_TEST_CODE && (count = AndroidTestRunConfiguration.getTestSourceRootCount(module)) > 0) {
            String shortMessage = "Test code not included into APK";
            final String fixMessage = "Code and resources under test source " + (count > 1 ? "roots" : "root") + " aren't included into debug APK.\nWould you like to include them and recompile " + module.getName() + " module?\n(You may change this option in Android facet settings later)";
            Runnable quickFix = new Runnable(){

                @Override
                public void run() {
                    int result = Messages.showYesNoCancelDialog((Project)AndroidTestRunConfiguration.this.getProject(), (String)fixMessage, (String)"Test code not included into APK", (Icon)Messages.getQuestionIcon());
                    if (result == 0) {
                        configuration.getState().PACK_TEST_CODE = true;
                    }
                }
            };
            errors.add(ValidationError.fatal("Test code not included into APK", quickFix));
        }
        ArrayList arrayList = errors;
        if (arrayList == null) {
            AndroidTestRunConfiguration.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    @Override
    @NotNull
    protected ApkProvider getApkProvider(@NotNull AndroidFacet facet, @NotNull ApplicationIdProvider applicationIdProvider) {
        if (facet == null) {
            AndroidTestRunConfiguration.$$$reportNull$$$0(3);
        }
        if (applicationIdProvider == null) {
            AndroidTestRunConfiguration.$$$reportNull$$$0(4);
        }
        if (facet.getAndroidModel() != null && facet.getAndroidModel() instanceof AndroidModuleModel) {
            GradleApkProvider gradleApkProvider = new GradleApkProvider(facet, applicationIdProvider, true);
            if (gradleApkProvider == null) {
                AndroidTestRunConfiguration.$$$reportNull$$$0(5);
            }
            return gradleApkProvider;
        }
        NonGradleApkProvider nonGradleApkProvider = new NonGradleApkProvider(facet, applicationIdProvider, null);
        if (nonGradleApkProvider == null) {
            AndroidTestRunConfiguration.$$$reportNull$$$0(6);
        }
        return nonGradleApkProvider;
    }

    private static int getTestSourceRootCount(@NotNull Module module) {
        if (module == null) {
            AndroidTestRunConfiguration.$$$reportNull$$$0(7);
        }
        ModuleRootManager manager = ModuleRootManager.getInstance((Module)module);
        return manager.getSourceRoots(true).length - manager.getSourceRoots(false).length;
    }

    private List<ValidationError> checkTestMethod() {
        PsiClass testClass;
        JavaRunConfigurationModule configurationModule = (JavaRunConfigurationModule)this.getConfigurationModule();
        try {
            testClass = configurationModule.checkModuleAndClassName(this.CLASS_NAME, ExecutionBundle.message((String)"no.test.class.specified.error.text", (Object[])new Object[0]));
        }
        catch (RuntimeConfigurationException e) {
            return ImmutableList.of((Object)ValidationError.fromException(e));
        }
        ArrayList errors = Lists.newArrayList();
        if (!JUnitUtil.isTestClass((PsiClass)testClass)) {
            errors.add(ValidationError.warning(ExecutionBundle.message((String)"class.isnt.test.class.error.message", (Object[])new Object[]{this.CLASS_NAME})));
        }
        if (this.METHOD_NAME == null || this.METHOD_NAME.trim().length() == 0) {
            errors.add(ValidationError.fatal(ExecutionBundle.message((String)"method.name.not.specified.error.message", (Object[])new Object[0])));
        }
        JUnitUtil.TestMethodFilter filter = new JUnitUtil.TestMethodFilter(testClass);
        boolean found = false;
        boolean testAnnotated = false;
        for (PsiMethod method : testClass.findMethodsByName(this.METHOD_NAME, true)) {
            if (filter.value(method)) {
                found = true;
            }
            if (!JUnitUtil.isTestAnnotated((PsiMethod)method)) continue;
            testAnnotated = true;
        }
        if (!found) {
            errors.add(ValidationError.warning(ExecutionBundle.message((String)"test.method.doesnt.exist.error.message", (Object[])new Object[]{this.METHOD_NAME})));
        }
        if (!AnnotationUtil.isAnnotated((PsiModifierListOwner)testClass, (String)"org.junit.runner.RunWith", (boolean)true) && !testAnnotated) {
            try {
                PsiClass testCaseClass = JUnitUtil.getTestCaseClass((Module)configurationModule.getModule());
                if (!testClass.isInheritor(testCaseClass, true)) {
                    errors.add(ValidationError.fatal(ExecutionBundle.message((String)"class.isnt.inheritor.of.testcase.error.message", (Object[])new Object[]{this.CLASS_NAME})));
                }
            }
            catch (JUnitUtil.NoJUnitException e) {
                errors.add(ValidationError.warning(ExecutionBundle.message((String)AndroidBundle.message("cannot.find.testcase.error", new Object[0]), (Object[])new Object[0])));
            }
        }
        return errors;
    }

    @NotNull
    public SettingsEditor<? extends RunConfiguration> getConfigurationEditor() {
        Project project = this.getProject();
        AndroidRunConfigurationEditor<AndroidTestRunConfiguration> editor = new AndroidRunConfigurationEditor<AndroidTestRunConfiguration>(project, new Predicate<AndroidFacet>(){

            public boolean apply(@Nullable AndroidFacet facet) {
                return facet != null && (Boolean)AndroidTestRunConfiguration.this.supportsRunningLibraryProjects(facet).getFirst() != false;
            }
        }, this);
        editor.setConfigurationSpecificEditor(new TestRunParameters(project, editor.getModuleSelector()));
        AndroidRunConfigurationEditor<AndroidTestRunConfiguration> androidRunConfigurationEditor = editor;
        if (androidRunConfigurationEditor == null) {
            AndroidTestRunConfiguration.$$$reportNull$$$0(8);
        }
        return androidRunConfigurationEditor;
    }

    @Override
    @NotNull
    protected ConsoleProvider getConsoleProvider() {
        ConsoleProvider consoleProvider = new ConsoleProvider(){

            @Override
            @NotNull
            public ConsoleView createAndAttach(@NotNull Disposable parent, @NotNull ProcessHandler handler, @NotNull Executor executor) throws ExecutionException {
                if (parent == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (handler == null) {
                    3.$$$reportNull$$$0(1);
                }
                if (executor == null) {
                    3.$$$reportNull$$$0(2);
                }
                AndroidTestConsoleProperties properties = new AndroidTestConsoleProperties((RunConfiguration)AndroidTestRunConfiguration.this, executor);
                BaseTestsOutputConsoleView consoleView = SMTestRunnerConnectionUtil.createAndAttachConsole((String)"Android", (ProcessHandler)handler, (TestConsoleProperties)properties);
                Disposer.register((Disposable)parent, (Disposable)consoleView);
                BaseTestsOutputConsoleView baseTestsOutputConsoleView = consoleView;
                if (baseTestsOutputConsoleView == null) {
                    3.$$$reportNull$$$0(3);
                }
                return baseTestsOutputConsoleView;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 3: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 3: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "parent";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "handler";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "executor";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/android/tools/idea/testartifacts/instrumented/AndroidTestRunConfiguration$3";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/android/tools/idea/testartifacts/instrumented/AndroidTestRunConfiguration$3";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "createAndAttach";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "createAndAttach";
                        break;
                    }
                    case 3: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 3: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        if (consoleProvider == null) {
            AndroidTestRunConfiguration.$$$reportNull$$$0(9);
        }
        return consoleProvider;
    }

    @Override
    protected boolean supportMultipleDevices() {
        return false;
    }

    @Override
    public boolean monitorRemoteProcess() {
        return false;
    }

    @Override
    @Nullable
    protected LaunchTask getApplicationLaunchTask(@NotNull ApplicationIdProvider applicationIdProvider, @NotNull AndroidFacet facet, boolean waitForDebugger, @NotNull LaunchStatus launchStatus) {
        String testPackage;
        if (applicationIdProvider == null) {
            AndroidTestRunConfiguration.$$$reportNull$$$0(10);
        }
        if (facet == null) {
            AndroidTestRunConfiguration.$$$reportNull$$$0(11);
        }
        if (launchStatus == null) {
            AndroidTestRunConfiguration.$$$reportNull$$$0(12);
        }
        String runner = StringUtil.isEmpty((String)this.INSTRUMENTATION_RUNNER_CLASS) ? AndroidTestRunConfiguration.findInstrumentationRunner(facet) : this.INSTRUMENTATION_RUNNER_CLASS;
        Map<String, String> runnerArguments = AndroidTestRunConfiguration.getRunnerArguments(facet);
        try {
            testPackage = applicationIdProvider.getTestPackageName();
            if (testPackage == null) {
                launchStatus.terminateLaunch("Unable to determine test package name");
                return null;
            }
        }
        catch (ApkProvisionException e) {
            launchStatus.terminateLaunch("Unable to determine test package name");
            return null;
        }
        return new MyApplicationLaunchTask(runner, testPackage, waitForDebugger, runnerArguments);
    }

    @Nullable
    public static String findInstrumentationRunner(@NotNull AndroidFacet facet) {
        Variant selectedVariant;
        String testRunner;
        if (facet == null) {
            AndroidTestRunConfiguration.$$$reportNull$$$0(13);
        }
        String runner = AndroidTestRunConfiguration.getRunnerFromManifest(facet);
        AndroidModuleModel androidModel = AndroidModuleModel.get(facet);
        if (runner == null && androidModel != null && (testRunner = (selectedVariant = androidModel.getSelectedVariant()).getMergedFlavor().getTestInstrumentationRunner()) != null) {
            runner = testRunner;
        }
        return runner;
    }

    @NotNull
    public static Map<String, String> getRunnerArguments(@NotNull AndroidFacet facet) {
        AndroidModuleModel androidModel;
        if (facet == null) {
            AndroidTestRunConfiguration.$$$reportNull$$$0(14);
        }
        if ((androidModel = AndroidModuleModel.get(facet)) != null) {
            HashMap<String, String> hashMap = new HashMap<String, String>(androidModel.getSelectedVariant().getMergedFlavor().getTestInstrumentationRunnerArguments());
            if (hashMap == null) {
                AndroidTestRunConfiguration.$$$reportNull$$$0(15);
            }
            return hashMap;
        }
        Map<String, String> map = Collections.emptyMap();
        if (map == null) {
            AndroidTestRunConfiguration.$$$reportNull$$$0(16);
        }
        return map;
    }

    @Nullable
    private static String getRunnerFromManifest(final @NotNull AndroidFacet facet) {
        if (facet == null) {
            AndroidTestRunConfiguration.$$$reportNull$$$0(17);
        }
        if (!ApplicationManager.getApplication().isReadAccessAllowed()) {
            return (String)ApplicationManager.getApplication().runReadAction((Computable)new Computable<String>(){

                public String compute() {
                    return AndroidTestRunConfiguration.getRunnerFromManifest(facet);
                }
            });
        }
        Manifest manifest = facet.getManifest();
        if (manifest != null) {
            for (Instrumentation instrumentation : manifest.getInstrumentations()) {
                PsiClass instrumentationClass;
                if (instrumentation == null || (instrumentationClass = (PsiClass)instrumentation.getInstrumentationClass().getValue()) == null) continue;
                return instrumentationClass.getQualifiedName();
            }
        }
        return null;
    }

    @Nullable
    public RefactoringElementListener getRefactoringElementListener(PsiElement element) {
        if (element instanceof PsiPackage) {
            String pkgName = ((PsiPackage)element).getQualifiedName();
            if (this.TESTING_TYPE == 1 && !StringUtil.equals((CharSequence)pkgName, (CharSequence)this.PACKAGE_NAME)) {
                return null;
            }
            if (this.TESTING_TYPE != 1 && !StringUtil.equals((CharSequence)pkgName, (CharSequence)StringUtil.getPackageName((String)this.CLASS_NAME))) {
                return null;
            }
            return new RefactoringElementAdapter(){

                protected void elementRenamedOrMoved(@NotNull PsiElement newElement) {
                    if (newElement == null) {
                        5.$$$reportNull$$$0(0);
                    }
                    if (newElement instanceof PsiPackage) {
                        String newPkgName = ((PsiPackage)newElement).getQualifiedName();
                        if (AndroidTestRunConfiguration.this.TESTING_TYPE == 1) {
                            AndroidTestRunConfiguration.this.PACKAGE_NAME = newPkgName;
                        } else {
                            AndroidTestRunConfiguration.this.CLASS_NAME = AndroidTestRunConfiguration.this.CLASS_NAME.replace(StringUtil.getPackageName((String)AndroidTestRunConfiguration.this.CLASS_NAME), newPkgName);
                        }
                    }
                }

                public void undoElementMovedOrRenamed(@NotNull PsiElement newElement, @NotNull String oldQualifiedName) {
                    if (newElement == null) {
                        5.$$$reportNull$$$0(1);
                    }
                    if (oldQualifiedName == null) {
                        5.$$$reportNull$$$0(2);
                    }
                    if (newElement instanceof PsiPackage) {
                        if (AndroidTestRunConfiguration.this.TESTING_TYPE == 1) {
                            AndroidTestRunConfiguration.this.PACKAGE_NAME = oldQualifiedName;
                        } else {
                            AndroidTestRunConfiguration.this.CLASS_NAME = AndroidTestRunConfiguration.this.CLASS_NAME.replace(StringUtil.getPackageName((String)AndroidTestRunConfiguration.this.CLASS_NAME), oldQualifiedName);
                        }
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "newElement";
                            break;
                        }
                        case 2: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "oldQualifiedName";
                            break;
                        }
                    }
                    objectArray2[1] = "com/android/tools/idea/testartifacts/instrumented/AndroidTestRunConfiguration$5";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "elementRenamedOrMoved";
                            break;
                        }
                        case 1: 
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[2] = "undoElementMovedOrRenamed";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            };
        }
        if ((this.TESTING_TYPE == 2 || this.TESTING_TYPE == 3) && element instanceof PsiClass) {
            if (!StringUtil.equals((CharSequence)JavaExecutionUtil.getRuntimeQualifiedName((PsiClass)((PsiClass)element)), (CharSequence)this.CLASS_NAME)) {
                return null;
            }
            return new RefactoringElementAdapter(){

                protected void elementRenamedOrMoved(@NotNull PsiElement newElement) {
                    if (newElement == null) {
                        6.$$$reportNull$$$0(0);
                    }
                    if (newElement instanceof PsiClass) {
                        AndroidTestRunConfiguration.this.CLASS_NAME = JavaExecutionUtil.getRuntimeQualifiedName((PsiClass)((PsiClass)newElement));
                    }
                }

                public void undoElementMovedOrRenamed(@NotNull PsiElement newElement, @NotNull String oldQualifiedName) {
                    if (newElement == null) {
                        6.$$$reportNull$$$0(1);
                    }
                    if (oldQualifiedName == null) {
                        6.$$$reportNull$$$0(2);
                    }
                    if (newElement instanceof PsiClass) {
                        AndroidTestRunConfiguration.this.CLASS_NAME = oldQualifiedName;
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "newElement";
                            break;
                        }
                        case 2: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "oldQualifiedName";
                            break;
                        }
                    }
                    objectArray2[1] = "com/android/tools/idea/testartifacts/instrumented/AndroidTestRunConfiguration$6";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "elementRenamedOrMoved";
                            break;
                        }
                        case 1: 
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[2] = "undoElementMovedOrRenamed";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            };
        }
        if (this.TESTING_TYPE == 3 && element instanceof PsiMethod) {
            PsiMethod psiMethod = (PsiMethod)element;
            if (!StringUtil.equals((CharSequence)psiMethod.getName(), (CharSequence)this.METHOD_NAME)) {
                return null;
            }
            PsiClass psiClass = psiMethod.getContainingClass();
            if (psiClass == null) {
                return null;
            }
            String fqName = psiClass.getQualifiedName();
            if (fqName != null && !StringUtil.equals((CharSequence)fqName, (CharSequence)this.CLASS_NAME)) {
                return null;
            }
            return new RefactoringElementAdapter(){

                protected void elementRenamedOrMoved(@NotNull PsiElement newElement) {
                    if (newElement == null) {
                        7.$$$reportNull$$$0(0);
                    }
                    if (newElement instanceof PsiMethod) {
                        AndroidTestRunConfiguration.this.METHOD_NAME = ((PsiMethod)newElement).getName();
                    }
                }

                public void undoElementMovedOrRenamed(@NotNull PsiElement newElement, @NotNull String oldQualifiedName) {
                    if (newElement == null) {
                        7.$$$reportNull$$$0(1);
                    }
                    if (oldQualifiedName == null) {
                        7.$$$reportNull$$$0(2);
                    }
                    if (newElement instanceof PsiMethod) {
                        AndroidTestRunConfiguration.this.METHOD_NAME = oldQualifiedName;
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "newElement";
                            break;
                        }
                        case 2: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "oldQualifiedName";
                            break;
                        }
                    }
                    objectArray2[1] = "com/android/tools/idea/testartifacts/instrumented/AndroidTestRunConfiguration$7";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "elementRenamedOrMoved";
                            break;
                        }
                        case 1: 
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[2] = "undoElementMovedOrRenamed";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            };
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 15: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 15: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/testartifacts/instrumented/AndroidTestRunConfiguration";
                break;
            }
            case 4: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "applicationIdProvider";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "launchStatus";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/testartifacts/instrumented/AndroidTestRunConfiguration";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "checkConfiguration";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getApkProvider";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurationEditor";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getConsoleProvider";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getRunnerArguments";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "supportsRunningLibraryProjects";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "checkConfiguration";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 15: 
            case 16: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getApkProvider";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getTestSourceRootCount";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getApplicationLaunchTask";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "findInstrumentationRunner";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getRunnerArguments";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getRunnerFromManifest";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 15: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyApplicationLaunchTask
    implements LaunchTask {
        @Nullable
        private final String myInstrumentationTestRunner;
        @NotNull
        private final String myTestApplicationId;
        private final boolean myWaitForDebugger;
        @NotNull
        private final Map<String, String> myInstrumentationTestRunnerArguments;

        public MyApplicationLaunchTask(@NotNull String runner, String testPackage, @NotNull boolean waitForDebugger, Map<String, String> arguments) {
            if (testPackage == null) {
                MyApplicationLaunchTask.$$$reportNull$$$0(0);
            }
            if (arguments == null) {
                MyApplicationLaunchTask.$$$reportNull$$$0(1);
            }
            this.myInstrumentationTestRunner = runner;
            this.myWaitForDebugger = waitForDebugger;
            this.myTestApplicationId = testPackage;
            this.myInstrumentationTestRunnerArguments = arguments;
        }

        @Override
        @NotNull
        public String getDescription() {
            if ("Launching instrumentation runner" == null) {
                MyApplicationLaunchTask.$$$reportNull$$$0(2);
            }
            return "Launching instrumentation runner";
        }

        @Override
        public int getDuration() {
            return 2;
        }

        @Override
        public boolean perform(@NotNull IDevice device, final @NotNull LaunchStatus launchStatus, final @NotNull ConsolePrinter printer) {
            if (device == null) {
                MyApplicationLaunchTask.$$$reportNull$$$0(3);
            }
            if (launchStatus == null) {
                MyApplicationLaunchTask.$$$reportNull$$$0(4);
            }
            if (printer == null) {
                MyApplicationLaunchTask.$$$reportNull$$$0(5);
            }
            printer.stdout("Running tests\n");
            final RemoteAndroidTestRunner runner = new RemoteAndroidTestRunner(this.myTestApplicationId, this.myInstrumentationTestRunner, (IShellEnabledDevice)device);
            switch (AndroidTestRunConfiguration.this.TESTING_TYPE) {
                case 1: {
                    runner.setTestPackageName(AndroidTestRunConfiguration.this.PACKAGE_NAME);
                    break;
                }
                case 2: {
                    runner.setClassName(AndroidTestRunConfiguration.this.CLASS_NAME);
                    break;
                }
                case 3: {
                    runner.setMethodName(AndroidTestRunConfiguration.this.CLASS_NAME, AndroidTestRunConfiguration.this.METHOD_NAME);
                }
            }
            runner.setDebug(this.myWaitForDebugger);
            runner.setRunOptions(AndroidTestRunConfiguration.this.EXTRA_OPTIONS);
            for (Map.Entry<String, String> entry : this.myInstrumentationTestRunnerArguments.entrySet()) {
                runner.addInstrumentationArg(entry.getKey(), entry.getValue());
            }
            printer.stdout("$ adb shell " + runner.getAmInstrumentCommand());
            ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

                @Override
                public void run() {
                    try {
                        runner.run(new ITestRunListener[]{new AndroidTestListener(launchStatus, printer)});
                    }
                    catch (Exception e) {
                        LOG.info((Throwable)e);
                        printer.stderr("Error: Unexpected exception while running tests: " + e);
                    }
                }
            });
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "testPackage";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "arguments";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/testartifacts/instrumented/AndroidTestRunConfiguration$MyApplicationLaunchTask";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "device";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "launchStatus";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "printer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/testartifacts/instrumented/AndroidTestRunConfiguration$MyApplicationLaunchTask";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDescription";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "perform";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

