/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.editor;

import com.android.tools.idea.uibuilder.analytics.NlUsageTrackerManager;
import com.android.tools.idea.uibuilder.editor.NlEditorPanel;
import com.android.tools.idea.uibuilder.editor.NlPreviewForm;
import com.android.tools.idea.uibuilder.model.NlLayoutType;
import com.android.tools.idea.uibuilder.surface.DesignSurface;
import com.google.wireless.android.sdk.stats.LayoutEditorEvent;
import com.intellij.designer.DesignerEditorPanelFacade;
import com.intellij.designer.LightToolWindow;
import com.intellij.designer.LightToolWindowManager;
import com.intellij.designer.ToggleEditorModeAction;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ToolWindowType;
import com.intellij.openapi.wm.ex.ToolWindowEx;
import com.intellij.openapi.wm.ex.ToolWindowManagerAdapter;
import com.intellij.openapi.wm.ex.ToolWindowManagerEx;
import com.intellij.openapi.wm.ex.ToolWindowManagerListener;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class NlAbstractWindowManager
extends LightToolWindowManager {
    private ToolWindowType myPreviousWindowType;
    private ToolWindowAnchor myPreviousWindowAnchor;
    private DesignSurface myDesignSurface;

    public NlAbstractWindowManager(@NotNull Project project, @NotNull FileEditorManager fileEditorManager) {
        if (project == null) {
            NlAbstractWindowManager.$$$reportNull$$$0(0);
        }
        if (fileEditorManager == null) {
            NlAbstractWindowManager.$$$reportNull$$$0(1);
        }
        super(project, fileEditorManager);
    }

    protected void initToolWindow(final @NotNull String id, @NotNull Icon icon) {
        if (id == null) {
            NlAbstractWindowManager.$$$reportNull$$$0(2);
        }
        if (icon == null) {
            NlAbstractWindowManager.$$$reportNull$$$0(3);
        }
        this.myToolWindow = ToolWindowManager.getInstance((Project)this.myProject).registerToolWindow(id, false, this.getAnchor(), (Disposable)this.myProject, true);
        this.myToolWindow.setIcon(icon);
        this.myToolWindow.setAvailable(false, null);
        this.myToolWindow.setAutoHide(false);
        this.myPreviousWindowType = this.myToolWindow.getType();
        this.myPreviousWindowAnchor = this.getEditorMode();
        ((ToolWindowManagerEx)ToolWindowManager.getInstance((Project)this.myProject)).addToolWindowManagerListener((ToolWindowManagerListener)new ToolWindowManagerAdapter(){

            public void stateChanged() {
                if (NlAbstractWindowManager.this.myProject.isDisposed()) {
                    return;
                }
                ToolWindow window = ToolWindowManager.getInstance((Project)NlAbstractWindowManager.this.myProject).getToolWindow(id);
                ToolWindowType newWindowType = window.getType();
                ToolWindowAnchor newWindowAnchor = NlAbstractWindowManager.this.getEditorMode();
                if (newWindowType != NlAbstractWindowManager.this.myPreviousWindowType || newWindowAnchor != NlAbstractWindowManager.this.myPreviousWindowAnchor) {
                    NlUsageTrackerManager.getInstance(NlAbstractWindowManager.this.myDesignSurface).logAction(LayoutEditorEvent.LayoutEditorEventType.UNKNOWN_EVENT_TYPE);
                    NlAbstractWindowManager.this.myPreviousWindowType = newWindowType;
                    NlAbstractWindowManager.this.myPreviousWindowAnchor = newWindowAnchor;
                }
            }
        }, (Disposable)this.myProject);
        this.initGearActions();
    }

    protected void updateToolWindow(@Nullable DesignerEditorPanelFacade designer) {
        this.myDesignSurface = NlAbstractWindowManager.getDesignSurface(designer);
    }

    @Nullable
    protected DesignerEditorPanelFacade getDesigner(@Nullable FileEditor editor) {
        return null;
    }

    protected ToggleEditorModeAction createToggleAction(@NotNull ToolWindowAnchor anchor) {
        if (anchor == null) {
            NlAbstractWindowManager.$$$reportNull$$$0(4);
        }
        return new ToggleEditorModeAction(this, this.myProject, anchor){

            protected LightToolWindowManager getOppositeManager() {
                return null;
            }
        };
    }

    @Nullable
    protected static DesignSurface getDesignSurface(@NotNull DesignerEditorPanelFacade designer) {
        if (designer == null) {
            NlAbstractWindowManager.$$$reportNull$$$0(5);
        }
        if (designer instanceof NlEditorPanel) {
            NlEditorPanel editor = (NlEditorPanel)designer;
            return editor.getSurface();
        }
        if (designer instanceof NlPreviewForm) {
            NlPreviewForm form = (NlPreviewForm)designer;
            return form.getFile() != null ? form.getSurface() : null;
        }
        throw new RuntimeException(designer.getClass().getName());
    }

    @NotNull
    protected static NlLayoutType getLayoutType(@NotNull DesignerEditorPanelFacade designer) {
        DesignSurface designSurface;
        if (designer == null) {
            NlAbstractWindowManager.$$$reportNull$$$0(6);
        }
        NlLayoutType nlLayoutType = (designSurface = NlAbstractWindowManager.getDesignSurface(designer)) != null ? designSurface.getLayoutType() : NlLayoutType.UNKNOWN;
        if (nlLayoutType == null) {
            NlAbstractWindowManager.$$$reportNull$$$0(7);
        }
        return nlLayoutType;
    }

    protected void createWindowContent(@NotNull JComponent contentPane, @NotNull JComponent focusedComponent, @Nullable AnAction[] actions) {
        if (contentPane == null) {
            NlAbstractWindowManager.$$$reportNull$$$0(8);
        }
        if (focusedComponent == null) {
            NlAbstractWindowManager.$$$reportNull$$$0(9);
        }
        ContentManager contentManager = this.myToolWindow.getContentManager();
        Content content = contentManager.getFactory().createContent(contentPane, null, false);
        content.setCloseable(false);
        content.setPreferredFocusableComponent(focusedComponent);
        if (actions != null) {
            ToolWindowEx toolWindow = (ToolWindowEx)this.myToolWindow;
            toolWindow.setTitleActions(actions);
        }
        contentManager.addContent(content);
        contentManager.setSelectedContent(content, true);
    }

    @Nullable
    public abstract Object getToolWindowContent(@NotNull DesignerEditorPanelFacade var1);

    public void activateToolWindow(@NotNull DesignerEditorPanelFacade designer, @NotNull Runnable runnable) {
        LightToolWindow toolWindow;
        if (designer == null) {
            NlAbstractWindowManager.$$$reportNull$$$0(10);
        }
        if (runnable == null) {
            NlAbstractWindowManager.$$$reportNull$$$0(11);
        }
        if ((toolWindow = (LightToolWindow)designer.getClientProperty((Object)this.getComponentName())) != null) {
            NlAbstractWindowManager.restore(toolWindow);
            runnable.run();
        } else {
            this.myToolWindow.show(runnable);
        }
    }

    private static void restore(@NotNull LightToolWindow toolWindow) {
        if (toolWindow == null) {
            NlAbstractWindowManager.$$$reportNull$$$0(12);
        }
        try {
            Method updateContent = LightToolWindow.class.getDeclaredMethod("updateContent", Boolean.TYPE, Boolean.TYPE);
            if (updateContent != null) {
                updateContent.setAccessible(true);
                updateContent.invoke((Object)toolWindow, Boolean.TRUE, Boolean.TRUE);
            }
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
            // empty catch block
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileEditorManager";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "icon";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
            case 5: 
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "designer";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/uibuilder/editor/NlAbstractWindowManager";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentPane";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "focusedComponent";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWindow";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/uibuilder/editor/NlAbstractWindowManager";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getLayoutType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "initToolWindow";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createToggleAction";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getDesignSurface";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getLayoutType";
                break;
            }
            case 7: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createWindowContent";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "activateToolWindow";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "restore";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

