/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.constraint;

import com.android.tools.idea.uibuilder.model.NlComponent;
import java.util.HashMap;
import java.util.List;

public class NlComponentUtils {
    private static final String ATT_LL = "layout_constraintLeft_toLeftOf";
    private static final String ATT_LR = "layout_constraintLeft_toRightOf";
    private static final String ATT_RL = "layout_constraintRight_toLeftOf";
    private static final String ATT_RR = "layout_constraintRight_toRightOf";
    private static final String ATT_TT = "layout_constraintTop_toTopOf";
    private static final String ATT_TB = "layout_constraintTop_toBottomOf";
    private static final String ATT_BT = "layout_constraintBottom_toTopOf";
    private static final String ATT_BB = "layout_constraintBottom_toBottomOf";
    private static final String[] LEFT = new String[]{"layout_constraintLeft_toLeftOf", "layout_constraintLeft_toRightOf"};
    private static final String[] RIGHT = new String[]{"layout_constraintRight_toRightOf", "layout_constraintRight_toLeftOf"};
    private static final String[] TOP = new String[]{"layout_constraintLeft_toLeftOf", "layout_constraintLeft_toRightOf"};
    private static final String[] BOTTOM = new String[]{"layout_constraintRight_toRightOf", "layout_constraintRight_toLeftOf"};

    private static HashMap<String, NlComponent> getMap(NlComponent nlComponent) {
        List<NlComponent> list = nlComponent.getModel().getComponents();
        HashMap<String, NlComponent> map = new HashMap<String, NlComponent>();
        for (NlComponent component : list) {
            String id = component.getAttribute("http://schemas.android.com/apk/res/android", "id");
            if (id == null) continue;
            map.put(id, component);
        }
        return map;
    }

    private static NlComponent getDir(HashMap<String, NlComponent> map, NlComponent component, String[] dir) {
        if (component == null) {
            return null;
        }
        for (int i = 0; i < dir.length; ++i) {
            String id = component.getAttribute("http://schemas.android.com/apk/res-auto", dir[i]);
            if (id == null) continue;
            return map.get(id);
        }
        return null;
    }

    public static boolean isHorizontalChain(NlComponent component) {
        HashMap<String, NlComponent> map = NlComponentUtils.getMap(component);
        if (NlComponentUtils.getDir(map, NlComponentUtils.getDir(map, component, LEFT), RIGHT) == component) {
            return true;
        }
        return NlComponentUtils.getDir(map, NlComponentUtils.getDir(map, component, RIGHT), LEFT) == component;
    }

    public static boolean isVerticalChain(NlComponent component) {
        HashMap<String, NlComponent> map = NlComponentUtils.getMap(component);
        if (NlComponentUtils.getDir(map, NlComponentUtils.getDir(map, component, TOP), BOTTOM) == component) {
            return true;
        }
        return NlComponentUtils.getDir(map, NlComponentUtils.getDir(map, component, BOTTOM), TOP) == component;
    }

    public static NlComponent getLeftMostInChain(NlComponent component) {
        NlComponent leftComponent;
        HashMap<String, NlComponent> map = NlComponentUtils.getMap(component);
        NlComponent current = component;
        do {
            if ((current = NlComponentUtils.getDir(map, leftComponent = current, LEFT)) != null) continue;
            return leftComponent;
        } while (NlComponentUtils.getDir(map, current, RIGHT) == leftComponent);
        return leftComponent;
    }

    public static NlComponent getTopMostInChain(NlComponent component) {
        NlComponent leftComponent;
        HashMap<String, NlComponent> map = NlComponentUtils.getMap(component);
        NlComponent current = component;
        do {
            if ((current = NlComponentUtils.getDir(map, leftComponent = current, TOP)) != null) continue;
            return leftComponent;
        } while (NlComponentUtils.getDir(map, current, BOTTOM) == leftComponent);
        return leftComponent;
    }
}

