/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.relative;

import com.android.tools.idea.uibuilder.api.DragHandler;
import com.android.tools.idea.uibuilder.api.DragType;
import com.android.tools.idea.uibuilder.api.InsertType;
import com.android.tools.idea.uibuilder.api.ResizeHandler;
import com.android.tools.idea.uibuilder.api.ViewEditor;
import com.android.tools.idea.uibuilder.api.ViewGroupHandler;
import com.android.tools.idea.uibuilder.graphics.NlGraphics;
import com.android.tools.idea.uibuilder.handlers.relative.ConstraintPainter;
import com.android.tools.idea.uibuilder.handlers.relative.GuidelinePainter;
import com.android.tools.idea.uibuilder.handlers.relative.RelativeDragHandler;
import com.android.tools.idea.uibuilder.handlers.relative.RelativeResizeHandler;
import com.android.tools.idea.uibuilder.model.NlComponent;
import com.android.tools.idea.uibuilder.model.SegmentType;
import com.android.tools.idea.uibuilder.model.TextDirection;
import com.android.tools.idea.uibuilder.surface.ScreenView;
import com.google.common.collect.Lists;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RelativeLayoutHandler
extends ViewGroupHandler {
    @Override
    public boolean paintConstraints(@NotNull ScreenView screenView, @NotNull Graphics2D graphics, @NotNull NlComponent component) {
        if (screenView == null) {
            RelativeLayoutHandler.$$$reportNull$$$0(0);
        }
        if (graphics == null) {
            RelativeLayoutHandler.$$$reportNull$$$0(1);
        }
        if (component == null) {
            RelativeLayoutHandler.$$$reportNull$$$0(2);
        }
        NlGraphics g = new NlGraphics(graphics, screenView);
        List<NlComponent> iterable = component.getChildren();
        ArrayList children = Lists.newArrayList(iterable);
        ConstraintPainter.paintSelectionFeedback(g, component, children, true, TextDirection.LEFT_TO_RIGHT);
        return false;
    }

    @Override
    @Nullable
    public DragHandler createDragHandler(@NotNull ViewEditor editor, @NotNull NlComponent layout, @NotNull List<NlComponent> components, @NotNull DragType type) {
        if (editor == null) {
            RelativeLayoutHandler.$$$reportNull$$$0(3);
        }
        if (layout == null) {
            RelativeLayoutHandler.$$$reportNull$$$0(4);
        }
        if (components == null) {
            RelativeLayoutHandler.$$$reportNull$$$0(5);
        }
        if (type == null) {
            RelativeLayoutHandler.$$$reportNull$$$0(6);
        }
        final RelativeDragHandler moveHandler = new RelativeDragHandler(editor, layout, components);
        return new DragHandler(editor, this, layout, components, type){

            @Override
            @Nullable
            public String update(int x, int y, int modifiers) {
                super.update(x, y, modifiers);
                NlComponent primary = (NlComponent)this.components.get(0);
                int deltaX = this.lastX - this.startX;
                int deltaY = this.lastY - this.startY;
                moveHandler.updateMove(primary, deltaX, deltaY, modifiers);
                return null;
            }

            @Override
            public void paint(@NotNull NlGraphics graphics) {
                if (graphics == null) {
                    1.$$$reportNull$$$0(0);
                }
                GuidelinePainter.paint(graphics, moveHandler);
            }

            @Override
            public void commit(int x, int y, int modifiers, @NotNull InsertType insertType) {
                if (insertType == null) {
                    1.$$$reportNull$$$0(1);
                }
                moveHandler.removeCycles();
                NlComponent previous = null;
                for (NlComponent component : this.components) {
                    if (previous == null) {
                        moveHandler.applyConstraints(component);
                    } else {
                        moveHandler.attachPrevious(previous, component);
                    }
                    previous = component;
                }
                this.insertAddedComponents(insertType);
            }

            private void insertAddedComponents(@NotNull InsertType insertType) {
                if (insertType == null) {
                    1.$$$reportNull$$$0(2);
                }
                List<NlComponent> added = this.components.stream().filter(component -> component.getParent() != this.layout).collect(Collectors.toList());
                this.editor.getModel().addComponents(added, this.layout, null, insertType);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "graphics";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "insertType";
                        break;
                    }
                }
                objectArray2[1] = "com/android/tools/idea/uibuilder/handlers/relative/RelativeLayoutHandler$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "paint";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "commit";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "insertAddedComponents";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    @Override
    @Nullable
    public ResizeHandler createResizeHandler(@NotNull ViewEditor editor, @NotNull NlComponent component, @Nullable SegmentType horizontalEdgeType, @Nullable SegmentType verticalEdgeType) {
        NlComponent parent;
        if (editor == null) {
            RelativeLayoutHandler.$$$reportNull$$$0(7);
        }
        if (component == null) {
            RelativeLayoutHandler.$$$reportNull$$$0(8);
        }
        if ((parent = component.getParent()) == null) {
            return null;
        }
        final RelativeResizeHandler resizeHandler = new RelativeResizeHandler(editor, parent, component, horizontalEdgeType, verticalEdgeType);
        return new ResizeHandler(editor, this, component, horizontalEdgeType, verticalEdgeType){

            @Override
            @Nullable
            public String update(int x, int y, int modifiers, @NotNull Rectangle newBounds) {
                if (newBounds == null) {
                    2.$$$reportNull$$$0(0);
                }
                super.update(x, y, modifiers, newBounds);
                resizeHandler.updateResize(this.component, newBounds, modifiers);
                return null;
            }

            @Override
            public void commit(int px, int py, int modifiers, @NotNull Rectangle newBounds) {
                if (newBounds == null) {
                    2.$$$reportNull$$$0(1);
                }
                resizeHandler.removeCycles();
                resizeHandler.applyConstraints(this.component);
            }

            @Override
            public void paint(@NotNull NlGraphics graphics) {
                if (graphics == null) {
                    2.$$$reportNull$$$0(2);
                }
                GuidelinePainter.paint(graphics, resizeHandler);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "newBounds";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "graphics";
                        break;
                    }
                }
                objectArray2[1] = "com/android/tools/idea/uibuilder/handlers/relative/RelativeLayoutHandler$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "update";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "commit";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "paint";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "screenView";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "graphics";
                break;
            }
            case 2: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "layout";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "components";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/uibuilder/handlers/relative/RelativeLayoutHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "paintConstraints";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "createDragHandler";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "createResizeHandler";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

