/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.palette;

import com.android.tools.idea.uibuilder.api.PaletteComponentHandler;
import com.android.tools.idea.uibuilder.api.XmlType;
import com.android.tools.idea.uibuilder.handlers.ViewHandlerManager;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.intellij.openapi.util.IconLoader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlValue;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@XmlRootElement(name="palette")
public class Palette {
    @XmlElements(value={@XmlElement(name="group", type=Group.class), @XmlElement(name="item", type=Item.class)})
    private final List<BaseItem> myItems = new ArrayList<BaseItem>();
    private final Set<String> myGradleCoordinateIds = new HashSet<String>();

    private Palette() {
    }

    public static Palette parse(@NotNull Reader xmlReader, @NotNull ViewHandlerManager manager) throws JAXBException {
        if (xmlReader == null) {
            Palette.$$$reportNull$$$0(0);
        }
        if (manager == null) {
            Palette.$$$reportNull$$$0(1);
        }
        Palette palette = Palette.unMarshal(xmlReader);
        palette.accept(item -> {
            if (manager == null) {
                Palette.$$$reportNull$$$0(6);
            }
            item.resolve(manager);
        });
        palette.accept(item -> item.addGradleCoordinateId(palette.myGradleCoordinateIds));
        palette.setParentGroups();
        return palette;
    }

    private void setParentGroups() {
        this.accept(new Visitor(){

            @Override
            public void visit(@NotNull Item item) {
                if (item == null) {
                    1.$$$reportNull$$$0(0);
                }
            }

            @Override
            public void visit(@NotNull Group group) {
                if (group == null) {
                    1.$$$reportNull$$$0(1);
                }
                group.getItems().forEach(item -> {
                    if (group == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    item.setParent(group);
                });
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "item";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "group";
                        break;
                    }
                }
                objectArray2[1] = "com/android/tools/idea/uibuilder/palette/Palette$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visit";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "lambda$visit$0";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    @NotNull
    public List<BaseItem> getItems() {
        List<BaseItem> list = this.myItems;
        if (list == null) {
            Palette.$$$reportNull$$$0(2);
        }
        return list;
    }

    @NotNull
    Set<String> getGradleCoordinateIds() {
        Set<String> set = this.myGradleCoordinateIds;
        if (set == null) {
            Palette.$$$reportNull$$$0(3);
        }
        return set;
    }

    private static Palette unMarshal(@NotNull Reader xmlReader) throws JAXBException {
        if (xmlReader == null) {
            Palette.$$$reportNull$$$0(4);
        }
        Unmarshaller unmarshaller = JAXBContext.newInstance((Class[])new Class[]{Palette.class}).createUnmarshaller();
        unmarshaller.setEventHandler(event -> {
            throw new RuntimeException(event.getLinkedException());
        });
        return (Palette)unmarshaller.unmarshal(xmlReader);
    }

    public void accept(@NotNull Visitor visitor) {
        if (visitor == null) {
            Palette.$$$reportNull$$$0(5);
        }
        for (BaseItem item : this.myItems) {
            item.accept(visitor);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "xmlReader";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/uibuilder/palette/Palette";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/uibuilder/palette/Palette";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getItems";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getGradleCoordinateIds";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "parse";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "unMarshal";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "lambda$parse$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class XmlValuePart {
        @XmlValue
        @Language(value="XML")
        @Nullable
        private String myValue;
        @XmlAttribute(name="reuse")
        private String myReuse;

        @Nullable
        public String getValue() {
            return this.myValue;
        }

        private boolean reuseFor(@NotNull String part) {
            if (part == null) {
                XmlValuePart.$$$reportNull$$$0(0);
            }
            return this.myReuse != null && Splitter.on((String)",").trimResults().splitToList((CharSequence)this.myReuse).contains(part);
        }

        public boolean reuseForPreview() {
            return this.reuseFor("preview");
        }

        public boolean reuseForDragPreview() {
            return this.reuseFor("drag-preview");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "part", "com/android/tools/idea/uibuilder/palette/Palette$XmlValuePart", "reuseFor"));
        }
    }

    public static class Item
    implements BaseItem {
        @XmlAttribute(required=true, name="tag")
        @NotNull
        private String myTagName;
        @XmlAttribute(name="id")
        @Nullable
        private String myId;
        @XmlAttribute(name="title")
        @Nullable
        private String myTitle;
        @XmlAttribute(name="icon")
        @Nullable
        private String myIconName;
        @XmlAttribute(name="icon24")
        @Nullable
        private String myIcon24Name;
        @XmlAttribute(name="coordinate")
        @Nullable
        private String myGradleCoordinateId;
        @XmlAttribute(name="scale")
        @Nullable
        private Double myPreviewScale;
        @XmlAttribute(name="render-separately")
        @Nullable
        private Boolean myPreviewRenderSeparately;
        @XmlElement(name="xml", type=XmlValuePart.class)
        private XmlValuePart myXmlValuePart;
        @Language(value="XML")
        @Nullable
        private String myXml;
        @XmlElement(name="preview")
        @Language(value="XML")
        @Nullable
        private String myPreviewXml;
        @XmlElement(name="drag-preview")
        @Language(value="XML")
        @Nullable
        private String myDragPreviewXml;
        @Nullable
        private Group myParent;
        private PaletteComponentHandler myHandler;

        @NotNull
        public String getTagName() {
            String string = this.myTagName;
            if (string == null) {
                Item.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getId() {
            String string = this.myId != null ? this.myId : this.myTagName;
            if (string == null) {
                Item.$$$reportNull$$$0(1);
            }
            return string;
        }

        @NotNull
        public String getTitle() {
            if (this.myTitle != null) {
                String string = this.myTitle;
                if (string == null) {
                    Item.$$$reportNull$$$0(2);
                }
                return string;
            }
            String string = this.myHandler.getTitle(this.myTagName);
            if (string == null) {
                Item.$$$reportNull$$$0(3);
            }
            return string;
        }

        @NotNull
        public Icon getIcon() {
            Icon icon;
            if (this.myIconName != null && (icon = IconLoader.findIcon((String)this.myIconName, this.getClass())) != null) {
                Icon icon2 = icon;
                if (icon2 == null) {
                    Item.$$$reportNull$$$0(4);
                }
                return icon2;
            }
            Icon icon3 = this.myHandler.getIcon(this.myTagName);
            if (icon3 == null) {
                Item.$$$reportNull$$$0(5);
            }
            return icon3;
        }

        @NotNull
        public Icon getLargeIcon() {
            Icon icon;
            if (this.myIcon24Name != null && (icon = IconLoader.findIcon((String)this.myIcon24Name, this.getClass())) != null) {
                Icon icon2 = icon;
                if (icon2 == null) {
                    Item.$$$reportNull$$$0(6);
                }
                return icon2;
            }
            if (this.myIconName != null && (icon = IconLoader.findIcon((String)(this.myIconName + "Large"), this.getClass())) != null) {
                Icon icon3 = icon;
                if (icon3 == null) {
                    Item.$$$reportNull$$$0(7);
                }
                return icon3;
            }
            Icon icon4 = this.myHandler.getLargeIcon(this.myTagName);
            if (icon4 == null) {
                Item.$$$reportNull$$$0(8);
            }
            return icon4;
        }

        @Nullable
        public String getGradleCoordinateId() {
            if (this.myGradleCoordinateId != null) {
                return this.myGradleCoordinateId;
            }
            return this.myHandler.getGradleCoordinateId(this.myTagName);
        }

        @NotNull
        @Language(value="XML")
        public String getXml() {
            if (this.myXml != null) {
                String string = this.myXml;
                if (string == null) {
                    Item.$$$reportNull$$$0(9);
                }
                return string;
            }
            String string = this.myHandler.getXml(this.myTagName, XmlType.COMPONENT_CREATION);
            if (string == null) {
                Item.$$$reportNull$$$0(10);
            }
            return string;
        }

        @NotNull
        @Language(value="XML")
        public String getPreviewXml() {
            if (this.myPreviewXml != null) {
                String string = this.myPreviewXml;
                if (string == null) {
                    Item.$$$reportNull$$$0(11);
                }
                return string;
            }
            String string = this.myHandler.getXml(this.myTagName, XmlType.PREVIEW_ON_PALETTE);
            if (string == null) {
                Item.$$$reportNull$$$0(12);
            }
            return string;
        }

        @NotNull
        @Language(value="XML")
        public String getDragPreviewXml() {
            if (this.myDragPreviewXml != null) {
                String string = this.myDragPreviewXml;
                if (string == null) {
                    Item.$$$reportNull$$$0(13);
                }
                return string;
            }
            String string = this.myHandler.getXml(this.myTagName, XmlType.DRAG_PREVIEW);
            if (string == null) {
                Item.$$$reportNull$$$0(14);
            }
            return string;
        }

        public double getPreviewScale() {
            if (this.myPreviewScale != null) {
                return this.myPreviewScale;
            }
            return this.myHandler.getPreviewScale(this.myTagName);
        }

        public boolean isPreviewRenderedSeparately() {
            if (this.myPreviewRenderSeparately != null) {
                return this.myPreviewRenderSeparately;
            }
            return false;
        }

        @Override
        @Nullable
        public Group getParent() {
            return this.myParent;
        }

        @Override
        public void setParent(@NotNull Group parent) {
            if (parent == null) {
                Item.$$$reportNull$$$0(15);
            }
            this.myParent = parent;
        }

        @Override
        public void accept(@NotNull Visitor visitor) {
            if (visitor == null) {
                Item.$$$reportNull$$$0(16);
            }
            visitor.visit(this);
        }

        private void resolve(@NotNull ViewHandlerManager manager) {
            if (manager == null) {
                Item.$$$reportNull$$$0(17);
            }
            this.myHandler = manager.getHandlerOrDefault(this.myTagName);
            if (this.myXmlValuePart != null) {
                this.myXml = this.myXmlValuePart.getValue();
                if (this.myPreviewXml == null && this.myXmlValuePart.reuseForPreview()) {
                    this.myPreviewXml = this.addId(this.myXml);
                }
                if (this.myDragPreviewXml == null && this.myXmlValuePart.reuseForDragPreview()) {
                    this.myDragPreviewXml = this.myXml;
                }
                this.myXmlValuePart = null;
            }
        }

        private void addGradleCoordinateId(@NotNull Set<String> coordinateIds) {
            String coordinateId;
            if (coordinateIds == null) {
                Item.$$$reportNull$$$0(18);
            }
            if (!Strings.isNullOrEmpty((String)(coordinateId = this.getGradleCoordinateId()))) {
                coordinateIds.add(coordinateId);
            }
        }

        @Language(value="XML")
        @Nullable
        private String addId(@Nullable @Language(value="XML") String xml) {
            if (xml == null || this.myId == null) {
                return xml;
            }
            int index = xml.indexOf("<" + this.myTagName);
            if (index < 0) {
                return xml;
            }
            return xml.substring(0, index += 1 + this.myTagName.length()) + "\n  android:id=\"@+id/" + this.getId() + "\"\n" + xml.substring(index);
        }

        @NotNull
        public String toString() {
            String string = this.myTagName;
            if (string == null) {
                Item.$$$reportNull$$$0(19);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 15: 
                case 16: 
                case 17: 
                case 18: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 15: 
                case 16: 
                case 17: 
                case 18: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/uibuilder/palette/Palette$Item";
                    break;
                }
                case 15: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parent";
                    break;
                }
                case 16: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "visitor";
                    break;
                }
                case 17: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "manager";
                    break;
                }
                case 18: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "coordinateIds";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTagName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getId";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTitle";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getIcon";
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLargeIcon";
                    break;
                }
                case 9: 
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getXml";
                    break;
                }
                case 11: 
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPreviewXml";
                    break;
                }
                case 13: 
                case 14: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDragPreviewXml";
                    break;
                }
                case 15: 
                case 16: 
                case 17: 
                case 18: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/uibuilder/palette/Palette$Item";
                    break;
                }
                case 19: {
                    objectArray = objectArray2;
                    objectArray2[1] = "toString";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 15: {
                    objectArray = objectArray;
                    objectArray[2] = "setParent";
                    break;
                }
                case 16: {
                    objectArray = objectArray;
                    objectArray[2] = "accept";
                    break;
                }
                case 17: {
                    objectArray = objectArray;
                    objectArray[2] = "resolve";
                    break;
                }
                case 18: {
                    objectArray = objectArray;
                    objectArray[2] = "addGradleCoordinateId";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 15: 
                case 16: 
                case 17: 
                case 18: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class Group
    implements BaseItem {
        @XmlAttribute(required=true, name="name")
        @NotNull
        private String myName;
        @XmlElements(value={@XmlElement(name="group", type=Group.class), @XmlElement(name="item", type=Item.class)})
        private List<BaseItem> myItems;
        @Nullable
        private Group myParent;

        private Group() {
            this.myItems = Lists.newArrayList();
        }

        public Group(@NotNull String name) {
            if (name == null) {
                Group.$$$reportNull$$$0(0);
            }
            this.myItems = Lists.newArrayList();
            this.myName = name;
        }

        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                Group.$$$reportNull$$$0(1);
            }
            return string;
        }

        @NotNull
        public List<BaseItem> getItems() {
            List<BaseItem> list = this.myItems;
            if (list == null) {
                Group.$$$reportNull$$$0(2);
            }
            return list;
        }

        @NotNull
        public BaseItem getItem(int index) {
            BaseItem baseItem = this.myItems.get(index);
            if (baseItem == null) {
                Group.$$$reportNull$$$0(3);
            }
            return baseItem;
        }

        @Override
        @Nullable
        public Group getParent() {
            return this.myParent;
        }

        @Override
        public void setParent(@NotNull Group parent) {
            if (parent == null) {
                Group.$$$reportNull$$$0(4);
            }
            this.myParent = parent;
        }

        @Override
        public void accept(@NotNull Visitor visitor) {
            if (visitor == null) {
                Group.$$$reportNull$$$0(5);
            }
            visitor.visit(this);
            for (BaseItem item : this.myItems) {
                item.accept(visitor);
            }
        }

        @NotNull
        public String toString() {
            String string = this.myName;
            if (string == null) {
                Group.$$$reportNull$$$0(6);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 6: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 6: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/uibuilder/palette/Palette$Group";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parent";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "visitor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/uibuilder/palette/Palette$Group";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getItems";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getItem";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "toString";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 6: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "setParent";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "accept";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 6: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    static interface BaseItem {
        public void accept(@NotNull Visitor var1);

        @Nullable
        public Group getParent();

        public void setParent(@NotNull Group var1);
    }

    public static interface Visitor {
        public void visit(@NotNull Item var1);

        default public void visit(@NotNull Group group) {
            if (group == null) {
                Visitor.$$$reportNull$$$0(0);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "group", "com/android/tools/idea/uibuilder/palette/Palette$Visitor", "visit"));
        }
    }
}

