/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.property.editors.support;

import com.android.ide.common.rendering.api.ResourceReference;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.rendering.api.StyleResourceValue;
import com.android.ide.common.resources.ResourceResolver;
import com.android.ide.common.resources.ResourceValueMap;
import com.android.resources.ResourceType;
import com.android.tools.idea.uibuilder.api.ViewHandler;
import com.android.tools.idea.uibuilder.handlers.ViewHandlerManager;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class StyleFilter {
    private final Project myProject;
    private final ResourceResolver myResolver;
    private final ResourceValueMap myFrameworkStyles;
    private final ResourceValueMap myProjectStyles;
    private final Set<String> myDerivedStyles;
    private final Set<String> myOtherStyles;
    private final Set<String> myCurrentInheritanceChain;

    public StyleFilter(@NotNull Project project, @NotNull ResourceResolver resolver) {
        if (project == null) {
            StyleFilter.$$$reportNull$$$0(0);
        }
        if (resolver == null) {
            StyleFilter.$$$reportNull$$$0(1);
        }
        this.myProject = project;
        this.myResolver = resolver;
        this.myFrameworkStyles = (ResourceValueMap)resolver.getFrameworkResources().get(ResourceType.STYLE);
        this.myProjectStyles = (ResourceValueMap)resolver.getProjectResources().get(ResourceType.STYLE);
        this.myDerivedStyles = new HashSet<String>();
        this.myOtherStyles = new HashSet<String>();
        this.myCurrentInheritanceChain = new HashSet<String>();
    }

    public static boolean hasWidgetStyles(@NotNull Project project, @NotNull ResourceResolver resolver, @NotNull String tagName) {
        if (project == null) {
            StyleFilter.$$$reportNull$$$0(2);
        }
        if (resolver == null) {
            StyleFilter.$$$reportNull$$$0(3);
        }
        if (tagName == null) {
            StyleFilter.$$$reportNull$$$0(4);
        }
        return !StyleFilter.getWidgetStyleNames(project, resolver, tagName).isEmpty();
    }

    public List<StyleResourceValue> getWidgetStyles(@NotNull String tagName) {
        if (tagName == null) {
            StyleFilter.$$$reportNull$$$0(5);
        }
        this.myDerivedStyles.clear();
        this.myOtherStyles.clear();
        this.myDerivedStyles.addAll(StyleFilter.getWidgetStyleNames(this.myProject, this.myResolver, tagName));
        return this.findDerivedStyles();
    }

    @NotNull
    public List<StyleResourceValue> getStylesDerivedFrom(@NotNull String baseStyle, boolean isFrameworkStyle) {
        if (baseStyle == null) {
            StyleFilter.$$$reportNull$$$0(6);
        }
        this.myDerivedStyles.clear();
        this.myOtherStyles.clear();
        if (isFrameworkStyle) {
            this.myDerivedStyles.add("android:" + baseStyle);
        } else {
            this.myDerivedStyles.add(baseStyle);
        }
        List<StyleResourceValue> list = this.findDerivedStyles();
        if (list == null) {
            StyleFilter.$$$reportNull$$$0(7);
        }
        return list;
    }

    private List<StyleResourceValue> findDerivedStyles() {
        ArrayList styles = new ArrayList(this.myFrameworkStyles.size() + this.myProjectStyles.size());
        this.myProjectStyles.values().forEach(style -> styles.add((StyleResourceValue)style));
        this.myFrameworkStyles.values().forEach(style -> styles.add((StyleResourceValue)style));
        return styles.stream().filter(this::filter).sorted(Comparator.comparing(ResourceValue::isUserDefined).reversed().thenComparing(ResourceReference::isFramework).thenComparing(ResourceReference::getName)).collect(Collectors.toList());
    }

    boolean filter(@NotNull StyleResourceValue style) {
        if (style == null) {
            StyleFilter.$$$reportNull$$$0(8);
        }
        if (style.getName().startsWith("Base.")) {
            return false;
        }
        if (style.isFramework() && style.getName().toLowerCase(Locale.US).equals(style.getName())) {
            return false;
        }
        this.myCurrentInheritanceChain.clear();
        return this.isDerived(style);
    }

    boolean isDerived(@NotNull StyleResourceValue style) {
        String styleName;
        if (style == null) {
            StyleFilter.$$$reportNull$$$0(9);
        }
        if (this.myDerivedStyles.contains(styleName = StyleFilter.getStyleName(style))) {
            return true;
        }
        if (this.myOtherStyles.contains(styleName)) {
            return false;
        }
        StyleResourceValue parentStyle = this.myResolver.getParent(style);
        if (parentStyle != null && !this.myCurrentInheritanceChain.contains(styleName)) {
            this.myCurrentInheritanceChain.add(styleName);
            return this.found(styleName, this.isDerived(parentStyle));
        }
        return this.found(styleName, false);
    }

    @NotNull
    private static String getStyleName(@NotNull StyleResourceValue style) {
        if (style == null) {
            StyleFilter.$$$reportNull$$$0(10);
        }
        if (style.isFramework()) {
            String string = "android:" + style.getName();
            if (string == null) {
                StyleFilter.$$$reportNull$$$0(11);
            }
            return string;
        }
        String string = style.getName();
        if (string == null) {
            StyleFilter.$$$reportNull$$$0(12);
        }
        return string;
    }

    private boolean found(@NotNull String name, boolean isIncluded) {
        if (name == null) {
            StyleFilter.$$$reportNull$$$0(13);
        }
        if (isIncluded) {
            this.myDerivedStyles.add(name);
        } else {
            this.myOtherStyles.add(name);
        }
        return isIncluded;
    }

    @NotNull
    private static List<String> getWidgetStyleNames(@NotNull Project project, @NotNull ResourceResolver resolver, @NotNull String tagName) {
        ViewHandlerManager manager;
        ViewHandler handler;
        if (project == null) {
            StyleFilter.$$$reportNull$$$0(14);
        }
        if (resolver == null) {
            StyleFilter.$$$reportNull$$$0(15);
        }
        if (tagName == null) {
            StyleFilter.$$$reportNull$$$0(16);
        }
        if ((handler = (manager = ViewHandlerManager.get(project)).getHandler(tagName)) == null) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                StyleFilter.$$$reportNull$$$0(17);
            }
            return list;
        }
        List<String> possibleNames = handler.getBaseStyles(tagName);
        ResourceValueMap frameworkStyles = (ResourceValueMap)resolver.getFrameworkResources().get(ResourceType.STYLE);
        ResourceValueMap projectStyles = (ResourceValueMap)resolver.getProjectResources().get(ResourceType.STYLE);
        ArrayList<String> names = new ArrayList<String>(4);
        for (String styleName : possibleNames) {
            if (frameworkStyles.containsKey((Object)styleName)) {
                names.add("android:" + styleName);
            }
            if (!projectStyles.containsKey((Object)styleName)) continue;
            names.add(styleName);
        }
        ArrayList<String> arrayList = names;
        if (arrayList == null) {
            StyleFilter.$$$reportNull$$$0(18);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 11: 
            case 12: 
            case 17: 
            case 18: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 11: 
            case 12: 
            case 17: 
            case 18: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolver";
                break;
            }
            case 4: 
            case 5: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tagName";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseStyle";
                break;
            }
            case 7: 
            case 11: 
            case 12: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/uibuilder/property/editors/support/StyleFilter";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "style";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/uibuilder/property/editors/support/StyleFilter";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getStylesDerivedFrom";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getStyleName";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getWidgetStyleNames";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "hasWidgetStyles";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getWidgetStyles";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getStylesDerivedFrom";
                break;
            }
            case 7: 
            case 11: 
            case 12: 
            case 17: 
            case 18: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "filter";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isDerived";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getStyleName";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "found";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getWidgetStyleNames";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 11: 
            case 12: 
            case 17: 
            case 18: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

