/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.scene.target;

import com.android.tools.idea.uibuilder.model.AttributesTransaction;
import com.android.tools.idea.uibuilder.model.NlComponent;
import com.android.tools.idea.uibuilder.model.NlModel;
import com.android.tools.idea.uibuilder.scene.SceneComponent;
import com.android.tools.idea.uibuilder.scene.target.BaseTarget;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import java.util.ArrayList;
import java.util.HashMap;
import org.jetbrains.annotations.NotNull;

public abstract class ConstraintTarget
extends BaseTarget {
    protected static final HashMap<String, String> ourReciprocalAttributes = new HashMap();
    protected static final HashMap<String, String> ourMapMarginAttributes;
    protected static final ArrayList<String> ourLeftAttributes;
    protected static final ArrayList<String> ourTopAttributes;
    protected static final ArrayList<String> ourRightAttributes;
    protected static final ArrayList<String> ourBottomAttributes;
    protected static final ArrayList<String> ourMarginAttributes;
    protected boolean myIsInHorizontalChain = false;
    protected boolean myIsInVerticalChain = false;
    protected SceneComponent myHorizontalChainHead;
    protected SceneComponent myVerticalChainHead;

    protected boolean hasAttributes(@NotNull NlComponent component, String uri, ArrayList<String> attributes) {
        if (component == null) {
            ConstraintTarget.$$$reportNull$$$0(0);
        }
        int count = attributes.size();
        for (int i = 0; i < count; ++i) {
            String attribute = attributes.get(i);
            if (component.getLiveAttribute(uri, attribute) == null) continue;
            return true;
        }
        return false;
    }

    private boolean hasAttributes(@NotNull AttributesTransaction transaction, String uri, ArrayList<String> attributes) {
        if (transaction == null) {
            ConstraintTarget.$$$reportNull$$$0(1);
        }
        int count = attributes.size();
        for (int i = 0; i < count; ++i) {
            String attribute = attributes.get(i);
            if (transaction.getAttribute(uri, attribute) == null) continue;
            return true;
        }
        return false;
    }

    protected String getConnectionId(@NotNull NlComponent component, String uri, ArrayList<String> attributes) {
        if (component == null) {
            ConstraintTarget.$$$reportNull$$$0(2);
        }
        int count = attributes.size();
        for (int i = 0; i < count; ++i) {
            String attribute = component.getLiveAttribute(uri, attributes.get(i));
            if (attribute == null) continue;
            return NlComponent.extractId(attribute);
        }
        return null;
    }

    protected boolean hasLeft(@NotNull AttributesTransaction transaction) {
        if (transaction == null) {
            ConstraintTarget.$$$reportNull$$$0(3);
        }
        return this.hasAttributes(transaction, "http://schemas.android.com/apk/res-auto", ourLeftAttributes);
    }

    protected boolean hasTop(@NotNull AttributesTransaction transaction) {
        if (transaction == null) {
            ConstraintTarget.$$$reportNull$$$0(4);
        }
        return this.hasAttributes(transaction, "http://schemas.android.com/apk/res-auto", ourTopAttributes);
    }

    protected boolean hasRight(@NotNull AttributesTransaction transaction) {
        if (transaction == null) {
            ConstraintTarget.$$$reportNull$$$0(5);
        }
        return this.hasAttributes(transaction, "http://schemas.android.com/apk/res-auto", ourRightAttributes);
    }

    protected boolean hasBottom(@NotNull AttributesTransaction transaction) {
        if (transaction == null) {
            ConstraintTarget.$$$reportNull$$$0(6);
        }
        return this.hasAttributes(transaction, "http://schemas.android.com/apk/res-auto", ourBottomAttributes);
    }

    protected void setDpAttribute(String uri, String attribute, AttributesTransaction transaction, int value) {
        String position = String.format("%ddp", value);
        transaction.setAttribute(uri, attribute, position);
    }

    protected void cleanup(@NotNull AttributesTransaction transaction) {
        boolean hasBaseline;
        if (transaction == null) {
            ConstraintTarget.$$$reportNull$$$0(7);
        }
        boolean hasLeft = this.hasLeft(transaction);
        boolean hasRight = this.hasRight(transaction);
        boolean hasTop = this.hasTop(transaction);
        boolean hasBottom = this.hasBottom(transaction);
        boolean bl = hasBaseline = transaction.getAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintBaseline_toBaselineOf") != null;
        if (!hasLeft) {
            transaction.setAttribute("http://schemas.android.com/apk/res/android", "layout_marginLeft", null);
            transaction.setAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintHorizontal_bias", null);
        }
        if (!hasRight) {
            transaction.setAttribute("http://schemas.android.com/apk/res/android", "layout_marginRight", null);
            transaction.setAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintHorizontal_bias", null);
        }
        if (!hasLeft && !hasRight) {
            if (transaction.getAttribute("http://schemas.android.com/tools", "layout_editor_absoluteX") == null) {
                this.setDpAttribute("http://schemas.android.com/tools", "layout_editor_absoluteX", transaction, this.myComponent.getOffsetParentX());
            }
        } else {
            transaction.setAttribute("http://schemas.android.com/tools", "layout_editor_absoluteX", null);
        }
        if (!hasTop) {
            transaction.setAttribute("http://schemas.android.com/apk/res/android", "layout_marginTop", null);
            transaction.setAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintVertical_bias", null);
        }
        if (!hasBottom) {
            transaction.setAttribute("http://schemas.android.com/apk/res/android", "layout_marginBottom", null);
            transaction.setAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintVertical_bias", null);
        }
        if (!(hasTop || hasBottom || hasBaseline)) {
            if (transaction.getAttribute("http://schemas.android.com/tools", "layout_editor_absoluteY") == null) {
                this.setDpAttribute("http://schemas.android.com/tools", "layout_editor_absoluteY", transaction, this.myComponent.getOffsetParentY());
            }
        } else {
            transaction.setAttribute("http://schemas.android.com/tools", "layout_editor_absoluteY", null);
        }
        if (!this.myComponent.allowsFixedPosition()) {
            transaction.setAttribute("http://schemas.android.com/tools", "layout_editor_absoluteX", null);
            transaction.setAttribute("http://schemas.android.com/tools", "layout_editor_absoluteY", null);
        }
    }

    protected void clearAttributes(String uri, ArrayList<String> attributes, AttributesTransaction transaction) {
        int count = attributes.size();
        for (int i = 0; i < count; ++i) {
            String attribute = attributes.get(i);
            transaction.setAttribute(uri, attribute, null);
        }
    }

    protected boolean checkIsInChain() {
        this.myHorizontalChainHead = null;
        this.myVerticalChainHead = null;
        this.myIsInHorizontalChain = false;
        this.myIsInVerticalChain = false;
        if (this.isInChain(ourRightAttributes, ourLeftAttributes)) {
            this.myIsInHorizontalChain = true;
        } else if (this.isInChain(ourLeftAttributes, ourRightAttributes)) {
            this.myIsInHorizontalChain = true;
        }
        if (this.myIsInHorizontalChain) {
            this.myHorizontalChainHead = this.findChainHead(this.myComponent, ourLeftAttributes, ourRightAttributes);
        }
        if (this.isInChain(ourBottomAttributes, ourTopAttributes)) {
            this.myIsInVerticalChain = true;
        } else if (this.isInChain(ourTopAttributes, ourBottomAttributes)) {
            this.myIsInVerticalChain = true;
        }
        if (this.myIsInVerticalChain) {
            this.myVerticalChainHead = this.findChainHead(this.myComponent, ourTopAttributes, ourBottomAttributes);
        }
        return this.myIsInHorizontalChain || this.myIsInVerticalChain;
    }

    private SceneComponent findChainHead(SceneComponent component, ArrayList<String> sideA, ArrayList<String> sideB) {
        while (true) {
            NlComponent nlComponent;
            String attributeA;
            if ((attributeA = this.getConnectionId(nlComponent = component.getNlComponent(), "http://schemas.android.com/apk/res-auto", sideA)) == null) {
                return component;
            }
            SceneComponent target = this.myComponent.getScene().getSceneComponent(attributeA);
            if (target == null) {
                return component;
            }
            String attributeB = this.getConnectionId(target.getNlComponent(), "http://schemas.android.com/apk/res-auto", sideB);
            if (attributeB == null) {
                return component;
            }
            if (!attributeB.equalsIgnoreCase(nlComponent.getId())) break;
            component = target;
        }
        return component;
    }

    private boolean isInChain(ArrayList<String> sideA, ArrayList<String> sideB) {
        String attributeB;
        SceneComponent target;
        String attributeA = this.getConnectionId(this.myComponent.getNlComponent(), "http://schemas.android.com/apk/res-auto", sideA);
        return attributeA != null && (target = this.myComponent.getScene().getSceneComponent(attributeA)) != null && (attributeB = this.getConnectionId(target.getNlComponent(), "http://schemas.android.com/apk/res-auto", sideB)) != null && attributeB.equalsIgnoreCase(this.myComponent.getNlComponent().getId());
    }

    protected void cycleChainStyle(SceneComponent chainHeadComponent, String orientationStyle) {
        NlComponent chainHead = chainHeadComponent.getNlComponent();
        String chainStyle = chainHead.getLiveAttribute("http://schemas.android.com/apk/res-auto", orientationStyle);
        if (chainStyle != null) {
            if (chainStyle.equalsIgnoreCase("spread")) {
                chainStyle = "spread_inside";
            } else if (chainStyle.equalsIgnoreCase("spread_inside")) {
                chainStyle = "packed";
            } else if (chainStyle.equalsIgnoreCase("packed")) {
                chainStyle = "spread";
            }
        } else {
            chainStyle = "spread";
        }
        final AttributesTransaction transaction = chainHead.startAttributeTransaction();
        transaction.setAttribute("http://schemas.android.com/apk/res-auto", orientationStyle, chainStyle);
        transaction.apply();
        NlModel nlModel = chainHead.getModel();
        Project project = nlModel.getProject();
        XmlFile file = nlModel.getFile();
        String label = "Cycle chain style";
        WriteCommandAction action = new WriteCommandAction(project, label, new PsiFile[]{file}){

            protected void run(@NotNull Result result) throws Throwable {
                if (result == null) {
                    1.$$$reportNull$$$0(0);
                }
                transaction.commit();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/android/tools/idea/uibuilder/scene/target/ConstraintTarget$1", "run"));
            }
        };
        action.execute();
        this.myComponent.getScene().needsRebuildList();
    }

    static {
        ourReciprocalAttributes.put("layout_constraintLeft_toLeftOf", "layout_constraintLeft_toRightOf");
        ourReciprocalAttributes.put("layout_constraintLeft_toRightOf", "layout_constraintLeft_toLeftOf");
        ourReciprocalAttributes.put("layout_constraintRight_toLeftOf", "layout_constraintRight_toRightOf");
        ourReciprocalAttributes.put("layout_constraintRight_toRightOf", "layout_constraintRight_toLeftOf");
        ourReciprocalAttributes.put("layout_constraintTop_toTopOf", "layout_constraintTop_toBottomOf");
        ourReciprocalAttributes.put("layout_constraintTop_toBottomOf", "layout_constraintTop_toTopOf");
        ourReciprocalAttributes.put("layout_constraintBottom_toTopOf", "layout_constraintBottom_toBottomOf");
        ourReciprocalAttributes.put("layout_constraintBottom_toBottomOf", "layout_constraintBottom_toTopOf");
        ourMapMarginAttributes = new HashMap();
        ourMapMarginAttributes.put("layout_constraintLeft_toLeftOf", "layout_marginLeft");
        ourMapMarginAttributes.put("layout_constraintLeft_toRightOf", "layout_marginLeft");
        ourMapMarginAttributes.put("layout_constraintRight_toLeftOf", "layout_marginRight");
        ourMapMarginAttributes.put("layout_constraintRight_toRightOf", "layout_marginRight");
        ourMapMarginAttributes.put("layout_constraintTop_toTopOf", "layout_marginTop");
        ourMapMarginAttributes.put("layout_constraintTop_toBottomOf", "layout_marginTop");
        ourMapMarginAttributes.put("layout_constraintBottom_toTopOf", "layout_marginBottom");
        ourMapMarginAttributes.put("layout_constraintBottom_toBottomOf", "layout_marginBottom");
        ourLeftAttributes = new ArrayList();
        ourLeftAttributes.add("layout_constraintLeft_toLeftOf");
        ourLeftAttributes.add("layout_constraintLeft_toRightOf");
        ourTopAttributes = new ArrayList();
        ourTopAttributes.add("layout_constraintTop_toTopOf");
        ourTopAttributes.add("layout_constraintTop_toBottomOf");
        ourRightAttributes = new ArrayList();
        ourRightAttributes.add("layout_constraintRight_toLeftOf");
        ourRightAttributes.add("layout_constraintRight_toRightOf");
        ourBottomAttributes = new ArrayList();
        ourBottomAttributes.add("layout_constraintBottom_toTopOf");
        ourBottomAttributes.add("layout_constraintBottom_toBottomOf");
        ourMarginAttributes = new ArrayList();
        ourMarginAttributes.add("layout_margin");
        ourMarginAttributes.add("layout_marginLeft");
        ourMarginAttributes.add("layout_marginRight");
        ourMarginAttributes.add("layout_marginTop");
        ourMarginAttributes.add("layout_marginBottom");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "transaction";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/uibuilder/scene/target/ConstraintTarget";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "hasAttributes";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getConnectionId";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "hasLeft";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "hasTop";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "hasRight";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "hasBottom";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "cleanup";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

