/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.surface;

import com.android.tools.idea.uibuilder.lint.LintAnnotationsModel;
import com.android.tools.idea.uibuilder.model.Coordinates;
import com.android.tools.idea.uibuilder.model.NlComponent;
import com.android.tools.idea.uibuilder.surface.Layer;
import com.android.tools.idea.uibuilder.surface.ScreenView;
import com.google.common.collect.Lists;
import java.awt.Graphics2D;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.android.uipreview.AndroidEditorSettings;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WarningLayer
extends Layer {
    public static final int PADDING = 5;
    private final ScreenView myScreenView;
    private final List<NlComponent> myAnnotatedComponents;

    public WarningLayer(@NotNull ScreenView screenView) {
        if (screenView == null) {
            WarningLayer.$$$reportNull$$$0(0);
        }
        this.myAnnotatedComponents = Lists.newArrayList();
        this.myScreenView = screenView;
    }

    @Override
    public void paint(@NotNull Graphics2D gc) {
        if (gc == null) {
            WarningLayer.$$$reportNull$$$0(1);
        }
        if (!AndroidEditorSettings.getInstance().getGlobalState().isShowLint()) {
            return;
        }
        this.myAnnotatedComponents.clear();
        LintAnnotationsModel lintModel = this.myScreenView.getModel().getLintAnnotationsModel();
        if (lintModel == null) {
            return;
        }
        for (NlComponent component : lintModel.getComponentsWithIssues()) {
            Icon icon;
            if (!component.isShowing() || (icon = lintModel.getIssueIcon(component)) == null) continue;
            int x = Coordinates.getSwingX(this.myScreenView, component.x);
            int y = Coordinates.getSwingY(this.myScreenView, component.y);
            int w = Coordinates.getSwingDimension(this.myScreenView, component.w);
            icon.paintIcon(null, gc, x + w - icon.getIconWidth() - 5, y + 5);
            this.myAnnotatedComponents.add(component);
        }
    }

    @Override
    @Nullable
    public String getTooltip(int mx, int my) {
        LintAnnotationsModel lintModel = this.myScreenView.getModel().getLintAnnotationsModel();
        if (lintModel == null) {
            return null;
        }
        for (NlComponent component : this.myAnnotatedComponents) {
            Icon icon = lintModel.getIssueIcon(component);
            if (icon == null) continue;
            int x = Coordinates.getSwingX(this.myScreenView, component.x);
            int y = Coordinates.getSwingY(this.myScreenView, component.y);
            int w = Coordinates.getSwingDimension(this.myScreenView, component.w);
            if (mx <= x + w - icon.getIconWidth() - 5 || mx >= x + w - 5 || my <= y + 5 || my >= y + 5 + icon.getIconHeight()) continue;
            return lintModel.getIssueMessage(component);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "screenView";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gc";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/uibuilder/surface/WarningLayer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "paint";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

