/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.welcome.wizard;

import com.android.tools.idea.welcome.wizard.ConsoleHighlighter;
import com.android.tools.idea.welcome.wizard.FirstRunWizardStep;
import com.intellij.execution.impl.ConsoleViewUtil;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.ide.util.DelegatingProgressIndicator;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ProgressStep
extends FirstRunWizardStep {
    private final ConsoleHighlighter myHighlighter;
    private final EditorEx myConsoleEditor;
    private JPanel myRoot;
    private JProgressBar myProgressBar;
    private JButton myShowDetailsButton;
    private JLabel myLabel;
    private JPanel myConsole;
    private ProgressIndicator myProgressIndicator;
    private double myFraction;

    public ProgressStep(@NotNull Disposable parent) {
        if (parent == null) {
            ProgressStep.$$$reportNull$$$0(0);
        }
        this(parent, "Downloading Components");
    }

    public ProgressStep(@NotNull Disposable parent, @NotNull String name) {
        if (parent == null) {
            ProgressStep.$$$reportNull$$$0(1);
        }
        if (name == null) {
            ProgressStep.$$$reportNull$$$0(2);
        }
        super(name);
        this.myFraction = 0.0;
        this.$$$setupUI$$$();
        this.setComponent(this.myRoot);
        this.myLabel.setText("Installing");
        this.myConsoleEditor = ConsoleViewUtil.setupConsoleEditor((Project)null, (boolean)false, (boolean)false);
        this.myConsoleEditor.getSettings().setUseSoftWraps(true);
        this.myConsoleEditor.reinitSettings();
        Disposer.register((Disposable)parent, (Disposable)new Disposable(){

            public void dispose() {
                EditorFactory.getInstance().releaseEditor((Editor)ProgressStep.this.myConsoleEditor);
            }
        });
        this.myHighlighter = new ConsoleHighlighter();
        this.myHighlighter.setModalityState(ModalityState.stateForComponent((Component)this.myLabel));
        this.myConsoleEditor.setHighlighter((EditorHighlighter)this.myHighlighter);
        JComponent editorComponent = this.myConsoleEditor.getComponent();
        this.myConsole.add((Component)editorComponent, "Center");
        editorComponent.setVisible(false);
        this.myShowDetailsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProgressStep.this.showConsole();
            }
        });
    }

    @Override
    public void init() {
    }

    @Override
    public void onEnterStep() {
        super.onEnterStep();
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                ProgressStep.this.execute();
            }
        });
    }

    protected abstract void execute();

    @Override
    @Nullable
    public JLabel getMessageLabel() {
        return null;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myShowDetailsButton;
    }

    @NotNull
    public synchronized ProgressIndicator getProgressIndicator() {
        if (this.myProgressIndicator == null) {
            this.myProgressIndicator = new ProgressIndicatorIntegration();
        }
        ProgressIndicator progressIndicator = this.myProgressIndicator;
        if (progressIndicator == null) {
            ProgressStep.$$$reportNull$$$0(3);
        }
        return progressIndicator;
    }

    public void print(@NotNull String s, @NotNull ConsoleViewContentType contentType) {
        if (s == null) {
            ProgressStep.$$$reportNull$$$0(4);
        }
        if (contentType == null) {
            ProgressStep.$$$reportNull$$$0(5);
        }
        this.myHighlighter.setModalityState(ModalityState.stateForComponent((Component)this.myConsole));
        this.myHighlighter.print(s + (s.endsWith("\n") ? "" : "\n"), contentType.getAttributes());
    }

    public void attachToProcess(ProcessHandler processHandler) {
        this.myHighlighter.attachToProcess(processHandler);
    }

    public boolean isCanceled() {
        return this.getProgressIndicator().isCanceled();
    }

    public void showConsole() {
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                JComponent editorComponent = ProgressStep.this.myConsoleEditor.getComponent();
                if (!editorComponent.isVisible()) {
                    ProgressStep.this.myShowDetailsButton.getParent().remove(ProgressStep.this.myShowDetailsButton);
                    editorComponent.setVisible(true);
                }
            }
        });
    }

    public void run(Runnable runnable, double progressPortion) {
        ProgressPortionReporter progress = new ProgressPortionReporter(this.getProgressIndicator(), this.myFraction, progressPortion);
        ProgressManager.getInstance().executeProcessUnderProgress(runnable, (ProgressIndicator)progress);
    }

    private void setFraction(double fraction) {
        this.myFraction = fraction;
        this.myProgressBar.setMaximum(1000);
        this.myProgressBar.setValue((int)(1000.0 * fraction));
    }

    public void advance(double progress) {
        this.getProgressIndicator().setFraction(this.myFraction + progress);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/welcome/wizard/ProgressStep";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/welcome/wizard/ProgressStep";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getProgressIndicator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "print";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JButton jButton;
        JProgressBar jProgressBar;
        JLabel jLabel;
        JPanel jPanel2;
        this.myRoot = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(3, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel3, new GridConstraints(0, 1, 1, 1, 0, 3, 0, 0, null, null, null));
        this.myLabel = jLabel = new JLabel();
        jPanel3.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 0, 1, 0, 0, new Dimension(650, -1), new Dimension(650, -1), new Dimension(650, -1)));
        this.myProgressBar = jProgressBar = new JProgressBar();
        jProgressBar.setIndeterminate(true);
        jPanel3.add((Component)jProgressBar, new GridConstraints(1, 0, 1, 1, 0, 1, 0, 0, new Dimension(650, -1), new Dimension(650, -1), new Dimension(650, -1)));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(0, 0, 1, 1, 0, 1, 6, 1, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel2.add((Component)spacer2, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myShowDetailsButton = jButton = new JButton();
        jButton.setText("Show Details");
        jPanel2.add((Component)jButton, new GridConstraints(1, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer3 = new Spacer();
        jPanel2.add((Component)spacer3, new GridConstraints(2, 0, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myConsole = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel2.add((Component)jPanel, new GridConstraints(2, 1, 1, 1, 0, 3, 2, 2, null, new Dimension(650, 50), null));
        Spacer spacer4 = new Spacer();
        jPanel2.add((Component)spacer4, new GridConstraints(2, 2, 1, 1, 0, 1, 6, 1, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myRoot;
    }

    private class ProgressIndicatorIntegration
    extends ProgressIndicatorBase {
        private ProgressIndicatorIntegration() {
        }

        public void start() {
            super.start();
            this.setIndeterminate(false);
        }

        public void setText(final String text) {
            ApplicationManager.getApplication().invokeLater(new Runnable(){

                @Override
                public void run() {
                    ProgressStep.this.myLabel.setText(text);
                }
            });
        }

        public void setText2(String text) {
            ProgressStep.this.print(text + "\n", ConsoleViewContentType.SYSTEM_OUTPUT);
            super.setText2(text);
        }

        public void stop() {
            ApplicationManager.getApplication().invokeLater(new Runnable(){

                @Override
                public void run() {
                    ProgressStep.this.myLabel.setText(null);
                    ProgressStep.this.myProgressBar.setVisible(false);
                    ProgressStep.this.showConsole();
                }
            }, ModalityState.stateForComponent((Component)ProgressStep.this.myProgressBar));
            super.stop();
        }

        public void setIndeterminate(final boolean indeterminate) {
            ApplicationManager.getApplication().invokeLater(new Runnable(){

                @Override
                public void run() {
                    ProgressStep.this.myProgressBar.setIndeterminate(indeterminate);
                }
            });
        }

        public void setFraction(final double fraction) {
            ApplicationManager.getApplication().invokeLater(new Runnable(){

                @Override
                public void run() {
                    ProgressStep.this.setFraction(fraction);
                }
            });
        }
    }

    public static class ProgressPortionReporter
    extends DelegatingProgressIndicator {
        private final double myStart;
        private final double myPortion;

        /*
         * WARNING - void declaration
         */
        public ProgressPortionReporter(@NotNull ProgressIndicator indicator, double start, double d) {
            void portion;
            if (indicator == null) {
                ProgressPortionReporter.$$$reportNull$$$0(0);
            }
            super(indicator);
            this.myStart = start;
            this.myPortion = portion;
        }

        public void start() {
            this.setFraction(0.0);
        }

        public void stop() {
            this.setFraction(this.myPortion);
        }

        public void setFraction(double fraction) {
            super.setFraction(this.myStart + fraction * this.myPortion);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/android/tools/idea/welcome/wizard/ProgressStep$ProgressPortionReporter", "<init>"));
        }
    }
}

