/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom.wrappers;

import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiTarget;
import com.intellij.psi.impl.RenameableFakePsiElement;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.util.IncorrectOperationException;
import java.io.File;
import javax.swing.Icon;
import org.jetbrains.android.dom.wrappers.ValueResourceElementWrapper;
import org.jetbrains.android.resourceManagers.ValueResourceInfo;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LazyValueResourceElementWrapper
extends RenameableFakePsiElement
implements PsiTarget,
Comparable<LazyValueResourceElementWrapper> {
    private final ValueResourceInfo myResourceInfo;
    private final PsiElement myParent;

    public LazyValueResourceElementWrapper(@NotNull ValueResourceInfo resourceInfo, @NotNull PsiElement parent) {
        if (resourceInfo == null) {
            LazyValueResourceElementWrapper.$$$reportNull$$$0(0);
        }
        if (parent == null) {
            LazyValueResourceElementWrapper.$$$reportNull$$$0(1);
        }
        super(parent);
        this.myParent = parent;
        this.myResourceInfo = resourceInfo;
    }

    public String getName() {
        return this.myResourceInfo.getName();
    }

    @Nullable
    public PsiElement setName(@NonNls @NotNull String name) throws IncorrectOperationException {
        XmlAttributeValue element;
        if (name == null) {
            LazyValueResourceElementWrapper.$$$reportNull$$$0(2);
        }
        if ((element = this.computeElement()) == null) {
            throw new IncorrectOperationException("Cannot find resource '" + this.myResourceInfo.getName() + "' in file " + this.myResourceInfo.getContainingFile().getPath());
        }
        return new ValueResourceElementWrapper(element).setName(name);
    }

    public ItemPresentation getPresentation() {
        return new ItemPresentation(){

            @Nullable
            public String getPresentableText() {
                String name = LazyValueResourceElementWrapper.this.myResourceInfo.getName();
                VirtualFile file = LazyValueResourceElementWrapper.this.myResourceInfo.getContainingFile();
                VirtualFile dir = file.getParent();
                if (dir == null) {
                    return name;
                }
                return name + " (..." + File.separatorChar + dir.getName() + File.separatorChar + file.getName() + ')';
            }

            public String getLocationString() {
                return null;
            }

            public Icon getIcon(boolean open) {
                return null;
            }
        };
    }

    @Nullable
    public XmlAttributeValue computeElement() {
        return this.myResourceInfo.computeXmlElement();
    }

    @NotNull
    public PsiElement getNavigationElement() {
        XmlAttributeValue element = this.myResourceInfo.computeXmlElement();
        Object object = element != null ? element : this.myParent;
        if (object == null) {
            LazyValueResourceElementWrapper.$$$reportNull$$$0(3);
        }
        return object;
    }

    @NotNull
    public ValueResourceInfo getResourceInfo() {
        ValueResourceInfo valueResourceInfo = this.myResourceInfo;
        if (valueResourceInfo == null) {
            LazyValueResourceElementWrapper.$$$reportNull$$$0(4);
        }
        return valueResourceInfo;
    }

    public String getTypeName() {
        return "Android Value Resource";
    }

    public Icon getIcon() {
        return null;
    }

    @Nullable
    public static PsiElement computeLazyElement(PsiElement element) {
        if (element instanceof LazyValueResourceElementWrapper) {
            element = ((LazyValueResourceElementWrapper)element).computeElement();
        }
        return element;
    }

    @Override
    public int compareTo(@NotNull LazyValueResourceElementWrapper other) {
        if (other == null) {
            LazyValueResourceElementWrapper.$$$reportNull$$$0(5);
        }
        return this.myResourceInfo.compareTo(other.myResourceInfo);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resourceInfo";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/android/dom/wrappers/LazyValueResourceElementWrapper";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "other";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/android/dom/wrappers/LazyValueResourceElementWrapper";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getNavigationElement";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getResourceInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "compareTo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

