/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.facet;

import com.android.builder.model.SourceProvider;
import com.android.prefs.AndroidLocation;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.ISystemImage;
import com.android.sdklib.internal.avd.AvdInfo;
import com.android.sdklib.internal.avd.AvdManager;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.tools.idea.AndroidPsiUtils;
import com.android.tools.idea.apk.ApkProjects;
import com.android.tools.idea.configurations.ConfigurationManager;
import com.android.tools.idea.databinding.DataBindingUtil;
import com.android.tools.idea.databinding.LightBrClass;
import com.android.tools.idea.gradle.project.sync.GradleSyncListener;
import com.android.tools.idea.gradle.project.sync.GradleSyncState;
import com.android.tools.idea.model.AndroidModel;
import com.android.tools.idea.model.AndroidModuleInfo;
import com.android.tools.idea.rendering.RenderService;
import com.android.tools.idea.res.AppResourceRepository;
import com.android.tools.idea.res.FileResourceRepository;
import com.android.tools.idea.res.LocalResourceRepository;
import com.android.tools.idea.res.ModuleResourceRepository;
import com.android.tools.idea.res.ProjectResourceRepository;
import com.android.tools.idea.res.ResourceFolderRegistry;
import com.android.tools.idea.run.LaunchCompatibility;
import com.android.tools.idea.sdk.AndroidSdks;
import com.android.tools.idea.templates.TemplateManager;
import com.android.utils.ILogger;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.intellij.CommonBundle;
import com.intellij.ProjectTopics;
import com.intellij.facet.Facet;
import com.intellij.facet.FacetConfiguration;
import com.intellij.facet.FacetManager;
import com.intellij.facet.FacetType;
import com.intellij.facet.FacetTypeId;
import com.intellij.facet.FacetTypeRegistry;
import com.intellij.facet.ModifiableFacetModel;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.Anchor;
import com.intellij.openapi.actionSystem.Constraints;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkModificator;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.ModuleRootAdapter;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.ThreeState;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.DomElement;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.android.compiler.AndroidAutogeneratorMode;
import org.jetbrains.android.compiler.AndroidCompileUtil;
import org.jetbrains.android.dom.manifest.Manifest;
import org.jetbrains.android.facet.AndroidFacetConfiguration;
import org.jetbrains.android.facet.AndroidFacetType;
import org.jetbrains.android.facet.AndroidResourceFilesListener;
import org.jetbrains.android.facet.AndroidRootUtil;
import org.jetbrains.android.facet.IdeaSourceProvider;
import org.jetbrains.android.facet.LayoutViewClassUtils;
import org.jetbrains.android.facet.ResourceFolderManager;
import org.jetbrains.android.resourceManagers.LocalResourceManager;
import org.jetbrains.android.resourceManagers.ResourceManager;
import org.jetbrains.android.resourceManagers.SystemResourceManager;
import org.jetbrains.android.sdk.AndroidPlatform;
import org.jetbrains.android.sdk.AndroidSdkData;
import org.jetbrains.android.sdk.AndroidSdkType;
import org.jetbrains.android.sdk.AvdManagerLog;
import org.jetbrains.android.sdk.MessageBuildingSdkLog;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.android.model.impl.JpsAndroidModuleProperties;

public class AndroidFacet
extends Facet<AndroidFacetConfiguration> {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.android.facet.AndroidFacet");
    public static final FacetTypeId<AndroidFacet> ID = new FacetTypeId("android");
    public static final String NAME = "Android";
    private static final Object APP_RESOURCES_LOCK = new Object();
    private static final Object PROJECT_RESOURCES_LOCK = new Object();
    private static final Object MODULE_RESOURCES_LOCK = new Object();
    private static boolean ourDynamicTemplateMenuCreated;
    private AvdManager myAvdManager;
    private AndroidSdkData mySdkData;
    private AndroidSdkHandler myHandler;
    private boolean myDataBindingEnabled;
    private SystemResourceManager myPublicSystemResourceManager;
    private SystemResourceManager myFullSystemResourceManager;
    private LocalResourceManager myLocalResourceManager;
    private final Map<String, Map<String, SmartPsiElementPointer<PsiClass>>> myInitialClassMaps;
    private Map<String, CachedValue<Map<String, PsiClass>>> myClassMaps;
    private final Object myClassMapLock;
    private final Set<AndroidAutogeneratorMode> myDirtyModes;
    private final Map<AndroidAutogeneratorMode, Set<String>> myAutogeneratedFiles;
    private volatile boolean myAutogenerationEnabled;
    private ConfigurationManager myConfigurationManager;
    private LocalResourceRepository myModuleResources;
    private AppResourceRepository myAppResources;
    private ProjectResourceRepository myProjectResources;
    private AndroidModel myAndroidModel;
    private final ResourceFolderManager myFolderManager;
    private SourceProvider myMainSourceSet;
    private IdeaSourceProvider myMainIdeaSourceSet;
    private final AndroidModuleInfo myAndroidModuleInfo;
    private RenderService myRenderService;
    private LightBrClass myLightBrClass;

    @Nullable
    public static AndroidFacet getInstance(@NotNull Module module, @NotNull IdeModifiableModelsProvider modelsProvider) {
        AndroidFacet facet;
        if (module == null) {
            AndroidFacet.$$$reportNull$$$0(0);
        }
        if (modelsProvider == null) {
            AndroidFacet.$$$reportNull$$$0(1);
        }
        if ((facet = AndroidFacet.getInstance(module)) == null) {
            ModifiableFacetModel facetModel = modelsProvider.getModifiableFacetModel(module);
            facet = (AndroidFacet)facetModel.getFacetByType(ID);
        }
        return facet;
    }

    @Nullable
    public static AndroidFacet getInstance(@NotNull Module module) {
        if (module == null) {
            AndroidFacet.$$$reportNull$$$0(2);
        }
        return (AndroidFacet)FacetManager.getInstance((Module)module).getFacetByType(ID);
    }

    @Nullable
    public static AndroidFacet getInstance(@NotNull ConvertContext context) {
        Module module;
        if (context == null) {
            AndroidFacet.$$$reportNull$$$0(3);
        }
        return (module = context.getModule()) != null ? AndroidFacet.getInstance(module) : null;
    }

    @Nullable
    public static AndroidFacet getInstance(@NotNull PsiElement element) {
        Module module;
        if (element == null) {
            AndroidFacet.$$$reportNull$$$0(4);
        }
        return (module = AndroidPsiUtils.getModuleSafely(element)) != null && !module.isDisposed() ? AndroidFacet.getInstance(module) : null;
    }

    @Nullable
    public static AndroidFacet getInstance(@NotNull DomElement element) {
        Module module;
        if (element == null) {
            AndroidFacet.$$$reportNull$$$0(5);
        }
        return (module = element.getModule()) != null ? AndroidFacet.getInstance(module) : null;
    }

    public AndroidFacet(@NotNull Module module, String name, @NotNull AndroidFacetConfiguration configuration) {
        if (module == null) {
            AndroidFacet.$$$reportNull$$$0(6);
        }
        if (configuration == null) {
            AndroidFacet.$$$reportNull$$$0(7);
        }
        super((FacetType)AndroidFacet.getFacetType(), module, name, (FacetConfiguration)configuration, null);
        this.myAvdManager = null;
        this.myDataBindingEnabled = false;
        this.myInitialClassMaps = Maps.newHashMap();
        this.myClassMaps = Maps.newHashMap();
        this.myClassMapLock = new Object();
        this.myDirtyModes = EnumSet.noneOf(AndroidAutogeneratorMode.class);
        this.myAutogeneratedFiles = Maps.newHashMap();
        this.myAutogenerationEnabled = false;
        this.myFolderManager = new ResourceFolderManager(this);
        this.myAndroidModuleInfo = AndroidModuleInfo.create(this);
        configuration.setFacet(this);
    }

    public boolean isAutogenerationEnabled() {
        return this.myAutogenerationEnabled;
    }

    public boolean requiresAndroidModel() {
        return !this.getProperties().ALLOW_USER_CONFIGURATION && !ApkProjects.isApkProject(this.getModule());
    }

    @Nullable
    public AndroidModel getAndroidModel() {
        return this.myAndroidModel;
    }

    public void setAndroidModel(@Nullable AndroidModel androidModel) {
        this.myAndroidModel = androidModel;
        DataBindingUtil.onIdeaProjectSet(this);
    }

    public boolean isAppProject() {
        int projectType = this.getProjectType();
        return projectType == 0 || projectType == 4;
    }

    public boolean canBeDependency() {
        int projectType = this.getProjectType();
        return projectType == 1 || projectType == 3;
    }

    public boolean isLibraryProject() {
        return this.getProjectType() == 1;
    }

    public int getProjectType() {
        return this.getProperties().PROJECT_TYPE;
    }

    public void setProjectType(int type) {
        this.getProperties().PROJECT_TYPE = type;
    }

    @NotNull
    public SourceProvider getMainSourceProvider() {
        if (this.myAndroidModel != null) {
            SourceProvider sourceProvider = this.myAndroidModel.getDefaultSourceProvider();
            if (sourceProvider == null) {
                AndroidFacet.$$$reportNull$$$0(8);
            }
            return sourceProvider;
        }
        if (this.myMainSourceSet == null) {
            this.myMainSourceSet = new LegacySourceProvider();
        }
        SourceProvider sourceProvider = this.myMainSourceSet;
        if (sourceProvider == null) {
            AndroidFacet.$$$reportNull$$$0(9);
        }
        return sourceProvider;
    }

    @NotNull
    public IdeaSourceProvider getMainIdeaSourceProvider() {
        if (!this.requiresAndroidModel()) {
            if (this.myMainIdeaSourceSet == null) {
                this.myMainIdeaSourceSet = IdeaSourceProvider.create(this);
            }
        } else {
            SourceProvider mainSourceSet = this.getMainSourceProvider();
            if (this.myMainIdeaSourceSet == null || mainSourceSet != this.myMainSourceSet) {
                this.myMainIdeaSourceSet = IdeaSourceProvider.create(mainSourceSet);
            }
        }
        IdeaSourceProvider ideaSourceProvider = this.myMainIdeaSourceSet;
        if (ideaSourceProvider == null) {
            AndroidFacet.$$$reportNull$$$0(10);
        }
        return ideaSourceProvider;
    }

    public ResourceFolderManager getResourceFolderManager() {
        return this.myFolderManager;
    }

    @NotNull
    public List<VirtualFile> getAllResourceDirectories() {
        List<VirtualFile> list = this.myFolderManager.getFolders();
        if (list == null) {
            AndroidFacet.$$$reportNull$$$0(11);
        }
        return list;
    }

    @Deprecated
    @Nullable
    public VirtualFile getPrimaryResourceDir() {
        List<VirtualFile> dirs = this.getAllResourceDirectories();
        if (!dirs.isEmpty()) {
            return dirs.get(0);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isGeneratedFileRemoved(@NotNull AndroidAutogeneratorMode mode) {
        if (mode == null) {
            AndroidFacet.$$$reportNull$$$0(12);
        }
        Map<AndroidAutogeneratorMode, Set<String>> map = this.myAutogeneratedFiles;
        synchronized (map) {
            Set<String> filePaths = this.myAutogeneratedFiles.get((Object)mode);
            if (filePaths != null) {
                for (String path : filePaths) {
                    VirtualFile file = LocalFileSystem.getInstance().findFileByPath(path);
                    if (file != null) continue;
                    return true;
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearAutogeneratedFiles(@NotNull AndroidAutogeneratorMode mode) {
        if (mode == null) {
            AndroidFacet.$$$reportNull$$$0(13);
        }
        Map<AndroidAutogeneratorMode, Set<String>> map = this.myAutogeneratedFiles;
        synchronized (map) {
            Set<String> set = this.myAutogeneratedFiles.get((Object)mode);
            if (set != null) {
                set.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markFileAutogenerated(@NotNull AndroidAutogeneratorMode mode, @NotNull VirtualFile file) {
        if (mode == null) {
            AndroidFacet.$$$reportNull$$$0(14);
        }
        if (file == null) {
            AndroidFacet.$$$reportNull$$$0(15);
        }
        Map<AndroidAutogeneratorMode, Set<String>> map = this.myAutogeneratedFiles;
        synchronized (map) {
            HashSet set = this.myAutogeneratedFiles.get((Object)mode);
            if (set == null) {
                set = Sets.newHashSet();
                this.myAutogeneratedFiles.put(mode, set);
            }
            set.add(file.getPath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public Set<String> getAutogeneratedFiles(@NotNull AndroidAutogeneratorMode mode) {
        if (mode == null) {
            AndroidFacet.$$$reportNull$$$0(16);
        }
        Map<AndroidAutogeneratorMode, Set<String>> map = this.myAutogeneratedFiles;
        // MONITORENTER : map
        Set<String> set = this.myAutogeneratedFiles.get((Object)mode);
        HashSet hashSet = set != null ? Sets.newHashSet(set) : Collections.emptySet();
        // MONITOREXIT : map
        if (hashSet != null) return hashSet;
        AndroidFacet.$$$reportNull$$$0(17);
        return hashSet;
    }

    private void activateSourceAutogenerating() {
        this.myAutogenerationEnabled = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearClassMaps() {
        Object object = this.myClassMapLock;
        synchronized (object) {
            this.myInitialClassMaps.clear();
        }
    }

    public void androidPlatformChanged() {
        this.myAvdManager = null;
        this.myLocalResourceManager = null;
        this.myPublicSystemResourceManager = null;
        this.clearClassMaps();
    }

    @NotNull
    public AvdInfo[] getAllAvds() {
        AvdManager manager = this.getAvdManagerSilently();
        if (manager != null && this.reloadAvds(manager)) {
            AvdInfo[] avdInfoArray = manager.getAllAvds();
            if (avdInfoArray == null) {
                AndroidFacet.$$$reportNull$$$0(18);
            }
            return avdInfoArray;
        }
        AvdInfo[] avdInfoArray = new AvdInfo[]{};
        if (avdInfoArray == null) {
            AndroidFacet.$$$reportNull$$$0(19);
        }
        return avdInfoArray;
    }

    private boolean reloadAvds(AvdManager manager) {
        try {
            MessageBuildingSdkLog log = new MessageBuildingSdkLog();
            manager.reloadAvds((ILogger)log);
            if (!log.getErrorMessage().isEmpty()) {
                String message = AndroidBundle.message("cant.load.avds.error.prefix", new Object[0]) + ' ' + log.getErrorMessage();
                Messages.showErrorDialog((Project)this.getModule().getProject(), (String)message, (String)CommonBundle.getErrorTitle());
            }
            return true;
        }
        catch (AndroidLocation.AndroidLocationException e) {
            Messages.showErrorDialog((Project)this.getModule().getProject(), (String)AndroidBundle.message("cant.load.avds.error", new Object[0]), (String)CommonBundle.getErrorTitle());
            return false;
        }
    }

    @NotNull
    public AvdInfo[] getValidCompatibleAvds() {
        AvdManager manager = this.getAvdManagerSilently();
        ArrayList result = Lists.newArrayList();
        if (manager != null && this.reloadAvds(manager)) {
            this.addCompatibleAvds(result, manager.getValidAvds());
        }
        AvdInfo[] avdInfoArray = result.toArray(new AvdInfo[result.size()]);
        if (avdInfoArray == null) {
            AndroidFacet.$$$reportNull$$$0(20);
        }
        return avdInfoArray;
    }

    @NotNull
    private AvdInfo[] addCompatibleAvds(@NotNull List<AvdInfo> to, @NotNull AvdInfo[] from) {
        if (to == null) {
            AndroidFacet.$$$reportNull$$$0(21);
        }
        if (from == null) {
            AndroidFacet.$$$reportNull$$$0(22);
        }
        AndroidVersion minSdk = AndroidModuleInfo.get(this).getRuntimeMinSdkVersion();
        AndroidPlatform platform = ((AndroidFacetConfiguration)this.getConfiguration()).getAndroidPlatform();
        if (platform == null) {
            LOG.error("Android Platform not set for module: " + this.getModule().getName());
            AvdInfo[] avdInfoArray = new AvdInfo[]{};
            if (avdInfoArray == null) {
                AndroidFacet.$$$reportNull$$$0(23);
            }
            return avdInfoArray;
        }
        for (AvdInfo avd : from) {
            ISystemImage systemImage = avd.getSystemImage();
            if (systemImage != null && LaunchCompatibility.canRunOnAvd(minSdk, platform.getTarget(), systemImage).isCompatible() == ThreeState.NO) continue;
            to.add(avd);
        }
        AvdInfo[] avdInfoArray = to.toArray(new AvdInfo[to.size()]);
        if (avdInfoArray == null) {
            AndroidFacet.$$$reportNull$$$0(24);
        }
        return avdInfoArray;
    }

    @Nullable
    public AvdManager getAvdManagerSilently() {
        try {
            return this.getAvdManager(new AvdManagerLog());
        }
        catch (AndroidLocation.AndroidLocationException androidLocationException) {
            return null;
        }
    }

    public AvdManager getAvdManager(ILogger log) throws AndroidLocation.AndroidLocationException {
        if (this.myAvdManager == null) {
            this.getSdkData();
            this.myAvdManager = AvdManager.getInstance((AndroidSdkHandler)this.myHandler, (ILogger)log);
        }
        return this.myAvdManager;
    }

    @Nullable
    public AndroidSdkData getSdkData() {
        if (this.mySdkData == null) {
            AndroidPlatform platform = ((AndroidFacetConfiguration)this.getConfiguration()).getAndroidPlatform();
            if (platform != null) {
                this.mySdkData = platform.getSdkData();
                this.myHandler = this.mySdkData.getSdkHandler();
            } else {
                this.mySdkData = null;
                this.myHandler = AndroidSdkHandler.getInstance(null);
            }
        }
        return this.mySdkData;
    }

    public static void createDynamicTemplateMenu() {
        if (ourDynamicTemplateMenuCreated) {
            return;
        }
        ourDynamicTemplateMenuCreated = true;
        DefaultActionGroup newGroup = (DefaultActionGroup)ActionManager.getInstance().getAction("NewGroup");
        newGroup.addSeparator();
        ActionGroup menu = TemplateManager.getInstance().getTemplateCreationMenu(null);
        if (menu != null) {
            newGroup.add((AnAction)menu, new Constraints(Anchor.AFTER, "NewFromTemplate"));
        }
    }

    public void initFacet() {
        StartupManager.getInstance((Project)this.getModule().getProject()).runWhenProjectIsInitialized(() -> {
            AndroidResourceFilesListener.notifyFacetInitialized(this);
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                return;
            }
            this.addResourceFolderToSdkRootsIfNecessary();
            ApplicationManager.getApplication().executeOnPooledThread(() -> {
                Module module = this.getModule();
                Project project = module.getProject();
                if (project.isDisposed()) {
                    return;
                }
                AndroidCompileUtil.generate(module, AndroidAutogeneratorMode.AAPT);
                AndroidCompileUtil.generate(module, AndroidAutogeneratorMode.AIDL);
                AndroidCompileUtil.generate(module, AndroidAutogeneratorMode.RENDERSCRIPT);
                AndroidCompileUtil.generate(module, AndroidAutogeneratorMode.BUILDCONFIG);
                this.activateSourceAutogenerating();
            });
        });
        this.getModule().getMessageBus().connect((Disposable)this).subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new ModuleRootAdapter(){
            private Sdk myPrevSdk;

            public void rootsChanged(ModuleRootEvent event) {
                ApplicationManager.getApplication().invokeLater(() -> {
                    if (AndroidFacet.this.isDisposed()) {
                        return;
                    }
                    ModuleRootManager rootManager = ModuleRootManager.getInstance((Module)AndroidFacet.this.getModule());
                    Sdk newSdk = rootManager.getSdk();
                    if (newSdk != null && newSdk.getSdkType() instanceof AndroidSdkType && !newSdk.equals(this.myPrevSdk)) {
                        AndroidFacet.this.androidPlatformChanged();
                        Set set = AndroidFacet.this.myDirtyModes;
                        synchronized (set) {
                            AndroidFacet.this.myDirtyModes.addAll(Arrays.asList(AndroidAutogeneratorMode.values()));
                        }
                    } else {
                        AndroidFacet.this.clearClassMaps();
                    }
                    this.myPrevSdk = newSdk;
                    AndroidFacet.this.getLocalResourceManager().invalidateAttributeDefinitions();
                });
            }
        });
        AndroidFacet.createDynamicTemplateMenu();
    }

    private void addResourceFolderToSdkRootsIfNecessary() {
        Module module = this.getModule();
        if (module.isDisposed()) {
            return;
        }
        Sdk sdk = ModuleRootManager.getInstance((Module)module).getSdk();
        if (sdk == null || !AndroidSdks.getInstance().isAndroidSdk(sdk)) {
            return;
        }
        AndroidPlatform platform = AndroidPlatform.getInstance(sdk);
        if (platform == null) {
            return;
        }
        String resFolderPath = platform.getTarget().getPath(11);
        if (resFolderPath == null) {
            return;
        }
        ArrayList filesToAdd = Lists.newArrayList();
        VirtualFile resFolder = LocalFileSystem.getInstance().findFileByPath(FileUtil.toSystemIndependentName((String)resFolderPath));
        if (resFolder != null) {
            filesToAdd.add(resFolder);
        }
        if (platform.needToAddAnnotationsJarToClasspath()) {
            String sdkHomePath = FileUtil.toSystemIndependentName((String)platform.getSdkData().getLocation().getPath());
            VirtualFile annotationsJar = JarFileSystem.getInstance().findFileByPath(sdkHomePath + "/tools/support/annotations.jar" + "!/");
            if (annotationsJar != null) {
                filesToAdd.add(annotationsJar);
            }
        }
        AndroidFacet.addFilesToSdkIfNecessary(sdk, filesToAdd);
    }

    private static void addFilesToSdkIfNecessary(@NotNull Sdk sdk, @NotNull Collection<VirtualFile> files) {
        if (sdk == null) {
            AndroidFacet.$$$reportNull$$$0(25);
        }
        if (files == null) {
            AndroidFacet.$$$reportNull$$$0(26);
        }
        ArrayList newFiles = Lists.newArrayList(files);
        newFiles.removeAll(Arrays.asList(sdk.getRootProvider().getFiles(OrderRootType.CLASSES)));
        if (newFiles.size() > 0) {
            SdkModificator modificator = sdk.getSdkModificator();
            for (VirtualFile file : newFiles) {
                modificator.addRoot(file, OrderRootType.CLASSES);
            }
            modificator.commitChanges();
        }
    }

    public void disposeFacet() {
        if (this.myConfigurationManager != null) {
            Disposer.dispose((Disposable)this.myConfigurationManager);
        }
        this.myAndroidModel = null;
    }

    @Nullable
    public ResourceManager getResourceManager(@Nullable String resourcePackage) {
        return this.getResourceManager(resourcePackage, null);
    }

    @Nullable
    public ResourceManager getResourceManager(@Nullable String resourcePackage, @Nullable PsiElement contextElement) {
        if ("android".equals(resourcePackage)) {
            return this.getSystemResourceManager();
        }
        if (contextElement != null && AndroidFacet.isInAndroidSdk(contextElement)) {
            return this.getSystemResourceManager();
        }
        return this.getLocalResourceManager();
    }

    public static boolean isInAndroidSdk(PsiElement element) {
        PsiFile file = element.getContainingFile();
        if (file == null) {
            return false;
        }
        VirtualFile virtualFile = file.getVirtualFile();
        if (virtualFile == null) {
            return false;
        }
        ProjectFileIndex projectFileIndex = ProjectRootManager.getInstance((Project)element.getProject()).getFileIndex();
        List entries = projectFileIndex.getOrderEntriesForFile(virtualFile);
        for (OrderEntry entry : entries) {
            Sdk sdk;
            if (!(entry instanceof JdkOrderEntry) || (sdk = ((JdkOrderEntry)entry).getJdk()) == null || !(sdk.getSdkType() instanceof AndroidSdkType)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public LocalResourceManager getLocalResourceManager() {
        if (this.myLocalResourceManager == null) {
            this.myLocalResourceManager = new LocalResourceManager(this);
        }
        LocalResourceManager localResourceManager = this.myLocalResourceManager;
        if (localResourceManager == null) {
            AndroidFacet.$$$reportNull$$$0(27);
        }
        return localResourceManager;
    }

    @Nullable
    public SystemResourceManager getSystemResourceManager() {
        return this.getSystemResourceManager(true);
    }

    @Nullable
    public SystemResourceManager getSystemResourceManager(boolean publicOnly) {
        AndroidPlatform platform;
        if (publicOnly) {
            AndroidPlatform platform2;
            if (this.myPublicSystemResourceManager == null && (platform2 = ((AndroidFacetConfiguration)this.getConfiguration()).getAndroidPlatform()) != null) {
                this.myPublicSystemResourceManager = new SystemResourceManager(this.getModule().getProject(), platform2, true);
            }
            return this.myPublicSystemResourceManager;
        }
        if (this.myFullSystemResourceManager == null && (platform = ((AndroidFacetConfiguration)this.getConfiguration()).getAndroidPlatform()) != null) {
            this.myFullSystemResourceManager = new SystemResourceManager(this.getModule().getProject(), platform, false);
        }
        return this.myFullSystemResourceManager;
    }

    @Nullable
    public Manifest getManifest() {
        VirtualFile manifestFile = this.getMainIdeaSourceProvider().getManifestFile();
        return manifestFile != null ? AndroidUtils.loadDomElement(this.getModule(), manifestFile, Manifest.class) : null;
    }

    @NotNull
    public static AndroidFacetType getFacetType() {
        AndroidFacetType androidFacetType = (AndroidFacetType)FacetTypeRegistry.getInstance().findFacetType(ID);
        if (androidFacetType == null) {
            AndroidFacet.$$$reportNull$$$0(28);
        }
        return androidFacetType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public Map<String, PsiClass> getClassMap(@NotNull String className) {
        CachedValue value;
        if (className == null) {
            AndroidFacet.$$$reportNull$$$0(29);
        }
        Object object = this.myClassMapLock;
        synchronized (object) {
            value = this.myClassMaps.get(className);
            if (value == null) {
                value = CachedValuesManager.getManager((Project)this.getModule().getProject()).createCachedValue(() -> {
                    if (className == null) {
                        AndroidFacet.$$$reportNull$$$0(47);
                    }
                    Map<String, PsiClass> map = this.computeClassMap(className);
                    return CachedValueProvider.Result.create(map, (Object[])new Object[]{PsiModificationTracker.JAVA_STRUCTURE_MODIFICATION_COUNT});
                }, false);
                this.myClassMaps.put(className, (CachedValue<Map<String, PsiClass>>)value);
            }
        }
        Map map = (Map)value.getValue();
        if (map == null) {
            AndroidFacet.$$$reportNull$$$0(30);
        }
        return map;
    }

    @NotNull
    private Map<String, PsiClass> computeClassMap(@NotNull String className) {
        PsiClass aClass;
        SmartPsiElementPointer<PsiClass> pointer;
        if (className == null) {
            AndroidFacet.$$$reportNull$$$0(31);
        }
        Map<String, SmartPsiElementPointer<PsiClass>> classMap = this.getInitialClassMap(className, false);
        HashMap result = Maps.newHashMap();
        boolean shouldRebuildInitialMap = false;
        for (String key : classMap.keySet()) {
            pointer = classMap.get(key);
            if (!AndroidFacet.isUpToDate(pointer, key)) {
                shouldRebuildInitialMap = true;
                break;
            }
            aClass = (PsiClass)pointer.getElement();
            if (aClass == null) continue;
            result.put(key, aClass);
        }
        if (shouldRebuildInitialMap) {
            result.clear();
            classMap = this.getInitialClassMap(className, true);
            for (String key : classMap.keySet()) {
                pointer = classMap.get(key);
                aClass = (PsiClass)pointer.getElement();
                if (aClass == null) continue;
                result.put(key, aClass);
            }
        }
        Project project = this.getModule().getProject();
        this.fillMap(className, ProjectScope.getProjectScope((Project)project), result, false);
        HashMap hashMap = result;
        if (hashMap == null) {
            AndroidFacet.$$$reportNull$$$0(32);
        }
        return hashMap;
    }

    private static boolean isUpToDate(SmartPsiElementPointer<PsiClass> pointer, String tagName) {
        PsiClass aClass = (PsiClass)pointer.getElement();
        if (aClass == null) {
            return false;
        }
        Object[] tagNames = LayoutViewClassUtils.getTagNamesByClass(aClass, -1);
        return ArrayUtilRt.find((Object[])tagNames, (Object)tagName) >= 0;
    }

    @NotNull
    private Map<String, SmartPsiElementPointer<PsiClass>> getInitialClassMap(@NotNull String className, boolean forceRebuild) {
        HashMap viewClassMap;
        if (className == null) {
            AndroidFacet.$$$reportNull$$$0(33);
        }
        if ((viewClassMap = this.myInitialClassMaps.get(className)) != null && !forceRebuild) {
            HashMap hashMap = viewClassMap;
            if (hashMap == null) {
                AndroidFacet.$$$reportNull$$$0(34);
            }
            return hashMap;
        }
        HashMap map = Maps.newHashMap();
        if (this.fillMap(className, this.getModule().getModuleWithDependenciesAndLibrariesScope(true), map, true)) {
            viewClassMap = Maps.newHashMapWithExpectedSize((int)map.size());
            SmartPointerManager manager = SmartPointerManager.getInstance((Project)this.getModule().getProject());
            for (Map.Entry entry : map.entrySet()) {
                viewClassMap.put(entry.getKey(), manager.createSmartPsiElementPointer((PsiElement)entry.getValue()));
            }
            this.myInitialClassMaps.put(className, viewClassMap);
        }
        Map map2 = viewClassMap != null ? viewClassMap : Collections.emptyMap();
        if (map2 == null) {
            AndroidFacet.$$$reportNull$$$0(35);
        }
        return map2;
    }

    private boolean fillMap(@NotNull String className, @NotNull GlobalSearchScope scope, Map<String, PsiClass> map, boolean libClassesOnly) {
        if (className == null) {
            AndroidFacet.$$$reportNull$$$0(36);
        }
        if (scope == null) {
            AndroidFacet.$$$reportNull$$$0(37);
        }
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)this.getModule().getProject());
        PsiClass baseClass = (PsiClass)ApplicationManager.getApplication().runReadAction(() -> {
            PsiClass aClass;
            if (className == null) {
                AndroidFacet.$$$reportNull$$$0(46);
            }
            try {
                aClass = facade.findClass(className, this.getModule().getModuleWithDependenciesAndLibrariesScope(true));
            }
            catch (IndexNotReadyException e) {
                aClass = null;
            }
            return aClass;
        });
        if (baseClass != null) {
            String[] baseClassTagNames;
            for (String tagName : baseClassTagNames = LayoutViewClassUtils.getTagNamesByClass(baseClass, this.getModuleMinApi())) {
                map.put(tagName, baseClass);
            }
            try {
                ClassInheritorsSearch.search((PsiClass)baseClass, (SearchScope)scope, (boolean)true).forEach(c -> {
                    String[] tagNames;
                    if (libClassesOnly && c.getManager().isInProject((PsiElement)c)) {
                        return true;
                    }
                    for (String tagName : tagNames = LayoutViewClassUtils.getTagNamesByClass(c, this.getModuleMinApi())) {
                        map.put(tagName, (PsiClass)c);
                    }
                    return true;
                });
            }
            catch (IndexNotReadyException e) {
                LOG.info((Throwable)e);
                return false;
            }
        }
        return map.size() > 0;
    }

    public int getModuleMinApi() {
        return this.getAndroidModuleInfo().getMinSdkVersion().getApiLevel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scheduleSourceRegenerating(@NotNull AndroidAutogeneratorMode mode) {
        if (mode == null) {
            AndroidFacet.$$$reportNull$$$0(38);
        }
        Set<AndroidAutogeneratorMode> set = this.myDirtyModes;
        synchronized (set) {
            this.myDirtyModes.add(mode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean cleanRegeneratingState(@NotNull AndroidAutogeneratorMode mode) {
        if (mode == null) {
            AndroidFacet.$$$reportNull$$$0(39);
        }
        Set<AndroidAutogeneratorMode> set = this.myDirtyModes;
        synchronized (set) {
            return this.myDirtyModes.remove((Object)mode);
        }
    }

    @NotNull
    public ConfigurationManager getConfigurationManager() {
        ConfigurationManager configurationManager = this.getConfigurationManager(true);
        if (configurationManager == null) {
            AndroidFacet.$$$reportNull$$$0(40);
        }
        return configurationManager;
    }

    @Contract(value="true -> !null")
    @Nullable
    public ConfigurationManager getConfigurationManager(boolean createIfNecessary) {
        if (this.myConfigurationManager == null && createIfNecessary) {
            this.myConfigurationManager = ConfigurationManager.create(this.getModule());
            Disposer.register((Disposable)this, (Disposable)this.myConfigurationManager);
        }
        return this.myConfigurationManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Contract(value="true -> !null")
    @Nullable
    public AppResourceRepository getAppResources(boolean createIfNecessary) {
        Object object = APP_RESOURCES_LOCK;
        synchronized (object) {
            if (this.myAppResources == null && createIfNecessary) {
                this.myAppResources = AppResourceRepository.create(this);
                Disposer.register((Disposable)this, (Disposable)this.myAppResources);
            }
            return this.myAppResources;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Contract(value="true -> !null")
    @Nullable
    public ProjectResourceRepository getProjectResources(boolean createIfNecessary) {
        Object object = PROJECT_RESOURCES_LOCK;
        synchronized (object) {
            if (this.myProjectResources == null && createIfNecessary) {
                this.myProjectResources = ProjectResourceRepository.create(this);
                Disposer.register((Disposable)this, (Disposable)this.myProjectResources);
            }
            return this.myProjectResources;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Contract(value="true -> !null")
    @Nullable
    public LocalResourceRepository getModuleResources(boolean createIfNecessary) {
        Object object = MODULE_RESOURCES_LOCK;
        synchronized (object) {
            if (this.myModuleResources == null && createIfNecessary) {
                this.myModuleResources = ModuleResourceRepository.create(this);
                Disposer.register((Disposable)this, (Disposable)this.myModuleResources);
            }
            return this.myModuleResources;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshResources() {
        Object object = MODULE_RESOURCES_LOCK;
        synchronized (object) {
            if (this.myModuleResources != null) {
                Disposer.dispose((Disposable)this.myModuleResources);
                this.myModuleResources = null;
            }
        }
        object = PROJECT_RESOURCES_LOCK;
        synchronized (object) {
            if (this.myProjectResources != null) {
                Disposer.dispose((Disposable)this.myProjectResources);
                this.myProjectResources = null;
            }
        }
        object = APP_RESOURCES_LOCK;
        synchronized (object) {
            if (this.myAppResources != null) {
                Disposer.dispose((Disposable)this.myAppResources);
                this.myAppResources = null;
            }
        }
        this.myConfigurationManager.getResolverCache().reset();
        ResourceFolderRegistry.reset();
        FileResourceRepository.reset();
    }

    @NotNull
    public JpsAndroidModuleProperties getProperties() {
        JpsAndroidModuleProperties state = ((AndroidFacetConfiguration)this.getConfiguration()).getState();
        assert (state != null);
        JpsAndroidModuleProperties jpsAndroidModuleProperties = state;
        if (jpsAndroidModuleProperties == null) {
            AndroidFacet.$$$reportNull$$$0(41);
        }
        return jpsAndroidModuleProperties;
    }

    public boolean isDataBindingEnabled() {
        return this.myDataBindingEnabled;
    }

    public void setDataBindingEnabled(boolean dataBindingEnabled) {
        this.myDataBindingEnabled = dataBindingEnabled;
    }

    @NotNull
    public Disposable addListener(@NotNull GradleSyncListener listener) {
        if (listener == null) {
            AndroidFacet.$$$reportNull$$$0(42);
        }
        Module module = this.getModule();
        MessageBusConnection messageBusConnection = GradleSyncState.subscribe(module.getProject(), listener, (Disposable)module);
        if (messageBusConnection == null) {
            AndroidFacet.$$$reportNull$$$0(43);
        }
        return messageBusConnection;
    }

    @NotNull
    public AndroidModuleInfo getAndroidModuleInfo() {
        AndroidModuleInfo androidModuleInfo = this.myAndroidModuleInfo;
        if (androidModuleInfo == null) {
            AndroidFacet.$$$reportNull$$$0(44);
        }
        return androidModuleInfo;
    }

    @NotNull
    public RenderService getRenderService() {
        if (this.myRenderService == null) {
            this.myRenderService = new RenderService(this);
        }
        RenderService renderService = this.myRenderService;
        if (renderService == null) {
            AndroidFacet.$$$reportNull$$$0(45);
        }
        return renderService;
    }

    public void setRenderService(@Nullable RenderService renderService) {
        this.myRenderService = renderService;
    }

    public void setLightBrClass(LightBrClass lightBrClass) {
        this.myLightBrClass = lightBrClass;
    }

    public LightBrClass getLightBrClass() {
        return this.myLightBrClass;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 23: 
            case 24: 
            case 27: 
            case 28: 
            case 30: 
            case 32: 
            case 34: 
            case 35: 
            case 40: 
            case 41: 
            case 43: 
            case 44: 
            case 45: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 23: 
            case 24: 
            case 27: 
            case 28: 
            case 30: 
            case 32: 
            case 34: 
            case 35: 
            case 40: 
            case 41: 
            case 43: 
            case 44: 
            case 45: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelsProvider";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 23: 
            case 24: 
            case 27: 
            case 28: 
            case 30: 
            case 32: 
            case 34: 
            case 35: 
            case 40: 
            case 41: 
            case 43: 
            case 44: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/android/facet/AndroidFacet";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 38: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mode";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "to";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 29: 
            case 31: 
            case 33: 
            case 36: 
            case 46: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "className";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/android/facet/AndroidFacet";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getMainSourceProvider";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getMainIdeaSourceProvider";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllResourceDirectories";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getAutogeneratedFiles";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllAvds";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getValidCompatibleAvds";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "addCompatibleAvds";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocalResourceManager";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getFacetType";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassMap";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "computeClassMap";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getInitialClassMap";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurationManager";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "getProperties";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "addListener";
                break;
            }
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "getAndroidModuleInfo";
                break;
            }
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "getRenderService";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 23: 
            case 24: 
            case 27: 
            case 28: 
            case 30: 
            case 32: 
            case 34: 
            case 35: 
            case 40: 
            case 41: 
            case 43: 
            case 44: 
            case 45: {
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isGeneratedFileRemoved";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "clearAutogeneratedFiles";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "markFileAutogenerated";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getAutogeneratedFiles";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "addCompatibleAvds";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "addFilesToSdkIfNecessary";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getClassMap";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "computeClassMap";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getInitialClassMap";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "fillMap";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "scheduleSourceRegenerating";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "cleanRegeneratingState";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "addListener";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "lambda$fillMap$3";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getClassMap$2";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 23: 
            case 24: 
            case 27: 
            case 28: 
            case 30: 
            case 32: 
            case 34: 
            case 35: 
            case 40: 
            case 41: 
            case 43: 
            case 44: 
            case 45: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class LegacySourceProvider
    implements SourceProvider {
        private LegacySourceProvider() {
        }

        public String getName() {
            return "main";
        }

        public File getManifestFile() {
            Module module = AndroidFacet.this.getModule();
            VirtualFile manifestFile = AndroidRootUtil.getFileByRelativeModulePath(module, AndroidFacet.this.getProperties().MANIFEST_FILE_RELATIVE_PATH, true);
            if (manifestFile == null) {
                VirtualFile root;
                VirtualFile virtualFile = root = !AndroidFacet.this.requiresAndroidModel() ? AndroidRootUtil.getMainContentRoot(AndroidFacet.this) : null;
                if (root != null) {
                    return new File(VfsUtilCore.virtualToIoFile((VirtualFile)root), "AndroidManifest.xml");
                }
                return new File("AndroidManifest.xml");
            }
            return VfsUtilCore.virtualToIoFile((VirtualFile)manifestFile);
        }

        public Set<File> getJavaDirectories() {
            HashSet dirs = Sets.newHashSet();
            Module module = AndroidFacet.this.getModule();
            VirtualFile[] contentRoots = ModuleRootManager.getInstance((Module)module).getContentRoots();
            if (contentRoots.length != 0) {
                for (VirtualFile root : contentRoots) {
                    dirs.add(VfsUtilCore.virtualToIoFile((VirtualFile)root));
                }
            }
            return dirs;
        }

        public Set<File> getResourcesDirectories() {
            return Collections.emptySet();
        }

        public Set<File> getAidlDirectories() {
            VirtualFile dir = AndroidRootUtil.getAidlGenDir(AndroidFacet.this);
            return dir == null ? Collections.emptySet() : Collections.singleton(VfsUtilCore.virtualToIoFile((VirtualFile)dir));
        }

        public Set<File> getRenderscriptDirectories() {
            VirtualFile dir = AndroidRootUtil.getRenderscriptGenDir(AndroidFacet.this);
            return dir == null ? Collections.emptySet() : Collections.singleton(VfsUtilCore.virtualToIoFile((VirtualFile)dir));
        }

        public Set<File> getResDirectories() {
            String resRelPath = AndroidFacet.this.getProperties().RES_FOLDER_RELATIVE_PATH;
            VirtualFile dir = AndroidRootUtil.getFileByRelativeModulePath(AndroidFacet.this.getModule(), resRelPath, true);
            return dir == null ? Collections.emptySet() : Collections.singleton(VfsUtilCore.virtualToIoFile((VirtualFile)dir));
        }

        public Set<File> getAssetsDirectories() {
            VirtualFile dir = AndroidRootUtil.getAssetsDir(AndroidFacet.this);
            return dir == null ? Collections.emptySet() : Collections.singleton(VfsUtilCore.virtualToIoFile((VirtualFile)dir));
        }

        public Collection<File> getJniLibsDirectories() {
            return Collections.emptyList();
        }

        public Collection<File> getShadersDirectories() {
            return Collections.emptyList();
        }

        public Collection<File> getCDirectories() {
            return Collections.emptyList();
        }

        public Collection<File> getCppDirectories() {
            return Collections.emptyList();
        }
    }
}

