/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.resourceManagers;

import com.android.resources.FolderTypeRelationship;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.tools.idea.AndroidPsiUtils;
import com.google.common.collect.ImmutableSet;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.XmlRecursiveElementVisitor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.containers.HashMap;
import com.intellij.util.containers.HashSet;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.xml.DomElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.android.AndroidIdIndex;
import org.jetbrains.android.AndroidValueResourcesIndex;
import org.jetbrains.android.dom.attrs.AttributeDefinitions;
import org.jetbrains.android.dom.resources.ResourceElement;
import org.jetbrains.android.dom.resources.Resources;
import org.jetbrains.android.dom.wrappers.FileResourceElementWrapper;
import org.jetbrains.android.dom.wrappers.LazyValueResourceElementWrapper;
import org.jetbrains.android.resourceManagers.FileResourceProcessor;
import org.jetbrains.android.resourceManagers.ValueResourceInfo;
import org.jetbrains.android.resourceManagers.ValueResourceInfoImpl;
import org.jetbrains.android.util.AndroidCommonUtils;
import org.jetbrains.android.util.AndroidResourceUtil;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.android.util.ResourceEntry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ResourceManager {
    protected final Project myProject;

    protected ResourceManager(@NotNull Project project) {
        if (project == null) {
            ResourceManager.$$$reportNull$$$0(0);
        }
        this.myProject = project;
    }

    @NotNull
    public abstract VirtualFile[] getAllResourceDirs();

    @NotNull
    public abstract List<VirtualFile> getResourceDirs();

    public abstract boolean isResourceDir(@NotNull VirtualFile var1);

    public boolean processFileResources(@NotNull String resourceType, @NotNull FileResourceProcessor processor) {
        if (resourceType == null) {
            ResourceManager.$$$reportNull$$$0(1);
        }
        if (processor == null) {
            ResourceManager.$$$reportNull$$$0(2);
        }
        return this.processFileResources(resourceType, processor, true);
    }

    public boolean processFileResources(@NotNull String resourceType, @NotNull FileResourceProcessor processor, boolean withDependencies) {
        ResourceFolderType folderType;
        if (resourceType == null) {
            ResourceManager.$$$reportNull$$$0(3);
        }
        if (processor == null) {
            ResourceManager.$$$reportNull$$$0(4);
        }
        if ((folderType = ResourceFolderType.getTypeByName((String)resourceType)) == null) {
            return true;
        }
        return this.processFileResources(folderType, processor, withDependencies, true);
    }

    public boolean processFileResources(@NotNull ResourceFolderType folderType, @NotNull FileResourceProcessor processor, boolean withDependencies, boolean publicOnly) {
        VirtualFile[] resDirs;
        if (folderType == null) {
            ResourceManager.$$$reportNull$$$0(5);
        }
        if (processor == null) {
            ResourceManager.$$$reportNull$$$0(6);
        }
        if (withDependencies) {
            resDirs = this.getAllResourceDirs();
        } else {
            List<VirtualFile> resourceDirs = this.getResourceDirs();
            resDirs = resourceDirs.toArray(new VirtualFile[resourceDirs.size()]);
        }
        for (VirtualFile resSubdir : AndroidResourceUtil.getResourceSubdirs(folderType, resDirs)) {
            ResourceFolderType resType = ResourceFolderType.getFolderType((String)resSubdir.getName());
            if (resType == null) continue;
            assert (folderType.equals((Object)resType));
            String resTypeName = resType.getName();
            for (VirtualFile resFile : resSubdir.getChildren()) {
                String resName = AndroidCommonUtils.getResourceName((String)resTypeName, (String)resFile.getName());
                if (resFile.isDirectory() || publicOnly && !this.isResourcePublic(resTypeName, resName) || processor.process(resFile, resName)) continue;
                return false;
            }
        }
        return true;
    }

    @NotNull
    public VirtualFile[] getResourceOverlayDirs() {
        if (VirtualFile.EMPTY_ARRAY == null) {
            ResourceManager.$$$reportNull$$$0(7);
        }
        return VirtualFile.EMPTY_ARRAY;
    }

    protected boolean isResourcePublic(@NotNull String type, @NotNull String name) {
        if (type == null) {
            ResourceManager.$$$reportNull$$$0(8);
        }
        if (name == null) {
            ResourceManager.$$$reportNull$$$0(9);
        }
        return true;
    }

    @NotNull
    public List<VirtualFile> getResourceSubdirs(@NotNull ResourceFolderType resourceType) {
        if (resourceType == null) {
            ResourceManager.$$$reportNull$$$0(10);
        }
        List<VirtualFile> list = AndroidResourceUtil.getResourceSubdirs(resourceType, this.getAllResourceDirs());
        if (list == null) {
            ResourceManager.$$$reportNull$$$0(11);
        }
        return list;
    }

    @NotNull
    public List<PsiFile> findResourceFiles(@NotNull String resType, @Nullable String resName, boolean distinguishDelimetersInName, String ... extensions) {
        if (resType == null) {
            ResourceManager.$$$reportNull$$$0(12);
        }
        if (extensions == null) {
            ResourceManager.$$$reportNull$$$0(13);
        }
        List<PsiFile> list = this.findResourceFiles(resType, resName, distinguishDelimetersInName, true, extensions);
        if (list == null) {
            ResourceManager.$$$reportNull$$$0(14);
        }
        return list;
    }

    @NotNull
    public List<PsiFile> findResourceFiles(@NotNull String resType1, @Nullable String resName1, boolean distinguishDelimetersInName, boolean withDependencies, final String ... extensions) {
        if (resType1 == null) {
            ResourceManager.$$$reportNull$$$0(15);
        }
        if (extensions == null) {
            ResourceManager.$$$reportNull$$$0(16);
        }
        ArrayList<PsiFile> result = new ArrayList<PsiFile>();
        HashSet extensionSet = new HashSet();
        Collections.addAll(extensionSet, extensions);
        this.processFileResources(resType1, new FileResourceProcessor((Set)extensionSet, resName1, distinguishDelimetersInName, result){
            final /* synthetic */ Set val$extensionSet;
            final /* synthetic */ String val$resName1;
            final /* synthetic */ boolean val$distinguishDelimetersInName;
            final /* synthetic */ List val$result;
            {
                this.val$extensionSet = set;
                this.val$resName1 = string;
                this.val$distinguishDelimetersInName = bl;
                this.val$result = list;
            }

            @Override
            public boolean process(@NotNull VirtualFile resFile, @NotNull String resName) {
                PsiFile file;
                if (resFile == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (resName == null) {
                    1.$$$reportNull$$$0(1);
                }
                String extension = resFile.getExtension();
                if ((extensions.length == 0 || this.val$extensionSet.contains(extension)) && (this.val$resName1 == null || AndroidUtils.equal(this.val$resName1, resName, this.val$distinguishDelimetersInName)) && (file = AndroidPsiUtils.getPsiFileSafely(ResourceManager.this.myProject, resFile)) != null) {
                    this.val$result.add(file);
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "resFile";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "resName";
                        break;
                    }
                }
                objectArray[1] = "org/jetbrains/android/resourceManagers/ResourceManager$1";
                objectArray[2] = "process";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, withDependencies);
        ArrayList<PsiFile> arrayList = result;
        if (arrayList == null) {
            ResourceManager.$$$reportNull$$$0(17);
        }
        return arrayList;
    }

    @NotNull
    public List<PsiFile> findResourceFiles(@NotNull String resType) {
        if (resType == null) {
            ResourceManager.$$$reportNull$$$0(18);
        }
        List<PsiFile> list = this.findResourceFiles(resType, null, true, new String[0]);
        if (list == null) {
            ResourceManager.$$$reportNull$$$0(19);
        }
        return list;
    }

    protected List<Pair<Resources, VirtualFile>> getResourceElements(@Nullable Set<VirtualFile> files) {
        return this.getRootDomElements(Resources.class, files);
    }

    private <T extends DomElement> List<Pair<T, VirtualFile>> getRootDomElements(@NotNull Class<T> elementType, @Nullable Set<VirtualFile> files) {
        if (elementType == null) {
            ResourceManager.$$$reportNull$$$0(20);
        }
        ArrayList<Pair<T, VirtualFile>> result = new ArrayList<Pair<T, VirtualFile>>();
        for (VirtualFile file : this.getAllValueResourceFiles()) {
            T element;
            if (files != null && !files.contains(file) || !file.isValid() || (element = AndroidUtils.loadDomElement(this.myProject, file, elementType)) == null) continue;
            result.add(Pair.create(element, (Object)file));
        }
        return result;
    }

    @NotNull
    protected Set<VirtualFile> getAllValueResourceFiles() {
        HashSet files = new HashSet();
        for (VirtualFile valueResourceDir : this.getResourceSubdirs(ResourceFolderType.VALUES)) {
            for (VirtualFile valueResourceFile : valueResourceDir.getChildren()) {
                if (valueResourceFile.isDirectory() || !valueResourceFile.getFileType().equals(StdFileTypes.XML)) continue;
                files.add(valueResourceFile);
            }
        }
        HashSet hashSet = files;
        if (hashSet == null) {
            ResourceManager.$$$reportNull$$$0(21);
        }
        return hashSet;
    }

    protected List<ResourceElement> getValueResources(final @NotNull ResourceType resourceType, @Nullable Set<VirtualFile> files) {
        if (resourceType == null) {
            ResourceManager.$$$reportNull$$$0(22);
        }
        final ArrayList<ResourceElement> result = new ArrayList<ResourceElement>();
        List<Pair<Resources, VirtualFile>> resourceFiles = this.getResourceElements(files);
        for (Pair<Resources, VirtualFile> pair : resourceFiles) {
            final Resources resources = (Resources)pair.getFirst();
            ApplicationManager.getApplication().runReadAction(new Runnable(){

                @Override
                public void run() {
                    if (!resources.isValid() || ResourceManager.this.myProject.isDisposed()) {
                        return;
                    }
                    List<ResourceElement> valueResources = AndroidResourceUtil.getValueResourcesFromElement(resourceType, resources);
                    for (ResourceElement valueResource : valueResources) {
                        String resName = (String)valueResource.getName().getValue();
                        if (resName == null || !ResourceManager.this.isResourcePublic(resourceType.getName(), resName)) continue;
                        result.add(valueResource);
                    }
                }
            });
        }
        return result;
    }

    @Nullable
    public String getValueResourceType(@NotNull XmlTag tag) {
        ResourceFolderType fileResType;
        if (tag == null) {
            ResourceManager.$$$reportNull$$$0(23);
        }
        if (ResourceFolderType.VALUES == (fileResType = this.getFileResourceFolderType(tag.getContainingFile()))) {
            return tag.getName();
        }
        return null;
    }

    @Nullable
    public ResourceFolderType getFileResourceFolderType(final @NotNull PsiFile file) {
        if (file == null) {
            ResourceManager.$$$reportNull$$$0(24);
        }
        return (ResourceFolderType)ApplicationManager.getApplication().runReadAction((Computable)new Computable<ResourceFolderType>(){

            @Nullable
            public ResourceFolderType compute() {
                PsiDirectory dir = file.getContainingDirectory();
                if (dir == null) {
                    return null;
                }
                PsiDirectory possibleResDir = dir.getParentDirectory();
                if (possibleResDir == null || !ResourceManager.this.isResourceDir(possibleResDir.getVirtualFile())) {
                    return null;
                }
                return ResourceFolderType.getFolderType((String)dir.getName());
            }
        });
    }

    @Nullable
    public String getFileResourceType(@NotNull PsiFile file) {
        ResourceFolderType folderType;
        if (file == null) {
            ResourceManager.$$$reportNull$$$0(25);
        }
        return (folderType = this.getFileResourceFolderType(file)) == null ? null : folderType.getName();
    }

    @NotNull
    private Set<String> getFileResourcesNames(@NotNull String resourceType) {
        if (resourceType == null) {
            ResourceManager.$$$reportNull$$$0(26);
        }
        HashSet result = new HashSet();
        this.processFileResources(resourceType, new FileResourceProcessor((Set)result){
            final /* synthetic */ Set val$result;
            {
                this.val$result = set;
            }

            @Override
            public boolean process(@NotNull VirtualFile resFile, @NotNull String resName) {
                if (resFile == null) {
                    4.$$$reportNull$$$0(0);
                }
                if (resName == null) {
                    4.$$$reportNull$$$0(1);
                }
                this.val$result.add(resName);
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "resFile";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "resName";
                        break;
                    }
                }
                objectArray[1] = "org/jetbrains/android/resourceManagers/ResourceManager$4";
                objectArray[2] = "process";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        HashSet hashSet = result;
        if (hashSet == null) {
            ResourceManager.$$$reportNull$$$0(27);
        }
        return hashSet;
    }

    @NotNull
    public Collection<String> getValueResourceNames(@NotNull ResourceType resourceType) {
        if (resourceType == null) {
            ResourceManager.$$$reportNull$$$0(28);
        }
        HashSet result = new HashSet();
        boolean attr = ResourceType.ATTR == resourceType;
        for (ResourceEntry entry : this.getValueResourceEntries(resourceType)) {
            String name = entry.getName();
            if (attr && name.startsWith("android:")) continue;
            result.add(name);
        }
        HashSet hashSet = result;
        if (hashSet == null) {
            ResourceManager.$$$reportNull$$$0(29);
        }
        return hashSet;
    }

    @NotNull
    public Collection<ResourceEntry> getValueResourceEntries(@NotNull ResourceType resourceType) {
        if (resourceType == null) {
            ResourceManager.$$$reportNull$$$0(30);
        }
        FileBasedIndex index = FileBasedIndex.getInstance();
        ResourceEntry typeMarkerEntry = AndroidValueResourcesIndex.createTypeMarkerKey(resourceType.getName());
        GlobalSearchScope scope = GlobalSearchScope.allScope((Project)this.myProject);
        HashMap file2resourceSet = new HashMap();
        index.processValues(AndroidValueResourcesIndex.INDEX_ID, (Object)typeMarkerEntry, null, (FileBasedIndex.ValueProcessor)new FileBasedIndex.ValueProcessor<ImmutableSet<AndroidValueResourcesIndex.MyResourceInfo>>((Map)file2resourceSet){
            final /* synthetic */ Map val$file2resourceSet;
            {
                this.val$file2resourceSet = map;
            }

            public boolean process(@NotNull VirtualFile file, ImmutableSet<AndroidValueResourcesIndex.MyResourceInfo> infos) {
                if (file == null) {
                    5.$$$reportNull$$$0(0);
                }
                for (AndroidValueResourcesIndex.MyResourceInfo info : infos) {
                    Set resourcesInFile = (Set)this.val$file2resourceSet.get(file);
                    if (resourcesInFile == null) {
                        resourcesInFile = new HashSet();
                        this.val$file2resourceSet.put(file, resourcesInFile);
                    }
                    resourcesInFile.add(info.getResourceEntry());
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/android/resourceManagers/ResourceManager$5", "process"));
            }
        }, scope);
        ArrayList<ResourceEntry> result = new ArrayList<ResourceEntry>();
        for (VirtualFile file : this.getAllValueResourceFiles()) {
            Set entries = (Set)file2resourceSet.get(file);
            if (entries == null) continue;
            for (ResourceEntry entry : entries) {
                if (!this.isResourcePublic(entry.getType(), entry.getName())) continue;
                result.add(entry);
            }
        }
        ArrayList<ResourceEntry> arrayList = result;
        if (arrayList == null) {
            ResourceManager.$$$reportNull$$$0(31);
        }
        return arrayList;
    }

    @NotNull
    public Collection<String> getResourceNames(@NotNull ResourceType type) {
        if (type == null) {
            ResourceManager.$$$reportNull$$$0(32);
        }
        Collection<String> collection = this.getResourceNames(type, false);
        if (collection == null) {
            ResourceManager.$$$reportNull$$$0(33);
        }
        return collection;
    }

    @NotNull
    public Collection<String> getResourceNames(@NotNull ResourceType resourceType, boolean publicOnly) {
        if (resourceType == null) {
            ResourceManager.$$$reportNull$$$0(34);
        }
        HashSet result = new HashSet();
        result.addAll(this.getValueResourceNames(resourceType));
        List folders = FolderTypeRelationship.getRelatedFolders((ResourceType)resourceType);
        if (!folders.isEmpty()) {
            for (ResourceFolderType folderType : folders) {
                if (folderType == ResourceFolderType.VALUES) continue;
                result.addAll(this.getFileResourcesNames(folderType.getName()));
            }
        }
        if (resourceType == ResourceType.ID) {
            result.addAll(this.getIds(true));
        }
        HashSet hashSet = result;
        if (hashSet == null) {
            ResourceManager.$$$reportNull$$$0(35);
        }
        return hashSet;
    }

    @Nullable
    public abstract AttributeDefinitions getAttributeDefinitions();

    @NotNull
    public List<XmlAttributeValue> findIdDeclarations(final @NotNull String id) {
        if (id == null) {
            ResourceManager.$$$reportNull$$$0(36);
        }
        if (!this.isResourcePublic(ResourceType.ID.getName(), id)) {
            List<XmlAttributeValue> list = Collections.emptyList();
            if (list == null) {
                ResourceManager.$$$reportNull$$$0(37);
            }
            return list;
        }
        final ArrayList<XmlAttributeValue> declarations = new ArrayList<XmlAttributeValue>();
        Collection files = FileBasedIndex.getInstance().getContainingFiles(AndroidIdIndex.INDEX_ID, (Object)("+" + id), GlobalSearchScope.allScope((Project)this.myProject));
        HashSet fileSet = new HashSet(files);
        PsiManager psiManager = PsiManager.getInstance((Project)this.myProject);
        for (VirtualFile subdir : this.getResourceSubdirsToSearchIds()) {
            for (VirtualFile file : subdir.getChildren()) {
                PsiFile psiFile;
                if (!fileSet.contains(file) || !((psiFile = psiManager.findFile(file)) instanceof XmlFile)) continue;
                psiFile.accept((PsiElementVisitor)new XmlRecursiveElementVisitor(){

                    public void visitXmlAttributeValue(XmlAttributeValue attributeValue) {
                        String idInAttr;
                        if (AndroidResourceUtil.isIdDeclaration(attributeValue) && id.equals(idInAttr = AndroidResourceUtil.getResourceNameByReferenceText(attributeValue.getValue()))) {
                            declarations.add(attributeValue);
                        }
                    }
                });
            }
        }
        ArrayList<XmlAttributeValue> arrayList = declarations;
        if (arrayList == null) {
            ResourceManager.$$$reportNull$$$0(38);
        }
        return arrayList;
    }

    @NotNull
    public Collection<String> getIds(boolean declarationsOnly) {
        if (this.myProject.isDisposed()) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                ResourceManager.$$$reportNull$$$0(39);
            }
            return list;
        }
        GlobalSearchScope scope = GlobalSearchScope.allScope((Project)this.myProject);
        FileBasedIndex index = FileBasedIndex.getInstance();
        HashMap file2idEntries = new HashMap();
        index.processValues(AndroidIdIndex.INDEX_ID, (Object)"$", null, (FileBasedIndex.ValueProcessor)new FileBasedIndex.ValueProcessor<Set<String>>((Map)file2idEntries){
            final /* synthetic */ Map val$file2idEntries;
            {
                this.val$file2idEntries = map;
            }

            public boolean process(@NotNull VirtualFile file, Set<String> value) {
                if (file == null) {
                    7.$$$reportNull$$$0(0);
                }
                this.val$file2idEntries.put(file, value);
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/android/resourceManagers/ResourceManager$7", "process"));
            }
        }, scope);
        HashSet result = new HashSet();
        for (VirtualFile resSubdir : this.getResourceSubdirsToSearchIds()) {
            for (VirtualFile resFile : resSubdir.getChildren()) {
                Set idEntries = (Set)file2idEntries.get(resFile);
                if (idEntries == null) continue;
                for (String idEntry : idEntries) {
                    if (idEntry.startsWith("+")) {
                        idEntry = idEntry.substring(1);
                    } else if (declarationsOnly) continue;
                    if (!this.isResourcePublic(ResourceType.ID.getName(), idEntry)) continue;
                    result.add(idEntry);
                }
            }
        }
        HashSet hashSet = result;
        if (hashSet == null) {
            ResourceManager.$$$reportNull$$$0(40);
        }
        return hashSet;
    }

    @NotNull
    public List<VirtualFile> getResourceSubdirsToSearchIds() {
        ArrayList<VirtualFile> resSubdirs = new ArrayList<VirtualFile>();
        for (ResourceFolderType type : FolderTypeRelationship.getIdGeneratingFolderTypes()) {
            resSubdirs.addAll(this.getResourceSubdirs(type));
        }
        ArrayList<VirtualFile> arrayList = resSubdirs;
        if (arrayList == null) {
            ResourceManager.$$$reportNull$$$0(41);
        }
        return arrayList;
    }

    public List<ResourceElement> findValueResources(@NotNull String resType, @NotNull String resName) {
        if (resType == null) {
            ResourceManager.$$$reportNull$$$0(42);
        }
        if (resName == null) {
            ResourceManager.$$$reportNull$$$0(43);
        }
        return this.findValueResources(resType, resName, true);
    }

    @NotNull
    public List<ResourceElement> findValueResources(@NotNull String resourceType, @NotNull String resourceName, boolean distinguishDelimitersInName) {
        if (resourceType == null) {
            ResourceManager.$$$reportNull$$$0(44);
        }
        if (resourceName == null) {
            ResourceManager.$$$reportNull$$$0(45);
        }
        List<ValueResourceInfoImpl> resources = this.findValueResourceInfos(resourceType, resourceName, distinguishDelimitersInName, false);
        ArrayList<ResourceElement> result = new ArrayList<ResourceElement>();
        for (ValueResourceInfoImpl resource : resources) {
            ResourceElement domElement = resource.computeDomElement();
            if (domElement == null) continue;
            result.add(domElement);
        }
        ArrayList<ResourceElement> arrayList = result;
        if (arrayList == null) {
            ResourceManager.$$$reportNull$$$0(46);
        }
        return arrayList;
    }

    public void collectLazyResourceElements(@NotNull String resType, @NotNull String resName, boolean withAttrs, @NotNull PsiElement context, @NotNull Collection<PsiElement> elements) {
        if (resType == null) {
            ResourceManager.$$$reportNull$$$0(47);
        }
        if (resName == null) {
            ResourceManager.$$$reportNull$$$0(48);
        }
        if (context == null) {
            ResourceManager.$$$reportNull$$$0(49);
        }
        if (elements == null) {
            ResourceManager.$$$reportNull$$$0(50);
        }
        List<ValueResourceInfoImpl> valueResources = this.findValueResourceInfos(resType, resName, false, withAttrs);
        for (ValueResourceInfo valueResourceInfo : valueResources) {
            elements.add((PsiElement)new LazyValueResourceElementWrapper(valueResourceInfo, context));
        }
        if (resType.equals("id")) {
            elements.addAll(this.findIdDeclarations(resName));
        }
        if (elements.size() == 0) {
            for (PsiFile psiFile : this.findResourceFiles(resType, resName, false, new String[0])) {
                elements.add(new FileResourceElementWrapper(psiFile));
            }
        }
    }

    @NotNull
    public List<ValueResourceInfoImpl> findValueResourceInfos(@NotNull String resourceType, final @NotNull String resourceName, final boolean distinguishDelimetersInName, boolean searchAttrs) {
        ResourceType type;
        if (resourceType == null) {
            ResourceManager.$$$reportNull$$$0(51);
        }
        if (resourceName == null) {
            ResourceManager.$$$reportNull$$$0(52);
        }
        ResourceType resourceType2 = type = resourceType.startsWith("+") ? ResourceType.ID : ResourceType.getEnum((String)resourceType);
        if (type == null || !AndroidResourceUtil.VALUE_RESOURCE_TYPES.contains(type) && (type != ResourceType.ATTR || !searchAttrs)) {
            List<ValueResourceInfoImpl> list = Collections.emptyList();
            if (list == null) {
                ResourceManager.$$$reportNull$$$0(53);
            }
            return list;
        }
        GlobalSearchScope scope = GlobalSearchScope.allScope((Project)this.myProject);
        final ArrayList<ValueResourceInfoImpl> result = new ArrayList<ValueResourceInfoImpl>();
        final Set<VirtualFile> valueResourceFiles = this.getAllValueResourceFiles();
        FileBasedIndex.getInstance().processValues(AndroidValueResourcesIndex.INDEX_ID, (Object)AndroidValueResourcesIndex.createTypeNameMarkerKey(resourceType, resourceName), null, (FileBasedIndex.ValueProcessor)new FileBasedIndex.ValueProcessor<ImmutableSet<AndroidValueResourcesIndex.MyResourceInfo>>(){

            public boolean process(@NotNull VirtualFile file, ImmutableSet<AndroidValueResourcesIndex.MyResourceInfo> infos) {
                if (file == null) {
                    8.$$$reportNull$$$0(0);
                }
                for (AndroidValueResourcesIndex.MyResourceInfo info : infos) {
                    String name = info.getResourceEntry().getName();
                    if (!AndroidUtils.equal(resourceName, name, distinguishDelimetersInName) || !valueResourceFiles.contains(file)) continue;
                    result.add(new ValueResourceInfoImpl(info.getResourceEntry().getName(), type, file, ResourceManager.this.myProject, info.getOffset()));
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/android/resourceManagers/ResourceManager$8", "process"));
            }
        }, scope);
        ArrayList<ValueResourceInfoImpl> arrayList = result;
        if (arrayList == null) {
            ResourceManager.$$$reportNull$$$0(54);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 11: 
            case 14: 
            case 17: 
            case 19: 
            case 21: 
            case 27: 
            case 29: 
            case 31: 
            case 33: 
            case 35: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 46: 
            case 53: 
            case 54: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 11: 
            case 14: 
            case 17: 
            case 19: 
            case 21: 
            case 27: 
            case 29: 
            case 31: 
            case 33: 
            case 35: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 46: 
            case 53: 
            case 54: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 10: 
            case 22: 
            case 26: 
            case 28: 
            case 30: 
            case 34: 
            case 44: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resourceType";
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "folderType";
                break;
            }
            case 7: 
            case 11: 
            case 14: 
            case 17: 
            case 19: 
            case 21: 
            case 27: 
            case 29: 
            case 31: 
            case 33: 
            case 35: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 46: 
            case 53: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/android/resourceManagers/ResourceManager";
                break;
            }
            case 8: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 12: 
            case 18: 
            case 42: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resType";
                break;
            }
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensions";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resType1";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 24: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 43: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resName";
                break;
            }
            case 45: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resourceName";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/android/resourceManagers/ResourceManager";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getResourceOverlayDirs";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getResourceSubdirs";
                break;
            }
            case 14: 
            case 17: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "findResourceFiles";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllValueResourceFiles";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileResourcesNames";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueResourceNames";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueResourceEntries";
                break;
            }
            case 33: 
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getResourceNames";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "findIdDeclarations";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "getIds";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "getResourceSubdirsToSearchIds";
                break;
            }
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "findValueResources";
                break;
            }
            case 53: 
            case 54: {
                objectArray = objectArray2;
                objectArray2[1] = "findValueResourceInfos";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "processFileResources";
                break;
            }
            case 7: 
            case 11: 
            case 14: 
            case 17: 
            case 19: 
            case 21: 
            case 27: 
            case 29: 
            case 31: 
            case 33: 
            case 35: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 46: 
            case 53: 
            case 54: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isResourcePublic";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getResourceSubdirs";
                break;
            }
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "findResourceFiles";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getRootDomElements";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getValueResources";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getValueResourceType";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getFileResourceFolderType";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getFileResourceType";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getFileResourcesNames";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getValueResourceNames";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getValueResourceEntries";
                break;
            }
            case 32: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getResourceNames";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "findIdDeclarations";
                break;
            }
            case 42: 
            case 43: 
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "findValueResources";
                break;
            }
            case 47: 
            case 48: 
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "collectLazyResourceElements";
                break;
            }
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "findValueResourceInfos";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 11: 
            case 14: 
            case 17: 
            case 19: 
            case 21: 
            case 27: 
            case 29: 
            case 31: 
            case 33: 
            case 35: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 46: 
            case 53: 
            case 54: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

