/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.sdk;

import com.android.repository.Revision;
import com.android.repository.api.ProgressIndicator;
import com.android.repository.io.FileOp;
import com.android.repository.io.FileOpUtils;
import com.android.sdklib.BuildToolInfo;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.devices.DeviceManager;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.tools.idea.sdk.IdeSdks;
import com.android.tools.idea.sdk.progress.StudioLoggerProgressIndicator;
import com.android.utils.ILogger;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.reference.SoftReference;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.android.sdk.AndroidSdkUtils;
import org.jetbrains.android.sdk.AndroidTargetData;
import org.jetbrains.android.sdk.MessageBuildingSdkLog;
import org.jetbrains.android.util.AndroidCommonUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidSdkData {
    private final Map<String, SoftReference<AndroidTargetData>> myTargetDataByTarget;
    private final DeviceManager myDeviceManager;
    private final int myPlatformToolsRevision;
    private static final ConcurrentMap<String, SoftReference<AndroidSdkData>> ourCache = Maps.newConcurrentMap();
    private AndroidSdkHandler mySdkHandler;

    @Nullable
    public static AndroidSdkData getSdkData(@NotNull File sdkLocation) {
        if (sdkLocation == null) {
            AndroidSdkData.$$$reportNull$$$0(0);
        }
        return AndroidSdkData.getSdkData(sdkLocation, false);
    }

    @Nullable
    public static AndroidSdkData getSdkData(@NotNull File sdkLocation, boolean forceReparse) {
        SoftReference cachedRef;
        if (sdkLocation == null) {
            AndroidSdkData.$$$reportNull$$$0(1);
        }
        String canonicalPath = FileUtil.toCanonicalPath((String)sdkLocation.getPath());
        if (!forceReparse && (cachedRef = (SoftReference)ourCache.get(canonicalPath)) != null) {
            AndroidSdkData cachedData = (AndroidSdkData)cachedRef.get();
            if (cachedData == null) {
                ourCache.remove(canonicalPath, cachedRef);
            } else {
                return cachedData;
            }
        }
        File canonicalLocation = new File(canonicalPath);
        if (!IdeSdks.getInstance().isValidAndroidSdkPath(canonicalLocation)) {
            return null;
        }
        AndroidSdkData sdkData = new AndroidSdkData(canonicalLocation);
        ourCache.put(canonicalPath, (SoftReference<AndroidSdkData>)new SoftReference((Object)sdkData));
        return sdkData;
    }

    @Nullable
    public static AndroidSdkData getSdkData(@NotNull String sdkPath) {
        if (sdkPath == null) {
            AndroidSdkData.$$$reportNull$$$0(2);
        }
        File file = new File(FileUtil.toSystemDependentName((String)sdkPath));
        return AndroidSdkData.getSdkData(file);
    }

    @Nullable
    public static AndroidSdkData getSdkData(@NotNull Sdk sdk) {
        String sdkHomePath;
        if (sdk == null) {
            AndroidSdkData.$$$reportNull$$$0(3);
        }
        if ((sdkHomePath = sdk.getHomePath()) != null) {
            return AndroidSdkData.getSdkData(sdk.getHomePath());
        }
        return null;
    }

    @Nullable
    public static AndroidSdkData getSdkData(@NotNull Project project) {
        Sdk sdk;
        if (project == null) {
            AndroidSdkData.$$$reportNull$$$0(4);
        }
        if ((sdk = ProjectRootManager.getInstance((Project)project).getProjectSdk()) != null) {
            return AndroidSdkData.getSdkData(sdk);
        }
        return null;
    }

    @Nullable
    public static AndroidSdkData getSdkData(@NotNull Module module) {
        if (module == null) {
            AndroidSdkData.$$$reportNull$$$0(5);
        }
        return AndroidSdkData.getSdkData(module.getProject());
    }

    private AndroidSdkData(@NotNull File localSdk) {
        if (localSdk == null) {
            AndroidSdkData.$$$reportNull$$$0(6);
        }
        this.myTargetDataByTarget = Maps.newHashMap();
        this.mySdkHandler = AndroidSdkHandler.getInstance((File)localSdk);
        File location = this.getLocation();
        String locationPath = location.getPath();
        Revision platformToolsRevision = AndroidCommonUtils.parsePackageRevision((String)locationPath, (String)"platform-tools");
        this.myPlatformToolsRevision = platformToolsRevision == null ? -1 : platformToolsRevision.getMajor();
        this.myDeviceManager = DeviceManager.createInstance((File)location, (File)this.mySdkHandler.getAndroidFolder(), (ILogger)new MessageBuildingSdkLog(), (FileOp)FileOpUtils.create());
    }

    @NotNull
    public File getLocation() {
        File location = this.mySdkHandler.getLocation();
        assert (location != null);
        File file = location;
        if (file == null) {
            AndroidSdkData.$$$reportNull$$$0(7);
        }
        return file;
    }

    @Deprecated
    @NotNull
    public String getPath() {
        String string = this.getLocation().getPath();
        if (string == null) {
            AndroidSdkData.$$$reportNull$$$0(8);
        }
        return string;
    }

    @Deprecated
    @Nullable
    public BuildToolInfo getLatestBuildTool() {
        return this.getLatestBuildTool(false);
    }

    @Nullable
    public BuildToolInfo getLatestBuildTool(boolean allowPreview) {
        return this.mySdkHandler.getLatestBuildTool((ProgressIndicator)new StudioLoggerProgressIndicator(this.getClass()), allowPreview);
    }

    @NotNull
    public IAndroidTarget[] getTargets() {
        Collection<IAndroidTarget> targets = this.getTargetCollection();
        IAndroidTarget[] iAndroidTargetArray = targets.toArray(new IAndroidTarget[targets.size()]);
        if (iAndroidTargetArray == null) {
            AndroidSdkData.$$$reportNull$$$0(9);
        }
        return iAndroidTargetArray;
    }

    @NotNull
    private Collection<IAndroidTarget> getTargetCollection() {
        StudioLoggerProgressIndicator progress = new StudioLoggerProgressIndicator(this.getClass());
        Collection collection = this.mySdkHandler.getAndroidTargetManager((ProgressIndicator)progress).getTargets((ProgressIndicator)progress);
        if (collection == null) {
            AndroidSdkData.$$$reportNull$$$0(10);
        }
        return collection;
    }

    @NotNull
    public IAndroidTarget[] getTargets(boolean includeAddOns) {
        Collection<IAndroidTarget> targets = this.getTargetCollection();
        ArrayList result = Lists.newArrayList();
        if (!includeAddOns) {
            for (IAndroidTarget target : targets) {
                if (!target.isPlatform()) continue;
                result.add(target);
            }
        } else {
            result.addAll(targets);
        }
        IAndroidTarget[] iAndroidTargetArray = result.toArray(new IAndroidTarget[result.size()]);
        if (iAndroidTargetArray == null) {
            AndroidSdkData.$$$reportNull$$$0(11);
        }
        return iAndroidTargetArray;
    }

    @Nullable
    public IAndroidTarget findTargetByName(@NotNull String name) {
        if (name == null) {
            AndroidSdkData.$$$reportNull$$$0(12);
        }
        for (IAndroidTarget target : this.getTargets()) {
            if (!target.getName().equals(name)) continue;
            return target;
        }
        return null;
    }

    @Nullable
    public IAndroidTarget findTargetByApiLevel(@NotNull String apiLevel) {
        if (apiLevel == null) {
            AndroidSdkData.$$$reportNull$$$0(13);
        }
        for (IAndroidTarget target : this.getTargets()) {
            if (!AndroidSdkUtils.targetHasId(target, apiLevel)) continue;
            return target;
        }
        return null;
    }

    @Nullable
    public IAndroidTarget findTargetByHashString(@NotNull String hashString) {
        if (hashString == null) {
            AndroidSdkData.$$$reportNull$$$0(14);
        }
        StudioLoggerProgressIndicator progress = new StudioLoggerProgressIndicator(this.getClass());
        return this.mySdkHandler.getAndroidTargetManager((ProgressIndicator)progress).getTargetFromHashString(hashString, (ProgressIndicator)progress);
    }

    public int getPlatformToolsRevision() {
        return this.myPlatformToolsRevision;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        AndroidSdkData sdkData = (AndroidSdkData)obj;
        return FileUtil.filesEqual((File)this.getLocation(), (File)sdkData.getLocation());
    }

    public int hashCode() {
        return FileUtil.fileHashCode((File)this.getLocation());
    }

    @NotNull
    public DeviceManager getDeviceManager() {
        DeviceManager deviceManager = this.myDeviceManager;
        if (deviceManager == null) {
            AndroidSdkData.$$$reportNull$$$0(15);
        }
        return deviceManager;
    }

    @NotNull
    public AndroidTargetData getTargetData(@NotNull IAndroidTarget target) {
        String key;
        SoftReference<AndroidTargetData> targetDataRef;
        AndroidTargetData targetData;
        if (target == null) {
            AndroidSdkData.$$$reportNull$$$0(16);
        }
        AndroidTargetData androidTargetData = targetData = (targetDataRef = this.myTargetDataByTarget.get(key = target.hashString())) != null ? (AndroidTargetData)targetDataRef.get() : null;
        if (targetData == null) {
            targetData = new AndroidTargetData(this, target);
            this.myTargetDataByTarget.put(key, (SoftReference<AndroidTargetData>)new SoftReference((Object)targetData));
        }
        AndroidTargetData androidTargetData2 = targetData;
        if (androidTargetData2 == null) {
            AndroidSdkData.$$$reportNull$$$0(17);
        }
        return androidTargetData2;
    }

    @NotNull
    public AndroidSdkHandler getSdkHandler() {
        AndroidSdkHandler androidSdkHandler = this.mySdkHandler;
        if (androidSdkHandler == null) {
            AndroidSdkData.$$$reportNull$$$0(18);
        }
        return androidSdkHandler;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 15: 
            case 17: 
            case 18: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 15: 
            case 17: 
            case 18: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkLocation";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkPath";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localSdk";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 15: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/android/sdk/AndroidSdkData";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "apiLevel";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hashString";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/android/sdk/AndroidSdkData";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocation";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getPath";
                break;
            }
            case 9: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargets";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetCollection";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeviceManager";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetData";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getSdkHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getSdkData";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 15: 
            case 17: 
            case 18: {
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "findTargetByName";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "findTargetByApiLevel";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "findTargetByHashString";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getTargetData";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 15: 
            case 17: 
            case 18: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

