/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.checks.CleanupDetector;
import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.ConstantEvaluator;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDisjunctionType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class HardwareIdDetector
extends Detector
implements Detector.JavaPsiScanner {
    private static final Implementation IMPLEMENTATION = new Implementation(HardwareIdDetector.class, Scope.JAVA_FILE_SCOPE);
    public static final Issue ISSUE = Issue.create("HardwareIds", "Hardware Id Usage", "Using these device identifiers is not recommended other than for high value fraud prevention and advanced telephony use-cases. For advertising use-cases, use `AdvertisingIdClient$Info#getId` and for analytics, use `InstanceId#getId`.", Category.SECURITY, 6, Severity.WARNING, IMPLEMENTATION).addMoreInfo("https://developer.android.com/training/articles/user-data-ids.html");
    private static final String BLUETOOTH_ADAPTER_GET_ADDRESS = "getAddress";
    private static final String WIFI_INFO_GET_MAC_ADDRESS = "getMacAddress";
    private static final String TELEPHONY_MANAGER_GET_DEVICE_ID = "getDeviceId";
    private static final String TELEPHONY_MANAGER_GET_LINE_1_NUMBER = "getLine1Number";
    private static final String TELEPHONY_MANAGER_GET_SIM_SERIAL_NUMBER = "getSimSerialNumber";
    private static final String TELEPHONY_MANAGER_GET_SUBSCRIBER_ID = "getSubscriberId";
    private static final String SETTINGS_SECURE_GET_STRING = "getString";
    private static final String PLAY_SERVICES_NOT_AVAILABLE_EXCEPTION = "com.google.android.gms.common.GooglePlayServicesNotAvailableException";
    private static final String MESSAGE_DEVICE_IDENTIFIERS = "Using `%1$s` to get device identifiers is not recommended.";
    private static final String RO_SERIALNO = "ro.serialno";
    private static final String CLASS_FOR_NAME = "forName";
    private static final String CLASSLOADER_LOAD_CLASS = "loadClass";

    @Override
    public List<String> getApplicableMethodNames() {
        return Arrays.asList(BLUETOOTH_ADAPTER_GET_ADDRESS, WIFI_INFO_GET_MAC_ADDRESS, TELEPHONY_MANAGER_GET_DEVICE_ID, TELEPHONY_MANAGER_GET_LINE_1_NUMBER, TELEPHONY_MANAGER_GET_SIM_SERIAL_NUMBER, TELEPHONY_MANAGER_GET_SUBSCRIBER_ID, SETTINGS_SECURE_GET_STRING, CLASS_FOR_NAME, CLASSLOADER_LOAD_CLASS);
    }

    @Override
    public void visitMethod(JavaContext context, JavaElementVisitor visitor, PsiMethodCallExpression node, PsiMethod method) {
        String methodName;
        JavaEvaluator evaluator = context.getEvaluator();
        String className = null;
        switch (methodName = method.getName()) {
            case "getAddress": {
                className = "android.bluetooth.BluetoothAdapter";
                break;
            }
            case "getMacAddress": {
                className = "android.net.wifi.WifiInfo";
                break;
            }
            case "getDeviceId": 
            case "getLine1Number": 
            case "getSimSerialNumber": 
            case "getSubscriberId": {
                className = "android.telephony.TelephonyManager";
                break;
            }
            case "getString": {
                className = "android.provider.Settings.Secure";
                break;
            }
            case "forName": {
                className = "java.lang.Class";
                break;
            }
            case "loadClass": {
                className = "java.lang.ClassLoader";
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        if (!evaluator.isMemberInClass((PsiMember)method, className)) {
            return;
        }
        if (methodName.equals(SETTINGS_SECURE_GET_STRING)) {
            if (evaluator.getParameterCount(method) != 2 || node.getArgumentList().getExpressions().length != 2) {
                return;
            }
            String value = ConstantEvaluator.evaluateString(context, (PsiElement)node.getArgumentList().getExpressions()[1], false);
            if (!"android_id".equals(value)) {
                return;
            }
        } else if (methodName.equals(CLASS_FOR_NAME) || methodName.equals(CLASSLOADER_LOAD_CLASS)) {
            HardwareIdDetector.findReflectionUsage(node, context);
            return;
        }
        if (HardwareIdDetector.inCatchPlayServicesNotAvailableException((PsiExpression)node)) {
            return;
        }
        String message = String.format(MESSAGE_DEVICE_IDENTIFIERS, methodName);
        context.report(ISSUE, (PsiElement)node, context.getLocation((PsiElement)node), message);
    }

    @Override
    public List<String> getApplicableReferenceNames() {
        return Collections.singletonList("SERIAL");
    }

    @Override
    public void visitReference(JavaContext context, JavaElementVisitor visitor, PsiJavaCodeReferenceElement reference, PsiElement resolved) {
        JavaEvaluator evaluator = context.getEvaluator();
        if (resolved instanceof PsiField && evaluator.isMemberInSubClassOf((PsiMember)((PsiField)resolved), "android.os.Build", false)) {
            String message = String.format(MESSAGE_DEVICE_IDENTIFIERS, "SERIAL");
            context.report(ISSUE, (PsiElement)reference, context.getNameLocation((PsiElement)reference), message);
        }
    }

    private static boolean inCatchPlayServicesNotAvailableException(PsiExpression expression) {
        PsiDisjunctionType disjunctionType;
        PsiType catchType;
        PsiCatchSection surroundingCatchSection = (PsiCatchSection)PsiTreeUtil.getParentOfType((PsiElement)expression, PsiCatchSection.class, (boolean)true);
        return surroundingCatchSection != null && surroundingCatchSection.getCatchType() != null && ((catchType = surroundingCatchSection.getCatchType()) instanceof PsiDisjunctionType ? (disjunctionType = (PsiDisjunctionType)catchType).getDisjunctions().stream().anyMatch(t -> t.equalsToText(PLAY_SERVICES_NOT_AVAILABLE_EXCEPTION)) : catchType.equalsToText(PLAY_SERVICES_NOT_AVAILABLE_EXCEPTION));
    }

    private static void findReflectionUsage(PsiMethodCallExpression expression, JavaContext context) {
        PsiExpression[] methodArgs = expression.getArgumentList().getExpressions();
        if (methodArgs.length < 1) {
            return;
        }
        String value = ConstantEvaluator.evaluateString(context, (PsiElement)methodArgs[0], false);
        if (!"android.os.SystemProperties".equals(value)) {
            return;
        }
        PsiMethod surroundingMethod = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)expression, PsiMethod.class, (boolean)true);
        if (surroundingMethod == null) {
            return;
        }
        InvokeCallVisitor visitor = new InvokeCallVisitor(context, expression);
        surroundingMethod.accept((PsiElementVisitor)visitor);
        PsiParameter argExpression = visitor.getPsiParameter();
        if (argExpression == null) {
            return;
        }
        PsiClass surroundingClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)surroundingMethod, PsiClass.class, (boolean)true);
        if (surroundingClass != null) {
            int paramIndex = surroundingMethod.getParameterList().getParameterIndex(argExpression);
            if (paramIndex < 0) {
                return;
            }
            FindMethodCallVisitor methodCallVisitor = new FindMethodCallVisitor(context, surroundingMethod, paramIndex);
            surroundingClass.accept((PsiElementVisitor)methodCallVisitor);
        }
    }

    private static final class FindMethodCallVisitor
    extends JavaRecursiveElementVisitor {
        private final JavaContext mContext;
        private final PsiMethod mPsiMethod;
        private final int mParamIndex;

        FindMethodCallVisitor(JavaContext context, PsiMethod method, int paramIndex) {
            this.mContext = context;
            this.mPsiMethod = method;
            this.mParamIndex = paramIndex;
        }

        public void visitMethodCallExpression(PsiMethodCallExpression expression) {
            PsiExpression paramExpr;
            String value;
            PsiExpression[] expressions;
            super.visitMethodCallExpression(expression);
            if (this.mPsiMethod == expression.resolveMethod() && (expressions = expression.getArgumentList().getExpressions()).length > this.mParamIndex && HardwareIdDetector.RO_SERIALNO.equals(value = ConstantEvaluator.evaluateString(this.mContext, (PsiElement)(paramExpr = expressions[this.mParamIndex]), false)) && !HardwareIdDetector.inCatchPlayServicesNotAvailableException((PsiExpression)expression)) {
                String message = String.format(HardwareIdDetector.MESSAGE_DEVICE_IDENTIFIERS, HardwareIdDetector.RO_SERIALNO);
                this.mContext.report(ISSUE, (PsiElement)paramExpr, this.mContext.getLocation((PsiElement)paramExpr), message);
            }
        }
    }

    private static final class InvokeCallVisitor
    extends JavaRecursiveElementVisitor {
        private final PsiMethodCallExpression mLoadMethod;
        private final JavaContext mContext;
        private String mLoadVariable;
        private String mMethodVariable;
        private boolean mProcessingDone;
        private PsiParameter mPsiParameter;

        public InvokeCallVisitor(JavaContext context, PsiMethodCallExpression expression) {
            this.mContext = context;
            this.mLoadMethod = expression;
        }

        public void visitElement(PsiElement element) {
            if (!this.mProcessingDone) {
                super.visitElement(element);
            }
        }

        public void visitMethodCallExpression(PsiMethodCallExpression expression) {
            super.visitMethodCallExpression(expression);
            if (expression == this.mLoadMethod) {
                PsiVariable variable = CleanupDetector.getVariableElement((PsiElement)expression);
                this.mLoadVariable = variable == null ? null : variable.getName();
            } else if (this.mLoadVariable != null && InvokeCallVisitor.isDesiredMethodCall(expression, this.mLoadVariable, "java.lang.Class", "getMethod", 0)) {
                PsiExpression arg = InvokeCallVisitor.methodParameterAt(expression, 0);
                String value = ConstantEvaluator.evaluateString(this.mContext, (PsiElement)arg, false);
                if ("get".equals(value)) {
                    PsiVariable variable = CleanupDetector.getVariableElement((PsiElement)expression);
                    this.mMethodVariable = variable == null ? null : variable.getName();
                }
            } else if (this.mMethodVariable != null && InvokeCallVisitor.isDesiredMethodCall(expression, this.mMethodVariable, "java.lang.reflect.Method", "invoke", 1)) {
                PsiElement resolved;
                PsiExpression arg = InvokeCallVisitor.methodParameterAt(expression, 1);
                String value = ConstantEvaluator.evaluateString(this.mContext, (PsiElement)arg, false);
                if (HardwareIdDetector.RO_SERIALNO.equals(value)) {
                    this.mContext.report(ISSUE, (PsiElement)arg, this.mContext.getLocation((PsiElement)arg), String.format(HardwareIdDetector.MESSAGE_DEVICE_IDENTIFIERS, HardwareIdDetector.RO_SERIALNO));
                } else if (arg instanceof PsiReferenceExpression && (resolved = ((PsiReferenceExpression)arg).resolve()) instanceof PsiParameter) {
                    this.mPsiParameter = (PsiParameter)resolved;
                }
                this.mProcessingDone = true;
            }
        }

        PsiParameter getPsiParameter() {
            return this.mPsiParameter;
        }

        private static PsiExpression methodParameterAt(PsiMethodCallExpression expression, int index) {
            PsiExpression[] expressions = expression.getArgumentList().getExpressions();
            assert (expressions.length > index);
            return expressions[index];
        }

        private static boolean isDesiredMethodCall(PsiMethodCallExpression expression, String variableQualifier, String containingClass, String desiredMethodName, int paramIndex) {
            if (!desiredMethodName.equals(expression.getMethodExpression().getReferenceName())) {
                return false;
            }
            PsiExpression qualifierExpression = expression.getMethodExpression().getQualifierExpression();
            if (qualifierExpression == null || !variableQualifier.equals(qualifierExpression.getText())) {
                return false;
            }
            PsiMethod method = expression.resolveMethod();
            return method != null && method.getContainingClass() != null && containingClass.equals(method.getContainingClass().getQualifiedName()) && expression.getArgumentList().getExpressions().length > paramIndex;
        }
    }
}

