/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options;

import com.intellij.application.options.codeStyle.OptionTreeWithPreviewPanel;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.ui.OnePixelDivider;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsCustomizable;
import com.intellij.psi.codeStyle.JavaCodeStyleSettings;
import com.intellij.psi.codeStyle.LanguageCodeStyleSettingsProvider;
import com.intellij.ui.border.CustomLineBorder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaDocFormattingPanel
extends OptionTreeWithPreviewPanel {
    private JCheckBox myEnableCheckBox;
    private final JPanel myJavaDocPanel = new JPanel(new BorderLayout());
    public static final String OTHER_GROUP = ApplicationBundle.message((String)"group.javadoc.other", (Object[])new Object[0]);
    public static final String INVALID_TAGS_GROUP = ApplicationBundle.message((String)"group.javadoc.invalid.tags", (Object[])new Object[0]);
    public static final String BLANK_LINES_GROUP = ApplicationBundle.message((String)"group.javadoc.blank.lines", (Object[])new Object[0]);
    public static final String ALIGNMENT_GROUP = ApplicationBundle.message((String)"group.javadoc.alignment", (Object[])new Object[0]);

    public JavaDocFormattingPanel(CodeStyleSettings settings) {
        super(settings);
        this.init();
    }

    @Override
    protected void init() {
        super.init();
        this.myEnableCheckBox = new JCheckBox(ApplicationBundle.message((String)"checkbox.enable.javadoc.formatting", (Object[])new Object[0]));
        this.myEnableCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JavaDocFormattingPanel.this.update();
            }
        });
        this.myPanel.setBorder((Border)new CustomLineBorder(OnePixelDivider.BACKGROUND, 1, 0, 0, 0));
        this.myJavaDocPanel.add("Center", this.myPanel);
        this.myJavaDocPanel.add((Component)this.myEnableCheckBox, "North");
    }

    @Override
    public LanguageCodeStyleSettingsProvider.SettingsType getSettingsType() {
        return LanguageCodeStyleSettingsProvider.SettingsType.LANGUAGE_SPECIFIC;
    }

    @Override
    public JComponent getPanel() {
        return this.myJavaDocPanel;
    }

    private void update() {
        JavaDocFormattingPanel.setEnabled(this.getPanel(), this.myEnableCheckBox.isSelected());
        this.myEnableCheckBox.setEnabled(true);
    }

    @Override
    protected void initTables() {
        this.initCustomOptions(ALIGNMENT_GROUP);
        this.initCustomOptions(BLANK_LINES_GROUP);
        this.initCustomOptions(INVALID_TAGS_GROUP);
        this.initBooleanField("WRAP_COMMENTS", ApplicationBundle.message((String)"checkbox.wrap.at.right.margin", (Object[])new Object[0]), OTHER_GROUP);
        this.initCustomOptions(OTHER_GROUP);
    }

    @Override
    protected int getRightMargin() {
        return 47;
    }

    @Override
    protected String getPreviewText() {
        return "package sample;\npublic class Sample {\n  /**\n   * This is a method description that is long enough to exceed right margin.\n   *\n   * Another paragraph of the description placed after blank line.\n   * <p/>\n   * Line with manual\n   * line feed.\n   * @param i short named parameter description\n   * @param longParameterName long named parameter description\n   * @param missingDescription\n   * @return return description.\n   * @throws XXXException description.\n   * @throws YException description.\n   * @throws ZException\n   *\n   * @invalidTag   */\n  public abstract String sampleMethod(int i, int longParameterName, int missingDescription) throws XXXException, YException, ZException;\n\n  /** One-line comment */\n  public abstract String sampleMethod2();\n\n  /**\n   * Simple method description\n   * @return\n   */\n  public abstract String sampleMethod3();\n";
    }

    private static void setEnabled(JComponent c, boolean enabled) {
        Component[] children2;
        c.setEnabled(enabled);
        for (Component child : children2 = c.getComponents()) {
            if (!(child instanceof JComponent)) continue;
            JavaDocFormattingPanel.setEnabled((JComponent)child, enabled);
        }
    }

    @Override
    public void apply(CodeStyleSettings settings) {
        super.apply(settings);
        ((JavaCodeStyleSettings)settings.getCustomSettings(JavaCodeStyleSettings.class)).ENABLE_JAVADOC_FORMATTING = this.myEnableCheckBox.isSelected();
    }

    @Override
    protected void resetImpl(CodeStyleSettings settings) {
        super.resetImpl(settings);
        this.myEnableCheckBox.setSelected(((JavaCodeStyleSettings)settings.getCustomSettings(JavaCodeStyleSettings.class)).ENABLE_JAVADOC_FORMATTING);
        this.update();
    }

    @Override
    public boolean isModified(CodeStyleSettings settings) {
        return super.isModified(settings) || this.myEnableCheckBox.isSelected() != ((JavaCodeStyleSettings)settings.getCustomSettings(JavaCodeStyleSettings.class)).ENABLE_JAVADOC_FORMATTING;
    }

    @Override
    @NotNull
    protected final FileType getFileType() {
        LanguageFileType languageFileType = StdFileTypes.JAVA;
        if (languageFileType == null) {
            JavaDocFormattingPanel.$$$reportNull$$$0(0);
        }
        return languageFileType;
    }

    @Override
    protected void customizeSettings() {
        LanguageCodeStyleSettingsProvider provider = LanguageCodeStyleSettingsProvider.forLanguage((Language)JavaLanguage.INSTANCE);
        if (provider != null) {
            provider.customizeSettings((CodeStyleSettingsCustomizable)this, this.getSettingsType());
        }
    }

    @Override
    protected String getTabTitle() {
        return ApplicationBundle.message((String)"title.javadoc", (Object[])new Object[0]);
    }

    @Override
    @Nullable
    public Language getDefaultLanguage() {
        return JavaLanguage.INSTANCE;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/application/options/JavaDocFormattingPanel", "getFileType"));
    }
}

