/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.colors.fileStatus;

import com.intellij.application.options.colors.fileStatus.FileStatusColorDescriptor;
import com.intellij.application.options.colors.fileStatus.FileStatusColorsTableModel;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.table.JBTable;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class FileStatusColorsTable
extends JBTable {
    public FileStatusColorsTable() {
        this.setShowGrid(false);
        this.setIntercellSpacing(new Dimension(0, 0));
        this.getColumnModel().setColumnSelectionAllowed(false);
        this.setSelectionMode(0);
        this.setDefaultRenderer(String.class, new MyStatusCellRenderer());
        this.setDefaultRenderer(Boolean.class, new MyDefaultStatusRenderer());
        this.setTableHeader(null);
        this.setRowHeight(JBUI.scale((int)22));
    }

    public void adjustColumnWidths() {
        for (int col = 0; col < this.getColumnCount(); ++col) {
            DefaultTableColumnModel colModel = (DefaultTableColumnModel)this.getColumnModel();
            TableColumn column = colModel.getColumn(col);
            Class colClass = this.getColumnClass(col);
            int width = 0;
            int rightGap = 0;
            if (this.getColumnClass(col).equals(Boolean.class)) {
                width = JBUI.scale((int)15);
            } else {
                rightGap = this.isColorColumn(col) ? JBUI.size((int)10, (int)1).width : 0;
                for (int row = 0; row < this.getRowCount(); ++row) {
                    TableCellRenderer renderer = this.getCellRenderer(row, col);
                    Component comp = renderer.getTableCellRendererComponent((JTable)((Object)this), this.getValueAt(row, col), false, false, row, col);
                    width = Math.max(width, comp.getPreferredSize().width);
                }
            }
            column.setPreferredWidth(width += rightGap);
            if (!colClass.equals(Color.class) && !colClass.equals(Boolean.class)) continue;
            column.setMinWidth(width);
            column.setMaxWidth(width);
        }
    }

    private boolean isColorColumn(int col) {
        return this.getModel().getColumnClass(col).equals(Color.class);
    }

    private static class MyDefaultStatusRenderer
    extends DefaultTableCellRenderer {
        private final JLabel myLabel = new JLabel();
        private final Color myLabelColor;

        public MyDefaultStatusRenderer() {
            this.myLabel.setOpaque(true);
            this.myLabelColor = ColorUtil.withAlpha((Color)this.myLabel.getForeground(), (double)0.5);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value2, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value2 instanceof Boolean) {
                this.myLabel.setForeground(isSelected ? UIUtil.getTableSelectionForeground() : this.myLabelColor);
                this.myLabel.setBackground(UIUtil.getTableBackground((boolean)isSelected));
                this.myLabel.setText((Boolean)value2 != false ? "" : "* ");
                this.myLabel.setHorizontalAlignment(4);
                return this.myLabel;
            }
            return super.getTableCellRendererComponent(table, value2, isSelected, hasFocus, row, column);
        }
    }

    private class MyStatusCellRenderer
    extends DefaultTableCellRenderer {
        private final JLabel myLabel = new JLabel();

        public MyStatusCellRenderer() {
            this.myLabel.setOpaque(true);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value2, boolean isSelected, boolean hasFocus, int row, int column) {
            FileStatusColorDescriptor descriptor2;
            Component c = super.getTableCellRendererComponent(table, value2, isSelected, hasFocus, row, column);
            if (value2 instanceof String && (descriptor2 = ((FileStatusColorsTableModel)FileStatusColorsTable.this.getModel()).getDescriptorByName((String)value2)) != null) {
                this.myLabel.setText((String)value2);
                this.myLabel.setForeground(isSelected ? UIUtil.getTableSelectionForeground() : descriptor2.getColor());
                this.myLabel.setBackground(UIUtil.getTableBackground((boolean)isSelected));
                return this.myLabel;
            }
            return c;
        }
    }
}

