/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.build;

import com.intellij.build.BuildContentManager;
import com.intellij.build.BuildContentManagerImpl;
import com.intellij.build.BuildDescriptor;
import com.intellij.build.BuildProgressListener;
import com.intellij.build.BuildView;
import com.intellij.build.DefaultBuildDescriptor;
import com.intellij.build.ExecutionNodeProgressAnimator;
import com.intellij.build.MultipleBuildsView;
import com.intellij.build.ViewManager;
import com.intellij.build.events.BuildEvent;
import com.intellij.build.events.EventResult;
import com.intellij.build.events.Failure;
import com.intellij.build.events.FailureResult;
import com.intellij.build.events.SkippedResult;
import com.intellij.build.events.StartBuildEvent;
import com.intellij.execution.ExecutionBundle;
import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.notification.Notification;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Toggleable;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.AtomicClearableLazyValue;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.ui.SystemNotifications;
import com.intellij.ui.content.Content;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.UIUtil;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.Icon;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
public abstract class AbstractViewManager
implements ViewManager,
BuildProgressListener,
Disposable {
    private static final Key<Boolean> PINNED_EXTRACTED_CONTENT = new Key("PINNED_EXTRACTED_CONTENT");
    protected final Project myProject;
    protected final BuildContentManager myBuildContentManager;
    private final AtomicClearableLazyValue<MultipleBuildsView> myBuildsViewValue;
    private final Set<MultipleBuildsView> myPinnedViews;
    private final AtomicBoolean isDisposed = new AtomicBoolean(false);

    public AbstractViewManager(Project project2, BuildContentManager buildContentManager) {
        this.myProject = project2;
        this.myBuildContentManager = buildContentManager;
        this.myBuildsViewValue = new AtomicClearableLazyValue<MultipleBuildsView>(){

            @NotNull
            protected MultipleBuildsView compute() {
                MultipleBuildsView buildsView = new MultipleBuildsView(AbstractViewManager.this.myProject, AbstractViewManager.this.myBuildContentManager, AbstractViewManager.this);
                Disposer.register((Disposable)AbstractViewManager.this, (Disposable)buildsView);
                MultipleBuildsView multipleBuildsView = buildsView;
                if (multipleBuildsView == null) {
                    1.$$$reportNull$$$0(0);
                }
                return multipleBuildsView;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/build/AbstractViewManager$1", "compute"));
            }
        };
        this.myPinnedViews = ContainerUtil.newConcurrentSet();
    }

    @Override
    public boolean isConsoleEnabledByDefault() {
        return false;
    }

    @Override
    public boolean isBuildContentView() {
        return true;
    }

    protected abstract String getViewName();

    protected Map<BuildInfo, BuildView> getBuildsMap() {
        return ((MultipleBuildsView)this.myBuildsViewValue.getValue()).getBuildsMap();
    }

    @Override
    public void onEvent(BuildEvent event) {
        MultipleBuildsView buildsView;
        if (this.isDisposed.get()) {
            return;
        }
        if (event instanceof StartBuildEvent) {
            this.configurePinnedContent();
            buildsView = (MultipleBuildsView)this.myBuildsViewValue.getValue();
        } else {
            buildsView = (MultipleBuildsView)this.myBuildsViewValue.getValue();
            if (!buildsView.shouldConsume(event)) {
                buildsView = this.myPinnedViews.stream().filter(pinnedView -> pinnedView.shouldConsume(event)).findFirst().orElse(null);
            }
        }
        if (buildsView != null) {
            buildsView.onEvent(event);
        }
    }

    void configureToolbar(DefaultActionGroup toolbarActions, MultipleBuildsView buildsView, BuildView view) {
        toolbarActions.removeAll();
        toolbarActions.addAll(view.createConsoleActions());
        toolbarActions.add((AnAction)new PinBuildViewAction(buildsView));
        toolbarActions.add((AnAction)new CloseBuildContentAction(buildsView));
    }

    @Nullable
    protected Icon getContentIcon() {
        return null;
    }

    protected void onBuildStart(BuildDescriptor buildDescriptor) {
    }

    protected void onBuildFinish(BuildDescriptor buildDescriptor) {
        BuildInfo buildInfo = (BuildInfo)buildDescriptor;
        if (buildInfo.result instanceof FailureResult) {
            boolean activate = buildInfo.activateToolWindowWhenFailed;
            this.myBuildContentManager.setSelectedContent(buildInfo.content, activate, activate, activate, null);
            List<? extends Failure> failures = ((FailureResult)buildInfo.result).getFailures();
            if (failures.isEmpty()) {
                return;
            }
            Failure failure = failures.get(0);
            Notification notification = failure.getNotification();
            if (notification != null) {
                String title = notification.getTitle();
                String content = notification.getContent();
                SystemNotifications.getInstance().notify(ToolWindowId.BUILD, title, content);
            }
        }
    }

    public void dispose() {
        this.isDisposed.set(true);
        this.myPinnedViews.clear();
        this.myBuildsViewValue.drop();
    }

    private void configurePinnedContent() {
        MultipleBuildsView buildsView = (MultipleBuildsView)this.myBuildsViewValue.getValue();
        Content content = buildsView.getContent();
        if (content != null && content.isPinned()) {
            String tabName = this.getPinnedTabName(buildsView);
            UIUtil.invokeLaterIfNeeded(() -> {
                content.setPinnable(false);
                if (content.getIcon() == null) {
                    content.setIcon(EmptyIcon.ICON_8);
                }
                content.putUserData(ToolWindow.SHOW_CONTENT_ICON, (Object)Boolean.TRUE);
                ((BuildContentManagerImpl)this.myBuildContentManager).updateTabDisplayName(content, tabName);
            });
            this.myPinnedViews.add(buildsView);
            this.myBuildsViewValue.drop();
            content.putUserData(PINNED_EXTRACTED_CONTENT, (Object)Boolean.TRUE);
        }
    }

    private String getPinnedTabName(MultipleBuildsView buildsView) {
        Map<BuildInfo, BuildView> buildsMap = buildsView.getBuildsMap();
        BuildInfo buildInfo = buildsMap.keySet().stream().reduce((b1, b2) -> b1.getStartTime() <= b2.getStartTime() ? b1 : b2).orElse(null);
        if (buildInfo != null) {
            String title = buildInfo.getTitle();
            String viewName = this.getViewName();
            String tabName = viewName + ": " + StringUtil.trimStart((String)title, (String)viewName);
            if (buildsMap.size() > 1) {
                tabName = tabName + String.format(" and %d more", buildsMap.size() - 1);
            }
            return tabName;
        }
        return this.getViewName();
    }

    private class CloseBuildContentAction
    extends AnAction
    implements DumbAware {
        private MultipleBuildsView myBuildsView;

        public CloseBuildContentAction(MultipleBuildsView buildsView) {
            this.myBuildsView = buildsView;
            AnAction action = ActionManager.getInstance().getAction("CloseContent");
            this.copyFrom(action);
            this.registerCustomShortcutSet(action.getShortcutSet(), buildsView.getContent().getPreferredFocusableComponent());
            Presentation templatePresentation = this.getTemplatePresentation();
            templatePresentation.setIcon(AllIcons.Actions.Cancel);
            templatePresentation.setText(ExecutionBundle.message((String)"close.tab.action.name", (Object[])new Object[0]));
            templatePresentation.setDescription(null);
        }

        public void actionPerformed(AnActionEvent e) {
            if (this.myBuildsView == null) {
                return;
            }
            Content content = this.myBuildsView.getContent();
            if (!content.isValid()) {
                return;
            }
            content.getManager().removeContent(content, true, true, true);
            if (AbstractViewManager.this.myBuildsViewValue.getValue() == this.myBuildsView) {
                AbstractViewManager.this.myBuildsViewValue.drop();
            } else {
                AbstractViewManager.this.myPinnedViews.remove(this.myBuildsView);
            }
            this.myBuildsView = null;
        }

        public void update(AnActionEvent e) {
            if (this.myBuildsView != null && this.myBuildsView.hasRunningBuilds()) {
                e.getPresentation().setEnabled(false);
            } else {
                e.getPresentation().setEnabled(this.myBuildsView != null);
            }
        }
    }

    private static class PinBuildViewAction
    extends DumbAwareAction
    implements Toggleable {
        private final Content myContent;

        public PinBuildViewAction(MultipleBuildsView buildsView) {
            this.myContent = buildsView.getContent();
        }

        public void actionPerformed(AnActionEvent e) {
            boolean selected;
            boolean bl = selected = !this.myContent.isPinned();
            if (selected) {
                this.myContent.putUserData(ToolWindow.SHOW_CONTENT_ICON, (Object)Boolean.TRUE);
            }
            this.myContent.setPinned(selected);
            e.getPresentation().putClientProperty("selected", (Object)selected);
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                PinBuildViewAction.$$$reportNull$$$0(0);
            }
            if (!this.myContent.isValid()) {
                return;
            }
            Boolean isPinnedAndExtracted = (Boolean)this.myContent.getUserData(PINNED_EXTRACTED_CONTENT);
            if (isPinnedAndExtracted == Boolean.TRUE) {
                e.getPresentation().setEnabledAndVisible(false);
                return;
            }
            boolean isActiveTab = this.myContent.getManager().getSelectedContent() == this.myContent;
            boolean selected = this.myContent.isPinned();
            e.getPresentation().setIcon(AllIcons.General.Pin_tab);
            e.getPresentation().putClientProperty("selected", (Object)selected);
            String text2 = !isActiveTab ? (selected ? IdeBundle.message((String)"action.unpin.active.tab", (Object[])new Object[0]) : IdeBundle.message((String)"action.pin.active.tab", (Object[])new Object[0])) : (selected ? IdeBundle.message((String)"action.unpin.tab", (Object[])new Object[0]) : IdeBundle.message((String)"action.pin.tab", (Object[])new Object[0]));
            e.getPresentation().setText(text2);
            e.getPresentation().setEnabledAndVisible(true);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/build/AbstractViewManager$PinBuildViewAction", "update"));
        }
    }

    static class BuildInfo
    extends DefaultBuildDescriptor {
        String message;
        String statusMessage;
        long endTime;
        EventResult result;
        Content content;
        boolean activateToolWindowWhenAdded;
        boolean activateToolWindowWhenFailed;

        public BuildInfo(@NotNull Object id, @NotNull String title, @NotNull String workingDir, long startTime) {
            if (id == null) {
                BuildInfo.$$$reportNull$$$0(0);
            }
            if (title == null) {
                BuildInfo.$$$reportNull$$$0(1);
            }
            if (workingDir == null) {
                BuildInfo.$$$reportNull$$$0(2);
            }
            super(id, title, workingDir, startTime);
            this.endTime = -1L;
            this.activateToolWindowWhenFailed = true;
        }

        public Icon getIcon() {
            return BuildInfo.getIcon(this.result);
        }

        private static Icon getIcon(EventResult result2) {
            if (result2 == null) {
                return ExecutionNodeProgressAnimator.getCurrentFrame();
            }
            if (result2 instanceof FailureResult) {
                return AllIcons.Process.State.RedExcl;
            }
            if (result2 instanceof SkippedResult) {
                return AllIcons.Process.State.YellowStr;
            }
            return AllIcons.Process.State.GreenOK;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "id";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "title";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "workingDir";
                    break;
                }
            }
            objectArray[1] = "com/intellij/build/AbstractViewManager$BuildInfo";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

