/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.build;

import com.intellij.build.BuildContentManager;
import com.intellij.build.BuildDescriptor;
import com.intellij.build.process.BuildProcessHandler;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.TerminateRemoteProcessDialog;
import com.intellij.execution.runners.ExecutionUtil;
import com.intellij.execution.ui.RunContentManagerImpl;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.ide.GeneralSettings;
import com.intellij.ide.impl.ContentManagerWatcher;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.project.VetoableProjectManagerListener;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.impl.ToolWindowImpl;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.ContentManagerAdapter;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.content.ContentManagerListener;
import com.intellij.ui.content.TabbedContent;
import com.intellij.util.ContentUtilEx;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public class BuildContentManagerImpl
implements BuildContentManager {
    public static final String Build = "Build";
    public static final String Sync = "Sync";
    public static final String Run = "Run";
    public static final String Debug = "Debug";
    private static final String[] ourPresetOrder = new String[]{"Build", "Sync", "Run", "Debug"};
    private static final Key<Map<Object, CloseListener>> CONTENT_CLOSE_LISTENERS = Key.create((String)"CONTENT_CLOSE_LISTENERS");
    private Project myProject;
    private ToolWindow myToolWindow;
    private final List<Runnable> myPostponedRunnables = new ArrayList<Runnable>();
    private Map<Content, Pair<Icon, AtomicInteger>> liveContentsMap = ContainerUtil.newConcurrentMap();

    public BuildContentManagerImpl(Project project2) {
        this.init(project2);
    }

    private void init(Project project2) {
        this.myProject = project2;
        if (project2.isDefault()) {
            return;
        }
        StartupManager.getInstance((Project)project2).runWhenProjectIsInitialized(() -> {
            ToolWindow toolWindow = ToolWindowManager.getInstance((Project)project2).registerToolWindow(ToolWindowId.BUILD, true, ToolWindowAnchor.BOTTOM, (Disposable)project2, true);
            JComponent component = toolWindow.getComponent();
            if (component != null) {
                component.putClientProperty("HideIdLabel", "true");
            }
            toolWindow.setIcon(AllIcons.Toolwindows.ToolWindowBuild);
            toolWindow.setAvailable(true, null);
            toolWindow.hide(null);
            this.myToolWindow = toolWindow;
            final ContentManager contentManager = this.myToolWindow.getContentManager();
            contentManager.addDataProvider(new DataProvider(){
                private int myInsideGetData = 0;

                public Object getData(String dataId) {
                    ++this.myInsideGetData;
                    try {
                        Object object = this.myInsideGetData == 1 ? DataManager.getInstance().getDataContext((Component)contentManager.getComponent()).getData(dataId) : null;
                        return object;
                    }
                    finally {
                        --this.myInsideGetData;
                    }
                }
            });
            new ContentManagerWatcher(toolWindow, contentManager);
            for (Runnable postponedRunnable : this.myPostponedRunnables) {
                postponedRunnable.run();
            }
            this.myPostponedRunnables.clear();
        });
    }

    public Promise<Void> runWhenInitialized(Runnable runnable2) {
        if (this.myToolWindow != null) {
            runnable2.run();
            return Promises.resolvedPromise(null);
        }
        AsyncPromise promise2 = new AsyncPromise();
        this.myPostponedRunnables.add(() -> {
            if (!this.myProject.isDisposed()) {
                runnable2.run();
                promise2.setResult(null);
            }
        });
        return promise2;
    }

    @Override
    public void addContent(Content content) {
        this.runWhenInitialized(() -> {
            if (!this.myToolWindow.isAvailable()) {
                this.myToolWindow.setAvailable(true, null);
            }
            ContentManager contentManager = this.myToolWindow.getContentManager();
            String name2 = content.getTabName();
            String category = StringUtil.trimEnd((String)((String)StringUtil.split((String)name2, (String)" ").get(0)), (char)':');
            int idx = -1;
            for (int i = 0; i < ourPresetOrder.length; ++i) {
                String s = ourPresetOrder[i];
                if (!s.equals(category)) continue;
                idx = i;
                break;
            }
            Content[] existingContents = contentManager.getContents();
            if (idx != -1) {
                Content[] existingCategoriesNames = MultiMap.createSmart();
                Content[] contentArray = existingContents;
                int n = contentArray.length;
                for (int i = 0; i < n; ++i) {
                    Content existingContent = contentArray[i];
                    String tabName = existingContent.getTabName();
                    existingCategoriesNames.putValue((Object)StringUtil.trimEnd((String)((String)StringUtil.split((String)tabName, (String)" ").get(0)), (char)':'), (Object)tabName);
                }
                int place = 0;
                for (int i = 0; i < idx; ++i) {
                    String key2 = ourPresetOrder[i];
                    Collection tabNames = existingCategoriesNames.get((Object)key2);
                    if (key2.equals(category)) continue;
                    place += tabNames.size();
                }
                contentManager.addContent(content, place);
            } else {
                contentManager.addContent(content);
            }
            for (Content existingContent : existingContents) {
                existingContent.setDisplayName(existingContent.getTabName());
            }
            String tabName = content.getTabName();
            this.updateTabDisplayName(content, tabName);
        });
    }

    public void updateTabDisplayName(Content content, String tabName) {
        this.runWhenInitialized(() -> {
            String displayName;
            ContentManager contentManager = this.myToolWindow.getContentManager();
            Content firstContent = contentManager.getContent(0);
            assert (firstContent != null);
            if (!Build.equals(firstContent.getTabName())) {
                if (contentManager.getContentCount() > 1) {
                    this.setIdLabelHidden(false);
                    displayName = tabName;
                } else {
                    displayName = "Build: " + tabName;
                }
            } else {
                displayName = tabName;
                this.setIdLabelHidden(true);
            }
            if (!displayName.equals(content.getDisplayName())) {
                content.setTabName(tabName);
                content.setDisplayName(displayName);
            }
        });
    }

    @Override
    public void removeContent(Content content) {
        this.runWhenInitialized(() -> {
            ContentManager contentManager = this.myToolWindow.getContentManager();
            if (contentManager != null && !contentManager.isDisposed()) {
                contentManager.removeContent(content, true);
            }
        });
    }

    @Override
    public ActionCallback setSelectedContent(@NotNull Content content, boolean requestFocus, boolean forcedFocus, boolean activate, @Nullable Runnable activationCallback) {
        if (content == null) {
            BuildContentManagerImpl.$$$reportNull$$$0(0);
        }
        ActionCallback actionCallback = new ActionCallback();
        Disposer.register((Disposable)content, (Disposable)actionCallback);
        this.runWhenInitialized(() -> {
            if (content == null) {
                BuildContentManagerImpl.$$$reportNull$$$0(10);
            }
            if (!this.myToolWindow.isAvailable()) {
                actionCallback.setRejected();
                return;
            }
            if (activate) {
                this.myToolWindow.show(activationCallback);
            }
            ActionCallback callback = this.myToolWindow.getContentManager().setSelectedContent(content, requestFocus, forcedFocus, false);
            callback.notify(actionCallback);
        });
        return actionCallback;
    }

    @Override
    public Content addTabbedContent(@NotNull JComponent contentComponent, @NotNull String groupPrefix, @NotNull String tabName, @Nullable Icon icon, @Nullable Disposable childDisposable) {
        TabbedContent tabbedContent;
        if (contentComponent == null) {
            BuildContentManagerImpl.$$$reportNull$$$0(1);
        }
        if (groupPrefix == null) {
            BuildContentManagerImpl.$$$reportNull$$$0(2);
        }
        if (tabName == null) {
            BuildContentManagerImpl.$$$reportNull$$$0(3);
        }
        ContentManager contentManager = this.myToolWindow.getContentManager();
        ContentUtilEx.addTabbedContent(contentManager, contentComponent, groupPrefix, tabName, false, childDisposable);
        Content content = contentManager.findContent(ContentUtilEx.getFullName(groupPrefix, tabName));
        if (icon != null && (tabbedContent = ContentUtilEx.findTabbedContent(contentManager, groupPrefix)) != null) {
            tabbedContent.putUserData(ToolWindow.SHOW_CONTENT_ICON, (Object)Boolean.TRUE);
            tabbedContent.setIcon(icon);
        }
        return content;
    }

    public void startBuildNotified(@NotNull BuildDescriptor buildDescriptor, @NotNull Content content, @Nullable BuildProcessHandler processHandler2) {
        if (buildDescriptor == null) {
            BuildContentManagerImpl.$$$reportNull$$$0(4);
        }
        if (content == null) {
            BuildContentManagerImpl.$$$reportNull$$$0(5);
        }
        if (processHandler2 != null) {
            Map closeListenerMap = (Map)content.getUserData(CONTENT_CLOSE_LISTENERS);
            if (closeListenerMap == null) {
                closeListenerMap = ContainerUtil.newHashMap();
                content.putUserData(CONTENT_CLOSE_LISTENERS, (Object)closeListenerMap);
            }
            closeListenerMap.put(buildDescriptor.getId(), new CloseListener(content, processHandler2));
        }
        this.runWhenInitialized(() -> {
            if (content == null) {
                BuildContentManagerImpl.$$$reportNull$$$0(9);
            }
            Pair pair2 = this.liveContentsMap.computeIfAbsent(content, c -> Pair.pair((Object)c.getIcon(), (Object)new AtomicInteger(0)));
            ((AtomicInteger)pair2.second).incrementAndGet();
            content.putUserData(ToolWindow.SHOW_CONTENT_ICON, (Object)Boolean.TRUE);
            content.setIcon(ExecutionUtil.getLiveIndicator((Icon)((Icon)pair2.first)));
            JComponent component = content.getComponent();
            if (component != null) {
                component.invalidate();
            }
            this.myToolWindow.setIcon(ExecutionUtil.getLiveIndicator((Icon)AllIcons.Toolwindows.ToolWindowBuild));
        });
    }

    public void finishBuildNotified(@NotNull BuildDescriptor buildDescriptor, @NotNull Content content) {
        CloseListener closeListener;
        Map closeListenerMap;
        if (buildDescriptor == null) {
            BuildContentManagerImpl.$$$reportNull$$$0(6);
        }
        if (content == null) {
            BuildContentManagerImpl.$$$reportNull$$$0(7);
        }
        if ((closeListenerMap = (Map)content.getUserData(CONTENT_CLOSE_LISTENERS)) != null && (closeListener = (CloseListener)((Object)closeListenerMap.remove(buildDescriptor.getId()))) != null) {
            Disposer.dispose((Disposable)closeListener);
            if (closeListenerMap.isEmpty()) {
                content.putUserData(CONTENT_CLOSE_LISTENERS, null);
            }
        }
        this.runWhenInitialized(() -> {
            Pair<Icon, AtomicInteger> pair2;
            if (content == null) {
                BuildContentManagerImpl.$$$reportNull$$$0(8);
            }
            if ((pair2 = this.liveContentsMap.get(content)) != null && ((AtomicInteger)pair2.second).decrementAndGet() == 0) {
                content.setIcon((Icon)pair2.first);
                if (pair2.first == null) {
                    content.putUserData(ToolWindow.SHOW_CONTENT_ICON, (Object)Boolean.FALSE);
                }
                this.liveContentsMap.remove(content);
                if (this.liveContentsMap.isEmpty()) {
                    this.myToolWindow.setIcon(AllIcons.Toolwindows.ToolWindowBuild);
                }
            }
        });
    }

    private void setIdLabelHidden(boolean hide) {
        JComponent component = this.myToolWindow.getComponent();
        Object oldValue = component.getClientProperty("HideIdLabel");
        String newValue = hide ? "true" : null;
        component.putClientProperty("HideIdLabel", newValue);
        if (this.myToolWindow instanceof ToolWindowImpl) {
            ((ToolWindowImpl)this.myToolWindow).getContentUI().propertyChange(new PropertyChangeEvent(this, "HideIdLabel", oldValue, newValue));
        }
    }

    private void waitForProcess(final boolean modal, final BuildProcessHandler processHandler2) {
        String title = ExecutionBundle.message((String)"terminating.process.progress.title", (Object[])new Object[]{processHandler2.getExecutionName()});
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(this.myProject, title, true){

            public boolean isConditionalModal() {
                return modal;
            }

            public boolean shouldStartInBackground() {
                return !modal;
            }

            public void run(final @NotNull ProgressIndicator progressIndicator) {
                if (progressIndicator == null) {
                    2.$$$reportNull$$$0(0);
                }
                final Semaphore semaphore = new Semaphore();
                semaphore.down();
                ApplicationManager.getApplication().executeOnPooledThread(() -> {
                    try {
                        processHandler2.waitFor();
                    }
                    finally {
                        semaphore.up();
                    }
                });
                progressIndicator.setText(ExecutionBundle.message((String)"waiting.for.vm.detach.progress.text", (Object[])new Object[0]));
                ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        while (true) {
                            if (progressIndicator.isCanceled() || !progressIndicator.isRunning()) break;
                            try {
                                1 var1_1 = this;
                                synchronized (var1_1) {
                                    this.wait(2000L);
                                    continue;
                                }
                            }
                            catch (InterruptedException interruptedException) {
                                continue;
                            }
                            break;
                        }
                        semaphore.up();
                    }
                });
                semaphore.waitFor();
            }

            public void onCancel() {
                processHandler2.forceProcessDetach();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progressIndicator", "com/intellij/build/BuildContentManagerImpl$2", "run"));
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentComponent";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groupPrefix";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tabName";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildDescriptor";
                break;
            }
        }
        objectArray2[1] = "com/intellij/build/BuildContentManagerImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "setSelectedContent";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "addTabbedContent";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "startBuildNotified";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "finishBuildNotified";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$finishBuildNotified$8";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$startBuildNotified$7";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$setSelectedContent$5";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private class CloseListener
    extends ContentManagerAdapter
    implements VetoableProjectManagerListener,
    Disposable {
        @Nullable
        private Content myContent;
        @Nullable
        private BuildProcessHandler myProcessHandler;

        private CloseListener(@NotNull Content content, BuildProcessHandler processHandler2) {
            if (content == null) {
                CloseListener.$$$reportNull$$$0(0);
            }
            if (processHandler2 == null) {
                CloseListener.$$$reportNull$$$0(1);
            }
            this.myContent = content;
            ContentManager contentManager = content.getManager();
            if (contentManager != null) {
                contentManager.addContentManagerListener((ContentManagerListener)this);
            }
            ProjectManager.getInstance().addProjectManagerListener(BuildContentManagerImpl.this.myProject, (ProjectManagerListener)this);
            this.myProcessHandler = processHandler2;
        }

        public void contentRemoved(ContentManagerEvent event) {
            Content content = event.getContent();
            if (content == this.myContent) {
                Disposer.dispose((Disposable)this);
            }
        }

        public void dispose() {
            if (this.myContent == null) {
                return;
            }
            Content content = this.myContent;
            ContentManager contentManager = content.getManager();
            if (contentManager != null) {
                contentManager.removeContentManagerListener((ContentManagerListener)this);
            }
            ProjectManager.getInstance().removeProjectManagerListener(BuildContentManagerImpl.this.myProject, (ProjectManagerListener)this);
            this.myContent = null;
            if (this.myProcessHandler instanceof Disposable) {
                Disposer.dispose((Disposable)((Disposable)this.myProcessHandler));
            }
            this.myProcessHandler = null;
        }

        public void contentRemoveQuery(ContentManagerEvent event) {
            boolean canClose;
            if (event.getContent() == this.myContent && !(canClose = this.closeQuery(false))) {
                event.consume();
            }
        }

        public void projectClosed(Project project2) {
            if (this.myContent != null && project2 == BuildContentManagerImpl.this.myProject) {
                ContentManager contentManager = this.myContent.getManager();
                if (contentManager != null) {
                    contentManager.removeContent(this.myContent, true);
                }
                Disposer.dispose((Disposable)this);
            }
        }

        public boolean canClose(@NotNull Project project2) {
            if (project2 == null) {
                CloseListener.$$$reportNull$$$0(2);
            }
            if (project2 != BuildContentManagerImpl.this.myProject) {
                return true;
            }
            if (this.myContent == null) {
                return true;
            }
            boolean canClose = this.closeQuery(true);
            if (canClose && this.myContent != null) {
                ContentManager contentManager = this.myContent.getManager();
                if (contentManager != null) {
                    contentManager.removeContent(this.myContent, true);
                }
                this.myContent = null;
            }
            return canClose;
        }

        private boolean closeQuery(boolean modal) {
            boolean destroyProcess;
            if (this.myProcessHandler == null || this.myProcessHandler.isProcessTerminated() || this.myProcessHandler.isProcessTerminating()) {
                return true;
            }
            this.myProcessHandler.putUserData(RunContentManagerImpl.ALWAYS_USE_DEFAULT_STOPPING_BEHAVIOUR_KEY, Boolean.TRUE);
            GeneralSettings.ProcessCloseConfirmation rc = TerminateRemoteProcessDialog.show(BuildContentManagerImpl.this.myProject, this.myProcessHandler.getExecutionName(), this.myProcessHandler);
            if (rc == null) {
                return false;
            }
            boolean bl = destroyProcess = rc == GeneralSettings.ProcessCloseConfirmation.TERMINATE;
            if (destroyProcess) {
                this.myProcessHandler.destroyProcess();
            } else {
                this.myProcessHandler.detachProcess();
            }
            BuildContentManagerImpl.this.waitForProcess(modal, this.myProcessHandler);
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "content";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "processHandler";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/build/BuildContentManagerImpl$CloseListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "canClose";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

