/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.build;

import com.intellij.build.AbstractViewManager;
import com.intellij.build.BuildContentDescriptor;
import com.intellij.build.BuildContentManager;
import com.intellij.build.BuildContentManagerImpl;
import com.intellij.build.BuildProgressListener;
import com.intellij.build.BuildTreeConsoleView;
import com.intellij.build.BuildView;
import com.intellij.build.DefaultBuildDescriptor;
import com.intellij.build.events.BuildEvent;
import com.intellij.build.events.FinishBuildEvent;
import com.intellij.build.events.StartBuildEvent;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ThreeComponentsSplitter;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.impl.ContentImpl;
import com.intellij.util.Alarm;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.EdtInvocationManager;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Experimental
public class MultipleBuildsView
implements BuildProgressListener,
Disposable {
    protected final Project myProject;
    protected final BuildContentManager myBuildContentManager;
    private final AtomicBoolean isInitializeStarted;
    private final List<Runnable> myPostponedRunnables;
    private final ProgressWatcher myProgressWatcher;
    private final ThreeComponentsSplitter myThreeComponentsSplitter;
    private final JBList<AbstractViewManager.BuildInfo> myBuildsList;
    private final Map<Object, AbstractViewManager.BuildInfo> myBuildsMap;
    private final Map<AbstractViewManager.BuildInfo, BuildView> myViewMap;
    private final AbstractViewManager myViewManager;
    private volatile Content myContent;
    private volatile DefaultActionGroup myToolbarActions;

    public MultipleBuildsView(Project project2, BuildContentManager buildContentManager, AbstractViewManager viewManager) {
        this.myProject = project2;
        this.myBuildContentManager = buildContentManager;
        this.myViewManager = viewManager;
        this.isInitializeStarted = new AtomicBoolean();
        this.myPostponedRunnables = ContainerUtil.createConcurrentList();
        this.myThreeComponentsSplitter = new ThreeComponentsSplitter();
        Disposer.register((Disposable)this, (Disposable)this.myThreeComponentsSplitter);
        this.myBuildsList = new JBList();
        this.myBuildsList.setModel(new DefaultListModel());
        this.myBuildsList.setFixedCellHeight(40);
        this.myBuildsList.installCellRenderer(obj -> {
            AbstractViewManager.BuildInfo buildInfo = (AbstractViewManager.BuildInfo)obj;
            JPanel panel2 = new JPanel(new BorderLayout());
            SimpleColoredComponent mainComponent = new SimpleColoredComponent();
            mainComponent.setIcon(buildInfo.getIcon());
            mainComponent.append(buildInfo.getTitle() + ": ", SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
            mainComponent.append(buildInfo.message, SimpleTextAttributes.REGULAR_ATTRIBUTES);
            panel2.add((Component)mainComponent, "North");
            if (buildInfo.statusMessage != null) {
                SimpleColoredComponent statusComponent = new SimpleColoredComponent();
                statusComponent.setIcon(EmptyIcon.ICON_16);
                statusComponent.append(buildInfo.statusMessage, SimpleTextAttributes.GRAY_ATTRIBUTES);
                panel2.add((Component)statusComponent, "South");
            }
            return panel2;
        });
        this.myViewMap = ContainerUtil.newConcurrentMap();
        this.myBuildsMap = ContainerUtil.newConcurrentMap();
        this.myProgressWatcher = new ProgressWatcher();
    }

    public void dispose() {
    }

    public Content getContent() {
        return this.myContent;
    }

    public Map<AbstractViewManager.BuildInfo, BuildView> getBuildsMap() {
        return Collections.unmodifiableMap(this.myViewMap);
    }

    public boolean shouldConsume(BuildEvent event) {
        return event.getParentId() != null && this.myBuildsMap.containsKey(event.getParentId()) || this.myBuildsMap.containsKey(event.getId());
    }

    @Override
    public void onEvent(BuildEvent event) {
        SmartList runOnEdt = new SmartList();
        if (event instanceof StartBuildEvent) {
            if (this.isInitializeStarted.get()) {
                long currentTime = System.currentTimeMillis();
                DefaultListModel listModel = (DefaultListModel)this.myBuildsList.getModel();
                boolean shouldBeCleared = !listModel.isEmpty();
                for (int i = 0; i < listModel.getSize(); ++i) {
                    AbstractViewManager.BuildInfo info = (AbstractViewManager.BuildInfo)listModel.getElementAt(i);
                    if (info.endTime != -1L && currentTime - info.endTime >= TimeUnit.SECONDS.toMillis(1L)) continue;
                    shouldBeCleared = false;
                    break;
                }
                if (shouldBeCleared) {
                    this.myBuildsMap.clear();
                    SmartList viewsToDispose = new SmartList(this.myViewMap.values());
                    runOnEdt.add(() -> viewsToDispose.forEach(Disposer::dispose));
                    this.myViewMap.clear();
                    listModel.clear();
                    this.myBuildsList.setVisible(false);
                    runOnEdt.add(() -> {
                        this.myThreeComponentsSplitter.setFirstComponent(null);
                        this.myThreeComponentsSplitter.setLastComponent(null);
                    });
                    this.myToolbarActions.removeAll();
                }
            }
            StartBuildEvent startBuildEvent = (StartBuildEvent)event;
            AbstractViewManager.BuildInfo buildInfo = new AbstractViewManager.BuildInfo(event.getId(), startBuildEvent.getBuildTitle(), startBuildEvent.getWorkingDir(), event.getEventTime());
            this.myBuildsMap.put(event.getId(), buildInfo);
        } else if (event.getParentId() != null) {
            AbstractViewManager.BuildInfo buildInfo = this.myBuildsMap.get(event.getParentId());
            assert (buildInfo != null);
            this.myBuildsMap.put(event.getId(), buildInfo);
        }
        runOnEdt.add(() -> {
            AbstractViewManager.BuildInfo buildInfo = this.myBuildsMap.get(event.getId());
            assert (buildInfo != null);
            if (event instanceof StartBuildEvent) {
                RunContentDescriptor contentDescriptor;
                StartBuildEvent startBuildEvent = (StartBuildEvent)event;
                buildInfo.message = startBuildEvent.getMessage();
                DefaultListModel listModel = (DefaultListModel)this.myBuildsList.getModel();
                listModel.addElement(buildInfo);
                BuildView view = this.myViewMap.computeIfAbsent(buildInfo, info -> {
                    DefaultBuildDescriptor buildDescriptor = new DefaultBuildDescriptor(startBuildEvent.getId(), startBuildEvent.getBuildTitle(), startBuildEvent.getWorkingDir(), startBuildEvent.getEventTime());
                    String selectionStateKey = "build.toolwindow." + this.myViewManager.getViewName() + ".selection.state";
                    BuildView buildView = new BuildView(this.myProject, buildDescriptor, selectionStateKey, this.myViewManager);
                    Disposer.register((Disposable)this.myThreeComponentsSplitter, (Disposable)buildView);
                    return buildView;
                });
                view.onEvent(startBuildEvent);
                this.myContent.setPreferredFocusedComponent(view::getPreferredFocusableComponent);
                Supplier<RunContentDescriptor> contentDescriptorSupplier = startBuildEvent.getContentDescriptorSupplier();
                RunContentDescriptor runContentDescriptor = contentDescriptor = contentDescriptorSupplier != null ? contentDescriptorSupplier.get() : null;
                if (contentDescriptor != null) {
                    boolean activateToolWindow;
                    buildInfo.activateToolWindowWhenAdded = activateToolWindow = contentDescriptor.isActivateToolWindowWhenAdded();
                    if (contentDescriptor instanceof BuildContentDescriptor) {
                        buildInfo.activateToolWindowWhenFailed = ((BuildContentDescriptor)contentDescriptor).isActivateToolWindowWhenFailed();
                    }
                    boolean focusContent = contentDescriptor.isAutoFocusContent();
                    this.myBuildContentManager.setSelectedContent(this.myContent, focusContent, focusContent, activateToolWindow, contentDescriptor.getActivationCallback());
                    Disposer.register((Disposable)view, (Disposable)contentDescriptor);
                } else {
                    this.myBuildContentManager.setSelectedContent(this.myContent, true, true, false, null);
                }
                buildInfo.content = this.myContent;
                if (this.myThreeComponentsSplitter.getLastComponent() == null) {
                    this.myThreeComponentsSplitter.setLastComponent((JComponent)view);
                    this.myViewManager.configureToolbar(this.myToolbarActions, this, view);
                }
                if (this.myBuildsList.getModel().getSize() > 1) {
                    JBScrollPane scrollPane = new JBScrollPane();
                    scrollPane.setBorder((Border)JBUI.Borders.empty());
                    scrollPane.setViewportView(this.myBuildsList);
                    this.myThreeComponentsSplitter.setFirstComponent((JComponent)scrollPane);
                    this.myBuildsList.setVisible(true);
                    this.myBuildsList.setSelectedIndex(0);
                    this.myThreeComponentsSplitter.repaint();
                    for (BuildView consoleView : this.myViewMap.values()) {
                        BuildTreeConsoleView buildConsoleView = consoleView.getView(BuildTreeConsoleView.class.getName(), BuildTreeConsoleView.class);
                        if (buildConsoleView == null) continue;
                        buildConsoleView.hideRootNode();
                    }
                } else {
                    this.myThreeComponentsSplitter.setFirstComponent(null);
                }
                this.myViewManager.onBuildStart(buildInfo);
                this.myProgressWatcher.addBuild(buildInfo);
                ((BuildContentManagerImpl)this.myBuildContentManager).startBuildNotified(buildInfo, buildInfo.content, startBuildEvent.getProcessHandler());
            } else {
                if (event instanceof FinishBuildEvent) {
                    buildInfo.endTime = event.getEventTime();
                    buildInfo.message = event.getMessage();
                    buildInfo.result = ((FinishBuildEvent)event).getResult();
                    this.myProgressWatcher.stopBuild(buildInfo);
                    ((BuildContentManagerImpl)this.myBuildContentManager).finishBuildNotified(buildInfo, buildInfo.content);
                    this.myViewManager.onBuildFinish(buildInfo);
                } else {
                    buildInfo.statusMessage = event.getMessage();
                }
                this.myViewMap.get(buildInfo).onEvent(event);
            }
        });
        if (this.myContent == null) {
            this.myPostponedRunnables.addAll((Collection<Runnable>)runOnEdt);
            if (this.isInitializeStarted.compareAndSet(false, true)) {
                UIUtil.invokeLaterIfNeeded(() -> {
                    this.myBuildsList.setSelectionMode(0);
                    this.myBuildsList.addListSelectionListener(new ListSelectionListener(){

                        @Override
                        public void valueChanged(ListSelectionEvent e) {
                            AbstractViewManager.BuildInfo selectedBuild = (AbstractViewManager.BuildInfo)MultipleBuildsView.this.myBuildsList.getSelectedValue();
                            if (selectedBuild == null) {
                                return;
                            }
                            BuildView view = (BuildView)MultipleBuildsView.this.myViewMap.get(selectedBuild);
                            JComponent lastComponent = MultipleBuildsView.this.myThreeComponentsSplitter.getLastComponent();
                            if (view != null && lastComponent != view.getComponent()) {
                                MultipleBuildsView.this.myThreeComponentsSplitter.setLastComponent(view.getComponent());
                                view.getComponent().setVisible(true);
                                if (lastComponent != null) {
                                    lastComponent.setVisible(false);
                                }
                                MultipleBuildsView.this.myViewManager.configureToolbar(MultipleBuildsView.this.myToolbarActions, MultipleBuildsView.this, view);
                                view.getComponent().repaint();
                            }
                            int firstSize = MultipleBuildsView.this.myThreeComponentsSplitter.getFirstSize();
                            int lastSize = MultipleBuildsView.this.myThreeComponentsSplitter.getLastSize();
                            if (firstSize == 0 && lastSize == 0) {
                                EdtInvocationManager.getInstance().invokeLater(() -> {
                                    int width = Math.round((float)MultipleBuildsView.this.myThreeComponentsSplitter.getWidth() / 4.0f);
                                    MultipleBuildsView.this.myThreeComponentsSplitter.setFirstSize(width);
                                });
                            }
                        }
                    });
                    JPanel consoleComponent = new JPanel(new BorderLayout());
                    consoleComponent.add((Component)this.myThreeComponentsSplitter, "Center");
                    this.myToolbarActions = new DefaultActionGroup();
                    consoleComponent.add((Component)ActionManager.getInstance().createActionToolbar("BuildView", (ActionGroup)this.myToolbarActions, false).getComponent(), "West");
                    this.myContent = new ContentImpl(consoleComponent, this.myViewManager.getViewName(), true);
                    Disposer.register((Disposable)this.myContent, (Disposable)this);
                    this.myContent.setCloseable(false);
                    Icon contentIcon = this.myViewManager.getContentIcon();
                    if (contentIcon != null) {
                        this.myContent.setIcon(contentIcon);
                        this.myContent.putUserData(ToolWindow.SHOW_CONTENT_ICON, (Object)Boolean.TRUE);
                    }
                    this.myBuildContentManager.addContent(this.myContent);
                    ArrayList<Runnable> postponedRunnables = new ArrayList<Runnable>(this.myPostponedRunnables);
                    this.myPostponedRunnables.clear();
                    for (Runnable postponedRunnable : postponedRunnables) {
                        postponedRunnable.run();
                    }
                });
            }
        } else {
            UIUtil.invokeLaterIfNeeded(() -> MultipleBuildsView.lambda$onEvent$6((List)runOnEdt));
        }
    }

    public boolean hasRunningBuilds() {
        return !this.myProgressWatcher.myBuilds.isEmpty();
    }

    private static /* synthetic */ void lambda$onEvent$6(List runOnEdt) {
        for (Runnable runnable2 : runOnEdt) {
            runnable2.run();
        }
    }

    private class ProgressWatcher
    implements Runnable {
        private final Alarm myRefreshAlarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD);
        private final Set<AbstractViewManager.BuildInfo> myBuilds = ContainerUtil.newConcurrentSet();

        private ProgressWatcher() {
        }

        @Override
        public void run() {
            this.myRefreshAlarm.cancelAllRequests();
            JComponent firstComponent = MultipleBuildsView.this.myThreeComponentsSplitter.getFirstComponent();
            if (firstComponent != null) {
                firstComponent.revalidate();
                firstComponent.repaint();
            }
            if (!this.myBuilds.isEmpty()) {
                this.myRefreshAlarm.addRequest((Runnable)this, 300);
            }
        }

        void addBuild(AbstractViewManager.BuildInfo buildInfo) {
            this.myBuilds.add(buildInfo);
            if (this.myBuilds.size() > 1) {
                this.myRefreshAlarm.cancelAllRequests();
                this.myRefreshAlarm.addRequest((Runnable)this, 300);
            }
        }

        void stopBuild(AbstractViewManager.BuildInfo buildInfo) {
            this.myBuilds.remove(buildInfo);
        }
    }
}

