/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeEditor.printing;

import com.intellij.codeEditor.printing.BasePainter;
import com.intellij.codeEditor.printing.CodeEditorBundle;
import com.intellij.codeEditor.printing.FileSeparatorProvider;
import com.intellij.codeEditor.printing.LineWrapper;
import com.intellij.codeEditor.printing.PrintSettings;
import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.LineIterator;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.util.containers.IntArrayList;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.font.LineMetrics;
import java.awt.geom.Area;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.print.PageFormat;
import java.awt.print.PrinterException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

class TextPainter
extends BasePainter {
    private final DocumentEx myDocument;
    private RangeMarker myRangeToPrint;
    private int myOffset;
    private int myLineNumber;
    private float myLineHeight;
    private float myDescent;
    private double myCharWidth;
    private final Font myPlainFont;
    private final Font myBoldFont;
    private final Font myItalicFont;
    private final Font myBoldItalicFont;
    private final Font myHeaderFont;
    private final EditorHighlighter myHighlighter;
    private final PrintSettings myPrintSettings;
    private final String myFullFileName;
    private final String myShortFileName;
    private int myPageIndex;
    private int myNumberOfPages;
    private int mySegmentEnd;
    private final LineMarkerInfo[] myMethodSeparators;
    private int myCurrentMethodSeparator;
    private final CodeStyleSettings myCodeStyleSettings;
    private final FileType myFileType;
    private boolean myPerformActualDrawing;
    private final String myPrintDate;
    private final String myPrintTime;
    @NonNls
    private static final String DEFAULT_MEASURE_HEIGHT_TEXT = "A";
    @NonNls
    private static final String DEFAULT_MEASURE_WIDTH_TEXT = "w";
    @NonNls
    private static final String HEADER_TOKEN_PAGE = "PAGE";
    @NonNls
    private static final String HEADER_TOKEN_TOTALPAGES = "TOTALPAGES";
    @NonNls
    private static final String HEADER_TOKEN_FILE = "FILE";
    @NonNls
    private static final String HEADER_TOKEN_FILENAME = "FILENAME";
    @NonNls
    private static final String HEADER_TOKEN_DATE = "DATE";
    @NonNls
    private static final String HEADER_TOKEN_TIME = "TIME";
    @NonNls
    private static final String DATE_FORMAT = "yyyy-MM-dd";
    @NonNls
    private static final String TIME_FORMAT = "HH:mm:ss";
    boolean isPrintingPass;

    public TextPainter(@NotNull DocumentEx editorDocument, EditorHighlighter highlighter, String fullFileName, String shortFileName, @NotNull PsiFile psiFile, FileType fileType) {
        if (editorDocument == null) {
            TextPainter.$$$reportNull$$$0(0);
        }
        if (psiFile == null) {
            TextPainter.$$$reportNull$$$0(1);
        }
        this(editorDocument, highlighter, fullFileName, shortFileName, psiFile.getProject(), fileType, FileSeparatorProvider.getFileSeparators(psiFile, editorDocument));
    }

    public TextPainter(@NotNull DocumentEx editorDocument, EditorHighlighter highlighter, String fullFileName, String shortFileName, Project project2, FileType fileType, List<LineMarkerInfo> separators) {
        if (editorDocument == null) {
            TextPainter.$$$reportNull$$$0(2);
        }
        this.myOffset = 0;
        this.myLineNumber = 1;
        this.myLineHeight = -1.0f;
        this.myDescent = -1.0f;
        this.myCharWidth = -1.0;
        this.myPageIndex = -1;
        this.myNumberOfPages = -1;
        this.isPrintingPass = true;
        this.myCodeStyleSettings = CodeStyleSettingsManager.getSettings((Project)project2);
        this.myDocument = editorDocument;
        this.myPrintSettings = PrintSettings.getInstance();
        String fontName = this.myPrintSettings.FONT_NAME;
        int fontSize = Math.round((float)this.myPrintSettings.FONT_SIZE / UISettings.getDefFontScale());
        this.myPlainFont = new Font(fontName, 0, fontSize);
        this.myBoldFont = new Font(fontName, 1, fontSize);
        this.myItalicFont = new Font(fontName, 2, fontSize);
        this.myBoldItalicFont = new Font(fontName, 3, fontSize);
        this.myHighlighter = highlighter;
        this.myHeaderFont = new Font(this.myPrintSettings.FOOTER_HEADER_FONT_NAME, 0, this.myPrintSettings.FOOTER_HEADER_FONT_SIZE);
        this.myFullFileName = fullFileName;
        this.myShortFileName = shortFileName;
        this.myRangeToPrint = editorDocument.createRangeMarker(0, this.myDocument.getTextLength());
        this.myFileType = fileType;
        this.myMethodSeparators = separators != null ? separators.toArray(new LineMarkerInfo[separators.size()]) : new LineMarkerInfo[]{};
        this.myCurrentMethodSeparator = 0;
        Date date = new Date();
        this.myPrintDate = new SimpleDateFormat(DATE_FORMAT).format(date);
        this.myPrintTime = new SimpleDateFormat(TIME_FORMAT).format(date);
    }

    public void setSegment(int segmentStart, int segmentEnd) {
        this.setSegment(this.myDocument.createRangeMarker(segmentStart, segmentEnd));
    }

    private void setSegment(RangeMarker marker) {
        if (this.myRangeToPrint != null) {
            this.myRangeToPrint.dispose();
        }
        this.myRangeToPrint = marker;
    }

    private float getLineHeight(Graphics g) {
        if (this.myLineHeight >= 0.0f) {
            return this.myLineHeight;
        }
        FontRenderContext fontRenderContext = ((Graphics2D)g).getFontRenderContext();
        LineMetrics lineMetrics = this.myPlainFont.getLineMetrics(DEFAULT_MEASURE_HEIGHT_TEXT, fontRenderContext);
        this.myLineHeight = lineMetrics.getHeight();
        return this.myLineHeight;
    }

    private float getDescent(Graphics g) {
        if (this.myDescent >= 0.0f) {
            return this.myDescent;
        }
        FontRenderContext fontRenderContext = ((Graphics2D)g).getFontRenderContext();
        LineMetrics lineMetrics = this.myPlainFont.getLineMetrics(DEFAULT_MEASURE_HEIGHT_TEXT, fontRenderContext);
        this.myDescent = lineMetrics.getDescent();
        return this.myDescent;
    }

    private Font getFont(int type2) {
        if (type2 == 1) {
            return this.myBoldFont;
        }
        if (type2 == 2) {
            return this.myItalicFont;
        }
        if (type2 == 3) {
            return this.myBoldItalicFont;
        }
        return this.myPlainFont;
    }

    @Override
    public int print(Graphics g, PageFormat pageFormat, int pageIndex) throws PrinterException {
        this.myPerformActualDrawing = false;
        if (this.myProgress.isCanceled()) {
            return 1;
        }
        Graphics2D g2d = (Graphics2D)g;
        if (this.myNumberOfPages < 0) {
            this.myProgress.setText(CodeEditorBundle.message("print.file.calculating.number.of.pages.progress", new Object[0]));
            if (!this.calculateNumberOfPages(g2d, pageFormat)) {
                return 1;
            }
        }
        if (pageIndex >= this.myNumberOfPages) {
            return 1;
        }
        boolean bl = this.isPrintingPass = !this.isPrintingPass;
        if (!this.isPrintingPass) {
            while (++this.myPageIndex < pageIndex) {
                if (this.printPageInReadAction(g2d, pageFormat, "print.skip.page.progress")) continue;
                return 1;
            }
            return (Integer)ReadAction.compute(() -> TextPainter.isValidRange(this.myRangeToPrint) ? 0 : 1);
        }
        this.myPerformActualDrawing = true;
        this.printPageInReadAction(g2d, pageFormat, "print.file.page.progress");
        return 0;
    }

    private boolean printPageInReadAction(Graphics2D g2d, PageFormat pageFormat, String progressMessageKey) {
        return (Boolean)ReadAction.compute(() -> {
            if (!TextPainter.isValidRange(this.myRangeToPrint)) {
                return false;
            }
            this.myProgress.setText(CodeEditorBundle.message(progressMessageKey, this.myShortFileName, this.myPageIndex + 1, this.myNumberOfPages));
            this.setSegment(this.printPage(g2d, pageFormat, this.myRangeToPrint));
            return true;
        });
    }

    private boolean calculateNumberOfPages(Graphics2D g2d, PageFormat pageFormat) {
        this.myNumberOfPages = 0;
        Ref firstPage = new Ref((Object)Boolean.TRUE);
        Ref tmpMarker = new Ref();
        while (((Boolean)ReadAction.compute(() -> {
            RangeMarker range;
            if (((Boolean)firstPage.get()).booleanValue()) {
                if (!TextPainter.isValidRange(this.myRangeToPrint)) {
                    return false;
                }
                tmpMarker.set((Object)this.myDocument.createRangeMarker(this.myRangeToPrint.getStartOffset(), this.myRangeToPrint.getEndOffset()));
                firstPage.set((Object)Boolean.FALSE);
            }
            if (!TextPainter.isValidRange(range = (RangeMarker)tmpMarker.get())) {
                return false;
            }
            tmpMarker.set((Object)this.printPage(g2d, pageFormat, range));
            range.dispose();
            return true;
        })).booleanValue()) {
            if (this.myProgress.isCanceled()) {
                return false;
            }
            ++this.myNumberOfPages;
        }
        if (!tmpMarker.isNull()) {
            ((RangeMarker)tmpMarker.get()).dispose();
        }
        return true;
    }

    private static boolean isValidRange(RangeMarker range) {
        return range != null && range.isValid() && range.getStartOffset() < range.getEndOffset();
    }

    private RangeMarker printPage(Graphics2D g2d, PageFormat pageFormat, RangeMarker range) {
        assert (TextPainter.isValidRange(range));
        int startOffset = range.getStartOffset();
        int endOffset = range.getEndOffset();
        this.myOffset = startOffset;
        this.mySegmentEnd = endOffset;
        this.myLineNumber = this.myDocument.getLineNumber(this.myOffset) + 1;
        Rectangle2D.Double clip = new Rectangle2D.Double(pageFormat.getImageableX(), pageFormat.getImageableY(), pageFormat.getImageableWidth(), pageFormat.getImageableHeight());
        this.draw(g2d, clip);
        return this.myOffset > startOffset && this.myOffset < endOffset ? this.myDocument.createRangeMarker(this.myOffset, endOffset) : null;
    }

    private void draw(Graphics2D g2D, Rectangle2D.Double clip) {
        double headerHeight = this.drawHeader(g2D, clip);
        clip.y += headerHeight;
        clip.height -= headerHeight;
        double footerHeight = this.drawFooter(g2D, clip);
        clip.height -= footerHeight;
        Rectangle2D.Double border = (Rectangle2D.Double)clip.clone();
        clip.x += this.getCharWidth(g2D) / 2.0;
        clip.width -= this.getCharWidth(g2D);
        if (this.myPrintSettings.PRINT_LINE_NUMBERS) {
            double numbersStripWidth = this.calcNumbersStripWidth(g2D, clip) + this.getCharWidth(g2D) / 2.0;
            clip.x += numbersStripWidth;
            clip.width -= numbersStripWidth;
        }
        clip.x += this.getCharWidth(g2D) / 2.0;
        clip.width -= this.getCharWidth(g2D);
        this.drawText(g2D, clip);
        this.drawBorder(g2D, border);
    }

    private void drawBorder(Graphics2D g, Rectangle2D clip) {
        if (this.myPrintSettings.DRAW_BORDER && this.myPerformActualDrawing) {
            Color save2 = g.getColor();
            g.setColor(Color.black);
            g.draw(clip);
            g.setColor(save2);
        }
    }

    private double getCharWidth(Graphics2D g) {
        if (this.myCharWidth < 0.0) {
            FontRenderContext fontRenderContext = g.getFontRenderContext();
            this.myCharWidth = this.myPlainFont.getStringBounds(DEFAULT_MEASURE_WIDTH_TEXT, fontRenderContext).getWidth();
        }
        return this.myCharWidth;
    }

    private void setForegroundColor(Graphics2D g, Color color) {
        if (color == null || !this.myPrintSettings.COLOR_PRINTING || !this.myPrintSettings.SYNTAX_PRINTING) {
            color = Color.black;
        }
        g.setColor(color);
    }

    private void setBackgroundColor(Graphics2D g, Color color) {
        if (color == null || !this.myPrintSettings.COLOR_PRINTING || !this.myPrintSettings.SYNTAX_PRINTING) {
            color = Color.white;
        }
        g.setColor(color);
    }

    private void setFont(Graphics2D g, Font font) {
        if (!this.myPrintSettings.SYNTAX_PRINTING) {
            font = this.myPlainFont;
        }
        g.setFont(font);
    }

    private void drawText(Graphics2D g, Rectangle2D clip) {
        float lineHeight = this.getLineHeight(g);
        HighlighterIterator hIterator = this.myHighlighter.createIterator(this.myOffset);
        if (hIterator.atEnd()) {
            this.myOffset = this.mySegmentEnd;
            return;
        }
        LineIterator lIterator = this.myDocument.createLineIterator();
        lIterator.start(this.myOffset);
        if (lIterator.atEnd()) {
            this.myOffset = this.mySegmentEnd;
            return;
        }
        TextAttributes attributes = hIterator.getTextAttributes();
        Color currentColor = attributes.getForegroundColor();
        Color backColor = attributes.getBackgroundColor();
        Color underscoredColor = attributes.getEffectColor();
        Font currentFont = this.getFont(attributes.getFontType());
        this.setForegroundColor(g, currentColor);
        this.setFont(g, currentFont);
        g.translate(clip.getX(), 0.0);
        Point2D.Double position = new Point2D.Double(0.0, clip.getY());
        double lineY = ((Point2D)position).getY();
        if (this.myPerformActualDrawing) {
            this.getMethodSeparator(lIterator.getLineNumber());
        }
        char[] text2 = this.myDocument.getCharsSequence().toString().toCharArray();
        while (!hIterator.atEnd() && !lIterator.atEnd()) {
            int hEnd = hIterator.getEnd();
            int lEnd = lIterator.getEnd();
            int lStart = lIterator.getStart();
            if (hEnd >= lEnd) {
                LineMarkerInfo marker;
                if (!this.drawString(g, text2, lEnd - lIterator.getSeparatorLength(), this.myOffset == lStart, position, clip, backColor, underscoredColor)) {
                    this.drawLineNumber(g, 0.0, lineY);
                    break;
                }
                this.drawLineNumber(g, 0.0, lineY);
                lIterator.advance();
                ++this.myLineNumber;
                ((Point2D)position).setLocation(0.0, ((Point2D)position).getY() + (double)lineHeight);
                lineY = ((Point2D)position).getY();
                this.myOffset = lEnd;
                if (this.myPerformActualDrawing && (marker = this.getMethodSeparator(lIterator.getLineNumber())) != null) {
                    Color save2 = g.getColor();
                    this.setForegroundColor(g, marker.separatorColor);
                    UIUtil.drawLine((Graphics)g, (int)0, (int)((int)lineY), (int)((int)clip.getWidth()), (int)((int)lineY));
                    this.setForegroundColor(g, save2);
                }
                if (!(((Point2D)position).getY() > clip.getY() + clip.getHeight() - (double)lineHeight)) continue;
                break;
            }
            if (hEnd > lEnd - lIterator.getSeparatorLength()) {
                if (!this.drawString(g, text2, lEnd - lIterator.getSeparatorLength(), this.myOffset == lStart, position, clip, backColor, underscoredColor)) {
                    this.drawLineNumber(g, 0.0, lineY);
                    break;
                }
            } else if (!this.drawString(g, text2, hEnd, this.myOffset == lStart, position, clip, backColor, underscoredColor)) {
                this.drawLineNumber(g, 0.0, lineY);
                break;
            }
            hIterator.advance();
            attributes = hIterator.getTextAttributes();
            Color color = attributes.getForegroundColor();
            if (color == null) {
                color = Color.black;
            }
            if (color != currentColor) {
                this.setForegroundColor(g, color);
                currentColor = color;
            }
            backColor = attributes.getBackgroundColor();
            underscoredColor = attributes.getEffectColor();
            Font font = this.getFont(attributes.getFontType());
            if (font != currentFont) {
                this.setFont(g, font);
                currentFont = font;
            }
            this.myOffset = hEnd;
        }
        g.translate(-clip.getX(), 0.0);
    }

    private LineMarkerInfo getMethodSeparator(int line) {
        LineMarkerInfo tmpMarker;
        LineMarkerInfo marker = null;
        while (this.myCurrentMethodSeparator < this.myMethodSeparators.length && (tmpMarker = this.myMethodSeparators[this.myCurrentMethodSeparator]) != null && FileSeparatorProvider.getDisplayLine(tmpMarker, this.myDocument) <= line) {
            marker = tmpMarker;
            ++this.myCurrentMethodSeparator;
        }
        return marker;
    }

    private double drawHeader(Graphics2D g, Rectangle2D clip) {
        String headerText2;
        LineMetrics lineMetrics = this.getHeaderFooterLineMetrics(g);
        double w = clip.getWidth();
        double x = clip.getX();
        double y = clip.getY();
        double h = 0.0;
        boolean wasDrawn = false;
        String headerText1 = this.myPrintSettings.FOOTER_HEADER_TEXT1;
        if (headerText1 != null && headerText1.length() > 0 && "Header".equals(this.myPrintSettings.FOOTER_HEADER_PLACEMENT1)) {
            h = this.drawHeaderOrFooterLine(g, x, y, w, headerText1, this.myPrintSettings.FOOTER_HEADER_ALIGNMENT1);
            wasDrawn = true;
            y += h;
        }
        if ((headerText2 = this.myPrintSettings.FOOTER_HEADER_TEXT2) != null && headerText2.length() > 0 && "Header".equals(this.myPrintSettings.FOOTER_HEADER_PLACEMENT2)) {
            if ("Left".equals(this.myPrintSettings.FOOTER_HEADER_ALIGNMENT1) && "Right".equals(this.myPrintSettings.FOOTER_HEADER_ALIGNMENT2) && wasDrawn) {
                y -= h;
            }
            h = this.drawHeaderOrFooterLine(g, x, y, w, headerText2, this.myPrintSettings.FOOTER_HEADER_ALIGNMENT2);
            y += h;
            wasDrawn = true;
        }
        return wasDrawn ? y - clip.getY() + (double)(lineMetrics.getHeight() / 3.0f) : 0.0;
    }

    private double drawFooter(Graphics2D g, Rectangle2D clip) {
        String headerText1;
        LineMetrics lineMetrics = this.getHeaderFooterLineMetrics(g);
        double w = clip.getWidth();
        double x = clip.getX();
        double y = clip.getY() + clip.getHeight();
        boolean wasDrawn = false;
        double h = 0.0;
        y -= (double)lineMetrics.getHeight();
        String headerText2 = this.myPrintSettings.FOOTER_HEADER_TEXT2;
        if (headerText2 != null && headerText2.length() > 0 && "Footer".equals(this.myPrintSettings.FOOTER_HEADER_PLACEMENT2)) {
            h = this.drawHeaderOrFooterLine(g, x, y, w, headerText2, this.myPrintSettings.FOOTER_HEADER_ALIGNMENT2);
            wasDrawn = true;
        }
        if ((headerText1 = this.myPrintSettings.FOOTER_HEADER_TEXT1) != null && headerText1.length() > 0 && "Footer".equals(this.myPrintSettings.FOOTER_HEADER_PLACEMENT1)) {
            y -= (double)lineMetrics.getHeight();
            if ("Left".equals(this.myPrintSettings.FOOTER_HEADER_ALIGNMENT1) && "Right".equals(this.myPrintSettings.FOOTER_HEADER_ALIGNMENT2) && wasDrawn) {
                y += h;
            }
            this.drawHeaderOrFooterLine(g, x, y, w, headerText1, this.myPrintSettings.FOOTER_HEADER_ALIGNMENT1);
            wasDrawn = true;
        }
        return wasDrawn ? clip.getY() + clip.getHeight() - y + (double)(lineMetrics.getHeight() / 4.0f) : 0.0;
    }

    private double drawHeaderOrFooterLine(Graphics2D g, double x, double y, double w, String headerText, String alignment) {
        FontRenderContext fontRenderContext = g.getFontRenderContext();
        LineMetrics lineMetrics = this.getHeaderFooterLineMetrics(g);
        float lineHeight = lineMetrics.getHeight();
        if (this.myPerformActualDrawing) {
            headerText = this.convertHeaderText(headerText);
            g.setFont(this.myHeaderFont);
            g.setColor(Color.black);
            float descent = lineMetrics.getDescent();
            double width = this.myHeaderFont.getStringBounds(headerText, fontRenderContext).getWidth() + this.getCharWidth(g);
            float yPos = (float)((double)(lineHeight - descent) + y);
            if ("Left".equals(alignment)) {
                this.drawStringToGraphics(g, headerText, x, yPos);
            } else if ("Center".equals(alignment)) {
                this.drawStringToGraphics(g, headerText, (float)(x + (w - width) / 2.0), yPos);
            } else if ("Right".equals(alignment)) {
                this.drawStringToGraphics(g, headerText, (float)(x + w - width), yPos);
            }
        }
        return lineHeight;
    }

    private String convertHeaderText(String s) {
        StringBuilder result2 = new StringBuilder("");
        int start = 0;
        boolean isExpression = false;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c != '$') continue;
            String token = s.substring(start, i);
            if (isExpression) {
                if (HEADER_TOKEN_PAGE.equals(token)) {
                    result2.append(this.myPageIndex + 1);
                } else if (HEADER_TOKEN_TOTALPAGES.equals(token)) {
                    result2.append(this.myNumberOfPages);
                } else if (HEADER_TOKEN_FILE.equals(token)) {
                    result2.append(this.myFullFileName);
                } else if (HEADER_TOKEN_FILENAME.equals(token)) {
                    result2.append(this.myShortFileName);
                } else if (HEADER_TOKEN_DATE.equals(token)) {
                    result2.append(this.myPrintDate);
                } else if (HEADER_TOKEN_TIME.equals(token)) {
                    result2.append(this.myPrintTime);
                }
            } else {
                result2.append(token);
            }
            isExpression = !isExpression;
            start = i + 1;
        }
        if (!isExpression && start < s.length()) {
            result2.append(s.substring(start, s.length()));
        }
        return result2.toString();
    }

    private LineMetrics getHeaderFooterLineMetrics(Graphics2D g) {
        FontRenderContext fontRenderContext = g.getFontRenderContext();
        return this.myHeaderFont.getLineMetrics(DEFAULT_MEASURE_HEIGHT_TEXT, fontRenderContext);
    }

    private double calcNumbersStripWidth(Graphics2D g, Rectangle2D clip) {
        if (!this.myPrintSettings.PRINT_LINE_NUMBERS) {
            return 0.0;
        }
        int maxLineNumber = this.myLineNumber + (int)(clip.getHeight() / (double)this.getLineHeight(g));
        FontRenderContext fontRenderContext = g.getFontRenderContext();
        double numbersStripWidth = 0.0;
        for (int i = this.myLineNumber; i < maxLineNumber; ++i) {
            double width = this.myPlainFont.getStringBounds(String.valueOf(i), fontRenderContext).getWidth();
            if (!(numbersStripWidth < width)) continue;
            numbersStripWidth = width;
        }
        return numbersStripWidth;
    }

    private void drawLineNumber(Graphics2D g, double x, double y) {
        if (!this.myPrintSettings.PRINT_LINE_NUMBERS || !this.myPerformActualDrawing) {
            return;
        }
        FontRenderContext fontRenderContext = g.getFontRenderContext();
        double width = this.myPlainFont.getStringBounds(String.valueOf(this.myLineNumber), fontRenderContext).getWidth() + this.getCharWidth(g);
        Color savedColor = g.getColor();
        Font savedFont = g.getFont();
        g.setColor(Color.black);
        g.setFont(this.myPlainFont);
        this.drawStringToGraphics(g, String.valueOf(this.myLineNumber), x - width, (double)(this.getLineHeight(g) - this.getDescent(g)) + y);
        g.setColor(savedColor);
        g.setFont(savedFont);
    }

    private boolean drawString(Graphics2D g, char[] text2, int end, boolean lineStart, Point2D position, Rectangle2D clip, Color backColor, Color underscoredColor) {
        boolean isInClip;
        boolean toContinue = true;
        if (end >= this.mySegmentEnd) {
            end = this.mySegmentEnd;
            toContinue = false;
        }
        if (this.myOffset >= end) {
            return toContinue;
        }
        boolean bl = isInClip = (double)this.getLineHeight(g) + position.getY() >= clip.getY() && position.getY() <= clip.getY() + clip.getHeight();
        if (!isInClip) {
            return toContinue;
        }
        if (this.myPrintSettings.WRAP) {
            double w = this.getTextSegmentWidth(text2, this.myOffset, end - this.myOffset, position.getX(), g);
            if (position.getX() + w > clip.getWidth()) {
                IntArrayList breakOffsets = LineWrapper.calcBreakOffsets(text2, this.myOffset, end, lineStart, position.getX(), clip.getWidth(), (t, start, count, x) -> this.getTextSegmentWidth(t, start, count, x, g));
                for (int i = 0; i < breakOffsets.size(); ++i) {
                    int breakOffset = breakOffsets.get(i);
                    this.drawTabbedString(g, text2, breakOffset - this.myOffset, position, backColor, underscoredColor);
                    position.setLocation(0.0, position.getY() + (double)this.getLineHeight(g));
                    if (!(position.getY() > clip.getY() + clip.getHeight() - (double)this.getLineHeight(g))) continue;
                    return false;
                }
            }
        }
        this.drawTabbedString(g, text2, end - this.myOffset, position, backColor, underscoredColor);
        return toContinue;
    }

    private void drawTabbedString(Graphics2D g, char[] text2, int length, Point2D position, Color backColor, Color underscoredColor) {
        ProgressManager.checkCanceled();
        if (length <= 0) {
            return;
        }
        double xStart = position.getX();
        double x = position.getX();
        double y = (double)(this.getLineHeight(g) - this.getDescent(g)) + position.getY();
        if (backColor != null && this.myPerformActualDrawing) {
            Color savedColor = g.getColor();
            this.setBackgroundColor(g, backColor);
            double w = this.getTextSegmentWidth(text2, this.myOffset, length, position.getX(), g);
            g.fill(new Area(new Rectangle2D.Double(position.getX(), y - (double)this.getLineHeight(g) + (double)this.getDescent(g), w, this.getLineHeight(g))));
            g.setColor(savedColor);
        }
        int start = this.myOffset;
        for (int i = this.myOffset; i < this.myOffset + length; ++i) {
            if (text2[i] != '\t') continue;
            if (i > start) {
                String s = new String(text2, start, i - start);
                x += this.drawStringToGraphics(g, s, x, y);
            }
            x = this.nextTabStop(g, x);
            start = i + 1;
        }
        if (this.myOffset + length > start) {
            String s = new String(text2, start, this.myOffset + length - start);
            x += this.drawStringToGraphics(g, s, x, y);
        }
        if (underscoredColor != null && this.myPerformActualDrawing) {
            Color savedColor = g.getColor();
            this.setForegroundColor(g, underscoredColor);
            double w = this.getTextSegmentWidth(text2, this.myOffset, length, position.getX(), g);
            UIUtil.drawLine((Graphics)g, (int)((int)position.getX()), (int)((int)y + 1), (int)((int)(xStart + w)), (int)((int)(y + 1.0)));
            g.setColor(savedColor);
        }
        position.setLocation(x, position.getY());
        this.myOffset += length;
    }

    private double drawStringToGraphics(Graphics2D g, String s, double x, double y) {
        if (!this.myPrintSettings.PRINT_AS_GRAPHICS) {
            if (this.myPerformActualDrawing) {
                g.drawString(s, (float)x, (float)y);
            }
            return g.getFontMetrics().stringWidth(s);
        }
        GlyphVector v = g.getFont().createGlyphVector(g.getFontRenderContext(), s);
        if (this.myPerformActualDrawing) {
            g.translate(x, y);
            g.fill(v.getOutline());
            g.translate(-x, -y);
        }
        return v.getLogicalBounds().getWidth();
    }

    private double getTextSegmentWidth(char[] text2, int offset, int length, double x, Graphics2D g) {
        int start = offset;
        double startX = x;
        for (int i = offset; i < offset + length; ++i) {
            if (text2[i] != '\t') continue;
            if (i > start) {
                x += TextPainter.getStringWidth(g, text2, start, i - start);
            }
            x = this.nextTabStop(g, x);
            start = i + 1;
        }
        if (offset + length > start) {
            x += TextPainter.getStringWidth(g, text2, start, offset + length - start);
        }
        return x - startX;
    }

    private static double getStringWidth(Graphics2D g, char[] text2, int start, int count) {
        String s = new String(text2, start, count);
        GlyphVector v = g.getFont().createGlyphVector(g.getFontRenderContext(), s);
        return v.getLogicalBounds().getWidth();
    }

    public double nextTabStop(Graphics2D g, double x) {
        double tabSize = this.myCodeStyleSettings.getTabSize(this.myFileType);
        if (tabSize <= 0.0) {
            tabSize = 1.0;
        }
        int nTabs = (int)(x / (tabSize *= g.getFont().getStringBounds(" ", g.getFontRenderContext()).getWidth()));
        return (double)(nTabs + 1) * tabSize;
    }

    @Override
    void dispose() {
        this.setSegment(null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "editorDocument";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "psiFile";
                break;
            }
        }
        objectArray[1] = "com/intellij/codeEditor/printing/TextPainter";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

