/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementDecorator;
import com.intellij.codeInsight.lookup.LookupElementPresentation;
import com.intellij.codeInsight.lookup.PsiTypeLookupItem;
import com.intellij.codeInsight.lookup.TypedLookupItem;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.ClassConditionKey;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import org.jetbrains.annotations.Nullable;

public class CastingLookupElementDecorator
extends LookupElementDecorator<LookupElement>
implements TypedLookupItem {
    public static final ClassConditionKey<CastingLookupElementDecorator> CLASS_CONDITION_KEY = ClassConditionKey.create(CastingLookupElementDecorator.class);
    private final LookupElement myCastItem;
    private final PsiType myCastType;

    @Nullable
    private static String getItemText(LookupElementPresentation base, LookupElement castItem) {
        LookupElementPresentation castPresentation = new LookupElementPresentation();
        castItem.renderElement(castPresentation);
        return castPresentation.getItemText();
    }

    private CastingLookupElementDecorator(LookupElement delegate, PsiType castType) {
        super(delegate);
        this.myCastType = castType;
        this.myCastItem = PsiTypeLookupItem.createLookupItem(castType, (PsiElement)delegate.getObject());
    }

    @Override
    public PsiType getType() {
        return this.myCastType;
    }

    public String toString() {
        return "(" + this.myCastItem.getLookupString() + ")" + this.getDelegate().getLookupString();
    }

    public void renderElement(LookupElementPresentation presentation) {
        this.getDelegate().renderElement(presentation);
        String castType = CastingLookupElementDecorator.getItemText(presentation, this.getCastItem());
        presentation.setItemText("(" + castType + ")" + presentation.getItemText());
        presentation.setTypeText(castType);
    }

    public void handleInsert(InsertionContext context) {
        CommonCodeStyleSettings settings = context.getCodeStyleSettings();
        String spaceWithin = settings.SPACE_WITHIN_CAST_PARENTHESES ? " " : "";
        String spaceAfter = settings.SPACE_AFTER_TYPE_CAST ? " " : "";
        Editor editor = context.getEditor();
        editor.getDocument().replaceString(context.getStartOffset(), context.getTailOffset(), (CharSequence)("(" + spaceWithin + spaceWithin + ")" + spaceAfter));
        CompletionUtil.emulateInsertion(context, context.getStartOffset() + 1 + spaceWithin.length(), this.myCastItem);
        CompletionUtil.emulateInsertion(this.getDelegate(), context.getTailOffset(), context);
    }

    public LookupElement getCastItem() {
        return this.myCastItem;
    }

    public static LookupElement createCastingElement(LookupElement delegate, PsiType castTo) {
        return new CastingLookupElementDecorator(delegate, castTo);
    }
}

