/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.ExpectedTypeInfo;
import com.intellij.codeInsight.ExpectedTypesProvider;
import com.intellij.codeInsight.completion.AllClassesGetter;
import com.intellij.codeInsight.completion.CompletionBundle;
import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.JavaClassNameInsertHandler;
import com.intellij.codeInsight.completion.JavaCompletionContributor;
import com.intellij.codeInsight.completion.JavaCompletionUtil;
import com.intellij.codeInsight.completion.JavaConstructorCallElement;
import com.intellij.codeInsight.completion.JavaPsiClassReferenceElement;
import com.intellij.codeInsight.completion.LimitedAccessibleClassPreprocessor;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.completion.SkipAutopopupInStrings;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.lang.LangBundle;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.impl.CustomSyntaxTableFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PsiJavaElementPattern;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiPlainTextFile;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.filters.ClassFilter;
import com.intellij.psi.filters.TrueFilter;
import com.intellij.psi.filters.element.ExcludeDeclaredFilter;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.DirectClassInheritorsSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.MultiMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaClassNameCompletionContributor
extends CompletionContributor {
    public static final PsiJavaElementPattern.Capture<PsiElement> AFTER_NEW = (PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().afterLeaf(new String[]{"new"});
    private static final PsiJavaElementPattern.Capture<PsiElement> IN_TYPE_PARAMETER = (PsiJavaElementPattern.Capture)((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().afterLeaf(new String[]{"extends", "super", "&"})).withParent((ElementPattern)PsiJavaPatterns.psiElement(PsiReferenceList.class).withParent(PsiTypeParameter.class));
    private static final ElementPattern<PsiElement> IN_EXTENDS_IMPLEMENTS = PsiJavaPatterns.psiElement().inside((ElementPattern)PsiJavaPatterns.psiElement(PsiReferenceList.class).withParent((ElementPattern)PsiJavaPatterns.psiClass()));

    public void fillCompletionVariants(@NotNull CompletionParameters parameters2, @NotNull CompletionResultSet _result) {
        if (parameters2 == null) {
            JavaClassNameCompletionContributor.$$$reportNull$$$0(0);
        }
        if (_result == null) {
            JavaClassNameCompletionContributor.$$$reportNull$$$0(1);
        }
        if (parameters2.getCompletionType() == CompletionType.CLASS_NAME || parameters2.isExtendedCompletion() && JavaClassNameCompletionContributor.mayContainClassName(parameters2)) {
            JavaClassNameCompletionContributor.addAllClasses(parameters2, _result);
        }
    }

    static void addAllClasses(CompletionParameters parameters2, CompletionResultSet _result) {
        CompletionResultSet result2 = _result.withPrefixMatcher(CompletionUtil.findReferenceOrAlphanumericPrefix(parameters2));
        JavaClassNameCompletionContributor.addAllClasses(parameters2, parameters2.getInvocationCount() <= 1, result2.getPrefixMatcher(), (Consumer<LookupElement>)_result);
    }

    private static boolean mayContainClassName(CompletionParameters parameters2) {
        PsiElement position = parameters2.getPosition();
        PsiFile file2 = position.getContainingFile();
        if (file2 instanceof PsiPlainTextFile || file2.getFileType() instanceof CustomSyntaxTableFileType) {
            return true;
        }
        if (SkipAutopopupInStrings.isInStringLiteral((PsiElement)position)) {
            return true;
        }
        PsiComment comment = (PsiComment)PsiTreeUtil.getParentOfType((PsiElement)position, PsiComment.class, (boolean)false);
        return comment != null && !(comment instanceof PsiDocComment);
    }

    public static void addAllClasses(@NotNull CompletionParameters parameters2, final boolean filterByScope, final @NotNull PrefixMatcher matcher, final @NotNull Consumer<LookupElement> consumer) {
        PsiElement insertedElement;
        if (parameters2 == null) {
            JavaClassNameCompletionContributor.$$$reportNull$$$0(2);
        }
        if (matcher == null) {
            JavaClassNameCompletionContributor.$$$reportNull$$$0(3);
        }
        if (consumer == null) {
            JavaClassNameCompletionContributor.$$$reportNull$$$0(4);
        }
        if (JavaCompletionContributor.ANNOTATION_NAME.accepts((Object)(insertedElement = parameters2.getPosition()))) {
            String name2;
            MultiMap<String, PsiClass> annoMap = JavaClassNameCompletionContributor.getAllAnnotationClasses(insertedElement, matcher);
            LimitedAccessibleClassPreprocessor processor2 = new LimitedAccessibleClassPreprocessor(parameters2, filterByScope, (Consumer<PsiClass>)((Consumer)anno -> {
                if (consumer == null) {
                    JavaClassNameCompletionContributor.$$$reportNull$$$0(9);
                }
                JavaPsiClassReferenceElement item = AllClassesGetter.createLookupItem(anno, JavaClassNameInsertHandler.JAVA_CLASS_INSERT_HANDLER);
                item.addLookupStrings(new String[]{JavaClassNameCompletionContributor.getClassNameWithContainers(anno)});
                consumer.consume((Object)item);
            }));
            Iterator iterator = CompletionUtil.sortMatching(matcher, annoMap.keySet()).iterator();
            while (iterator.hasNext() && ContainerUtil.process((Iterable)annoMap.get((Object)(name2 = (String)iterator.next())), (Processor)processor2)) {
            }
            return;
        }
        final ExcludeDeclaredFilter filter2 = IN_EXTENDS_IMPLEMENTS.accepts((Object)insertedElement) ? new ExcludeDeclaredFilter(new ClassFilter(PsiClass.class)) : (IN_TYPE_PARAMETER.accepts((Object)insertedElement) ? new ExcludeDeclaredFilter(new ClassFilter(PsiTypeParameter.class)) : TrueFilter.INSTANCE);
        final boolean inJavaContext = parameters2.getPosition() instanceof PsiIdentifier;
        final boolean afterNew = AFTER_NEW.accepts((Object)insertedElement);
        if (afterNew) {
            PsiExpression expr = (PsiExpression)PsiTreeUtil.getContextOfType((PsiElement)insertedElement, PsiExpression.class, (boolean)true);
            for (ExpectedTypeInfo info : ExpectedTypesProvider.getExpectedTypes(expr, true)) {
                PsiClass defClass;
                PsiType defaultType;
                PsiType type2 = info.getType();
                PsiClass psiClass = PsiUtil.resolveClassInType((PsiType)type2);
                if (psiClass != null && psiClass.getName() != null) {
                    consumer.consume((Object)JavaClassNameCompletionContributor.createClassLookupItem(psiClass, inJavaContext));
                }
                if ((defaultType = info.getDefaultType()).equals(type2) || (defClass = PsiUtil.resolveClassInType((PsiType)defaultType)) == null || defClass.getName() == null) continue;
                consumer.consume((Object)JavaClassNameCompletionContributor.createClassLookupItem(defClass, true));
            }
        }
        final boolean pkgContext = JavaCompletionUtil.inSomePackage(insertedElement);
        AllClassesGetter.processJavaClasses(parameters2, matcher, filterByScope, new Consumer<PsiClass>(){

            public void consume(PsiClass psiClass) {
                this.processClass(psiClass, null, "");
            }

            private void processClass(PsiClass psiClass, @Nullable Set<PsiClass> visited, String prefix) {
                block7: {
                    PsiClass[] innerClasses;
                    block6: {
                        boolean isInnerClass = StringUtil.isNotEmpty((String)prefix);
                        if (isInnerClass && this.isProcessedIndependently(psiClass)) {
                            return;
                        }
                        if (!filter2.isAcceptable((Object)psiClass, insertedElement)) break block6;
                        if (!inJavaContext) {
                            JavaPsiClassReferenceElement element = AllClassesGetter.createLookupItem(psiClass, AllClassesGetter.TRY_SHORTENING);
                            element.setLookupString(prefix + element.getLookupString());
                            consumer.consume((Object)element);
                        } else {
                            Condition condition2 = eachClass -> filter2.isAcceptable(eachClass, insertedElement) && AllClassesGetter.isAcceptableInContext(insertedElement, eachClass, filterByScope, pkgContext);
                            for (JavaPsiClassReferenceElement element : JavaClassNameCompletionContributor.createClassLookupItems(psiClass, afterNew, JavaClassNameInsertHandler.JAVA_CLASS_INSERT_HANDLER, (Condition<PsiClass>)condition2)) {
                                element.setLookupString(prefix + element.getLookupString());
                                JavaConstructorCallElement.wrap(element, insertedElement).forEach(arg_0 -> ((Consumer)consumer).consume(arg_0));
                            }
                        }
                        break block7;
                    }
                    String name2 = psiClass.getName();
                    if (name2 == null || (innerClasses = psiClass.getInnerClasses()).length <= 0) break block7;
                    if (visited == null) {
                        visited = ContainerUtil.newHashSet();
                    }
                    for (PsiClass innerClass : innerClasses) {
                        if (!visited.add(innerClass)) continue;
                        this.processClass(innerClass, visited, prefix + name2 + ".");
                    }
                }
            }

            private boolean isProcessedIndependently(PsiClass psiClass) {
                String innerName = psiClass.getName();
                return innerName != null && matcher.prefixMatches(innerName);
            }
        });
    }

    @NotNull
    private static MultiMap<String, PsiClass> getAllAnnotationClasses(PsiElement context, PrefixMatcher matcher) {
        MultiMap map = new MultiMap();
        GlobalSearchScope scope = context.getResolveScope();
        PsiClass annotation = JavaPsiFacade.getInstance((Project)context.getProject()).findClass("java.lang.annotation.Annotation", scope);
        if (annotation != null) {
            DirectClassInheritorsSearch.search((PsiClass)annotation, (SearchScope)scope, (boolean)false).forEach(psiClass -> {
                if (!psiClass.isAnnotationType() || psiClass.getQualifiedName() == null) {
                    return true;
                }
                String name2 = (String)ObjectUtils.assertNotNull((Object)psiClass.getName());
                if (!matcher.prefixMatches(name2) && !matcher.prefixMatches(name2 = JavaClassNameCompletionContributor.getClassNameWithContainers(psiClass))) {
                    return true;
                }
                map.putValue((Object)name2, psiClass);
                return true;
            });
        }
        MultiMap multiMap = map;
        if (multiMap == null) {
            JavaClassNameCompletionContributor.$$$reportNull$$$0(5);
        }
        return multiMap;
    }

    @NotNull
    private static String getClassNameWithContainers(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            JavaClassNameCompletionContributor.$$$reportNull$$$0(6);
        }
        String name2 = (String)ObjectUtils.assertNotNull((Object)psiClass.getName());
        for (PsiClass parent : JBIterable.generate((Object)psiClass, PsiClass::getContainingClass)) {
            name2 = parent.getName() + "." + name2;
        }
        String string = name2;
        if (string == null) {
            JavaClassNameCompletionContributor.$$$reportNull$$$0(7);
        }
        return string;
    }

    static LookupElement highlightIfNeeded(JavaPsiClassReferenceElement element, CompletionParameters parameters2) {
        return JavaCompletionUtil.highlightIfNeeded(null, (LookupElement)element, element.getObject(), parameters2.getPosition());
    }

    public static JavaPsiClassReferenceElement createClassLookupItem(PsiClass psiClass, boolean inJavaContext) {
        return AllClassesGetter.createLookupItem(psiClass, inJavaContext ? JavaClassNameInsertHandler.JAVA_CLASS_INSERT_HANDLER : AllClassesGetter.TRY_SHORTENING);
    }

    public static List<JavaPsiClassReferenceElement> createClassLookupItems(PsiClass psiClass, boolean withInners, InsertHandler<JavaPsiClassReferenceElement> insertHandler, Condition<PsiClass> condition2) {
        SmartList result2 = new SmartList();
        if (condition2.value((Object)psiClass)) {
            result2.add(AllClassesGetter.createLookupItem(psiClass, insertHandler));
        }
        String name2 = psiClass.getName();
        if (withInners && name2 != null) {
            for (PsiClass inner : psiClass.getInnerClasses()) {
                if (!inner.hasModifierProperty("static")) continue;
                for (JavaPsiClassReferenceElement lookupInner : JavaClassNameCompletionContributor.createClassLookupItems(inner, true, insertHandler, condition2)) {
                    String forced = lookupInner.getForcedPresentableName();
                    String qualifiedName = name2 + "." + (forced != null ? forced : inner.getName());
                    lookupInner.setForcedPresentableName(qualifiedName);
                    lookupInner.setLookupString(qualifiedName);
                    result2.add(lookupInner);
                }
            }
        }
        return result2;
    }

    public String handleEmptyLookup(@NotNull CompletionParameters parameters2, Editor editor) {
        if (parameters2 == null) {
            JavaClassNameCompletionContributor.$$$reportNull$$$0(8);
        }
        if (!(parameters2.getOriginalFile() instanceof PsiJavaFile)) {
            return null;
        }
        if (JavaClassNameCompletionContributor.shouldShowSecondSmartCompletionHint(parameters2)) {
            return LangBundle.message("completion.no.suggestions", new Object[0]) + "; " + StringUtil.decapitalize((String)CompletionBundle.message("completion.class.name.hint.2", JavaClassNameCompletionContributor.getActionShortcut((String)"CodeCompletion")));
        }
        return null;
    }

    private static boolean shouldShowSecondSmartCompletionHint(CompletionParameters parameters2) {
        return parameters2.getCompletionType() == CompletionType.BASIC && parameters2.getInvocationCount() == 2 && parameters2.getOriginalFile().getLanguage().isKindOf((Language)JavaLanguage.INSTANCE);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "_result";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matcher";
                break;
            }
            case 4: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/completion/JavaClassNameCompletionContributor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/completion/JavaClassNameCompletionContributor";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllAnnotationClasses";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassNameWithContainers";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "fillCompletionVariants";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addAllClasses";
                break;
            }
            case 5: 
            case 7: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getClassNameWithContainers";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "handleEmptyLookup";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "lambda$addAllClasses$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

