/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.ExpectedTypeInfo;
import com.intellij.codeInsight.completion.CollectionsUtilityMethodsProvider;
import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResult;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.codeInsight.completion.JavaChainLookupElement;
import com.intellij.codeInsight.completion.JavaClassNameCompletionContributor;
import com.intellij.codeInsight.completion.JavaCompletionContributor;
import com.intellij.codeInsight.completion.JavaCompletionSession;
import com.intellij.codeInsight.completion.JavaCompletionSorting;
import com.intellij.codeInsight.completion.JavaCompletionUtil;
import com.intellij.codeInsight.completion.JavaPsiClassReferenceElement;
import com.intellij.codeInsight.completion.JavaSmartCompletionContributor;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.completion.ReferenceExpressionCompletionContributor;
import com.intellij.codeInsight.completion.TypeArgumentCompletionProvider;
import com.intellij.codeInsight.completion.impl.BetterPrefixMatcher;
import com.intellij.codeInsight.completion.impl.CamelHumpMatcher;
import com.intellij.codeInsight.lookup.AutoCompletionPolicy;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.PsiJavaElementPattern;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiImportStatementBase;
import com.intellij.psi.PsiJavaCodeReferenceCodeFragment;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.filters.ElementFilter;
import com.intellij.psi.search.PsiShortNamesCache;
import com.intellij.util.CollectConsumer;
import com.intellij.util.Consumer;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaNoVariantsDelegator
extends CompletionContributor {
    public void fillCompletionVariants(@NotNull CompletionParameters parameters2, @NotNull CompletionResultSet result2) {
        boolean empty;
        if (parameters2 == null) {
            JavaNoVariantsDelegator.$$$reportNull$$$0(0);
        }
        if (result2 == null) {
            JavaNoVariantsDelegator.$$$reportNull$$$0(1);
        }
        final JavaCompletionSession session2 = new JavaCompletionSession(result2);
        ResultTracker tracker = new ResultTracker(result2){

            @Override
            public void consume(CompletionResult plainResult) {
                super.consume(plainResult);
                LookupElement element = plainResult.getLookupElement();
                Object o = element.getObject();
                if (o instanceof PsiClass) {
                    session2.registerClass((PsiClass)o);
                }
                if (element instanceof TypeArgumentCompletionProvider.TypeArgsLookupElement) {
                    ((TypeArgumentCompletionProvider.TypeArgsLookupElement)element).registerSingleClass(session2);
                }
            }
        };
        result2.runRemainingContributors(parameters2, (Consumer)tracker);
        boolean bl = empty = tracker.containsOnlyPackages || JavaNoVariantsDelegator.suggestAllAnnotations(parameters2);
        if (JavaCompletionContributor.isClassNamePossible(parameters2) && !JavaCompletionContributor.mayStartClassName(result2)) {
            result2.restartCompletionOnAnyPrefixChange();
        }
        if (empty) {
            JavaNoVariantsDelegator.delegate(parameters2, JavaCompletionSorting.addJavaSorting(parameters2, result2), session2);
        } else if (Registry.is((String)"ide.completion.show.better.matching.classes") && parameters2.getCompletionType() == CompletionType.BASIC && parameters2.getInvocationCount() <= 1 && JavaCompletionContributor.mayStartClassName(result2) && JavaCompletionContributor.isClassNamePossible(parameters2) && !JavaNoVariantsDelegator.areNonImportedInheritorsAlreadySuggested(parameters2)) {
            JavaNoVariantsDelegator.suggestNonImportedClasses(parameters2, JavaCompletionSorting.addJavaSorting(parameters2, result2.withPrefixMatcher((PrefixMatcher)tracker.betterMatcher)), session2);
        }
    }

    private static boolean areNonImportedInheritorsAlreadySuggested(@NotNull CompletionParameters parameters2) {
        if (parameters2 == null) {
            JavaNoVariantsDelegator.$$$reportNull$$$0(2);
        }
        return JavaSmartCompletionContributor.AFTER_NEW.accepts((Object)parameters2.getPosition()) && JavaSmartCompletionContributor.getExpectedTypes(parameters2).length > 0;
    }

    private static boolean suggestAllAnnotations(CompletionParameters parameters2) {
        return ((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().withParents(new Class[]{PsiJavaCodeReferenceElement.class, PsiAnnotation.class})).accepts((Object)parameters2.getPosition());
    }

    private static void delegate(CompletionParameters parameters2, CompletionResultSet result2, JavaCompletionSession session2) {
        if (parameters2.getCompletionType() == CompletionType.BASIC) {
            PsiElement position = parameters2.getPosition();
            JavaNoVariantsDelegator.suggestCollectionUtilities(parameters2, result2, position);
            if (parameters2.getInvocationCount() <= 1 && (JavaCompletionContributor.mayStartClassName(result2) || JavaNoVariantsDelegator.suggestAllAnnotations(parameters2)) && JavaCompletionContributor.isClassNamePossible(parameters2)) {
                JavaNoVariantsDelegator.suggestNonImportedClasses(parameters2, result2, session2);
                return;
            }
            JavaNoVariantsDelegator.suggestChainedCalls(parameters2, result2, position);
        }
        if (parameters2.getCompletionType() == CompletionType.SMART && parameters2.getInvocationCount() == 2) {
            result2.runRemainingContributors(parameters2.withInvocationCount(3), true);
        }
    }

    private static void suggestCollectionUtilities(CompletionParameters parameters2, CompletionResultSet result2, PsiElement position) {
        if (StringUtil.isNotEmpty((String)result2.getPrefixMatcher().getPrefix())) {
            for (ExpectedTypeInfo info : JavaSmartCompletionContributor.getExpectedTypes(parameters2)) {
                new CollectionsUtilityMethodsProvider(position, info.getType(), info.getDefaultType(), (Consumer<LookupElement>)result2).addCompletions(true);
            }
        }
    }

    private static void suggestChainedCalls(CompletionParameters parameters2, CompletionResultSet result2, PsiElement position) {
        PsiElement parent = position.getParent();
        if (!(parent instanceof PsiJavaCodeReferenceElement) || parent.getParent() instanceof PsiImportStatementBase) {
            return;
        }
        PsiElement qualifier = ((PsiJavaCodeReferenceElement)parent).getQualifier();
        if (!(qualifier instanceof PsiJavaCodeReferenceElement) || ((PsiJavaCodeReferenceElement)qualifier).isQualified()) {
            return;
        }
        PsiElement target2 = ((PsiJavaCodeReferenceElement)qualifier).resolve();
        if (target2 != null && !(target2 instanceof PsiPackage)) {
            return;
        }
        PsiFile file2 = position.getContainingFile();
        if (file2 instanceof PsiJavaCodeReferenceCodeFragment) {
            return;
        }
        String fullPrefix = parent.getText().substring(0, parameters2.getOffset() - parent.getTextRange().getStartOffset());
        CompletionResultSet qualifiedCollector = result2.withPrefixMatcher(fullPrefix);
        ElementFilter filter2 = JavaCompletionContributor.getReferenceFilter(position);
        for (LookupElement base : JavaNoVariantsDelegator.suggestQualifierItems(parameters2, (PsiJavaCodeReferenceElement)qualifier, filter2)) {
            String separator;
            PsiReferenceExpression ref;
            PsiType type2 = JavaCompletionUtil.getLookupElementType(base);
            if (type2 == null || PsiType.VOID.equals((Object)type2) || (ref = ReferenceExpressionCompletionContributor.createMockReference(position, type2, base, separator = parent instanceof PsiMethodReferenceExpression ? "::" : ".")) == null) continue;
            for (LookupElement item : JavaSmartCompletionContributor.completeReference(position, (PsiJavaCodeReferenceElement)ref, filter2, true, true, parameters2, result2.getPrefixMatcher())) {
                qualifiedCollector.addElement(JavaCompletionUtil.highlightIfNeeded(null, (LookupElement)new JavaChainLookupElement(base, item, separator), item.getObject(), position));
            }
        }
    }

    private static Set<LookupElement> suggestQualifierItems(CompletionParameters parameters2, PsiJavaCodeReferenceElement qualifier, ElementFilter filter2) {
        String referenceName = qualifier.getReferenceName();
        if (referenceName == null) {
            return Collections.emptySet();
        }
        CamelHumpMatcher qMatcher = new CamelHumpMatcher(referenceName);
        Set<LookupElement> plainVariants = JavaSmartCompletionContributor.completeReference((PsiElement)qualifier, qualifier, filter2, true, true, parameters2, qMatcher);
        for (PsiClass aClass : PsiShortNamesCache.getInstance((Project)qualifier.getProject()).getClassesByName(referenceName, qualifier.getResolveScope())) {
            plainVariants.add((LookupElement)JavaClassNameCompletionContributor.createClassLookupItem(aClass, true));
        }
        if (!plainVariants.isEmpty()) {
            return plainVariants;
        }
        LinkedHashSet<LookupElement> allClasses = new LinkedHashSet<LookupElement>();
        PsiElement qualifierName = qualifier.getReferenceNameElement();
        if (qualifierName != null) {
            JavaClassNameCompletionContributor.addAllClasses(parameters2.withPosition(qualifierName, qualifierName.getTextRange().getEndOffset()), true, qMatcher, (Consumer<LookupElement>)new CollectConsumer(allClasses));
        }
        return allClasses;
    }

    private static void suggestNonImportedClasses(CompletionParameters parameters2, CompletionResultSet result2, @Nullable JavaCompletionSession session2) {
        JavaClassNameCompletionContributor.addAllClasses(parameters2, true, result2.getPrefixMatcher(), (Consumer<LookupElement>)((Consumer)element -> {
            if (session2 != null && session2.alreadyProcessed((LookupElement)element)) {
                return;
            }
            JavaPsiClassReferenceElement classElement = (JavaPsiClassReferenceElement)element.as(JavaPsiClassReferenceElement.CLASS_CONDITION_KEY);
            if (classElement != null) {
                classElement.setAutoCompletionPolicy(AutoCompletionPolicy.NEVER_AUTOCOMPLETE);
                element = JavaClassNameCompletionContributor.highlightIfNeeded(classElement, parameters2);
            }
            result2.addElement(element);
        }));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/completion/JavaNoVariantsDelegator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "fillCompletionVariants";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "areNonImportedInheritorsAlreadySuggested";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class ResultTracker
    implements Consumer<CompletionResult> {
        private final CompletionResultSet myResult;
        public boolean containsOnlyPackages = true;
        public BetterPrefixMatcher betterMatcher;

        public ResultTracker(CompletionResultSet result2) {
            this.myResult = result2;
            this.betterMatcher = new BetterPrefixMatcher.AutoRestarting(result2);
        }

        public void consume(CompletionResult plainResult) {
            this.myResult.passResult(plainResult);
            LookupElement element = plainResult.getLookupElement();
            if (this.containsOnlyPackages && !(CompletionUtil.getTargetElement(element) instanceof PsiPackage)) {
                this.containsOnlyPackages = false;
            }
            this.betterMatcher = this.betterMatcher.improve(plainResult);
        }
    }
}

