/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.JavaCompletionUtil;
import com.intellij.codeInsight.completion.JavaMethodCallElement;
import com.intellij.codeInsight.completion.StaticMemberProcessor;
import com.intellij.codeInsight.lookup.AutoCompletionPolicy;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.VariableLookupItem;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiImportStaticStatement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaStaticMemberProcessor
extends StaticMemberProcessor {
    private final PsiElement myOriginalPosition;

    public JavaStaticMemberProcessor(CompletionParameters parameters2) {
        super(parameters2.getPosition());
        PsiImportList importList;
        this.myOriginalPosition = parameters2.getOriginalPosition();
        PsiFile file2 = parameters2.getPosition().getContainingFile();
        if (file2 instanceof PsiJavaFile && (importList = ((PsiJavaFile)file2).getImportList()) != null) {
            for (PsiImportStaticStatement statement2 : importList.getImportStaticStatements()) {
                this.importMembersOf(statement2.resolveTargetClass());
            }
        }
    }

    @Override
    @Nullable
    protected LookupElement createLookupElement(@NotNull PsiMember member, @NotNull PsiClass containingClass, boolean shouldImport) {
        if (member == null) {
            JavaStaticMemberProcessor.$$$reportNull$$$0(0);
        }
        if (containingClass == null) {
            JavaStaticMemberProcessor.$$$reportNull$$$0(1);
        }
        shouldImport |= this.myOriginalPosition != null && PsiTreeUtil.isAncestor((PsiElement)containingClass, (PsiElement)this.myOriginalPosition, (boolean)false);
        if (!PsiNameHelper.getInstance((Project)member.getProject()).isIdentifier(member.getName(), PsiUtil.getLanguageLevel((PsiElement)this.getPosition()))) {
            return null;
        }
        PsiReference ref = this.createReferenceToMemberName(member);
        if (ref == null) {
            return null;
        }
        if (ref instanceof PsiReferenceExpression && ((PsiReferenceExpression)ref).multiResolve(true).length > 0) {
            shouldImport = false;
        }
        if (member instanceof PsiMethod) {
            return AutoCompletionPolicy.NEVER_AUTOCOMPLETE.applyPolicy((LookupElement)new GlobalMethodCallElement((PsiMethod)member, shouldImport, false));
        }
        return AutoCompletionPolicy.NEVER_AUTOCOMPLETE.applyPolicy((LookupElement)new VariableLookupItem((PsiField)member, shouldImport){

            @Override
            public void handleInsert(InsertionContext context) {
                FeatureUsageTracker.getInstance().triggerFeatureUsed("editing.completion.global.member.name");
                super.handleInsert(context);
            }
        });
    }

    private PsiReference createReferenceToMemberName(@NotNull PsiMember member) {
        if (member == null) {
            JavaStaticMemberProcessor.$$$reportNull$$$0(2);
        }
        String exprText = member.getName() + (member instanceof PsiMethod ? "()" : "");
        return JavaPsiFacade.getElementFactory((Project)member.getProject()).createExpressionFromText(exprText, this.myOriginalPosition).findReferenceAt(0);
    }

    @Override
    protected LookupElement createLookupElement(@NotNull List<PsiMethod> overloads, @NotNull PsiClass containingClass, boolean shouldImport) {
        if (overloads == null) {
            JavaStaticMemberProcessor.$$$reportNull$$$0(3);
        }
        if (containingClass == null) {
            JavaStaticMemberProcessor.$$$reportNull$$$0(4);
        }
        GlobalMethodCallElement element = new GlobalMethodCallElement(overloads.get(0), shouldImport |= this.myOriginalPosition != null && PsiTreeUtil.isAncestor((PsiElement)containingClass, (PsiElement)this.myOriginalPosition, (boolean)false), true);
        JavaCompletionUtil.putAllMethods((LookupElement)element, overloads);
        return element;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "member";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingClass";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "overloads";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/completion/JavaStaticMemberProcessor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createLookupElement";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "createReferenceToMemberName";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class GlobalMethodCallElement
    extends JavaMethodCallElement {
        public GlobalMethodCallElement(PsiMethod member, boolean shouldImport, boolean mergedOverloads) {
            super(member, shouldImport, mergedOverloads);
        }

        @Override
        public void handleInsert(InsertionContext context) {
            FeatureUsageTracker.getInstance().triggerFeatureUsed("editing.completion.global.member.name");
            super.handleInsert(context);
        }
    }
}

