/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.ExpectedTypeInfo;
import com.intellij.codeInsight.JavaPsiEquivalenceUtil;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.JavaCompletionUtil;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementWeigher;
import com.intellij.openapi.util.Comparing;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PsiJavaElementPattern;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.patterns.StandardPatterns;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.filters.AndFilter;
import com.intellij.psi.filters.ClassFilter;
import com.intellij.psi.filters.ElementFilter;
import com.intellij.psi.filters.element.ExcludeDeclaredFilter;
import com.intellij.psi.filters.element.ExcludeSillyAssignment;
import com.intellij.psi.impl.search.MethodDeepestSuperSearcher;
import com.intellij.psi.scope.ElementClassFilter;
import com.intellij.psi.util.PropertyUtilBase;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class RecursionWeigher
extends LookupElementWeigher {
    private final ElementFilter myFilter;
    private final PsiElement myPosition;
    private final PsiReferenceExpression myReference;
    @Nullable
    private final PsiMethodCallExpression myExpression;
    private final PsiMethod myPositionMethod;
    private final ExpectedTypeInfo[] myExpectedInfos;
    private final PsiExpression myCallQualifier;
    private final PsiExpression myPositionQualifier;
    private final boolean myDelegate;
    private final CompletionType myCompletionType;

    public RecursionWeigher(PsiElement position, CompletionType completionType, @NotNull PsiReferenceExpression reference, @Nullable PsiMethodCallExpression expression2, ExpectedTypeInfo[] expectedInfos) {
        if (reference == null) {
            RecursionWeigher.$$$reportNull$$$0(0);
        }
        super("recursion");
        this.myCompletionType = completionType;
        this.myFilter = RecursionWeigher.recursionFilter(position);
        this.myPosition = position;
        this.myReference = reference;
        this.myExpression = expression2;
        this.myPositionMethod = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)position, PsiMethod.class, (boolean)false);
        this.myExpectedInfos = expectedInfos;
        this.myCallQualifier = RecursionWeigher.normalizeQualifier((PsiElement)this.myReference.getQualifierExpression());
        this.myPositionQualifier = RecursionWeigher.normalizeQualifier(position.getParent() instanceof PsiJavaCodeReferenceElement ? ((PsiJavaCodeReferenceElement)position.getParent()).getQualifier() : null);
        this.myDelegate = this.isDelegatingCall();
    }

    @Nullable
    private static PsiExpression normalizeQualifier(@Nullable PsiElement qualifier) {
        return qualifier instanceof PsiThisExpression || !(qualifier instanceof PsiExpression) ? null : (PsiExpression)qualifier;
    }

    private boolean isDelegatingCall() {
        if (this.myCallQualifier != null && this.myPositionQualifier != null && this.myCallQualifier != this.myPositionQualifier && JavaPsiEquivalenceUtil.areExpressionsEquivalent(this.myCallQualifier, this.myPositionQualifier)) {
            return false;
        }
        return this.myCallQualifier != null || this.myPositionQualifier != null;
    }

    @Nullable
    static ElementFilter recursionFilter(PsiElement element) {
        if (((PsiJavaElementPattern.Capture)((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().afterLeaf(new String[]{"return"})).inside(PsiReturnStatement.class)).accepts((Object)element)) {
            return new ExcludeDeclaredFilter(ElementClassFilter.METHOD);
        }
        if (((PsiJavaElementPattern.Capture)((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().inside(StandardPatterns.or((ElementPattern[])new ElementPattern[]{PsiJavaPatterns.psiElement(PsiAssignmentExpression.class), PsiJavaPatterns.psiElement(PsiVariable.class)}))).andNot((ElementPattern)PsiJavaPatterns.psiElement().afterLeaf(new String[]{"."}))).accepts((Object)element)) {
            return new AndFilter((ElementFilter)new ExcludeSillyAssignment(), (ElementFilter)new ExcludeDeclaredFilter(new ClassFilter(PsiVariable.class)));
        }
        return null;
    }

    @NotNull
    public Result weigh(@NotNull LookupElement element) {
        PsiType itemType;
        Object object;
        if (element == null) {
            RecursionWeigher.$$$reportNull$$$0(1);
        }
        if (!((object = element.getObject()) instanceof PsiMethod || object instanceof PsiVariable || object instanceof PsiExpression)) {
            Result result2 = Result.normal;
            if (result2 == null) {
                RecursionWeigher.$$$reportNull$$$0(2);
            }
            return result2;
        }
        if (this.myFilter != null && !this.myFilter.isAcceptable(object, this.myPosition)) {
            Result result3 = Result.recursive;
            if (result3 == null) {
                RecursionWeigher.$$$reportNull$$$0(3);
            }
            return result3;
        }
        if (this.isPassingObjectToItself(object) && this.myCompletionType == CompletionType.SMART) {
            Result result4 = Result.passingObjectToItself;
            if (result4 == null) {
                RecursionWeigher.$$$reportNull$$$0(4);
            }
            return result4;
        }
        if (this.myExpectedInfos != null && (itemType = JavaCompletionUtil.getLookupElementType(element)) != null) {
            boolean hasRecursiveInvocations = false;
            boolean hasOtherInvocations = false;
            for (ExpectedTypeInfo expectedInfo : this.myExpectedInfos) {
                PsiMethod calledMethod = expectedInfo.getCalledMethod();
                if (!expectedInfo.getType().isAssignableFrom(itemType)) continue;
                if (calledMethod != null && calledMethod.equals(this.myPositionMethod) || this.isGetterSetterAssignment(object, calledMethod)) {
                    hasRecursiveInvocations = true;
                    continue;
                }
                if (calledMethod == null) continue;
                hasOtherInvocations = true;
            }
            if (hasRecursiveInvocations && !hasOtherInvocations) {
                Result result5 = this.myDelegate ? Result.delegation : Result.recursive;
                if (result5 == null) {
                    RecursionWeigher.$$$reportNull$$$0(5);
                }
                return result5;
            }
        }
        if (this.myExpression != null) {
            Result result6 = Result.normal;
            if (result6 == null) {
                RecursionWeigher.$$$reportNull$$$0(6);
            }
            return result6;
        }
        if (object instanceof PsiMethod && this.myPositionMethod != null) {
            PsiMethod method = (PsiMethod)object;
            if (PsiTreeUtil.isAncestor((PsiElement)this.myReference, (PsiElement)this.myPosition, (boolean)false) && Comparing.equal((String)method.getName(), (String)this.myPositionMethod.getName())) {
                if (!this.myDelegate && RecursionWeigher.findDeepestSuper(method).equals(RecursionWeigher.findDeepestSuper(this.myPositionMethod))) {
                    Result result7 = Result.recursive;
                    if (result7 == null) {
                        RecursionWeigher.$$$reportNull$$$0(7);
                    }
                    return result7;
                }
                Result result8 = Result.delegation;
                if (result8 == null) {
                    RecursionWeigher.$$$reportNull$$$0(8);
                }
                return result8;
            }
        }
        Result result9 = Result.normal;
        if (result9 == null) {
            RecursionWeigher.$$$reportNull$$$0(9);
        }
        return result9;
    }

    @Nullable
    private String getSetterPropertyName(@Nullable PsiMethod calledMethod) {
        PsiElement target2;
        if (PropertyUtilBase.isSimplePropertySetter((PsiMethod)calledMethod)) {
            assert (calledMethod != null);
            return PropertyUtilBase.getPropertyName((PsiMethod)calledMethod);
        }
        PsiReferenceExpression reference = ExcludeSillyAssignment.getAssignedReference(this.myPosition);
        if (reference != null && (target2 = reference.resolve()) instanceof PsiField) {
            return PropertyUtilBase.suggestPropertyName((PsiField)((PsiField)target2));
        }
        return null;
    }

    private boolean isGetterSetterAssignment(Object lookupObject, @Nullable PsiMethod calledMethod) {
        String prop = this.getSetterPropertyName(calledMethod);
        if (prop == null) {
            return false;
        }
        if (lookupObject instanceof PsiField && prop.equals(PropertyUtilBase.suggestPropertyName((PsiField)((PsiField)lookupObject)))) {
            return true;
        }
        return lookupObject instanceof PsiMethod && PropertyUtilBase.isSimplePropertyGetter((PsiMethod)((PsiMethod)lookupObject)) && prop.equals(PropertyUtilBase.getPropertyName((PsiMethod)((PsiMethod)lookupObject)));
    }

    private boolean isPassingObjectToItself(Object object) {
        if (object instanceof PsiThisExpression) {
            return this.myCallQualifier != null && !this.myDelegate || this.myCallQualifier instanceof PsiSuperExpression;
        }
        return this.myCallQualifier instanceof PsiReferenceExpression && object.equals(((PsiReferenceExpression)this.myCallQualifier).advancedResolve(true).getElement());
    }

    @NotNull
    public static PsiMethod findDeepestSuper(@NotNull PsiMethod method) {
        if (method == null) {
            RecursionWeigher.$$$reportNull$$$0(10);
        }
        CommonProcessors.FindFirstProcessor processor2 = new CommonProcessors.FindFirstProcessor();
        MethodDeepestSuperSearcher.processDeepestSuperMethods(method, (Processor<PsiMethod>)processor2);
        PsiMethod first = (PsiMethod)processor2.getFoundValue();
        PsiMethod psiMethod = first == null ? method : first;
        if (psiMethod == null) {
            RecursionWeigher.$$$reportNull$$$0(11);
        }
        return psiMethod;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/completion/RecursionWeigher";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/completion/RecursionWeigher";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "weigh";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "findDeepestSuper";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "weigh";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "findDeepestSuper";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static enum Result {
        delegation,
        normal,
        passingObjectToItself,
        recursive;

    }
}

