/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeHighlighting.MainHighlightingPassFactory;
import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeHighlighting.TextEditorHighlightingPassFactory;
import com.intellij.codeHighlighting.TextEditorHighlightingPassRegistrar;
import com.intellij.codeInsight.daemon.impl.ExternalToolPass;
import com.intellij.codeInsight.daemon.impl.FileStatusMap;
import com.intellij.codeInsight.daemon.impl.HighlightInfoProcessor;
import com.intellij.lang.ExternalLanguageAnnotators;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.AbstractProjectComponent;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiFile;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExternalToolPassFactory
extends AbstractProjectComponent
implements TextEditorHighlightingPassFactory,
MainHighlightingPassFactory {
    private final MergingUpdateQueue myExternalActivitiesQueue;

    public ExternalToolPassFactory(Project project2, TextEditorHighlightingPassRegistrar highlightingPassRegistrar) {
        super(project2);
        highlightingPassRegistrar.registerTextEditorHighlightingPass((TextEditorHighlightingPassFactory)this, new int[]{4}, null, true, 8);
        this.myExternalActivitiesQueue = new MergingUpdateQueue("ExternalActivitiesQueue", 300, true, MergingUpdateQueue.ANY_COMPONENT, (Disposable)project2, null, false);
        this.myExternalActivitiesQueue.setPassThrough(ApplicationManager.getApplication().isUnitTestMode());
    }

    @NonNls
    @NotNull
    public String getComponentName() {
        if ("ExternalToolPassFactory" == null) {
            ExternalToolPassFactory.$$$reportNull$$$0(0);
        }
        return "ExternalToolPassFactory";
    }

    @Override
    @Nullable
    public TextEditorHighlightingPass createHighlightingPass(@NotNull PsiFile file2, @NotNull Editor editor) {
        TextRange textRange;
        if (file2 == null) {
            ExternalToolPassFactory.$$$reportNull$$$0(1);
        }
        if (editor == null) {
            ExternalToolPassFactory.$$$reportNull$$$0(2);
        }
        TextRange textRange2 = textRange = FileStatusMap.getDirtyTextRange(editor, 8) == null ? null : file2.getTextRange();
        if (textRange == null || !ExternalToolPassFactory.externalAnnotatorsDefined(file2)) {
            return null;
        }
        return new ExternalToolPass(this, file2, editor, textRange.getStartOffset(), textRange.getEndOffset());
    }

    private static boolean externalAnnotatorsDefined(@NotNull PsiFile file2) {
        if (file2 == null) {
            ExternalToolPassFactory.$$$reportNull$$$0(3);
        }
        for (Language language : file2.getViewProvider().getLanguages()) {
            List externalAnnotators = ExternalLanguageAnnotators.allForFile((Language)language, (PsiFile)file2);
            if (externalAnnotators.isEmpty()) continue;
            return true;
        }
        return false;
    }

    void scheduleExternalActivity(@NotNull Update update2) {
        if (update2 == null) {
            ExternalToolPassFactory.$$$reportNull$$$0(4);
        }
        this.myExternalActivitiesQueue.queue(update2);
    }

    @Override
    @Nullable
    public TextEditorHighlightingPass createMainHighlightingPass(@NotNull PsiFile file2, @NotNull Document document, @NotNull HighlightInfoProcessor highlightInfoProcessor) {
        TextRange range;
        if (file2 == null) {
            ExternalToolPassFactory.$$$reportNull$$$0(5);
        }
        if (document == null) {
            ExternalToolPassFactory.$$$reportNull$$$0(6);
        }
        if (highlightInfoProcessor == null) {
            ExternalToolPassFactory.$$$reportNull$$$0(7);
        }
        if ((range = file2.getTextRange()) == null || !ExternalToolPassFactory.externalAnnotatorsDefined(file2)) {
            return null;
        }
        return new ExternalToolPass(this, file2, document, null, range.getStartOffset(), range.getEndOffset(), highlightInfoProcessor, true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/ExternalToolPassFactory";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "update";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlightInfoProcessor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponentName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/ExternalToolPassFactory";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createHighlightingPass";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "externalAnnotatorsDefined";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "scheduleExternalActivity";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createMainHighlightingPass";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

