/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzerSettings;
import com.intellij.codeInsight.daemon.GutterIconDescriptor;
import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.codeInsight.daemon.LineMarkerProviderDescriptor;
import com.intellij.codeInsight.daemon.MergeableLineMarkerInfo;
import com.intellij.codeInsight.daemon.NavigateAction;
import com.intellij.codeInsight.daemon.impl.MarkerType;
import com.intellij.concurrency.JobLauncher;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.SeparatorPlacement;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.impl.FindSuperElementsHelper;
import com.intellij.psi.search.searches.AllOverridingMethodsSearch;
import com.intellij.psi.search.searches.DirectClassInheritorsSearch;
import com.intellij.psi.search.searches.FunctionalExpressionSearch;
import com.intellij.psi.search.searches.SuperMethodsSearch;
import com.intellij.psi.util.MethodSignatureBackedByPsiMethod;
import com.intellij.psi.util.PsiExpressionTrimRenderer;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.Function;
import com.intellij.util.FunctionUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaLineMarkerProvider
extends LineMarkerProviderDescriptor {
    protected final DaemonCodeAnalyzerSettings myDaemonSettings;
    protected final EditorColorsManager myColorsManager;
    private final GutterIconDescriptor.Option myLambdaOption = new GutterIconDescriptor.Option("java.lambda", "Lambda", AllIcons.Gutter.ImplementingFunctionalInterface);
    private final GutterIconDescriptor.Option myOverriddenOption = new GutterIconDescriptor.Option("java.overridden", "Overridden method", AllIcons.Gutter.OverridenMethod);
    private final GutterIconDescriptor.Option myImplementedOption = new GutterIconDescriptor.Option("java.implemented", "Implemented method", AllIcons.Gutter.ImplementedMethod);
    private final GutterIconDescriptor.Option myOverridingOption = new GutterIconDescriptor.Option("java.overriding", "Overriding method", AllIcons.Gutter.OverridingMethod);
    private final GutterIconDescriptor.Option myImplementingOption = new GutterIconDescriptor.Option("java.implementing", "Implementing method", AllIcons.Gutter.ImplementingMethod);

    public JavaLineMarkerProvider(DaemonCodeAnalyzerSettings daemonSettings, EditorColorsManager colorsManager) {
        this.myDaemonSettings = daemonSettings;
        this.myColorsManager = colorsManager;
    }

    @Nullable
    public LineMarkerInfo getLineMarkerInfo(@NotNull PsiElement element) {
        PsiMethod interfaceMethod;
        if (element == null) {
            JavaLineMarkerProvider.$$$reportNull$$$0(0);
        }
        PsiElement parent = element.getParent();
        if (element instanceof PsiIdentifier && parent instanceof PsiMethod) {
            if (!this.myOverridingOption.isEnabled() && !this.myImplementingOption.isEnabled()) {
                return null;
            }
            PsiMethod method = (PsiMethod)parent;
            MethodSignatureBackedByPsiMethod superSignature = (MethodSignatureBackedByPsiMethod)SuperMethodsSearch.search((PsiMethod)method, null, (boolean)true, (boolean)false).findFirst();
            if (superSignature != null) {
                Icon icon;
                boolean overrides;
                boolean bl = overrides = method.hasModifierProperty("abstract") == superSignature.getMethod().hasModifierProperty("abstract");
                if (overrides) {
                    if (!this.myOverridingOption.isEnabled()) {
                        return null;
                    }
                    icon = AllIcons.Gutter.OverridingMethod;
                } else {
                    if (!this.myImplementingOption.isEnabled()) {
                        return null;
                    }
                    icon = AllIcons.Gutter.ImplementingMethod;
                }
                return JavaLineMarkerProvider.createSuperMethodLineMarkerInfo(element, icon, 11);
            }
        }
        if (this.myLambdaOption.isEnabled() && parent instanceof PsiFunctionalExpression && (element instanceof PsiJavaToken && ((PsiJavaToken)element).getTokenType() == JavaTokenType.ARROW && parent instanceof PsiLambdaExpression || element instanceof PsiIdentifier && parent instanceof PsiMethodReferenceExpression && ((PsiMethodReferenceExpression)parent).getReferenceNameElement() == element) && (interfaceMethod = LambdaUtil.getFunctionalInterfaceMethod((PsiElement)parent)) != null) {
            return JavaLineMarkerProvider.createSuperMethodLineMarkerInfo(element, AllIcons.Gutter.ImplementingFunctionalInterface, 11);
        }
        if (this.myDaemonSettings.SHOW_METHOD_SEPARATORS && element.getFirstChild() == null) {
            PsiElement element1 = element;
            boolean isMember = false;
            while (element1 != null && !(element1 instanceof PsiFile) && element1.getPrevSibling() == null) {
                if (!((element1 = element1.getParent()) instanceof PsiMember)) continue;
                isMember = true;
                break;
            }
            if (isMember && !(element1 instanceof PsiAnonymousClass) && !(element1.getParent() instanceof PsiAnonymousClass)) {
                PsiFile file2 = element1.getContainingFile();
                Document document = file2 == null ? null : PsiDocumentManager.getInstance((Project)file2.getProject()).getLastCommittedDocument(file2);
                boolean drawSeparator = false;
                if (document != null) {
                    CharSequence documentChars = document.getCharsSequence();
                    int category = JavaLineMarkerProvider.getCategory(element1, documentChars);
                    for (PsiElement child = element1.getPrevSibling(); child != null; child = child.getPrevSibling()) {
                        int category1 = JavaLineMarkerProvider.getCategory(child, documentChars);
                        if (category1 == 0) continue;
                        drawSeparator = category != 1 || category1 != 1;
                        break;
                    }
                }
                if (drawSeparator) {
                    LineMarkerInfo info = new LineMarkerInfo(element, element.getTextRange(), null, 11, (Function)FunctionUtil.nullConstant(), null, GutterIconRenderer.Alignment.RIGHT);
                    EditorColorsScheme scheme2 = this.myColorsManager.getGlobalScheme();
                    info.separatorColor = scheme2.getColor(CodeInsightColors.METHOD_SEPARATORS_COLOR);
                    info.separatorPlacement = SeparatorPlacement.TOP;
                    return info;
                }
            }
        }
        return null;
    }

    @NotNull
    private static LineMarkerInfo createSuperMethodLineMarkerInfo(@NotNull PsiElement name2, @NotNull Icon icon, int passId) {
        if (name2 == null) {
            JavaLineMarkerProvider.$$$reportNull$$$0(1);
        }
        if (icon == null) {
            JavaLineMarkerProvider.$$$reportNull$$$0(2);
        }
        ArrowUpLineMarkerInfo info = new ArrowUpLineMarkerInfo(name2, icon, MarkerType.OVERRIDING_METHOD, passId);
        LineMarkerInfo lineMarkerInfo = NavigateAction.setNavigateAction((LineMarkerInfo)info, (String)"Go to super method", (String)"GotoSuperMethod");
        if (lineMarkerInfo == null) {
            JavaLineMarkerProvider.$$$reportNull$$$0(3);
        }
        return lineMarkerInfo;
    }

    private static int getCategory(@NotNull PsiElement element, @NotNull CharSequence documentChars) {
        if (element == null) {
            JavaLineMarkerProvider.$$$reportNull$$$0(4);
        }
        if (documentChars == null) {
            JavaLineMarkerProvider.$$$reportNull$$$0(5);
        }
        if (element instanceof PsiField || element instanceof PsiTypeParameter) {
            return 1;
        }
        if (element instanceof PsiClass || element instanceof PsiClassInitializer) {
            return 2;
        }
        if (element instanceof PsiMethod) {
            int end;
            if (((PsiMethod)element).hasModifierProperty("abstract")) {
                return 1;
            }
            TextRange textRange = element.getTextRange();
            int start = textRange.getStartOffset();
            int crlf = StringUtil.getLineBreakCount((CharSequence)documentChars.subSequence(start, end = Math.min(documentChars.length(), textRange.getEndOffset())));
            return crlf == 0 ? 1 : 2;
        }
        return 0;
    }

    public void collectSlowLineMarkers(@NotNull List<PsiElement> elements, @NotNull Collection<LineMarkerInfo> result2) {
        if (elements == null) {
            JavaLineMarkerProvider.$$$reportNull$$$0(6);
        }
        if (result2 == null) {
            JavaLineMarkerProvider.$$$reportNull$$$0(7);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        ArrayList<Computable> tasks = new ArrayList<Computable>();
        MultiMap byClass = MultiMap.create();
        for (int i = 0; i < elements.size(); ++i) {
            PsiElement element = elements.get(i);
            ProgressManager.checkCanceled();
            if (!(element instanceof PsiIdentifier)) continue;
            PsiElement parent = element.getParent();
            if (parent instanceof PsiMethod) {
                PsiMethod method = (PsiMethod)parent;
                PsiClass psiClass = method.getContainingClass();
                if (!PsiUtil.canBeOverridden((PsiMethod)method) || psiClass == null) continue;
                byClass.putValue((Object)psiClass, (Object)method);
                continue;
            }
            if (!(parent instanceof PsiClass) || parent instanceof PsiTypeParameter) continue;
            tasks.add(() -> this.collectInheritingClasses((PsiClass)parent));
        }
        for (PsiClass psiClass : byClass.keySet()) {
            Collection methods = byClass.get((Object)psiClass);
            tasks.add(() -> JavaLineMarkerProvider.collectSiblingInheritedMethods(methods));
            tasks.add(() -> this.collectOverridingMethods(methods, psiClass));
        }
        Object lock = new Object();
        ProgressIndicator indicator = ProgressIndicatorProvider.getGlobalProgressIndicator();
        JobLauncher.getInstance().invokeConcurrentlyUnderProgress(tasks, indicator, true, computable -> {
            if (result2 == null) {
                JavaLineMarkerProvider.$$$reportNull$$$0(26);
            }
            List infos = (List)computable.compute();
            Object object = lock;
            synchronized (object) {
                result2.addAll(infos);
            }
            return true;
        });
    }

    @NotNull
    private static List<LineMarkerInfo> collectSiblingInheritedMethods(@NotNull Collection<PsiMethod> methods) {
        if (methods == null) {
            JavaLineMarkerProvider.$$$reportNull$$$0(8);
        }
        Map<PsiMethod, FindSuperElementsHelper.SiblingInfo> map = FindSuperElementsHelper.getSiblingInheritanceInfos(methods);
        List list2 = ContainerUtil.map(map.keySet(), method -> {
            PsiElement range = JavaLineMarkerProvider.getMethodRange(method);
            ArrowUpLineMarkerInfo upInfo = new ArrowUpLineMarkerInfo(range, AllIcons.Gutter.SiblingInheritedMethod, MarkerType.SIBLING_OVERRIDING_METHOD, 11);
            return NavigateAction.setNavigateAction((LineMarkerInfo)upInfo, (String)"Go to super method", (String)"GotoSuperMethod");
        });
        if (list2 == null) {
            JavaLineMarkerProvider.$$$reportNull$$$0(9);
        }
        return list2;
    }

    @NotNull
    private static PsiElement getMethodRange(@NotNull PsiMethod method) {
        PsiIdentifier range;
        if (method == null) {
            JavaLineMarkerProvider.$$$reportNull$$$0(10);
        }
        if (method.isPhysical()) {
            range = method.getNameIdentifier();
        } else {
            PsiElement navigationElement = method.getNavigationElement();
            PsiElement psiElement = range = navigationElement instanceof PsiNameIdentifierOwner ? ((PsiNameIdentifierOwner)navigationElement).getNameIdentifier() : navigationElement;
        }
        if (range == null) {
            range = method;
        }
        PsiIdentifier psiIdentifier = range;
        if (psiIdentifier == null) {
            JavaLineMarkerProvider.$$$reportNull$$$0(11);
        }
        return psiIdentifier;
    }

    @NotNull
    protected List<LineMarkerInfo> collectInheritingClasses(@NotNull PsiClass aClass) {
        if (aClass == null) {
            JavaLineMarkerProvider.$$$reportNull$$$0(12);
        }
        if (aClass.hasModifierProperty("final")) {
            List<LineMarkerInfo> list2 = Collections.emptyList();
            if (list2 == null) {
                JavaLineMarkerProvider.$$$reportNull$$$0(13);
            }
            return list2;
        }
        if ("java.lang.Object".equals(aClass.getQualifiedName())) {
            List<LineMarkerInfo> list3 = Collections.emptyList();
            if (list3 == null) {
                JavaLineMarkerProvider.$$$reportNull$$$0(14);
            }
            return list3;
        }
        PsiClass subClass = (PsiClass)DirectClassInheritorsSearch.search((PsiClass)aClass).findFirst();
        if (subClass != null || FunctionalExpressionSearch.search((PsiClass)aClass).findFirst() != null) {
            Icon icon;
            if (aClass.isInterface()) {
                if (!this.myImplementedOption.isEnabled()) {
                    List<LineMarkerInfo> list4 = Collections.emptyList();
                    if (list4 == null) {
                        JavaLineMarkerProvider.$$$reportNull$$$0(15);
                    }
                    return list4;
                }
                icon = AllIcons.Gutter.ImplementedMethod;
            } else {
                if (!this.myOverriddenOption.isEnabled()) {
                    List<LineMarkerInfo> list5 = Collections.emptyList();
                    if (list5 == null) {
                        JavaLineMarkerProvider.$$$reportNull$$$0(16);
                    }
                    return list5;
                }
                icon = AllIcons.Gutter.OverridenMethod;
            }
            PsiIdentifier range = aClass.getNameIdentifier();
            if (range == null) {
                range = aClass;
            }
            MarkerType type2 = MarkerType.SUBCLASSED_CLASS;
            LineMarkerInfo info = new LineMarkerInfo((PsiElement)range, range.getTextRange(), icon, 11, type2.getTooltip(), type2.getNavigationHandler(), GutterIconRenderer.Alignment.RIGHT);
            NavigateAction.setNavigateAction((LineMarkerInfo)info, (String)(aClass.isInterface() ? "Go to implementation(s)" : "Go to subclass(es)"), (String)"GotoImplementation");
            List<LineMarkerInfo> list6 = Collections.singletonList(info);
            if (list6 == null) {
                JavaLineMarkerProvider.$$$reportNull$$$0(17);
            }
            return list6;
        }
        List<LineMarkerInfo> list7 = Collections.emptyList();
        if (list7 == null) {
            JavaLineMarkerProvider.$$$reportNull$$$0(18);
        }
        return list7;
    }

    @NotNull
    private List<LineMarkerInfo> collectOverridingMethods(@NotNull Iterable<PsiMethod> _methods, @NotNull PsiClass containingClass) {
        PsiMethod interfaceMethod;
        if (_methods == null) {
            JavaLineMarkerProvider.$$$reportNull$$$0(19);
        }
        if (containingClass == null) {
            JavaLineMarkerProvider.$$$reportNull$$$0(20);
        }
        if (!this.myOverriddenOption.isEnabled() && !this.myImplementedOption.isEnabled()) {
            List<LineMarkerInfo> list2 = Collections.emptyList();
            if (list2 == null) {
                JavaLineMarkerProvider.$$$reportNull$$$0(21);
            }
            return list2;
        }
        com.intellij.util.containers.HashSet overridden = new com.intellij.util.containers.HashSet();
        HashSet methodSet = ContainerUtil.newHashSet(_methods);
        AllOverridingMethodsSearch.search((PsiClass)containingClass).forEach(arg_0 -> JavaLineMarkerProvider.lambda$collectOverridingMethods$5(methodSet, (Set)overridden, arg_0));
        if (!methodSet.isEmpty() && (interfaceMethod = LambdaUtil.getFunctionalInterfaceMethod((PsiClass)containingClass)) != null && FunctionalExpressionSearch.search((PsiClass)containingClass).findFirst() != null) {
            overridden.add(interfaceMethod);
        }
        ArrayList<LineMarkerInfo> result2 = new ArrayList<LineMarkerInfo>();
        for (PsiMethod method : overridden) {
            boolean overrides;
            ProgressManager.checkCanceled();
            boolean bl = overrides = !method.hasModifierProperty("abstract");
            if (overrides) {
                if (!this.myOverriddenOption.isEnabled()) {
                    List<LineMarkerInfo> list3 = Collections.emptyList();
                    if (list3 == null) {
                        JavaLineMarkerProvider.$$$reportNull$$$0(22);
                    }
                    return list3;
                }
            } else if (!this.myImplementedOption.isEnabled()) {
                List<LineMarkerInfo> list4 = Collections.emptyList();
                if (list4 == null) {
                    JavaLineMarkerProvider.$$$reportNull$$$0(23);
                }
                return list4;
            }
            PsiElement range = JavaLineMarkerProvider.getMethodRange(method);
            MarkerType type2 = MarkerType.OVERRIDDEN_METHOD;
            Icon icon = overrides ? AllIcons.Gutter.OverridenMethod : AllIcons.Gutter.ImplementedMethod;
            LineMarkerInfo info = new LineMarkerInfo(range, range.getTextRange(), icon, 11, type2.getTooltip(), type2.getNavigationHandler(), GutterIconRenderer.Alignment.RIGHT);
            NavigateAction.setNavigateAction((LineMarkerInfo)info, (String)(overrides ? "Go to overriding methods" : "Go to implementation(s)"), (String)"GotoImplementation");
            result2.add(info);
        }
        ArrayList<LineMarkerInfo> arrayList = result2;
        if (arrayList == null) {
            JavaLineMarkerProvider.$$$reportNull$$$0(24);
        }
        return arrayList;
    }

    public String getName() {
        return "Java line markers";
    }

    @NotNull
    public GutterIconDescriptor.Option[] getOptions() {
        GutterIconDescriptor.Option[] optionArray = new GutterIconDescriptor.Option[]{this.myLambdaOption, this.myOverriddenOption, this.myImplementedOption, this.myOverridingOption, this.myImplementingOption};
        if (optionArray == null) {
            JavaLineMarkerProvider.$$$reportNull$$$0(25);
        }
        return optionArray;
    }

    private static /* synthetic */ boolean lambda$collectOverridingMethods$5(Set methodSet, Set overridden, Pair pair2) {
        ProgressManager.checkCanceled();
        PsiMethod superMethod = (PsiMethod)pair2.getFirst();
        if (methodSet.remove(superMethod)) {
            overridden.add(superMethod);
        }
        return !methodSet.isEmpty();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 9: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 9: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "icon";
                break;
            }
            case 3: 
            case 9: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/JavaLineMarkerProvider";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "documentChars";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 7: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methods";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "_methods";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/JavaLineMarkerProvider";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createSuperMethodLineMarkerInfo";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "collectSiblingInheritedMethods";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getMethodRange";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "collectInheritingClasses";
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "collectOverridingMethods";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getLineMarkerInfo";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createSuperMethodLineMarkerInfo";
                break;
            }
            case 3: 
            case 9: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getCategory";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "collectSlowLineMarkers";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "collectSiblingInheritedMethods";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getMethodRange";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "collectInheritingClasses";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "collectOverridingMethods";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "lambda$collectSlowLineMarkers$3";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 9: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ArrowUpLineMarkerInfo
    extends MergeableLineMarkerInfo<PsiElement> {
        private ArrowUpLineMarkerInfo(@NotNull PsiElement element, @NotNull Icon icon, @NotNull MarkerType markerType, int passId) {
            if (element == null) {
                ArrowUpLineMarkerInfo.$$$reportNull$$$0(0);
            }
            if (icon == null) {
                ArrowUpLineMarkerInfo.$$$reportNull$$$0(1);
            }
            if (markerType == null) {
                ArrowUpLineMarkerInfo.$$$reportNull$$$0(2);
            }
            super(element, element.getTextRange(), icon, passId, markerType.getTooltip(), markerType.getNavigationHandler(), GutterIconRenderer.Alignment.LEFT);
        }

        public boolean canMergeWith(@NotNull MergeableLineMarkerInfo<?> info) {
            if (info == null) {
                ArrowUpLineMarkerInfo.$$$reportNull$$$0(3);
            }
            if (!(info instanceof ArrowUpLineMarkerInfo)) {
                return false;
            }
            PsiElement otherElement = info.getElement();
            PsiElement myElement = this.getElement();
            return otherElement != null && myElement != null;
        }

        public Icon getCommonIcon(@NotNull List<MergeableLineMarkerInfo> infos) {
            if (infos == null) {
                ArrowUpLineMarkerInfo.$$$reportNull$$$0(4);
            }
            return this.myIcon;
        }

        @NotNull
        public Function<? super PsiElement, String> getCommonTooltip(@NotNull List<MergeableLineMarkerInfo> infos) {
            if (infos == null) {
                ArrowUpLineMarkerInfo.$$$reportNull$$$0(5);
            }
            Function function = element -> "Multiple method overrides";
            if (function == null) {
                ArrowUpLineMarkerInfo.$$$reportNull$$$0(6);
            }
            return function;
        }

        public String getElementPresentation(PsiElement element) {
            PsiElement parent = element.getParent();
            if (parent instanceof PsiFunctionalExpression) {
                return PsiExpressionTrimRenderer.render((PsiExpression)((PsiExpression)parent));
            }
            return super.getElementPresentation(element);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 6: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 6: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "icon";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "markerType";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "info";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "infos";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInsight/daemon/impl/JavaLineMarkerProvider$ArrowUpLineMarkerInfo";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInsight/daemon/impl/JavaLineMarkerProvider$ArrowUpLineMarkerInfo";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCommonTooltip";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "canMergeWith";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getCommonIcon";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "getCommonTooltip";
                    break;
                }
                case 6: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 6: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

