/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerImpl;
import com.intellij.codeInsight.daemon.impl.HighlightersRecycler;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.impl.DocumentMarkupModel;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.util.Consumer;
import com.intellij.util.Processor;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class LineMarkersUtil {
    private static final Logger LOG = Logger.getInstance(LineMarkersUtil.class);
    private static final Key<LineMarkerInfo> LINE_MARKER_INFO = Key.create((String)"LINE_MARKER_INFO");

    LineMarkersUtil() {
    }

    static boolean processLineMarkers(@NotNull Project project2, @NotNull Document document, @NotNull Segment bounds, int group, @NotNull Processor<LineMarkerInfo> processor2) {
        if (project2 == null) {
            LineMarkersUtil.$$$reportNull$$$0(0);
        }
        if (document == null) {
            LineMarkersUtil.$$$reportNull$$$0(1);
        }
        if (bounds == null) {
            LineMarkersUtil.$$$reportNull$$$0(2);
        }
        if (processor2 == null) {
            LineMarkersUtil.$$$reportNull$$$0(3);
        }
        MarkupModelEx markupModel = (MarkupModelEx)DocumentMarkupModel.forDocument(document, project2, true);
        return markupModel.processRangeHighlightersOverlappingWith(bounds.getStartOffset(), bounds.getEndOffset(), (Processor<? super RangeHighlighterEx>)((Processor)highlighter -> {
            LineMarkerInfo info;
            if (processor2 == null) {
                LineMarkersUtil.$$$reportNull$$$0(16);
            }
            return (info = LineMarkersUtil.getLineMarkerInfo(highlighter)) == null || group != -1 && info.updatePass != group || processor2.process((Object)info);
        }));
    }

    static void setLineMarkersToEditor(@NotNull Project project2, @NotNull Document document, @NotNull Segment bounds, @NotNull Collection<LineMarkerInfo> markers, int group) {
        if (project2 == null) {
            LineMarkersUtil.$$$reportNull$$$0(4);
        }
        if (document == null) {
            LineMarkersUtil.$$$reportNull$$$0(5);
        }
        if (bounds == null) {
            LineMarkersUtil.$$$reportNull$$$0(6);
        }
        if (markers == null) {
            LineMarkersUtil.$$$reportNull$$$0(7);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        MarkupModelEx markupModel = (MarkupModelEx)DocumentMarkupModel.forDocument(document, project2, true);
        HighlightersRecycler toReuse = new HighlightersRecycler();
        LineMarkersUtil.processLineMarkers(project2, document, bounds, group, (Processor<LineMarkerInfo>)((Processor)info -> {
            toReuse.recycleHighlighter(info.highlighter);
            return true;
        }));
        if (LOG.isDebugEnabled()) {
            List<LineMarkerInfo> oldMarkers = DaemonCodeAnalyzerImpl.getLineMarkers(document, project2);
            LOG.debug("LineMarkersUtil.setLineMarkersToEditor(markers: " + markers + ", group: " + group + "); oldMarkers: " + oldMarkers + "; reused: " + toReuse.forAllInGarbageBin().size());
        }
        for (LineMarkerInfo lineMarkerInfo : markers) {
            TextRange elementRange;
            TextRange textRange;
            PsiElement element = lineMarkerInfo.getElement();
            if (element == null || (textRange = element.getTextRange()) == null || !TextRange.containsRange((Segment)bounds, (Segment)(elementRange = InjectedLanguageManager.getInstance((Project)project2).injectedToHost(element, textRange)))) continue;
            LineMarkersUtil.createOrReuseLineMarker(lineMarkerInfo, markupModel, toReuse);
        }
        for (RangeHighlighter rangeHighlighter : toReuse.forAllInGarbageBin()) {
            rangeHighlighter.dispose();
        }
    }

    @NotNull
    private static RangeHighlighter createOrReuseLineMarker(@NotNull LineMarkerInfo info, @NotNull MarkupModel markupModel, @Nullable HighlightersRecycler toReuse) {
        boolean lineSeparatorPlacementChanged;
        RangeHighlighter highlighter;
        if (info == null) {
            LineMarkersUtil.$$$reportNull$$$0(8);
        }
        if (markupModel == null) {
            LineMarkersUtil.$$$reportNull$$$0(9);
        }
        RangeHighlighter rangeHighlighter = highlighter = toReuse == null ? null : toReuse.pickupHighlighterFromGarbageBin(info.startOffset, info.endOffset, 3000);
        if (highlighter == null) {
            highlighter = markupModel.addRangeHighlighter(info.startOffset, info.endOffset, 3000, null, HighlighterTargetArea.LINES_IN_RANGE);
        }
        highlighter.putUserData(LINE_MARKER_INFO, (Object)info);
        LineMarkerInfo.LineMarkerGutterIconRenderer newRenderer = (LineMarkerInfo.LineMarkerGutterIconRenderer)info.createGutterRenderer();
        LineMarkerInfo.LineMarkerGutterIconRenderer oldRenderer = highlighter.getGutterIconRenderer() instanceof LineMarkerInfo.LineMarkerGutterIconRenderer ? (LineMarkerInfo.LineMarkerGutterIconRenderer)highlighter.getGutterIconRenderer() : null;
        boolean rendererChanged = oldRenderer == null || newRenderer == null || !newRenderer.equals((Object)oldRenderer);
        boolean lineSeparatorColorChanged = !Comparing.equal((Object)highlighter.getLineSeparatorColor(), (Object)info.separatorColor);
        boolean bl = lineSeparatorPlacementChanged = !Comparing.equal((Object)highlighter.getLineSeparatorPlacement(), (Object)info.separatorPlacement);
        if (rendererChanged || lineSeparatorColorChanged || lineSeparatorPlacementChanged) {
            ((MarkupModelEx)markupModel).changeAttributesInBatch((RangeHighlighterEx)highlighter, (Consumer<RangeHighlighterEx>)((Consumer)markerEx -> {
                if (info == null) {
                    LineMarkersUtil.$$$reportNull$$$0(15);
                }
                if (rendererChanged) {
                    markerEx.setGutterIconRenderer((GutterIconRenderer)newRenderer);
                }
                if (lineSeparatorColorChanged) {
                    markerEx.setLineSeparatorColor(info.separatorColor);
                }
                if (lineSeparatorPlacementChanged) {
                    markerEx.setLineSeparatorPlacement(info.separatorPlacement);
                }
            }));
        }
        info.highlighter = highlighter;
        RangeHighlighter rangeHighlighter2 = highlighter;
        if (rangeHighlighter2 == null) {
            LineMarkersUtil.$$$reportNull$$$0(10);
        }
        return rangeHighlighter2;
    }

    static void addLineMarkerToEditorIncrementally(@NotNull Project project2, @NotNull Document document, @NotNull LineMarkerInfo marker) {
        if (project2 == null) {
            LineMarkersUtil.$$$reportNull$$$0(11);
        }
        if (document == null) {
            LineMarkersUtil.$$$reportNull$$$0(12);
        }
        if (marker == null) {
            LineMarkersUtil.$$$reportNull$$$0(13);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        MarkupModelEx markupModel = (MarkupModelEx)DocumentMarkupModel.forDocument(document, project2, true);
        LineMarkerInfo[] markerInTheWay = new LineMarkerInfo[]{null};
        boolean allIsClear = markupModel.processRangeHighlightersOverlappingWith(marker.startOffset, marker.endOffset, (Processor<? super RangeHighlighterEx>)((Processor)highlighter -> {
            markerInTheWay[0] = LineMarkersUtil.getLineMarkerInfo(highlighter);
            return markerInTheWay[0] == null;
        }));
        if (allIsClear) {
            LineMarkersUtil.createOrReuseLineMarker(marker, markupModel, null);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("LineMarkersUtil.addLineMarkerToEditorIncrementally: " + marker + " " + (allIsClear ? "created" : " (was not added because " + markerInTheWay[0] + " was in the way)"));
        }
    }

    private static LineMarkerInfo getLineMarkerInfo(@NotNull RangeHighlighter highlighter) {
        if (highlighter == null) {
            LineMarkersUtil.$$$reportNull$$$0(14);
        }
        return (LineMarkerInfo)highlighter.getUserData(LINE_MARKER_INFO);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bounds";
                break;
            }
            case 3: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "markers";
                break;
            }
            case 8: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "markupModel";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/LineMarkersUtil";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "marker";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlighter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/LineMarkersUtil";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createOrReuseLineMarker";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "processLineMarkers";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setLineMarkersToEditor";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createOrReuseLineMarker";
                break;
            }
            case 10: {
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "addLineMarkerToEditorIncrementally";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getLineMarkerInfo";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "lambda$createOrReuseLineMarker$2";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "lambda$processLineMarkers$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

