/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeInsight.daemon.DaemonBundle;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzerSettings;
import com.intellij.codeInsight.daemon.ReferenceImporter;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerEx;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.VisibleHighlightingPassFactory;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.HintAction;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.util.Processor;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ShowAutoImportPass
extends TextEditorHighlightingPass {
    private final Editor myEditor;
    private final PsiFile myFile;
    private final int myStartOffset;
    private final int myEndOffset;

    public ShowAutoImportPass(@NotNull Project project2, @NotNull PsiFile file2, @NotNull Editor editor) {
        if (project2 == null) {
            ShowAutoImportPass.$$$reportNull$$$0(0);
        }
        if (file2 == null) {
            ShowAutoImportPass.$$$reportNull$$$0(1);
        }
        if (editor == null) {
            ShowAutoImportPass.$$$reportNull$$$0(2);
        }
        super(project2, editor.getDocument(), false);
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.myEditor = editor;
        ProperTextRange range = VisibleHighlightingPassFactory.calculateVisibleRange(this.myEditor);
        this.myStartOffset = range.getStartOffset();
        this.myEndOffset = range.getEndOffset();
        this.myFile = file2;
    }

    @Override
    public void doCollectInformation(@NotNull ProgressIndicator progress) {
        if (progress == null) {
            ShowAutoImportPass.$$$reportNull$$$0(3);
        }
    }

    @Override
    public void doApplyInformationToEditor() {
        TransactionGuard.submitTransaction((Disposable)this.myProject, this::addImports);
    }

    public void addImports() {
        Application application = ApplicationManager.getApplication();
        application.assertIsDispatchThread();
        if (!application.isUnitTestMode() && !this.myEditor.getContentComponent().hasFocus()) {
            return;
        }
        if (DumbService.isDumb((Project)this.myProject) || !this.myFile.isValid()) {
            return;
        }
        if (this.myEditor.isDisposed() || this.myEditor instanceof EditorWindow && !((EditorWindow)this.myEditor).isValid()) {
            return;
        }
        int caretOffset = this.myEditor.getCaretModel().getOffset();
        this.importUnambiguousImports(caretOffset);
        List<HighlightInfo> visibleHighlights = ShowAutoImportPass.getVisibleHighlights(this.myStartOffset, this.myEndOffset, this.myProject, this.myEditor);
        for (int i = visibleHighlights.size() - 1; i >= 0; --i) {
            HighlightInfo info = visibleHighlights.get(i);
            if (info.startOffset > caretOffset || !this.showAddImportHint(info)) continue;
            return;
        }
        for (HighlightInfo visibleHighlight : visibleHighlights) {
            if (visibleHighlight.startOffset <= caretOffset || !this.showAddImportHint(visibleHighlight)) continue;
            return;
        }
    }

    private void importUnambiguousImports(int caretOffset) {
        if (!DaemonCodeAnalyzerSettings.getInstance().isImportHintEnabled()) {
            return;
        }
        if (!DaemonCodeAnalyzer.getInstance((Project)this.myProject).isImportHintsEnabled(this.myFile)) {
            return;
        }
        Document document = this.getDocument();
        ArrayList infos = new ArrayList();
        DaemonCodeAnalyzerEx.processHighlights(document, this.myProject, null, 0, document.getTextLength(), (Processor<HighlightInfo>)((Processor)info -> {
            if (!info.hasHint() || info.getSeverity() != HighlightSeverity.ERROR) {
                return true;
            }
            PsiReference reference = this.myFile.findReferenceAt(info.getActualStartOffset());
            if (reference != null && reference.getElement().getTextRange().containsOffset(caretOffset)) {
                return true;
            }
            infos.add(info);
            return true;
        }));
        ReferenceImporter[] importers = (ReferenceImporter[])Extensions.getExtensions(ReferenceImporter.EP_NAME);
        for (HighlightInfo info2 : infos) {
            for (ReferenceImporter importer : importers) {
                if (importer.autoImportReferenceAt(this.myEditor, this.myFile, info2.getActualStartOffset())) break;
            }
        }
    }

    @NotNull
    private static List<HighlightInfo> getVisibleHighlights(int startOffset, int endOffset, Project project2, Editor editor) {
        ArrayList<HighlightInfo> highlights = new ArrayList<HighlightInfo>();
        DaemonCodeAnalyzerEx.processHighlights(editor.getDocument(), project2, null, startOffset, endOffset, (Processor<HighlightInfo>)((Processor)info -> {
            if (info.hasHint() && !editor.getFoldingModel().isOffsetCollapsed(info.startOffset)) {
                highlights.add((HighlightInfo)info);
            }
            return true;
        }));
        ArrayList<HighlightInfo> arrayList = highlights;
        if (arrayList == null) {
            ShowAutoImportPass.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    private boolean showAddImportHint(HighlightInfo info) {
        if (!DaemonCodeAnalyzerSettings.getInstance().isImportHintEnabled()) {
            return false;
        }
        if (!DaemonCodeAnalyzer.getInstance((Project)this.myProject).isImportHintsEnabled(this.myFile)) {
            return false;
        }
        PsiElement element = this.myFile.findElementAt(info.startOffset);
        if (element == null || !element.isValid()) {
            return false;
        }
        List<Pair<HighlightInfo.IntentionActionDescriptor, TextRange>> list2 = info.quickFixActionRanges;
        for (Pair<HighlightInfo.IntentionActionDescriptor, TextRange> pair2 : list2) {
            IntentionAction action = ((HighlightInfo.IntentionActionDescriptor)pair2.getFirst()).getAction();
            if (!(action instanceof HintAction) || !action.isAvailable(this.myProject, this.myEditor, this.myFile)) continue;
            return ((HintAction)action).showHint(this.myEditor);
        }
        return false;
    }

    public static String getMessage(boolean multiple, String name2) {
        String messageKey = multiple ? "import.popup.multiple" : "import.popup.text";
        String hintText = DaemonBundle.message((String)messageKey, (Object[])new Object[]{name2});
        hintText = hintText + " " + KeymapUtil.getFirstKeyboardShortcutText((AnAction)ActionManager.getInstance().getAction("ShowIntentionActions"));
        return hintText;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progress";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/ShowAutoImportPass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/ShowAutoImportPass";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getVisibleHighlights";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "doCollectInformation";
                break;
            }
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

